/*****************************************************************************
*   "Irit" - the 3d polygonal solid modeller.				     *
*									     *
* Written by:  Gershon Elber				Ver 0.2, Mar. 1990   *
******************************************************************************
* Test program of the InptPrsr.c module:				     *
* Note you can set DEBUG for InptPrsr preprocessor for intermidiate results: *
*****************************************************************************/

#ifdef __MSDOS__
#include <stdlib.h>
#include <conio.h>
#include <alloc.h>
#endif /* __MSDOS__ */

#include <stdio.h>
#include <setjmp.h>
#include "program.h"
#include "inptprsg.h"
#include "dosintr.h"
#include "matherr.h"

char CurrentWorkingDir[LINE_LEN];      /* Save start CWD to recover on exit. */

ObjectStruct *GlblObjList = NULL;	   /* All objects defined on system. */

int  GlblWasCtrlBrk = FALSE; 	     /* True if control break/C was pressed. */
int  GlblFatalError = FALSE;	  /* True if disaster in system - must quit! */
int  GlblLoadColor = 1,
     GlblBoolColor = 2,
     GlblICrvColor = 14,
     GlblPrimColor = 4;

char *GlblHelpFileName = "irit.hlp";

jmp_buf GlblLongJumpBuffer;		          /* Used in error recovery. */

#ifdef __MSDOS__
extern unsigned int _stklen = 16384;	     /* Increase default stack size. */
#endif /* __MSDOS__ */

static void PrintInptPrsrError(void);

/*****************************************************************************
* Simple main routine to emulate the needed parameters for InputParser:      *
*****************************************************************************/
void main(void)
{
    SetUpPredefObjects();		  /* Prepare the predefined objects. */
    fprintf(stderr, "Input Parser Test Program (type expression follows by ';'):\n");

    DosGetTime(1.0);				    /* Reset the time count. */
    AliasReset();

    /* If one long jumped to here with value 2, we must quit the program!    */
    if (setjmp(LongJumpBuffer) == 2)	          /* Used in error recovery. */
	exit(1);

    while (TRUE) {					      /* Do forever. */
	if (!InputParser())		     /* Error was found - handle it. */
	    PrintInptPrsrError();
	fprintf(stderr, "\nCurrent defined objects (Core left = %lx) :\n",
								coreleft());
	PrintObjectList(GlblObjList);
    }
}

/*****************************************************************************
* Routine to query (and print) the errors found in InputParser:		     *
*****************************************************************************/
static void PrintInptPrsrError(void)
{
    InptPrsrEvalErrType ErrorNum;
    char *ErrorMsg;

    if ((ErrorNum = InptPrsrParseError(&ErrorMsg)) != IPE_NO_ERR) {/*Prsr err*/
	fprintf(stderr, "Parsing Error: ");
	switch (ErrorNum) {
	    case IP_ERR_WRONG_SYNTAX:
		fprintf(stderr, "Wrong syntax\n");
		break;
	    case IP_ERR_PARAM_EXPECT:
		fprintf(stderr, "Parameter Expected - %s\n", ErrorMsg);
		break;
	    case IP_ERR_ONE_OPERAND:
		fprintf(stderr, "Wrong Number of operands (1) - %s\n", ErrorMsg);
		break;
	    case IP_ERR_TWO_OPERAND:
		fprintf(stderr, "Wrong Number of operands (2) - %s\n", ErrorMsg);
		break;
	    case IP_ERR_STACK_OV:
		fprintf(stderr, "Internal Stack OverFlow at - %s\n", ErrorMsg);
		break;
	    case IP_ERR_PARAM_MATCH:
		fprintf(stderr, "Parenthesis mismatch - %s\n", ErrorMsg);
		break;
	    case IP_ERR_UNDEF_TOKEN:
		fprintf(stderr, "Undefined token - %s\n", ErrorMsg);
		break;
	    case IP_ERR_UNDEF_FUNC:
		fprintf(stderr, "Undefined function - %s\n", ErrorMsg);
		break;
	    case IP_ERR_NAME_TOO_LONG:
		fprintf(stderr, "Object name too long - %s\n", ErrorMsg);
		break;
	    case IP_ERR_PARAM_FUNC:
		fprintf(stderr, "Parameters expected in func %s\n", ErrorMsg);
		break;
	    case IP_ERR_NO_PARAM_FUNC:
		fprintf(stderr, "No Parameters expected in func %s\n", ErrorMsg);
		break;
	}
	return;
    }

    if ((ErrorNum = InptPrsrEvalError(&ErrorMsg)) != IPE_NO_ERR) {/*Eval err.*/
	fprintf(stderr, "Eval Error: ");
	switch (ErrorNum) {
	    case IE_ERR_FATAL_ERROR:
		fprintf(stderr, "Fatal Error - %s\n", ErrorMsg);
		break;
	    case IE_ERR_DIV_BY_ZERO:
		fprintf(stderr, "Division by zero - %s\n", ErrorMsg);
		break;
	    case IE_ERR_NO_OBJ_METHOD:
		fprintf(stderr, "No such method for object - %s\n", ErrorMsg);
		break;
	    case IE_ERR_TYPE_MISMATCH:
		fprintf(stderr, "Parameter type mismatch - %s\n", ErrorMsg);
		break;
	    case IE_ERR_ASSIGN_LEFT_OP:
		fprintf(stderr, "Lval is not a parameter - %s\n", ErrorMsg);
		break;
	    case IE_ERR_MIXED_OBJ:
		fprintf(stderr, "Mixed types in expression - %s\n", ErrorMsg);
		break;
	    case IE_ERR_UNDEF_OBJECT:
		fprintf(stderr, "No such object defined - %s\n", ErrorMsg);
		break;
	    case IE_ERR_NO_ASSIGNMENT:
		fprintf(stderr, "Assignment was expected\n");
		break;
	    case IE_ERR_FP_ERROR:
		fprintf(stderr, "Floating Point Error - %s\n", ErrorMsg);
		break;
	    case IE_ERR_NUM_PRM_MISMATCH:
		fprintf(stderr, "Number of func. param. mismatch - %s\n", ErrorMsg);
		break;
	    case IE_ERR_MAT_POWER:
		fprintf(stderr, "Wrong range or result exists, operator - %s\n", ErrorMsg);
		break;
	    case IE_ERR_FREE_SIMPLE:
		fprintf(stderr, "Free only Geometric Objects - %s\n", ErrorMsg);
		break;
	    case IE_ERR_MODIF_ITER_VAR:
		fprintf(stderr,
		    "Iteration var. type modified or freed - %s\n", ErrorMsg);
		break;
	    case IE_ERR_BOOLEAN_ERR:
		fprintf(stderr,
			"Geometric Boolean operation error - %s\n", ErrorMsg);
		break;
	    case IE_ERR_LIST_TOO_LONG:
		fprintf(stderr,
			"List length too big - up to %d only.\n", MAX_OBJ_LIST);
		break;
	    case IE_ERR_DATA_PRSR_ERROR:
		fprintf(stderr, "%s", ErrorMsg);
		break;
	}
	return;
    }
}

/*****************************************************************************
* MyExit routine. 							     *
*****************************************************************************/
void MyExit(int ExitCode)
{
    exit(ExitCode);
}

/*****************************************************************************
* FatalEror routine. same as MyExit routine, but print error message	     *
* before it dies.							     *
*****************************************************************************/
void FatalError(char *ErrorMsg)
{
    fprintf(stderr, "%s\n", ErrorMsg);

    exit(99);
}

/*****************************************************************************
*   Routine that is called from the floating point package in case of fatal  *
* floating point error. Print error message, long jump to main loop. Default *
* FPE handler - must be reset after redirected to other module.		     *
*****************************************************************************/
#ifdef __MSDOS__
void DefaultFPEHandler(int Sig, int Type, int *RegList)
#else
void DefaultFPEHandler(int Type)
#endif /* __MSDOS__ */
{
    PrintFPError(Type);		     /* Print the floating point error type. */

    longjmp(LongJumpBuffer, 1);
}

/*****************************************************************************
*  And other emulations to the routines:				     *
*****************************************************************************/
void WndwPause()
{
    fprintf(stderr, "Pause was called, press anything:");
    getch();
}

void WndwInputWindowGetStr(char *Str, int Length)
{
    gets(Str);
}

void WndwLogPrint(RealType *R)
{
    fprintf(stderr, "Log file toggle - value = %lf\n", *R);
}

void WndwInputWindowPutStr(char *Str, int Color)
{
    printf("%s\n", Str);
}

void WndwInputWindowPutStrFS(char *Str, int Color, int Reset)
{
    printf("%s\n", Str);
}

void WndwViewGeomObject(ObjectStruct *PObj, RealType *ClearScreen)
{
    fprintf(stderr,
	"VIEW: object %s (Clear = %g)\n", PObj->Name, *ClearScreen);
}

void WndwStatusWindowUpdate()
{
    fprintf(stderr, "Core left = %lx\n", coreleft());
}

void DosChangeDir(char *s)
{
    fprintf(stderr, "CHDIR: to directory %s\n", s);
}

double DosGetTime(double ResetTime)
{
    fprintf(stderr, "Time invoked with reset = %lf\n", ResetTime);
    return 1234.5678;
}

void DosEditFile(char *s)
{
    fprintf(stderr, "Edit invoked with file \"%s\"\n", s);
}

void DosSystem()
{
    fprintf(stderr, "System invoked\n");
}

void DosPrintDir(char *s)
{
    fprintf(stderr, "Print Dir entered (%s)\n", s);
}

void InteractPolyObject(ObjectStruct *PObj, RealType *UpdateGlblMat)
{
    fprintf(stderr, "View Object entered, object %s, Update= %lf\n",
						PObj -> Name, *UpdateGlblMat);
}

void ViewGeomObject(ObjectStruct *PObj)
{
    fprintf(stderr, "View Object entered, object %s\n", PObj -> Name);
}

void ViewSetNormals(RealType *Active, RealType *Size, RealType *Color)
{
    fprintf(stderr,
	"View set normals entered, Active = %g Size = %g Color = %g\n",
		*Active, *Size, *Color);
}

void GGTone(int Freq, int Time)
{
    fprintf(stderr, "Beep invoked, Freq = %d, Time = %d\n", Freq, Time);
}

#ifndef __MSDOS__
getch()
{
    fprintf(stderr, "GetCh has been invoked.\n");
}

coreleft()
{
    return 100000;
}
#endif /* __MSDOS__ */
