/*****************************************************************************
* General, visible to others, definitions of View Object module.	     *
*									     *
* Written by:  Gershon Elber			IBM PC Ver 0.1,	Sep. 1988    *
*****************************************************************************/

#ifndef	VIEW_OBJ_H
#define	VIEW_OBJ_H

/* Interactive menu setup structure: */
#define INTERACT_NUM_OF_STRINGS	3
#define INTERACT_NUM_OF_SUB_WINDOWS	11
#define INTERACT_SUB_WINDOW_HEIGHT	0.04  /* Actually half Height/Width. */
#define INTERACT_SUB_WINDOW_WIDTH	0.3

#define MAX_ROTATE_ANGLE	45.0 /* Max. rates used by interactive mode. */
#define MAX_TRANSLATE_FACTOR	2.0
#define MAX_SCALE_FACTOR	2.0

#define GENERIC_MAT_FILE	"generic.mat"

typedef struct InteractString {
    double X, Y;
    int Color;
    char *Str;
} InteractString;
typedef struct InteractSubWindow {
    double X, Y;					   /* Center points. */
    int Color,
	TextInside; /* If TRUE, Str will be in window, otherwise left to it. */
    char *Str;
} InteractSubWindow;
typedef struct InteractWindowStruct {	 /* The interactive menu structures. */
    /* Rotate, Translate, Scale strings: */
    InteractString Strings[INTERACT_NUM_OF_STRINGS];
    InteractSubWindow SubWindows[INTERACT_NUM_OF_SUB_WINDOWS];
} InteractWindowStruct;


/* Prototypes for the View Object module: */

void InteractDrawMenu(void);
int InteractHandleInput(MatrixType TransMat, MatrixType OrigMat);

#endif	VIEW_OBJ_H
