/*****************************************************************************
* General, visible to others, definitions of Expr2Tre.c module.		     *
*****************************************************************************/

#ifndef EXPR_2_TREE_GH
#define EXPR_2_TREE_GH

#define  DERIVATIVE	   /* Uncomment if derivative evaluations is needed. */

/*****************************************************************************
* The global constants - should	be available to	every body using expr2tre    *
*****************************************************************************/

#define	PARAMETER_A    0		       /* Make life easier in usage. */
#define	PARAMETER_B    1
#define	PARAMETER_C    2
#define	PARAMETER_D    3
#define	PARAMETER_E    4
#define	PARAMETER_F    5
#define	PARAMETER_G    6
#define	PARAMETER_H    7
#define	PARAMETER_I    8
#define	PARAMETER_J    9
#define	PARAMETER_K    10
#define	PARAMETER_L    11
#define	PARAMETER_M    12
#define	PARAMETER_N    13
#define	PARAMETER_O    14
#define	PARAMETER_P    15
#define	PARAMETER_Q    16
#define	PARAMETER_R    17
#define	PARAMETER_S    18
#define	PARAMETER_T    19
#define	PARAMETER_U    20
#define	PARAMETER_V    21
#define	PARAMETER_W    22
#define	PARAMETER_X    23
#define	PARAMETER_Y    24
#define	PARAMETER_Z    25
#define	PARAMETER_Z1   26			     /* Number of variables. */
#define	PARAMETER_ALL  -1		/* Match all parameters is searches. */

/*****************************************************************************
* The basic expression tree node definition:				     *
*****************************************************************************/
typedef	struct ExprNode {
     struct ExprNode *Right, *Left;
     int NodeKind;
     double Data;
} ExprNode;

/*****************************************************************************
* The function definitions as in expr2tre module:			     *
* Note the following explainations are not full	and give only brief scan...  *
*****************************************************************************/
ExprNode *Expr2Tree(char *str);  /* Main routine - conv. string to bin-tree. */
int ParserError(void);		  /* Return last error found in Expr2Tree(). */
void PrintTree(ExprNode *Root, char *str);  /* Print bin-tree in infix form. */
ExprNode *CopyTree(ExprNode *Root);    /* Create a totally new copy of tree. */
double EvalTree(ExprNode *Root);	       /* Numerically evaluate tree. */
int EvalError(void);		   /* Return last error found in EvalTree(). */
#ifdef DERIVATIVE
ExprNode *DerivTree(ExprNode *Root, int prm);	   /* Symbolic der. of tree. */
int DerivError(void);		  /* Return last error found in DerivTree(). */
#endif DERIVATIVE
void SetParamValue(double Value, int Num);    /* Assign Value to param. Num. */
int CmpTree(ExprNode *Root1, ExprNode *Root2);    /* Cmp. symbol. two trees. */
int ParamInTree(ExprNode *Root, int Param); /* Return if Param in tree Root. */
void FreeTree(ExprNode *Root);	 /* Release dynamic memory occupied by tree. */

/*****************************************************************************
* Error numbers as located during the parsing process:			     *
*****************************************************************************/
#define P_ERR_WrongSyntax	1
#define P_ERR_ParamExpect	2
#define P_ERR_OneOperand	3
#define P_ERR_TwoOperand	4
#define P_ERR_StackOV		5
#define P_ERR_ParaMatch		6
#define P_ERR_UndefToken	7

/*****************************************************************************
* Error numbers as located during the derivation creation:		     *
*****************************************************************************/
#define	D_ERR_NoneConstExp	1
#define	D_ERR_NoAbsDeriv	2
#define	D_ERR_NoMinDeriv	3
#define	D_ERR_NoMaxDeriv	4
#define	D_ERR_NoModDeriv	5

/*****************************************************************************
* Error numbers as located during the evaluation process:		     *
*****************************************************************************/
#define	E_ERR_DivByZero 1

#endif EXPR_2_TREE_GH
