
#include "stdlib.h"
#include "fcntl.h"
#include "memory.h"
#include "stdio.h"
#include "io.h"
#include "func.h"

boolean is386;

#define SIZE 16384U
unsigned char buff1[SIZE];
unsigned char buff2[SIZE];


// Simply compare the two buffers byte by byte,
// and report any mismatches.  The buffers should be identical,
// but do to faulty external caches, the data can become corrupted.

void compare(char *p1,char *p2,unsigned size,unsigned long pos)
{
char *save=p1;

while (size--)
  { if (*p1 != *p2)
      { printf(
"Mismatch at: %5u  Pos: %7lu  adr1: %4x adr2: %4x  buff1=%3u buff2=%3u\n",
	      p1-save,pos+(unsigned)p1-(unsigned)save,p1,p2,*p1,*p2);
      }
    p1++;
    p2++;
  }
}
      


void do_file(int fh,unsigned size)
{
unsigned count;
unsigned long pos;
char *ptr;
unsigned i;

_lseek(fh,pos=0L,SEEK_SET);

printf("Buffer: %5u\n",size);

while (count=_read(fh,buff1,size))	// standard read routine
  { for (i=0;i<32;i++)
      memcpy(buff2,buff1,count);	// standard memcpy routine

    compare(buff1,buff2,count,pos);
    pos += count;
  }
}



unsigned main(unsigned argc,char *argv[])
{
int fh;
unsigned i;

if ((fh=_open(argv[1],O_RDONLY|O_BINARY)) == -1)
  { printf("Can't open %s\n",argv[1]);
    return 1;
  }

for (i=64; i<=SIZE; i<<=1)
  do_file(fh,i);

return 0;
}
