          



          Chapter 3 - The JAWS Menu System



          The chapter entitled "The  Speech  Pad  and  Keyboard",  the JAWS
          Tutorial,  Part  1  should  be  read  or listened to, or the JAWS
          Training tape about the speech pad  should be  listened to before
          proceeding with this chapter.



          The Menu System                                   page - 32
          

          The JAWS menu system is designed to be user-friendly. The 
          operator can easily adjust the basic configuration of JAWS 
          without having to remember which key sequence performs what 
          function.  By going through the menu system, a user may adjust 
          voice parameters such as volume, rate, and pitch of speech; 
          universal parameters such as sensitivity to upper and lower case 
          letters, and the way specific words are pronounced; load a 
          previously saved configuration; define or revise window frames; 
          or search the screen for a string of characters or an 
          enhancement.

          After JAWS has been loaded into memory, the menu system will be 
          accessed by typing a "Hot Key", normally "Control-/" (holding 
          down the "Control" key and pressing the forward slash "/" key).  

          An alternative  "Hot Key"  is shift-control-insert, hold down the
          shift and the control key and press the insert or zero key on the
          numeric pad.

          Currently, for the menu system to function, the monitor must be 
          in an 80 column across by 25 row down text mode.  If the monitor 
          is in a graphic mode or a 40 column text mode, the menu system 
          may not function properly.  When using application programs which
          use these display modes, you should not attempt to use the JAWS 
          menu system.  

          When the menu system is invoked, the menus will occupy the upper 
          four lines of the  monitor  screen  and  the  PC  Cursor  will be
          activated to  control menu operations  (the JAWS Cursor can still
          be turned on and used to read around the menu system and the rest
          of the  screen).   When the  menu system  is exited, the original
          screen contents and cursor state and  position will  be restored.
          If the  monitor being  used is  a color monitor, JAWS' menus will
          display  with  red  characters  on  a  black  background.    On a
          monochrome  monitor,  the  menus will display with high-intensity
          (brighter)  characters  on  a  black  background.    The  menu is
          enclosed in  a double  line border  with the title of the current
          menu located within the top border.  We will refer  to this first
          line as  the title  line. The  side borders and bottom border are
          solid double lines.  Nothing will appear within these borders.

          The second line of the screen will contain the items to choose
          from for the current menu.  We will refer to this line as the
          top or first line of the menu.  Along this top line, one item
          will always be highlighted.  On a color monitor, the highlighted
          item will appear as black characters on a red background.  On a
          monochrome monitor, the highlighted item will appear in reverse
          video (black characters on a white background).  The third line
          of the screen will contain a general description of what you may
          do when the highlighted item is selected. We will refer to this

          The Menu System                                   page - 33
          

          line as the bottom or second line of the menu.



          The Menu System                                   page - 34
          

          SELECTING AN ITEM.

          There are two ways to select an item.  You can move the highlight
          bar to the desired option by using either Prior Character and 
          Next Character (the Left Arrow and Right Arrow keys) or by 
          using Prior  Word and  Next Word and pressing either Enter or the
          Down Arrow (Next Line) key.   Alternatively, you  can simply type
          the letter  appearing in  upper case (usually the first letter of
          the word) in the name of the desired  item (JAWS  will inform you
          of the  letter appearing in upper case if you use Prior Character
          or Next Character to  select a  choice, or  if you  perform a Say
          Character when  a choice is highlighted). One of three things can
          happen when you select an item:   you  will "descend"  to another
          menu,  you  will  be  asked  to  enter  information specific to a
          function, or you will cause JAWS to execute the function you have
          selected.

          Within the menu system, there are several keys of particular 
          interest:  

          1.   Prior Character  or Next  Character (the left or right arrow
          keys) will cause the highlight bar to move  left or  right across
          the menu  items.   As the  highlight bar moves, the speech device
          will speak the letter which appears  in  upper  case  in  the new
          selection. If  the Prior  Word or Next Word keys are used instead
          of Prior or Next Character, the  highlight bar  will move  to the
          appropriate selection,  and that entire selection will be spoken.
          If the leftmost item  is highlighted  and the  left arrow  key is
          pressed (or  Prior Word), the highlight bar will "wrap-around" to
          the  rightmost  item.    Similarly,  if  the  rightmost  item  is
          highlighted and you press the right arrow key (or Next Word), the
          highlight bar will wrap around to the leftmost item.

          2.   The Say Line key (the Zero-8) will speak the currently 
          highlighted item along with the description appearing on line 2 
          of the menu.

          3.   The Escape key will cause a return to the next higher 
          menu, if one exists; or if you are in the main menu (the highest 
          level) an exit the menu system and a return to what you were 
          doing before you pressed the Hot Key. If you are being asked to 
          provide information specific to a function and decide not to
          perform the function, pressing Escape will cause a return to 
          the menu from which the function was called. The Up Arrow key 
          and the letter X will function identically to the Escape key.

          4.   The Enter key will select the currently highlighted item 
          and either bring you to a "lower" menu, bring you to a prompt 
          requesting further information, or begin to perform a function.  
          The Down Arrow key will function identically to the Enter key.

          The Menu System                                   page - 35
          


          5.   Typing Alt-X (holding down the Alt key and pressing the
          letter X) will cause you to immediately leave the menu system
          and return to what you were doing before you typed the Hot Key.
          If you are being prompted for information, you will immediately
          stop and return to the application.  Any information entered
          prior to pressing Alt-X will be discarded.  Alt-Escape will
          function identically to Alt-X.



          The Menu System                                   page - 36
          

          LEVEL ADJUSTING MENUS.

          Level Adjusting Menus are frequently used to adjust volume, rate,
          and  pitch.  In  most  respects, a Level Adjusting Menu functions
          very much like the standard menu described above.  Pressing Prior
          Character or Next Character (the Left Arrow or Right Arrow keys),
          or Prior Word and Next Word will cause the highlight  bar to move
          left or right, Escape (or an X, or an Up Arrow) will cause you to
          return to the previous menu,  and  typing  Alt-X  (or Alt-Escape)
          will exit  the menu  system.  The differences from standard menus
          are discussed in the paragraphs below.

          The title line of a Level Adjusting Menu will specify which level
          you are adjusting.

          Line 1 of a Level Adjusting Menu specifies the range over which 
          the particular level can be adjusted.  This range will vary 
          depending on the particular speech device and whether you are 
          specifying a volume, rate, pitch, or other level.  The line will 
          contain numbers representing the various discrete levels within 
          the range, which will always be from one to the maximum value
          within the range.  The current setting of the level will always 
          be highlighted.

          Line 2 of a Level Adjusting Menu gives brief instructions 
          concerning the keys to be used to adjust a level.  

          To decrease a single level you may either use the Left Arrow 
          key (Prior Character will decrease the level without speaking, 
          Prior Word will decrease the level and speak the new level), 
          type L for lower, or type < for Less-than.  To increase a 
          single level, you may either use the Right Arrow key (Next 
          Character will increase the level without speaking, Next Word 
          will increase the level and speak the new level), type H for 
          higher, or type > for greater-than.  To set a specific level, 
          you may simply type the number of the desired level and press 
          Enter.  

          Note that in level adjusting menus, Escape and Alt-X do not 
          discard the new level and restore the old level.  Changes to the 
          various levels take effect as soon as they are made.

          For example, selecting the option Volume from the JAWS Global 
          Echo Menu will bring up the Adjust Global Volume menu.  Assume
          that Line 1 of the menu has numbers in the range of 1 to 10 
          displayed on it.  If the volume is currently at level 5, the 
          number 5 on line 1 will be highlighted.  If you wish to decrease 
          the volume but you're not sure to what level, you can use Prior 
          Word (Zero-4) (or the letter L, or the < symbol).  Each time
          you press Prior Word, the volume will be decreased and the 

          The Menu System                                   page - 37
          

          speech device will speak the new level.  When the volume is 
          correct, you can press Escape to return to the previous menu or
          Alt-X to return to the application.

          If you know beforehand that volume level 7 is the most 
          comfortable and the current level is 3, you can simply type the 
          character 7  and press  Enter.  The volume will be set to level 7
          and the  speech device  will say  "seven".   Again, typing Escape
          will return to the previous menu or Alt-X will return to the 
          application.



          The Menu System                                   page - 38
          

          THE MAIN MENU.

          When you type the Hot Key from DOS or from within an application 
          program, you will enter the JAWS menu system.  The first menu 
          which will appear is the JAWS Main Menu.  The speech device will 
          respond "JAWS Main Menu".  The choices offered by the Main Menu 
          are:  

          Voice       - Adjust all voice parameters.

          Configfiles - Load from disk or save to disk a configuration
                        file.

          Frames      - Speak, activate, quiet, or revise a frame.

          Macro       - Create, revise, duplicate, or erase a macro.

          Enhance     - Find and speak screen enhancements or colors.

          Search      - Search forward or backward on the screen for
                        a string of characters.

          Go to       - Go to a screen row or column.

          All the  main menu items except Search and Go to will move you to
          a lower level menu.   Search  and  Go  to  will  ask  for further
          information and then perform their respective functions.

          Selecting Voice will allow you to adjust the manner in which 
          characters and words are spoken.  Among other things, volume, 
          rate, and pitch  can be adjusted; multiple identical character 
          filtering can be adjusted or disabled; and JAWS' sensitivity to 
          upper and lower case letters can be enabled or disabled.

          Selecting Configfiles will allow you to save the existing 
          configuration of JAWS to a file for later recall or to load a 
          previously saved  JAWS configuration.  Also use this menu to save
          or load dictionary files.
           
          Selecting Frames will allow you to speak, activate, quiet or 
          revise window frames.  With Frames, you will be able to 
          restrict JAWS' attention to a particular region of the screen
          such as an application's window or the position for a name and 
          address on a data entry screen.  Frames can also be silenced so 
          that changes made to a specific area of the display screen will 
          not be inadvertently spoken (such as the status line of a word 
          processor which changes whenever a character is typed).



          The Menu System                                   page - 39
          

          Selecting Macro will allow you to create or revise, duplicate, 
          erase, or identify a  JAWS macro  key definition.   Using macros,
          you will  be able to customize the current JAWS configuration for
          easier use with various  application programs.   For  example, if
          you use  the WordStar word processor which uses Control-F to move
          to the next word in a document, you will probably  want to create
          a macro  which, when  JAWS sees you type Control-F, will insert a
          Say Word command after the Control-F.   Such  a macro  will cause
          the cursor  to move  and also  speak the word to which the cursor
          has moved.

          Selecting  Enhance  will  allow  you  to  search  for   a  screen
          enhancement or  color and control how enhancements will be spoken
          when the Zero key is held down and  the 5  on the  numbers row is
          pressed.   You will be able to repeat the most recent enhancement
          search, search for an enhancement different from the current one,
          or search  for a  specific enhancement.  You will also be able to
          specify the starting position (from the cursor location,  the top
          of the screen, or the bottom of the screen) and direction for the
          search (forward or backward) or restrict the search to a specific
          frame.  

          Selecting Search  will allow  you to search for a specific string
          of characters on the  screen.   You will  be able  to specify the
          starting  position  (from  the  cursor  location,  the top of the
          screen, or the bottom of the screen) and direction for the search
          (forward  or  backward),  or  restrict  the  search to a specific
          frame.

          Selecting Goto will allow you to move the JAWS Cursor to a 
          specific row and column location on  the  screen.    You  will be
          asked to  specify the position to move to - such as r5 c8 to move
          to row 5 column 8 - and then press Enter. 



          The Menu System                                   page - 40
          

          THE VOICE MENU.

          Selecting Voice from the  JAWS Main  Menu will  bring you  to the
          JAWS Voice Menu, whose choices will allow you to control the 
          behavior of the speech device attached to your computer.  The 
          choices offered by the Voice menu are:

          Keyboard  - Adjust voice parameters for keyboard echo.

          Screen    - Adjust voice parameters for screen echo.

          speechPad - Adjust voice parameters for the speech pad.

          Global    - adjust speech parameters for keyboard, screen, and
                      speech pad.

          Universal - Dictionary, numbers, symbols, pause, case, filter,
                      etc.

          Each selection will bring you to a lower menu.  Typing Escape
          will return you to the JAWS Main Menu.

          Selecting Keyboard,  Screen, speechPad, and Global will allow you
          to adjust such things as whether or not characters or  words from
          that particular  source will be spoken and the level at which the
          volume, rate, and pitch for the  speaking of  those characters or
          words will be set.

          Selecting Universal  will allow you to adjust the manner in which
          words are spoken.  For  example,  Dictionary  will  allow  you to
          adjust the  way the  speech device pronounces certain words while
          Numbers will allow you to specify whether you want numbers spoken
          as digits  (ie. one  two three)  or as  full numbers (one hundred
          twenty-three).



          The Menu System                                   page - 41
          

          THE GLOBAL ECHO MENU.

          Selecting Global from the JAWS Voice Menu will  bring you  to the
          JAWS Global Echo Menu, whose choices will allow you to adjust the
          speech  parameters  for  the  keyboard,  screen,  and  speech pad
          simultaneously.   Additionally, the  selections Keyboard, Screen,
          and speechPad on the Voice menu  will  allow  you  to  adjust the
          speech  parameters  for  each  of  the  three  sources  of speech
          independently of one another. The Global Echo Menu selection 
          Volume, for example, will allow you  to increase  or decrease the
          volume level  for all  three sources  of speech at once while the
          Keyboard Echo Menu selection Volume will change the  volume level
          for only  those characters  typed at  the keyboard.   The choices
          offered by the Global Echo Menu are:

          Echo   - Enable or disable both keyboard and screen echoing.

          Volume - Adjust the overall volume level.

          Rate   - Adjust the overall rate of speech.

          Pitch  - Adjust overall pitch.

          Typing Escape will cause you to return to the JAWS Voice Menu.

          Selecting Echo will bring you to a menu  which will  allow you to
          either enable  or disable keyboard and screen echoing.  If either
          keyboard or screen echoing is enabled,  the oN  selection will be
          highlighted.   Otherwise, the  ofF selection will be highlighted.
          If oN is selected  and  keyboard  echoing  was  off,  it  will be
          enabled in  the state  it was  in   prior to being turned off (if
          keyboard echo was set to Word before being turned off, it will be
          set to Word when re-enabled).

          Selecting  Volume,  Rate,  or  Pitch  will  bring  you to a Level
          Adjusting menu which will allow you to simultaneously  adjust the
          level  of  volume,  rate  of  speech,  or pitch for the keyboard,
          screen, and speech pad.  With  a level  adjusting menu,  Next and
          Prior Word,  Next and  Prior Character,  the letters H and L, and
          the symbols greater than and less than will allow you to make the
          level  higher  or  lower.    For more detailed information on how
          level adjusting menus work, refer to the section  of this chapter
          entitled "Level Adjusting Menus".



          The Menu System                                   page - 42
          

          THE KEYBOARD ECHO MENU.

          Selecting Keyboard from the JAWS Voice Menu will bring you to
          the JAWS Keyboard Echo Menu, whose choices will allow you to 
          alter the way characters typed at the keyboard are spoken by the 
          speech device.  These choices are:

          Echo          - Characters, words, off.

          Volume        - Adjust the volume level for keyboard echoing.

          Rate          - Adjust the rate of speech for keyboard echoing.

          Pitch         - Adjust the pitch for keyboard echoing.

          Interruptable - Enable or disable interruptable speech for
                          keyboard echoing.

          Labels        - Turn keyboard labels on or off.

          Keyrepeat     - Turn automatic key repeat on or off.

          Typing Escape will return you to the JAWS Voice Menu. 

          Selecting  any  of  the  choices  on  this menu will bring you to
          another menu; however, the choices Volume,  Rate, and  Pitch will
          bring you  to a special Level Adjusting menu which will allow you
          to adjust the level of that particular speech attribute.   With a
          level  adjusting  menu,  Next  and  Prior  Word,  Next  and Prior
          Character, the letters H and L, and the symbols greater  than and
          less than  will allow you to make the level higher or lower.  For
          more detailed information concerning  how a  Level Adjusting Menu
          works,  refer  to  the  section  of  this chapter entitled "Level
          Adjusting Menus".

          Selecting Echo will bring you to a menu where you will be able 
          to specify whether you want keyboard input echoed as individual 
          characters, as entire words, or not echoed at all.  The current 
          setting will be highlighted.

          Selecting Interruptable will bring  you to  a menu  where you can
          enable or  disable the  interruptability of  keyboard input.  The
          current setting will be highlighted.   For example,  while typing
          within a  word processor  you might want individual characters to
          be echoed; but, for speed  and  easier  typing  you  might enable
          interruptable speech so that when you type a letter, any previous
          letter being spoken will be interrupted by the new letter.

          Selecting Labels will bring you to a menu  where you  can turn on
          or off the speaking of individual key labels.  The current 

          The Menu System                                   page - 43
          

          setting will be highlighted.  If turned off, key labels such as 
          Page Down will not be spoken when the key is pressed.


          Selecting Keyrepeat will bring you to a menu where you can
          enable or disable automatic key repeat.  The current setting will
          be highlighted.  If Keyrepeat is on, holding down a key will
          cause that character to automatically repeat after about one
          second.



          The Menu System                                   page - 44
          

          THE SCREEN ECHO MENU.

          Selecting Screen from the JAWS Voice Menu will bring you to 
          the  JAWS Screen Echo Menu, whose choices will allow you to 
          adjust voice parameters for the echoing of characters to the 
          screen.  The choices offered by this menu are:

          Echo   - Enable or disable screen echoing.

          Volume - Adjust the volume for screen echoing.

          Rate   - Adjust the rate of speech for screen echoing.

          Pitch  - Adjust the pitch for screen echoing.

          Typing Escape will cause you to return to the JAWS Voice Menu.

          Selecting Echo will bring you to a menu which will allow you to
          either enable or disable the echoing of characters being written
          to the screen.  The current setting will be highlighted.

          The selections  Volume, Rate,  and Pitch  will bring you to Level
          Adjusting menus which will allow you to adjust the level  of that
          particular speech  attribute.   With a level adjusting menu, Next
          and Prior Word, Next and Prior  Character, the  letters H  and L,
          and the symbols greater than and less than will allow you to make
          the  level  higher  or  lower.    For  more  detailed information
          concerning how a level adjusting menu works, refer to the section
          of this chapter entitled "Level Adjusting Menus".



          The Menu System                                   page - 45
          

          THE SPEECH PAD ECHO MENU.

          Selecting speechPad from the  JAWS Voice  Menu will  bring you to
          the JAWS  Speech Pad  Echo Menu,  whose choices will allow you to
          adjust the voice parameters for  the  speech  pad.    The choices
          offered are:

          Volume        - Adjust the volume level for the speech pad.

          Rate          - Adjust the rate of speech for the speech pad.

          Pitch         - Adjust the pitch for the speech pad. 

          Interruptable - Enable or disable interruptable speech for the
                          speech pad.

          Typing Escape will cause you to return to the JAWS Voice Menu.

          The selections  Volume, Rate,  and Pitch  will bring you to Level
          Adjusting menus which will allow you to change the level  of that
          particular speech  attribute.   With a level adjusting menu, Next
          and Prior Word, Next and Prior  Character, the  letters H  and L,
          and the symbols greater than and less than will allow you to make
          the  level  higher  or  lower.    For  more  detailed information
          concerning how  level adjusting  menus work, refer to the section
          of this chapter entitled "Level Adjusting Menus".

          Selecting Interruptable will bring you to a menu which will allow
          you  to  either  enable  or  disable interruptable speech for the
          speech pad.  The current setting for interruptable speech for the
          speech  pad  will  be  highlighted.    If interruptable speech is
          turned on,  speech  pad  commands  will  be  interrupted whenever
          another key  is pressed or whenever another speech pad command is
          issued.  For further information on the functioning of the speech
          pad, refer to the chapter of this manual entitled Speech Pad.



          The Menu System                                   page - 46
          

          THE UNIVERSAL SPEECH MENU.

          Selecting Universal  from the  JAWS Voice  Menu will allow you to
          alter certain "universal" speech  parameters which  are described
          in  detail  below.    The  choices  offered by the JAWS Universal
          Speech Menu are:

          Dictionary - Adjust the pronunciation of words.

          Numbers    - Adjust the pronunciation of numbers.

          Symbols    - Adjust the speaking of punctuation and special
                       characters.

          Pause      - Adjust the length of the pause between words.

          Case       - Enable or disable the sensing of upper and lower
                       case letters.

          Filter     - Limit the speaking of multiple identical characters.

          Acronyms   - Spell acronyms that are all upper case.

          All of the selections will bring you to other menus.  Typing 
          Escape will cause you to return to the JAWS Voice Menu.

          Selecting Pause will bring you to a special  Level Adjusting menu
          which will  allow you to adjust the duration of the pause between
          words.  With a level adjusting  menu, Next  and Prior  Word, Next
          and Prior Character, the letters H and L, and the symbols greater
          than and less than  will allow  you to  make the  level higher or
          lower.   For further and more detailed information concerning the
          operation of level adjusting menus, refer to the  section of this
          chapter entitled "Level Adjusting Menus".

          Selecting Numbers will allow you to specify whether numbers 
          should be  spoken as  individual digits  or as full numbers or as
          pairs.  The current setting will be highlighted.  For example, if
          numbers are  to be spoken as digits, the value 123 will be spoken
          as "one two three".   On  the other  hand, if  numbers are  to be
          spoken as full numbers, 123 will be spoken as "one hundred twenty
          three".

          Selecting Case will bring you to a menu  which will  allow you to
          either  enable  or  disable  the  sensing of upper and lower case
          letters.  The current  setting  will  be  highlighted.    If case
          sensitivity  in  spell  mode  is enabled, JAWS will differentiate
          between upper and lower case letters by pausing and then speaking
          upper case  letters in  a higher  pitch.   If case sensitivity in
          full speech mode is enabled then JAWS will say "cap" if the first

          The Menu System                                   page - 47
          

          letter of  the word  is capitalized.  If the whole is capitalized
          JAWS will say "cap cap".  If any other situation  exists, such as
          the first  two letters  capitalized, probably an error, JAWS will
          say "cap" three times. 



          The Menu System                                   page - 48
          

          THE DICTIONARY MENU.

          Selecting Dictionary from the  JAWS  Universal  Speech  Menu will
          bring you  to the  JAWS Dictionary Menu, whose choices will allow
          you  to  enable,  disable,  ERASE  FROM  or  add  to  the  speech
          translation dictionary.   If  an entry for a word is found in the
          dictionary, the revised pronunciation will be sent to  the speech
          device  in  place  of  the  original word. For example, without a
          dictionary entry, the word echo is often pronounced "etch-o".  If
          the  a  dictionary  entry  has  been created for echo, the speech
          device will pronounce it using the stored pronunciation  (such as
          "ekko"). The choices offered by this menu are: 

          oN     - Use the currently loaded dictionary words.

          ofF    - Do not use the currently loaded words.

          Add    - Add a word to the dictionary.

          Erase  - Erase a word from the dictionary.

          Typing Escape will return you to the JAWS Universal Speech Menu.

          Selecting oN will allow you to use the currently loaded 
          dictionary words.  Selecting ofF will disable dictionary 
          translation.

          Selecting Add  will allow you to add a word to the dictionary. If
          a word is being mispronounced by the speech  device and  the word
          does not already exist in the dictionary, adding an entry for the
          word  along  with  a  revised  pronunciation  should  correct the
          problem.

          The word  or phrase you add to the dictionary must be preceded by
          a delimeter character.  The same delimeter must separate the word
          or  phrase  being  entered  from the substitution string, and the
          substitution string must be followed by the same  delimeter.  The
          delimeter can  be any  character, the  first character entered is
          selected by JAWS to  be the  delimeter.   For example,  to change
          "goodbye" to "adios" enter anyone of the following examples:

          .goodbye.adios.
          ;goodbye; adios ;
          "goodbye"adios"

          Remember that any character can be used as a delimeter, the first
          one entered is the delimeter.  This technique allows changing any
          character  or  string  of  characters into any other characger or
          string of characters, eliminating the limitations  posed by other
          dictionary systems.

          The Menu System                                   page - 49
          


          Selecting Erase will allow you to remove the definition of a
          word from the dictionary.  When an entry is erased and the word
          is encountered, it will be passed to the speech device unaltered.

          To erase  a dictionary  entry select  "Erase" from  the menu, you
          will be prompted to enter the word or phrase you  wish to delete.
          Enter the  word or phrase without the delimeter character.  If it
          is in the dictionary it will be erased  and you  will be returned
          to the dictionary menu.

          Dictionary files  can be  saved on  disk or loaded from disk, and
          they can be created  or edited  in a  standard word  processor or
          editor.  See the chapter on configuration files for details.
             



          The Menu System                                   page - 50
          

          THE SYMBOLS MENU.

          Selecting Symbols from the  JAWS Universal Speech Menu will bring
          you to the JAWS  Symbols Menu,  whose choices  will allow  you to
          specify whether you wish to have all, most, or only some symbols,
          punctuation  marks,  and  special  characters  verbalized.    The
          choices offered by this menu are:

          All  - Speak all symbols.

          Most - Speak most symbols.

          Some - Speak only some symbols.

          None - Speak no symbols.

          Typing  Escape  will  cause  you  to return to the JAWS Universal
          Menu.

          Selecting All will cause the speech device to speak every symbol,
          punctuation  mark,  or  special  character as text is being read.
          This mode would be most useful when proof  reading a  document to
          check punctuation and spelling.

          Selecting Most  will cause the speech device to speak all symbols
          except for  some common  punctuation marks.   This  mode would be
          most useful  when using a word processor or other program to read
          a letter, manual, or other document.

          Selecting Some will cause the speech device to  speak only  a few
          punctuation or special symbols.

          Selecting  None  will  eliminate  the speaking of punctuation and
          other special characters.



          The Menu System                                   page - 51
          

          THE FILTER MENU.

          Selecting Filter from the JAWS Universal  Speech Menu  will bring
          you  to  the  JAWS  Filter  Menu, whose choices will allow you to
          adjust the manner in which multiple identical characters  will be
          spoken.   The current  setting will  be highlighted.  The choices
          offered are:

          3   - Speak multiple identical characters as three characters.

          4   - Speak multiple identical characters as four characters.

          5   - Speak multiple identical characters as five characters.

          6   - Speak multiple identical characters as six characters.

          All - Speak all multiple identical characters.

          Typing Escape will cause you  to  return  to  the  JAWS Universal
          Speech Menu.

          Your options are to speak multiple identical characters as three,
          four, five, or six characters; or to speak all multiple identical
          characters.   Selecting one  of these options will cause multiple
          identical characters to be filtered in that manner. 

          For example, when reading the  table  of  contents  of  a manual,
          periods  are  often  used  to  help  a  reader  match  a  section
          description with the page  number where  that section  begins.  A
          user  would  find  it  annoying  to  hear  the  speech device say
          "period" fifty seven times between the  description and  the page
          number  when  reading  the  manual  from disk.  To eliminate this
          problem, the user might  tell JAWS  to filter  multiple identical
          characters down  to three  characters.   So now the speech device
          will speak the description,  say "period  period period"  and say
          the page number.



          The Menu System                                   page - 52
          

          THE CONFIGURATION MENU.

          Selecting Configfiles  from the  JAWS Main Menu will bring you to
          the JAWS Configuration Menu, whose choices will allow you to load
          or save  a JAWS  configuration or  dictionary file.   The choices
          offered are:

          Load - Load configuration from a disk file

          Save - Save configuration to a disk file

          Typing Escape will cause you to return to the JAWS Main Menu.

          Selecting Load will allow you to load a previously saved 
          configuration.  You will be asked to provide a name for the 
          configuration you wish to load.  For example, you might have a 
          configuration loaded which is customized for use with 
          Lotus 1-2-3.  If you then wish to switch to Word Perfect  to edit
          a document, you would select Load, specify the name of the 
          configuration file customized for Word Perfect, and proceed to 
          run Word  Perfect.   This can also be done by running the program
          "JCF_LOAD" from a  batch  file  or  from  the  DOS  command line.
          JCF_LOAD, followed  by the  name of  the configuration file, will
          automatically load  that configuration  from disk.   This program
          may also be called "CONLOAD" on some versions of JAWS.

          Selecting Save  will allow  you to save the current configuration
          of JAWS for later recall.  You will be asked to provide a name to
          use for the configuration file.  The name of the most recently 
          loaded configuration  file will  be the  default.    When JAWS is
          first started, the file JAWS.JCF (if it exists) is loaded  as the
          initial  configuration.    If  you  wish to have certain settings
          become active  every time  JAWS is  loaded, simply  save the file
          with file name:  JAWS.JCF.

          The Save  option can  be useful  in two ways:  First, if you find
          that you frequently adjust  the  volume,  rate,  pitch,  or other
          speech parameter  every time  you load  a JAWS configuration, you
          should  save   the   configuration   after   making   your  usual
          adjustments.   As you  make adjustments,  they become part of the
          current configuration.  Saving  the configuration  will therefore
          save the  current settings  of the  various levels along with any
          frame and  macro  definitions.    The  next  time  you  load that
          configuration file, your custom settings will be there.

          Second, if you purchase a software package for which there is no 
          predefined custom configuration for JAWS, you can load an 
          existing configuration, alter it to fit the application, and save
          it for later recall.


          The Menu System                                   page - 53
          

          For further information concerning the customizing of JAWS, refer
          to the chapter entitled "Customizing JAWS".

          For  further  information  concerning  JAWS  Configuration Files,
          refer  to  the  chapter  of  this  manual entitled "Configuration
          Files".



          The Menu System                                   page - 54
          


          Dictionary files can also be loaded or saved using the configfile
          menu.   The dictionary files are designed to have an extension of
          ".JDF", which stands for JAWS Dictionary File.  When prompted for
          a file  name simply  include the JDF extension and JAWS will know
          that you want a dictionary file.  Once a dictionary file has been
          saved to  disk it can be edited in a word processor or editor and
          then loaded back into JAWS.

          THE FRAME MAINTENANCE MENU.

          Selecting Frames from the JAWS Main  Menu will  bring you  to the
          JAWS Frame  Maintenance Menu, whose choices allow you to maintain
          JAWS window frames.  Frames are essentially what the name implies
          -  a  "device"  used  to  focus  your (and JAWS) attention to the
          "picture" or window enclosed by the frame. The choices offered by
          this menu are:

          Speak    - Speak the contents of the screen within a frame.

          Activate - Activate a frame.

          Quiet    - Silence a frame.

          Revise   - Revise the definition of a frame.

          Typing Escape will cause you to return to the JAWS Main Menu.

          Each of  these options  will ask you to specify the number of the
          frame on which to operate.  The default  value will  initially be
          the frame  last referenced.  If no frame has yet been referenced,
          the default will be frame number one.  Pressing Enter will accept
          the default frame number as the frame to use.  If you wish to use
          a frame other than the default, you can simply type the number of
          that frame,  the default will be eliminated, and if the value you
          enter is a legitimate frame number  (currently frame  numbers may
          be in  the range  of 1  to 200),  that number will become the new
          default.  Additionally, the frame  with number 0 has been defined
          as occupying  the entire screen.  This frame cannot be changed or
          altered in any way, so if you are  asked for  a frame  number and
          you want  the function  to operate  on the entire screen, you can
          specify a frame number of 0.

          Selecting Speak and specifying a frame number will speak the 
          contents of the specified frame.

          Instead of specifying a number you can specify the frame that the
          cursor is  in.   Enter "J"  to speak the frame the JAWS cursor is
          in, "P" for the frame the PC cursor is in, and "A" for the active
          cursor, the  one that  is currently  turned on.   This feature is

          The Menu System                                   page - 55
          

          very useful on data base  systems,  you  can  create  a  macro to
          perform a  tab and  then speak the frame the PC cursor is in.  If
          the frames have been designed correctly you should hear the title
          and/or the contents of the field that the cursor moved to.

          Selecting Activate and specifying a number will make the 
          specified frame the active frame and remove any silencing from 
          it. When a frame is active, all reading and cursor movement will 
          take place within that frame.  The number of the currently active
          frame will be saved as part of the configuration (for further 
          information concerning configurations, refer to the section of 
          this chapter entitled "The Configuration Menu"). 

          Selecting  Quiet  and  specifying  a  frame number will cause the
          specified frame to be silenced.   Silencing a  frame prevents its
          contents from being inadvertently spoken; therefore, when a frame
          is silenced,  changes made  to anything  within that  frame by an
          application program  will not  be spoken.  However, if the number
          of the silent frame is specified in the Speak command,  the frame
          is embedded within a frame which is specified in a Speak command,
          or the data within the frame is accessed via the  speech pad, its
          contents will  be spoken.   This is because the methods of access
          just described are ways in which the user would intentionally ask
          to hear a frame's contents. 

          A  frame  will  remain  silent  until it is activated or revised.
          Should a silent frame  be  activated,  it  will  lose  its silent
          status and the user will have to again select Quiet to re-silence
          it.  Silencing a frame can be especially useful when using a word
          processor utilizing  the top lines of the screen as status lines.
          The status lines change whenever  a  character  is  typed  or the
          cursor is  moved, but the user seldom cares.  If the status lines
          have not been silenced, then  every  change  made  to  the status
          lines will be spoken.

          Selecting Revise  and specifying a frame number will allow you to
          alter the dimensions of a frame.  The current dimensions  will be
          displayed and  you will  be allowed  to alter  the top and bottom
          rows and the left and right columns of the frame.  Initially, all
          frames  will  occupy  the  entire  screen and therefore will have
          dimensions of top row = 1, bottom row = 25, left column  = 1, and
          right column = 80.

          Alternating between  Speak and  Revise will allow you to adjust a
          frame to include only  the information  that is  required for the
          specific application.  When the frame dimensions are correct, the
          frame can be activated, silenced, used  in a  macro, searched, or
          saved as part of a configuration file.

          For further and more detailed information on Frames and Frame

          The Menu System                                   page - 56
          

          Maintenance, refer to the chapter entitled "Frames".



          The Menu System                                   page - 57
          

          THE MACROS MENU.

          Selecting Macro  from the  JAWS Main  Menu will  bring you to the
          JAWS  Macros  Menu,  whose  choices  will  allow  you  to create,
          identify, and maintain macro definitions.  These choices are:

          Revise    - Create or revise a macro key definition.

          Duplicate - Duplicate a macro key definition.

          Erase     - Erase a macro key definition.

          Identify  - Identify defined macro keys.

          Typing Escape will cause you to return to the JAWS Main Menu.

          Selecting Revise  will allow  you to revise an existing macro key
          definition or create a  new macro  key definition.   You  will be
          asked for  the key  you wish  to revise.  If a definition exists,
          you will be allowed to revise the existing definition; otherwise,
          you will  be asked  to enter  the sequence  of key  strokes to be
          substituted when the defined key is  pressed.   The macro  may be
          edited  by  holding  down  the  Control and Left Shift keys while
          pressing any cursor movement key.  After  a  macro  definition is
          assigned,  it   may  be   further  revised,  duplicated,  erased,
          identified, or saved as  part of  the current  configuration. For
          further  information  concerning  configurations,  refer  to  the
          section of this chapter entitled The Configuration Menu. 

          Selecting Duplicate will ask you to specify the  key you  wish to
          duplicate and  then the  key to  receive its  definition.  If the
          receiving key has not been assigned  a macro  definition, it will
          be assigned the duplicate definition; otherwise, if the receiving
          key has already been  defined, an  error message  will appear and
          you will  be asked  to re-enter the receiving key. If you wish to
          duplicate  a  key  definition  on  a  key  which  already  has  a
          definition  assigned  to  it,  you  must first erase the existing
          definition for the receiving key.

          Selecting Erase will ask you  to  specify  the  key  you  wish to
          erase.   After you specify the key, the current definition of the
          key will appear and you will be asked for confirmation before the
          key definition is erased.

          Selecting Identify will allow you to browse the keys which are 
          defined along with their definitions.

          For further information on macros, refer to the chapter of this 
          manual entitled "Macros".


          The Menu System                                   page - 58
          

          THE ENHANCEMENT MENU.

          Selecting Enhance  from the  JAWS Main Menu will bring you to the
          JAWS Enhancement Menu, whose  choices  give  you  the  ability to
          search for or speak screen enhancements.  JAWS will sense whether
          you are using a color or  a monochrome  monitor and  allow you to
          search  for  or  speak  enhancements  accordingly.    The choices
          offered by this menu are:

          Different - Search for an enhancement different from the current
                      one.

          Find      - Search for a specific enhancement or color.

          Repeat    - Repeat the previous enhancement search.

          Say       - Say the foreground, background, or both enhancements.

          Typing Escape will allow you to return to the JAWS Main Menu.

          For all search operations, the currently active frame number will
          be the  default and the default search direction will be from the
          cursor forward (toward the bottom of the screen).  To  accept the
          defaults, simply press Enter.  Alternatively, you can specify the
          frame to search by entering the frame's number (selecting frame 0
          will search the entire screen) or select a different direction or
          starting position by specifying the letter T for Top of frame and
          forward, the  letter B  for Bottom  of frame and backward, or the
          letter C for Cursor position  and  backward.    Either  the frame
          number,  the  direction,  or  both  may  be  omitted  to  use the
          defaults.  However, if both are specified, the  frame number must
          appear first.

          Selecting Different  will allow  you to search for an enhancement
          different from the one where the cursor is  currently positioned.
          You will be asked to specify a frame number and the direction in 
          which to search.  

          Selecting Find will produce different results depending upon 
          whether you are using a color or a monochrome monitor.  If you 
          have a color monitor, you will be brought to the JAWS Find-a-
          Color Menu and offered the various color choices available.  If
          you have a monochrome monitor, you will be brought to the JAWS
          Find Highlight Menu and allowed to choose from the various types
          of monochrome highlighting available.  After selecting the type
          of enhancement to search for, you will be asked to specify a
          frame number and the direction in which to search. When you've
          specified all the information, JAWS will exit the menu system, 



          The Menu System                                   page - 59
          

          search for the NEXT occurrence of that specific enhancement,
          position the JAWS Cursor at that point, and turn on the JAWS
          Cursor.

          Selecting Repeat will allow you to re-execute the previous
          enhancement search using the same options.

          Selecting Say will bring you to the JAWS Say Enhancement Menu
          which will  allow you  to specify how enhancements will be spoken
          when the Zero key is held down and  the number  5 on  the numbers
          row is pressed.  

          For  further  information  concerning  enhancements, refer to the
          chapter of this manual entitled "Enhancements".



          The Menu System                                   page - 60
          

          THE FIND-A-COLOR MENU.

          If you have a color monitor and you select Find from the JAWS 
          Enhancement Menu, you will be brought to the JAWS Find-a-Color 
          Menu which will allow you to specify the color for which to 
          search.  The choices offered by this menu are:

          B       - Black, Blue, Brown, Bright-White.

          L       - Light blue, Light green, Light cyan, Light magenta.

          G       - Gray, Green.

          Cyan    - Search for a cyan enhancement.

          Red     - Search for a red enhancement.

          Magenta - Search for a magenta enhancement.

          White   - Search for a white enhancement.

          Yellow  - Search for a yellow enhancement.

          Typing Escape will cause  you to  return to  the JAWS Enhancement
          Menu.

          Selecting  the  letters  B,  L,  or G will bring you to sub-menus
          which will allow you to choose  from  the  colors  listed  in the
          description for  that menu  item.   For example, selecting B will
          allow you to  choose  from  the  colors  Black,  Blue,  Brown, or
          Bright-White.

          Selecting one of the other options offered on the menu will allow
          you to search for that particular color.

          After selecting a color, you will be asked to specify whether the
          enhancement should  be in  the foreground,  background, or either
          the foreground or the background.   You  will  then  be  asked to
          specify a  frame number  and a direction in which to search.  The
          currently active frame number will be the default and the default
          search  direction  will  be  from  the cursor forward (toward the
          bottom of the screen).  You  can specify  the frame  to search by
          entering the  frame's number  (selecting frame  0 will search the
          entire screen). You can select a different direction  or starting
          position by specifying the letter T for Top of frame and forward,
          the letter B for Bottom of  frame and  backward, or  the letter C
          for Cursor  position and  backward.  Either the frame number, the
          direction, or both may be omitted to use the defaults.   However,
          if both are specified, the frame number must appear first.


          The Menu System                                   page - 61
          

          THE FIND HIGHLIGHT MENU.

          If you have a monochrome monitor and you select Find from the
          JAWS Enhancement Menu, you will be brought to the JAWS Find
          Highlight Menu, whose choices will allow you to specify which
          monochrome enhancements JAWS should attempt to find.  The choices
          offered by this menu are:

          Reverse    - Search for a reverse video item.

          Normal     - Search for a normally highlighted item.

          Intense    - Search for an intensely highlighted item.

          Underlined - Search for an underlined item.

          Blinking   - Search for a blinking item.

          Typing Escape  will cause  you to  return to the JAWS Enhancement
          Menu.

          After selecting any  of  these  options,  you  will  be  asked to
          specify the  frame number  and the  direction of the search.  The
          currently active frame number will be the default and the default
          search  direction  will  be  from  the cursor forward (toward the
          bottom of the screen).  You  can specify  the frame  to search by
          entering the  frame's number  (selecting frame  0 will search the
          entire screen). You can select a different direction  or starting
          position by specifying the letter T for Top of frame and forward,
          the letter B for Bottom of  frame and  backward, or  the letter C
          for Cursor  position and  backward.  Either the frame number, the
          direction, or both may be omitted to use the defaults.   However,
          if both are specified, the frame number must appear first.

          After entering  any options and pressing Enter, JAWS will perform
          the search.  If  the  desired  enhancement  is  found  (either by
          itself  or  in  combination  with  other  enhancements), the menu
          system will be exited, the JAWS Cursor will be positioned at that
          point and  the field  will be  spoken.   If the search fails, the
          menu  system  will  be  exited,  the  cursors  returned  to their
          original positions, and an  error tone will be produced.



          The Menu System                                   page - 62
          

          THE SAY ENHANCEMENT MENU.

          If  you  have  a  color  monitor,  selecting  Say  from  the JAWS
          Enhancement Menu will bring you to the JAWS Say Enhancement Menu,
          whose choices  will allow  you to specify how screen enhancements
          should be spoken.  The choices are: 

          Foreground - Say the foreground enhancement.

          Background - Say the background enhancement.

          Both       - Say both the foreground and background enhancements.

          Typing Escape will cause  you to  return to  the JAWS Enhancement
          Menu.

          These options  will cause  either the  foreground, background, or
          both enhancements to be spoken when the Zero key is held down and
          the 5 on the numbers row is pressed.

          These selections only apply to color monitors.



          The Menu System                                   page - 63
          

          THE STRING SEARCH MENU.

          Selecting Search  from the  JAWS Main  Menu will bring you to the
          JAWS String Search Menu.   This  is not  a true  menu in  that it
          offers no choices or selections - it simply asks you to enter the
          string you  wish to  find and  then asks  you to  specify a frame
          number and options - such as the direction to search.

          Line 1  of the menu will display the word "Find:" followed by the
          last string searched for, should one exist.   Line 2  of the menu
          will display  the message "Enter the string to search for...". If
          you press Enter at this point, the previous string (if  any) will
          be used  as the  default.   Typing Escape  before you press Enter
          will cause you to return to the JAWS Main Menu.

          After entering a  string,  JAWS  will  ask  you  for  "Options". 
          Options can be either a frame number, the direction to search, or
          both. The currently active frame number  will be  the default and
          the  default  search  direction  will  be from the cursor forward
          (toward the bottom of the screen).  You can specify  the frame to
          search  by  entering  the  frame's number (selecting frame 0 will
          search the entire screen). You can  select a  different direction
          or starting  position by specifying the letter T for Top of frame
          and forward, the letter B for  Bottom of  frame and  backward, or
          the letter  C for Cursor position and backward.  Either the frame
          number,  the  direction,  or  both  may  be  omitted  to  use the
          defaults.   However, if both are specified, the frame number must
          appear first.

          After you have specified  the string  and any  options, JAWS will
          perform  the  search.    If  the  string has been found, the menu
          system will be exited, the JAWS Cursor will be turned on and
          positioned at the beginning of that string and the string will be
          spoken; otherwise,  JAWS will  produce an error tone and exit the
          menu system.



          The Menu System                                   page - 64
          

          THE GO TO MENU.

          Selecting Goto from the JAWS Main Menu will bring you to the JAWS
          Go To  Menu. This  is not  a true  menu in that it offers no true
          choices or  selections  -  it  simply  asks  you  to  specify the
          position you wish to go to.

          Line 1  of the  menu will say: "Enter the position to go to:" and
          line 2 of the menu will  say: "Enter  the number  of the  row and
          column  you  wish  to  go  to."   At this point you may enter the
          number of the row and/or column to which you wish to go.

          The position can be entered in a variety of ways,  and either the
          row or  the column  may be  omitted.  For example, to move to row
          12, column 40 you could enter  any  of  the  following:   r12c40,
          12r40c, 40c12r,  c40r12, r12  c40, r 12 c 40, etc.  The important
          point is that the row number must be preceded or  followed by the
          letter r  and the  column number  must be preceded or followed by
          the letter  c.    The  row  and  column  numbers  also  cannot be
          immediately next  to each other - they must be separated from one
          another by either a letter or a space (R12 40C is acceptable, but
          r1240c is not).

          After  you  have  specified  the  requested information, the JAWS
          Cursor will  be moved  to the  screen position  indicated and you
          will be returned to the application.



          The Menu System                                   page - 65
