procedure clean_up_display;
var start, finish : integer;
begin
   if (xkbd <= 1) AND (ykbd = out_start_line) then exit;
   start := (80*(yout - 1) + xout) - 1;
   finish := (80*(ykbd - 1) + xkbd) - 1;
   while start <= finish do
   begin
     if (start > lead_attr) then
       video^[start].a := xmt_attrib;
     start := start + 1;
   end;
end;

procedure del_char;
var backslash : char;
begin
  if (inp_ptr <> out_ptr) OR (mode in [AMTOR,PACKET]) then
  begin
    if xkbd > 1 then
    begin
      if (mode in [CW,RTTY,ASCII]) then
      begin
        inp_ptr := inp_ptr - 1;
        if (inp_ptr < 0 ) then inp_ptr := buf_size;
        dec(xkbd);
        gotoxy(xkbd,ykbd);
        transmit_color;
        write(' '^H);
      end;
      if mode in [AMTOR, PACKET] then
        begin
          transmit_color;
          gotoxy(xout,yout); write(' ');
          dec(xout);
          kam_out(^H);
          dec(xkbd);
          gotoxy(xkbd,ykbd);
          write(' '^H);
          repeat until char_ready;
          backslash := kam_in;
        end;
    end;
  end;
end;

procedure add_char(ch : char);
begin
  inp_ptr := (inp_ptr + 1) AND buf_size;
  kbd_buffer[inp_ptr] := ch;
  gotoxy(xkbd,ykbd);
  case state  of
    transmit   : transmit_color;
    receive    : aux_color;
    transceive : transmit_color;
  end;
  if ch = #$0D
  then begin
         write(#31);
         xkbd := 1;
         ykbd := ykbd + 1;
       end
  else begin
         case ch of
           #07 : case mode of
                   CW     : write(' ');
                   AMTOR,
                   RTTY,
                   ASCII,
                   PACKET : write(#254);
                 end;
           else  write(ch);
         end;
         xkbd := xkbd + 1;
         if xkbd > scrn_width then
         begin
           xkbd := 1;
           ykbd := ykbd + 1;
         end;
       end;
  if ykbd > out_end_line then
    begin
      transmit_color;
      window(1,out_start_line,80,out_end_line);
      gotoxy(1,1); DelLine;
      full_window;
      ykbd := ykbd - 1;
      yout := yout - 1;
    end;
  gotoxy(xkbd,ykbd);
end;

procedure RYs;
var   i : integer;
     RY : string[72];
begin
  RY := 'RYRYRYRYRYRYRYRYRYRYRYRYRYRYRYRYRYRYRYRYRYRYRYRYRY';
  for i := 1 to length(RY) do
    add_char(RY[i]);
  add_char(#13);
end;

procedure xmt_msg( nbr : integer);
var  index : integer;
     size  : integer;
begin
  index := 1;
  size := ord(msg[nbr][0])+1;
  while (index < size) do
    begin
      add_char(msg[nbr][index]);
      index := index + 1;
    end;
end;
