; Routines for outputing text in color modes
;
; works in any model
;
; Author: Emil LAURENTIU
; Date:	  Sunday, 29 September 1996

jumps
locals
.MODEL SMALL,C

.DATA
	PUBLIC	C	mono
	PUBLIC	C	ega_vga
mono		dw	0
ega_vga		dw	0
init_ok		dw	0
page_off	dw	0
base_port	dw	?
v_segment	dw	0b800h
chars		dw	?
c_page		db	?
max_row		db	25
max_col		db	?
attrib		db	2
t_row		db	?
t_col		db	?
direction	db	0

.CODE

	PUBLIC	C	textinit
	PUBLIC	C	textout

get_cursorpoz	proc	near
	mov	ax,40h
	mov	es,ax
	mov	bh,0
	mov	bl,c_page
	shl	bl,1
	add	bx,50h
	mov	ax,es:[bx]
	mov	t_col,al
	mov	t_row,ah
	ret
get_cursorpoz	endp

set_cursorpoz	proc	near
	mov	ax,40h
	mov	es,ax
	mov	bh,0
	mov	bl,c_page
	shl	bl,1
	add	bx,50h
	mov	al,t_col
	mov	ah,t_row
	mov	es:[bx],ax
	mov	bx,page_off
	mov	al,t_row
	mul	max_col
	add	bx,ax
	mov	al,t_col
	cbw
	add	bx,ax
	mov	dx,base_port
	mov	al,0eh
	out	dx,al
	jmp	short	$+2
	inc	dx
	mov	al,bh
	out	dx,al
	dec	dx
	jmp	short	$+2
	mov	al,0fh
	out	dx,al
	jmp	short	$+2
	inc	dx
	mov	al,bl
	out	dx,al
	dec	dx
	jmp	short	$+2
	ret
set_cursorpoz	endp

put_char proc	 near
	push	ax
	mov	bx,page_off
	mov	al,t_row
	mul	max_col
	add	bx,ax
	mov	al,t_col
	cbw
	add	bx,ax
	shl	bx,1
	mov	ax,v_segment
	mov	es,ax
	pop	ax
	mov	ah,attrib
	mov	es:[bx],ax
	inc	chars
	ret
put_char endp

get_hexdigit	proc	near
	lodsb
	or	al,20h
	sub	al,'0'
	cmp	al,0ah
	jb	ex_hex
	sub	al,27h
ex_hex: and	al,0fh
	ret
get_hexdigit	endp

get_decimal2	proc	near
	push	bx
	lodsw
	sub	ax,3030h
	mov	bx,ax
	mov	al,10
	mul	bl
	add	al,bh
	pop	bx
	ret
get_decimal2	endp

set_noblink	proc	near
	push	ax
	cmp	ega_vga,1
	jnz	@@ex_set
	mov	dx,base_port
	add	dx,6
	in	al,dx
	jmp	short $+2
	mov	dx,3c0h
	mov	al,30h
	out	dx,al
	jmp	short $+2
	inc	dx
	in	al,dx
	mov	ah,al
	and	ah,NOT 8
	dec	dx
	jmp	short $+2
	mov	dx,base_port
	add	dx,6
	in	al,dx
	jmp	short $+2
	mov	dx,3c0h
	mov	al,30h
	out	dx,al
	jmp	short $+2
	mov	al,ah
	out	dx,al
	jmp	short $+2
@@ex_set:
	pop	ax
	ret
set_noblink	endp

set_attrib	proc	near
	mov	ax,v_segment
	mov	es,ax
	mov	di,page_off
	mov	al,max_col
	mul	max_row
	mov	cx,ax
	mov	al,07
@@lp:	inc	di
	stosb
	loop	@@lp
	ret
set_attrib	endp

textinit PROC	C
	push	di
	mov	ax,40h
	mov	es,ax
	mov	ax,es:[63h]
	mov	base_port,ax
	mov	al,es:[62h]
	mov	c_page,al
	mov	ax,es:[4Eh]
	mov	page_off,ax
	mov	al,es:[4Ah]
	mov	max_col,al
	mov	al,es:[87h]
	test	al,2
	jz	@@sk7
	mov	mono,1
@@sk7:	test	al,60h
	jz	@@sk6
	mov	ega_vga,1
	mov	al,es:[84h]
	inc	al
	mov	max_row,al
@@sk6:	mov	al,es:[65h]
	test	al,4
	jz	@@sk1
	mov	mono,1
	mov	v_segment,0b000h
	mov	attrib,07
	jmp	@@sk5
@@sk1:	call	set_noblink
@@sk5:	call	set_attrib
	mov	al,es:[65h]
	test	al,1		; graphic / text mode ?
	mov	ax,0
	jz	@@sk2
	mov	ax,1
@@sk2:	mov	init_ok,ax
	pop	di
	ret
textinit endp

textout PROC	C	string:DATAPTR
	push	si di
	cmp	init_ok,1
	jnz	t_ret
	mov	chars,0
if @datasize
	lds	si,string
else
	mov	si,string
endif
	call	get_cursorpoz
more:
	lodsb
	test	al,al
	jz	str_end
	cmp	al,'%'
	jz	special
	cmp	al,0dh
	jz	ch_cr
	cmp	al,0ah
	jz	ch_lf
	cmp	al,08h
	jz	ch_bs
normal:
	call	put_char
	cmp	direction,0
	jz	dir0
	cmp	direction,1
	jz	dir1
	cmp	direction,2
	jz	dir2
	cmp	direction,3
	jz	dir3
dir3:
	cmp	t_row,0
	jz	str_end
	dec	t_row
	jmp	more
dir2:
	cmp	t_col,0
	jz	str_end
	dec	t_col
	jmp	more
dir0:
	inc	t_col
	mov	al,t_col
	cmp	al,max_col
	jb	more
ch_lf:
	mov	t_col,0
dir1:
	inc	t_row
	mov	al,t_row
	cmp	al,max_row
	jb	more
	dec	t_row
scroll:
	push	si
	mov	di,page_off
	mov	si,di
	mov	al,max_col
	cbw
	shl	ax,1
	add	si,ax
	mov	al,max_col
	mul	max_row
	mov	cx,ax
	push	ds
	mov	ax,v_segment
	mov	ds,ax
	mov	es,ax
	rep	movsw
	pop	ds
	mov	ax,0720h
	mov	cl,max_col
	rep	stosw
	pop	si
	jmp	more
ch_cr:
	mov	t_col,0
	jmp	more
ch_bs:
	cmp	t_col,0
	jz	more
	dec	t_col
	mov	al,' '
	call	put_char
	jmp	more
special:
	lodsb
	cmp	al,'%'
	jz	normal
	or	al,20h
	cmp	al,'a'
	jz	attrib_color
	cmp	al,'b'
	jz	back_color
	cmp	al,'f'
	jz	front_color
	cmp	al,'r'
	jz	set_row
	cmp	al,'c'
	jz	set_col
	cmp	al,'d'
	jz	set_dir
	jmp	more
back_color:
	call	get_hexdigit
	cmp	mono,1
	jnz	@@sb
	test	al,8
	mov	al,0
	jz	@@sb
	mov	al,7
@@sb:	mov	ah,attrib
	and	ah,0fh
	shl	al,4
	or	ah,al
	mov	attrib,ah
	jmp	more
front_color:
	call	get_hexdigit
	cmp	mono,1
	jnz	@@sf
	cmp	al,0
	jz	@@sf
	or	al,7
@@sf:	mov	ah,attrib
	and	ah,0f0h
	or	ah,al
	mov	attrib,ah
	jmp	more
attrib_color:
	call	get_hexdigit
	cmp	mono,1
	jnz	@@sa1
	test	al,8
	mov	al,0
	jz	@@sa1
	mov	al,7
@@sa1:	shl	al,4
	mov	ah,al
	call	get_hexdigit
	cmp	mono,1
	jnz	@@sa2
	cmp	al,0
	jz	@@sa2
	or	al,7
@@sa2:	or	ah,al
	mov	attrib,ah
	jmp	more
set_row:
	call	get_decimal2
	mov	t_row,al
	jmp	more
set_col:
	call	get_decimal2
	mov	t_col,al
	jmp	more
set_dir:
	call	get_hexdigit
	and	al,3
	mov	direction,al
	jmp	more
str_end:
	call	set_cursorpoz
	mov	ax,chars
t_ret:
	pop	di si
	ret
textout endp

	END
