/*
 *	normprob.c  --  recompute ifs probabilities
 *
 *	4 june 1989  Olle Olsson
 */

#include <stdlib.h>
#include "ifs.h"

void normprob( tp0, size )
transform *tp0;			/* the transformations */
int size;			/* number of transformations */
{
int i;				/* tmp */
transform *tp;			/* tmp */
double psum;			/* sum */

/* make the probability sum == 1  (disregarding groups) */

/* add */
for (tp = tp0, i = size, psum = 0; i > 0; ++tp, --i)
	{
	/* quietly adjust too small or negative values */
 	if (tp -> prob < MINPROB)
		tp -> prob = MINPROB;

	psum += tp -> prob;
	}

/* adjust */
for (tp = tp0, i = size; i > 0; ++tp, --i)
	tp -> prob /= psum;
}

double grprob( tp0, size, group )
transform *tp0;			/* the transformations */
int size;			/* number of transformations */
int group;			/* the group */
{
double gpr;			/* the sum */
register transform *tp;		/* tmp */

/* get group prob. */
for (gpr = 0, tp = tp0; size > 0; --size, ++tp)
	if (tp -> group == group)
		gpr += tp -> prob;

return (gpr);
}

void normgprob( tp0, size, group, gprob )
transform *tp0;			/* the transformations */
int size;			/* number of transformations */
int group;			/* the group */
double gprob;			/* required probability */
{
int i;				/* tmp */
transform *tp;			/* tmp */
double psum;			/* sum */
double afact;			/* adjustment factor */

/* "normalize" group: make the group probabiliy sum eqal to gprob */

/* add */
for (tp = tp0, i = size, psum = 0; i > 0; ++tp, --i)
	if (tp -> group == group)
		{
		/* quietly adjust too small or negative values */
	 	if (tp -> prob < MINPROB)
			tp -> prob = MINPROB;

		psum += tp -> prob;
		}

/* adjust */
afact = gprob / psum;

for (tp = tp0, i = size; i > 0; ++tp, --i)
	if (tp -> group == group)
		tp -> prob *= afact;
}



