/*
 *	mul4f.c  -- fixed point multiply, 2 byte fraction
 *
 *	15 june 1989  Olle
 */

#pragma inline

/* There is no way to get half a parameter into a register, do it by hand */
#define lswa bp+4
#define mswa bp+6
#define lswb bp+8
#define mswb bp+10

/*long mul4f( long a, long b );*/

/* You can't return (ax:dx) so pretend it is a void function */
void mul4f( long a, long b );

void mul4f( long a, long b )
{
					/* cx accumulates msw, bx lsw */
asm	mov	ax, word ptr [mswa]	/* msw a */
asm	cmp	ax, 0
asm	jz	mua0			/* 0 * b = 0 */

asm	cmp	word ptr [mswb], 0	/* msw b */
asm	jz	mub0

asm	mul	word ptr [mswb]		/* msw b */
asm	mov	cx, ax			/* lsw of mul */

asm	mov	ax, word ptr [lswa]	/* lsw a */
asm	mul	word ptr [lswb]		/* lsw b */
asm	mov	bx, dx			/* msw of mul */

asm	mov	ax, word ptr [mswa]	/* msw a */
asm	mul	word ptr [lswb]		/* lsw b */
asm	add	bx, ax			/* add partial result */
asm	adc	cx, dx

asm	mov	ax, word ptr [mswb]	/* msw b */
asm	mul	word ptr [lswa]		/* lsw a */
asm	add	ax, bx			/* add partial result */
asm	adc	dx, cx			/* result in dx:ax */

return;
	
mua0:					/* msw a is zero */

asm	mov	ax, word ptr [lswa]	/* lsw a */
asm	mul	word ptr [lswb]		/* lsw b */
asm	mov	bx, dx			/* msw of mul */

asm	mov	ax, word ptr [mswb]	/* msw b */
asm	cmp	ax, 0
asm	jz	mua1			/* msw b is also zero */

asm	mul	word ptr [lswa]		/* lsw a */
asm	add	ax, bx			/* add partial result */
asm	adc	dx, 0			/* result in dx:ax */

return;
	
mua1:
asm	mov	ax, bx			/* both msws are zero */
asm	xor	dx, dx			/* result in dx:ax */

return;

mub0:					/* msw b is zero, but not msw a */

asm	mov	ax, word ptr [lswa]	/* lsw a */
asm	mul	word ptr [lswb]		/* lsw b */
asm	mov	bx, dx			/* msw of mul */

asm	mov	ax, word ptr [mswa]	/* msw a */
asm	mul	word ptr [lswb]		/* lsw b */

asm	add	ax, bx			/* add partial result */
asm	adc	dx, 0			/* result in dx:ax */

return;
}
