/*                        Sprite & Scrolling Engine                         */
/*        Copyright (c) Genesoft 1995-1996.  All rights reserved.           */

#include<sse.h>
#include<ssepal.h>
#include<ssecapt.h>
#include<sseutil.h>

#include<stdio.h>
#include<io.h>
#include<fcntl.h>

#include"mapmaker.h"

sseTileGraphicInfo * Tiles;
sseTileMapInfo * Map, ** MapOfTiles;
TileLocInfo * TLI;
int MapsOfTiles;
char * MapName;

int ReadExact( char * FileName, int FH, char * Dest, int Bytes );

int MinMapWidth, MinMapHeight;

int LoadTiles( char * FileName )
{
   int CreateMapOfTiles( sseTileMapInfo ** TMI, TileLocInfo * TLI, int TileNum, int TilesLeft );
   int fh, size, i, found;

   Tiles = Alloc( sizeof( sseTileGraphicInfo ) );

   if( ( fh = open( FileName, O_RDONLY | O_BINARY ) ) == -1 )
   {
      printf( "Error opening file \"%s\"!\n\n", FileName );
      return 1;
   }

   // Read the Tile Set's header

   if( ReadExact( FileName, fh, (char*)Tiles, sizeof( sseTileGraphicInfo ) ) ) return -1;
   if( Tiles->IDNumber != TILE_GRAPHIC_ID )
   {
      printf( "Invalid Tile Set: \"%s\"", FileName );
      return 1;
   }

   // Read the Tile Set's data

   size = Tiles->Width * Tiles->Height * Tiles->NumTiles;
   if( ReadExact( FileName, fh, Alloc( size ), size ) ) return -1;

   // Add a solid 255-color tile

   size = Tiles->Width * Tiles->Height;
   memByteFill( Alloc( size ), 255, size );

   // Read the Tile Location Info

   size = sizeof( TileLocInfo ) * Tiles->NumTiles;
   TLI = Alloc( size );
   if( ReadExact( FileName, fh, (char*)TLI, size ) ) return -1;

   close( fh );

   // Create the Maps of Tiles

   MapsOfTiles = TLI[ Tiles->NumTiles-1 ].FileNum +1;
   MapOfTiles = Alloc( sizeof( MapOfTiles ) * MapsOfTiles );

   MinMapWidth = ScreenWidth/Tiles->Width + (ScreenWidth%Tiles->Width ?1:0);
   MinMapHeight = ScreenHeight/Tiles->Height + (ScreenHeight%Tiles->Height ?1:0);

   for( i=0, found=0; i<MapsOfTiles; i++ )
      found = CreateMapOfTiles( MapOfTiles+i, TLI, found, Tiles->NumTiles-found );
   
   // Increment NumTiles to include 255-color tile

   Tiles->NumTiles++;

   return 0;
}

int LoadMap( char * FileName )
{
   int fh, size;

   Map = Alloc( sizeof( sseTileMapInfo ) );

   if( ( fh = open( FileName, O_RDONLY | O_BINARY ) ) == -1 ) return -1;

   // Read the Tile Map's header

   if( ReadExact( FileName, fh, (char*)Map, sizeof( sseTileMapInfo ) ) )
      { close( fh ); return -1; }

   // Read the Tile Map's data

   size = Map->Width * Map->Height;
   if( ReadExact( FileName, fh, Alloc( size ), size ) )
      { close( fh ); return -1; }
   
   close( fh );
   
   MapName = FileName;
   return 0;
}

int CreateMap( char * FileName )
{
   int x, y, fh, size;
   if( (fh = open( FileName, O_WRONLY | O_BINARY | O_CREAT | O_TRUNC/*, S_IRUSR | S_IWUSR | S_IRGRP | S_IWGRP*/ )) == -1 ) return -1;
   
   printf("\n New Map \"%s\"\n\n  Tile Set dimensions x,y: %d,%d\n", FileName, Tiles->Width, Tiles->Height );
   printf(" Enter map dimensions x,y: ");
   scanf("%d,%d", &x, &y );
   
   if( x * Tiles->Width < ScreenWidth || y * Tiles->Height < ScreenHeight )
      { close( fh ); return -2; }
   
   size = sizeof( sseTileMapInfo ) + x * y;
   Map = Alloc( size );
   Map->Width = x;
   Map->Height = y;
   memByteFill( Map + 1, 0, x * y );
   
   if( write( fh, Map, size ) != size )
        { close( fh ); return -2; }
   
   close( fh );

   MapName = FileName;
   return 0;
}

int SaveMap( char * FileName )
{
   int fh, size;

   if( ( fh = open( FileName, O_WRONLY | O_BINARY | O_TRUNC ) ) == -1 ) return 1;

   // Read the Tile Map's header

   size = sizeof( sseTileMapInfo ) + Map->Width * Map->Height;
   if( write( fh, Map, size ) != size ) { close( fh ); return -1; }

   close( fh );

   return 0;
}


int ReadExact( char * FileName, int FH, char * Dest, int Bytes )
{
   int t;
   t = read( FH, Dest, Bytes );
   if( t == -1 )
   {
      printf( "Read error in file \"%s\"!\n\n", FileName );
      close( FH );
      return 1;
   }
   if( t < Bytes )
   {
      printf( "Unexpected EOF in \"%s\"!\n\n", FileName );
      close( FH );
      return 1;
   }
   return 0;
}

int CreateMapOfTiles( sseTileMapInfo ** TMI, TileLocInfo * TLI, int TileNum, int TilesLeft )
{
   int w, h, thisfile, k;
   TileLocInfo * t;
   unsigned char * Map;

   *TMI = Alloc( sizeof( sseTileMapInfo ) );

   TLI += TileNum;
   w = MinMapWidth;
   h = MinMapHeight;
   thisfile = TLI->FileNum;
   t = TLI;
   k = TilesLeft;
   while( k-- )
   {
      if( t->FileNum != thisfile ) break;
      if( t->XPos >= w ) w = t->XPos +1;
      if( t->YPos >= h ) h = t->YPos +1;
      t++;
   }

   (*TMI)->Width = w;
   (*TMI)->Height = h;
   Map = Alloc( w * h );
   memByteFill( Map, Tiles->NumTiles, w * h );

   while( TLI < t )
   {
      *(Map + TLI->XPos + TLI->YPos * w) = TileNum;
      TileNum++;
      TLI++;
   }

   return TileNum;
}

