/*                        Sprite & Scrolling Engine                         */
/*        Copyright (c) Genesoft 1995-1996.  All rights reserved.           */

#include<stdio.h>
#include<stdlib.h>

#include<sse.h>
#include<ssedvid.h>
#include<ssekeyb.h>

#include"mapmaker.h"

#define EM_EDIT_MAP   0
#define EM_GRAB_TILES 1

sseSpriteHeader * ActiveCursor;
sseSpriteTracking * MouseCursor;
sseTileMapInfo * CurrentMap;
int SelectedMapOfTiles, EditMode;
short PrevMouseB;

int MapX, MapY;
int MaxX, MaxY;
int CX, CY;
int PX, PY, OX, OY;
char * MT, * OMT;

struct
{
   int Width;
   int Height;
   int BytesPerRow;
   char * Data;
   sseSpriteTracking * TR, * TL, * BR, * BL;
} Brush;


#define ST_EXIT -1
#define ST_HELP 1
#define ST_SAVE 2


void EditMap()
{
   void SetupEditor();
   void ExitEditor();
   int Edit();
   int result;

   SetupEditor();

   do{
      result = Edit();

      if( result == ST_SAVE )
      {
         if( SaveMap( MapName ) )
         {
            ExitEditor();
            printf( "Map Save failed\n\n" );
            return;
         }
      }

   } while( result != ST_EXIT );

   ExitEditor();
}

void SetupEditor()
{
   SelectedMapOfTiles = 0;

   EditMode = EM_EDIT_MAP;
   CurrentMap = Map;
   sseInitEngine( ScreenMode, Tiles, Map, 8, 8, 0 );

   mouseX = ScreenWidth / 2;
   mouseY = ScreenHeight / 2;
   mousePoll();
   PrevMouseB = mouseB;

   RegisterSprites();

   ActiveCursor = MPointer;
   MouseCursor = sseInitSprite( ActiveCursor, mouseX, mouseY, 0, 1 );

   MapX = MapY = 0;
   MaxX = Map->Width * Tiles->Width - ScreenWidth;
   MaxY = Map->Height * Tiles->Height - ScreenHeight;
   OX = OY = -1;
   OMT = NULL;

   Brush.Width = 0;
   Brush.TL = sseInitSprite( BoxTL, 999, 999, 0, 0 );
   Brush.TR = sseInitSprite( BoxTR, 999, 999, 0, 0 );
   Brush.BL = sseInitSprite( BoxBL, 999, 999, 0, 0 );
   Brush.BR = sseInitSprite( BoxBR, 999, 999, 0, 0 );

   keyInstallHandler();
}

void ExitEditor()
{
   keyRestoreHandler();
   sseRestoreVideoMode();
}

void UpdateBox( int Xa, int Ya, int Xb, int Yb )
{
   int X1, Y1, X2, Y2;
   
   if( Xa < Xb ) (X1 = Xa, X2 = Xb); else (X1 = Xb, X2 = Xa);
   if( Ya < Yb ) (Y1 = Ya, Y2 = Yb); else (Y1 = Yb, Y2 = Ya);
   
   X1 = X1 / Tiles->Width;
   Y1 = Y1 / Tiles->Height;
   X2 = X2 / Tiles->Width +1;
   Y2 = Y2 / Tiles->Height +1;
      
   Brush.Width = X2 - X1;
   Brush.Height = Y2 - Y1;
   Brush.BytesPerRow = CurrentMap->Width;
   Brush.Data = (char*)(CurrentMap+1) + Y1 * CurrentMap->Width + X1;
   
   X1 = X1 * Tiles->Width - CX;
   Y1 = Y1 * Tiles->Height - CY;
   X2 = X2 * Tiles->Width - CX;
   Y2 = Y2 * Tiles->Height - CY;
   
   Brush.TL->X = X1; Brush.TL->Y = Y1;
   Brush.TR->X = X2; Brush.TR->Y = Y1;
   Brush.BL->X = X1; Brush.BL->Y = Y2;
   Brush.BR->X = X2; Brush.BR->Y = Y2;
}

void HideBox()
{
   Brush.TL->X = 999; Brush.TL->Y = 999;
   Brush.TR->X = 999; Brush.TR->Y = 999;
   Brush.BL->X = 999; Brush.BL->Y = 999;
   Brush.BR->X = 999; Brush.BR->Y = 999;
}

void MoveBox( int X, int Y )
{
   int X2, Y2;
   X2 = X + Brush.Width * Tiles->Width;
   Y2 = Y + Brush.Height * Tiles->Height;
   Brush.TL->X = X; Brush.TL->Y = Y;
   Brush.TR->X = X2; Brush.TR->Y = Y;
   Brush.BL->X = X; Brush.BL->Y = Y2;
   Brush.BR->X = X2; Brush.BR->Y = Y2;
}

void ApplyBrush( char * dest )
{
   int w, h;
   char * src;
   src = Brush.Data;
   h = Brush.Height;
   while( h-- )
   {
      w = Brush.Width;
      while( w-- )
      {
          if( *src != Tiles->NumTiles -1 ) *dest = *src;
          dest++; src++;
      }
      src += Brush.BytesPerRow - Brush.Width;
      dest += CurrentMap->Width - Brush.Width;
   }
}

void GetMouseStatus()
{
   PrevMouseB = mouseB;
   mousePoll();
   if( mouseX < 0 ) mouseX = 0;
   else if( mouseX >= ScreenWidth ) mouseX = ScreenWidth -1;
   if( mouseY < 0 ) mouseY = 0;
   else if( mouseY >= ScreenHeight ) mouseY = ScreenHeight -1;
}


#define LeftButton() ( mouseB & 1 )
#define RightButton() ( mouseB & 2 )

#define LeftClick() ( mouseB & 1 && ! (PrevMouseB & 1) )
#define RightClick() ( mouseB & 2 && ! (PrevMouseB & 2) )

#define LeftRelease() ( ! (mouseB & 1) && PrevMouseB & 1 )
#define RightRelease() ( ! (mouseB & 2) && PrevMouseB & 2 )


void SwitchMode()
{
   if( EditMode == EM_EDIT_MAP )
   {
      EditMode = EM_GRAB_TILES;
      CurrentMap = MapOfTiles[ SelectedMapOfTiles ];
      ActiveCursor = MCross;
      CX = CY = 0;
   }
   else
   {
      EditMode = EM_EDIT_MAP;
      CurrentMap = Map;
      ActiveCursor = MPointer;
      CX = MapX;
      CY = MapY;
   }

   sseInitEngine( MODE_ALREADY_SET, Tiles, CurrentMap, 8, 8, 0 );
   MouseCursor = sseInitSprite( ActiveCursor, mouseX, mouseY, 0, 0);
   Brush.TL = sseInitSprite( BoxTL, 999, 999, 0, 0 );
   Brush.TR = sseInitSprite( BoxTR, 999, 999, 0, 0 );
   Brush.BL = sseInitSprite( BoxBL, 999, 999, 0, 0 );
   Brush.BR = sseInitSprite( BoxBR, 999, 999, 0, 0 );
}

int Edit()
{
   int X, Y;
   while( 1 )
   {
      GetMouseStatus();

      PX = CX + mouseX;
      PY = CY + mouseY;

      if( RightClick() ) SwitchMode();
      
      if( EditMode == EM_GRAB_TILES )
      {
         if( LeftClick() )
         {
            OX = PX;
            OY = PY;
            OMT = NULL;
         }
         if( LeftButton() )
         {
            UpdateBox( OX, OY, PX, PY );
         }
         if( LeftRelease() )
         {
            SwitchMode();
         }
      }
      if( EditMode == EM_EDIT_MAP )
      {
         X = (PX - (Brush.Width-1)*Tiles->Width/2) /Tiles->Width;
         Y = (PY - (Brush.Height-1)*Tiles->Height/2) /Tiles->Height;
      
         if( X < 0 ) X = 0;
         else if( X + Brush.Width > CurrentMap->Width ) X = CurrentMap->Width - Brush.Width;
         if( Y < 0 ) Y = 0;
         else if( Y + Brush.Height > CurrentMap->Height ) Y = CurrentMap->Height - Brush.Height;
      
         MT = ((char*)(CurrentMap+1)) + X + Y * CurrentMap->Width;
         if( LeftButton() && MT != OMT )
         {
            OMT = MT;
            ApplyBrush( MT );
            sseFlagRedrawScreen();
         }
         
         if( Brush.Width )
         {
            MoveBox( X * Tiles->Width - CX, Y * Tiles->Height - CY );
         }
         
         MapX += 8 * (RIGHT_PRESSED - LEFT_PRESSED);
         MapY += 8 * (DOWN_PRESSED - UP_PRESSED);

         if(MapX > MaxX ) MapX = MaxX;
         else if(MapX < 0) MapX = 0;
         if(MapY > MaxY ) MapY = MaxY;
         else if(MapY < 0) MapY = 0;
         CX = MapX;
         CY = MapY;
      }

      MouseCursor->X = mouseX;
      MouseCursor->Y = mouseY;

      if( ESC_PRESSED ) return ST_EXIT;
      if( S_PRESSED ) return ST_SAVE;

      sseUpdateScreen( CX, CY );
   }
}
