#! /bin/csh -f
set command=`basename $0`
if ($#argv != 1) then
  echo $command": bad number of arguments"
  exit 1
endif
if (! -r $1) then
  echo $command": cannot open "$1
  exit 1
endif
set tmp=/tmp/$command"$$"
onintr quit
cat <<'EOF' >$tmp
BEGIN {
	printf "#define X 10\n"
	printf "#include \"chem.h\"\n"
	}
/^atomlocation/ {
	printf "sphere s%d %g %g %g %g\n", $11, $4 / 1300.0, $5 / 1300.0, \
	$6 / 1300, $7
	atomx[$2] = $4 / 1300.0
	atomy[$2] = $5 / 1300.0
	atomz[$2] = $6 / 1300.0
	atoms++
	next
	}
/^chemical / {
	if ($3 > $NF) next
	if ($3 < 1 || $3 > atoms)
	{
	  print "bad input data"
	  exit
	}
	if ($NF < 1 || $NF > atoms)
	{
	  print "bad input data"
	  exit
	}
	printf "cylinder open s0 %g %g %g %g %g %g RAD\n", \
	atomx[$3], atomy[$3], atomz[$3], \
	atomx[$NF], atomy[$NF], atomz[$NF]
	next
	}
'EOF'
tr -s "()," " " <$1|sort|awk -f $tmp|sort
quit:
if (-e $tmp) rm -f $tmp
