/*	Lib.h - miscellaneous definitions that come from library headers.
*/

#define uchar	unsigned char
#define uint	unsigned int
#define ulong	unsigned long

#define ERROR   (-1)		/* function failure return val		*/
#define OK      ( 0)		/* function success return val		*/

/*	DDJ, April 1987, page 138. 
*/
#ifdef ALLOCATE
#define INIT(x) = { x }
#define GLOBAL
#else
#define INIT(x)
#define GLOBAL extern
#endif


#ifdef __STDC__
#define CRASH(msg) { \
printf( "\nFatal Error in \"%s\", line %d\n%s",\
__FILE__,__LINE__,msg ); exit(1); }
#else
#define CRASH(msg) { printf("\nFatal Error: %s\n", msg ); exit(1); }
#endif

#define NELEMS(x) (sizeof(x)/sizeof(*x))

