

pnmrotate(1)               Unix Programmer's Manual               pnmrotate(1)


NAME
     pnmrotate - rotate a portable anymap by some angle

SYNOPSIS
     pnmrotate [-noantialias] angle [pnmfile]
                              -----  -------

DESCRIPTION
     Reads a portable anymap as input.  Rotates it by the specified angle  and
     produces a portable anymap as output.  If the input file is in color, the
     output will be too, otherwise it will be  grayscale.   The  angle  is  in
     degrees   (floating   point),  measured  counter-clockwise.   It  can  be
     negative, but it should be between  -90  and  90.   Also,  for  rotations
     greater  than  45  degrees  you  may  get better results if you first use
     pnmflip to do a 90 degree  rotation  and  then  pnmrotate  less  than  45
     -------                                         ---------
     degrees back the other direction

     The rotation algorithm is Alan Paeth's three-shear method.  Each shear is
     implemented  by looping over the source pixels and distributing fractions
     to each of the destination pixels.  This has an "anti-aliasing" effect  -
     it  avoids  jagged  edges  and similar artifacts.  However, it also means
     that the original colors or gray levels in the image  are  modified.   If
     you  need  to  keep  precisely  the  same  set of colors, you can use the
     -noantialias flag.  This does  the  shearing  by  moving  pixels  without
     changing  their  values.   If you want anti-aliasing and don't care about
     the precise colors, but still need a limited *number* of colors, you  can
     run the result through ppmquant.
                            --------

     All flags can be abbreviated to their shortest unique prefix.

REFERENCES
     "A Fast Algorithm for General Raster Rotation" by  Alan  Paeth,  Graphics
     Interface '86, pp. 77-81.

SEE ALSO
     pnmshear(1), pnmflip(1), pnm(5), ppmquant(1)

AUTHOR
     Copyright (C) 1989, 1991 by Jef Poskanzer.




















                               12 January 1991                               1

