;*
;* DRAW.ASM module
;* by Piotr Ulaszewski
;* simple line, triangle, text scrolling and displaying functions
;* see MANUAL.TXT for detailed info on every function
;*

%define st st0

; globals for the drawing functions (DRAW.ASM)
global _XLine                                    ;proc
global _FTriangle                                ;proc
global _PutText                                  ;proc
global _ScrollText                               ;proc
global _Line                                     ;proc
global _Circle                                   ;proc
global _PutPixel                                 ;proc
global _GetPixel                                 ;proc
global _CheckScrollTextLength                    ;proc
global _WriteWordSVGA                            ;proc
global _WriteCharSVGA                            ;proc
global _CreateColor                              ;proc

extern _VBE_XResolution
extern _VBE_YResolution
extern _VBE_VirtualScreenAddress
extern _VBE_FirstByteBeyondVirtualScreen
extern _VBE_BytesPerScanLine
extern _VBE_BitsPerPixel
extern _VBE_CalcBitsPerPixel
extern _VBE_CalcBitsPerPixel2
extern _ROM_Font

%include "include\segments.inc"
%include "include\message.mac"



;******************************************************************************
;*
;* XLine procedure, call it like this :
;* (non-inclusive)
;*                              dd      push (c)        ebp+20
;*                              dd      push (y)        ebp+16
;*                              dd      push (x2)       ebp+12
;*                              dd      push (x1)       ebp+8
;*                              dd      call _XLine
;*
;******************************************************************************
segment _TEXT
_XLine:
	push ebp
	mov ebp,esp
	pushad
	push es
	push ds
	pop es
	mov eax,[ebp+12]                ; x2
	mov ebx,[ebp+8]                 ; x1
	cmp eax,ebx
	jnl .plus                       ; when x2<x1 exchange them
	mov [ebp+8],eax                 ; x1
	mov [ebp+12],ebx                ; x2
.plus:
	mov eax,[ebp+16]                ; y
	cmp eax,[_VBE_YResolution]
	jge near .end
	or eax,eax
	jl near .end                    ; when y does not exist
	mov eax,[ebp+8]                 ; x1
	cmp eax,[_VBE_XResolution]
	jge near .end
	or eax,eax
	jge .x1_ok                      ; ok for 0<=x1<XResolution
	mov dword [ebp+8],0             ; when x1<0 -> x1=0
.x1_ok:
	mov eax,[ebp+12]                ; x2
	or eax,eax
	jl near .end
	cmp eax,[_VBE_XResolution]
	jl .x2_ok                       ; ok for 0<=x2<XResolution
	mov ebx,[_VBE_XResolution]
	dec ebx
	mov [ebp+12],ebx                ; when x2>=Xresolution -> x2=XResolution-1
.x2_ok:
	mov ebx,[_VBE_XResolution]      ; EBX = XResolution
	imul ebx,[ebp+16]               ; y
	add ebx,[ebp+8]                 ; x1
	imul ebx,[_VBE_CalcBitsPerPixel2]
	mov edi,ebx
	add edi,[_VBE_VirtualScreenAddress]
	mov ecx,[ebp+12]                ; x2
	mov ebx,[ebp+8]                 ; x1
	sub ecx,ebx
	imul ecx,[_VBE_CalcBitsPerPixel2]
	or ecx,ecx
	jz .end
	cmp dword [_VBE_CalcBitsPerPixel],8
	jne .hicolor
	mov dl,[ebp+20]
	shl dx,8
	mov dl,[ebp+20]
	mov ax,dx
	shl eax,16
	mov ax,dx
	jmp .draw_it
.hicolor:
	cmp dword [_VBE_CalcBitsPerPixel],16
	jne .truecolor
	mov eax,[ebp+20]
	shl eax,16
	mov ax,[ebp+20]
	jmp .draw_it
.truecolor:
	mov eax,[ebp+20]

; // modifications
.draw_it:
	xor dl,dl
	cmp ecx,byte 3
	jbe .already_aligned            ; do not need alignment
	mov edx,edi
	and edx,byte 3                  ; align dword 
	jz .already_aligned     
	xchg ecx,edx                    ; ecx = 1,2 or 3    edx = total length
	sub edx,ecx                     ; edx = length to go after alignment
	rep stosb
	xchg ecx,edx                    ; edx = 0    ecx = fill length after alignment
.already_aligned:
; // end of modifications

	shr ecx,1
	adc dl,0
	shr ecx,1
	rep stosd
	jnc .point
	stosw
.point:
	or dl,dl
	jz .end
	stosb
.end:
	pop es
	popad
	pop ebp
	ret



;******************************************************************************
;*
;* FTriangle proc, call it like this :
;*                              dd      push (c)        ebp+32
;*                              dd      push (y3)       ebp+28
;*                              dd      push (x3)       ebp+24
;*                              dd      push (y2)       ebp+20
;*                              dd      push (x2)       ebp+16
;*                              dd      push (y1)       ebp+12
;*                              dd      push (x1)       ebp+8
;*                                      call _FTriangle
;*
;******************************************************************************
segment _DATA
; helping variables for the FTriangle function
dx12  dd 0
dx13  dd 0
dx23  dd 0
yk1   dd 0
xk1   dd 0
yk2   dd 0
xk2   dd 0
yk3   dd 0
xk3   dd 0

segment _TEXT
_FTriangle:
	push ebp
	mov ebp,esp
	pushad
	push es
	push ds
	pop es

	mov ebx,[ebp+12]                  ; y1
	cmp ebx,[ebp+28]                  ; y3
	jl .oky13
	mov edx,[ebp+8]                   ; x1
	xchg edx,[ebp+24]                 ; x3 <=> x1
	mov [ebp+8],edx                   ; x1
	mov ebx,[ebp+12]                  ; y1
	xchg ebx,[ebp+28]                 ; y3
	mov [ebp+12],ebx                  ; y1

.oky13:
	mov ebx,[ebp+20]                  ; y2
	cmp ebx,[ebp+28]                  ; y3
	jl .oky23
	mov edx,[ebp+16]                  ; x2
	xchg edx,[ebp+24]                 ; x3 <=> x2
	mov [ebp+16],edx                  ; x2
	mov ebx,[ebp+20]                  ; y2
	xchg ebx,[ebp+28]                 ; y3
	mov [ebp+20],ebx                  ; y2

.oky23:
	mov ebx,[ebp+12]                  ; y1
	cmp ebx,[ebp+20]                  ; y2
	jl .oky12
	mov edx,[ebp+8]                   ; x1
	xchg edx,[ebp+16]                 ; x2 <=> x1
	mov [ebp+8],edx                   ; x1
	mov ebx,[ebp+12]                  ; y1
	xchg ebx,[ebp+20]                 ; y2
	mov [ebp+12],ebx                  ; y1

.oky12:
	mov ebx,[ebp+20]                  ; y2
	sub ebx,[ebp+12]                  ; y1
	jnz .nonzero12
	mov dword [dx12],0
	jmp .after12

.nonzero12:
	mov edx,[ebp+8]                   ; x1
	shl edx,8
	mov eax,[ebp+16]                  ; x2
	shl eax,8
	sub eax,edx
	cdq
	idiv ebx
	mov dword [dx12],eax

.after12:
	mov edx,[ebp+12]                  ; y1
	mov [yk1],edx
	mov edx,[ebp+8]                   ; x1
	shl edx,8
	mov [xk1],edx
	mov ebx,[ebp+28]                  ; y3
	sub ebx,[ebp+12]                  ; y1
	jnz .nonzero13
	mov dword [dx13],0
	jmp .after13

.nonzero13:
	mov edx,[ebp+8]                   ; x1
	shl edx,8
	mov eax,[ebp+24]                  ; x3
	shl eax,8
	sub eax,edx
	cdq
	idiv ebx
	mov [dx13],eax

.after13:
	mov edx,[ebp+12]                  ; y1
	mov [yk2],edx
	mov edx,[ebp+8]                   ; x1
	shl edx,8
	mov [xk2],edx
	mov ebx,[ebp+20]                  ; y2
	sub ebx,[ebp+28]                  ; y3
	jnz .nonzero23
	mov dword [dx23],0
	jmp .after23

.nonzero23:
	mov edx,[ebp+24]                  ; x3
	shl edx,8
	mov eax,[ebp+16]                  ; x2
	shl eax,8
	sub eax,edx
	cdq
	idiv ebx
	mov [dx23],eax

.after23:
	mov edx,[ebp+20]                  ; y2
	mov [yk3],edx
	mov edx,[ebp+16]                  ; x2
	shl edx,8
	mov [xk3],edx

.rys12:
	mov edx,[yk1]
	cmp edx,[ebp+20]                  ; y2
	je .endl12
	mov edx,[xk1]
	sar edx,8
	mov ebx,[xk2]
	sar ebx,8
	cmp dx,bx
	jng .okbxdx12
	xchg dx,bx

.okbxdx12:
	push dword [ebp+32]               ; color
	movsx ebx,bx
	movsx edx,dx
	push dword [yk1]                  ; y
	push ebx                          ; xl2
	push edx                          ; xl1
	call _XLine
	add esp,byte 16

	mov edx,[dx12]
	mov ebx,[dx13]
	add [xk1],edx
	add [xk2],ebx
	add dword [yk1],1
	jmp .rys12

.endl12:
.rys23:
	mov edx,[xk2]
	mov ebx,[xk3]
	sar edx,8
	sar ebx,8
	cmp dx,bx
	jng .okbxdx23
	xchg dx,bx

.okbxdx23:
	push dword [ebp+32]               ; color
	movsx ebx,bx
	movsx edx,dx
	push dword [yk3]                  ; y
	push ebx                          ; xl2
	push edx                          ; xl1
	call _XLine
	add esp,byte 16

	mov edx,[dx23]
	mov ebx,[dx13]
	add [xk3],edx
	add [xk2],ebx
	mov edx,[yk3]
	add dword [yk3],1
	cmp edx,[ebp+28]                  ; y3
	jne .rys23

	pop es
	popad
	pop ebp
	ret



;******************************************************************************
;*
;* PutText proc, call it like this :
;*                              dd      push (txt_ptr)  ebp+24   text pointer
;*                              db      push (colorize) ebp+20   1=multicolor
;*                              dd      push (color)    ebp+16
;*                              dd      push (y0)       ebp+12
;*                              dd      push (x0)       ebp+8
;*                                      call _PutText
;*
;*                             out :    EAX - position at Virtual Screen
;*                                            after the end of written text
;*
;******************************************************************************
_PutText:
	push ebp
	mov ebp,esp
	push ebx
	push ecx
	push edx
	push esi
	push edi
	push es
	push ds
	pop es
	mov ebx,[_VBE_XResolution]
	imul ebx,[ebp+12]               ; y0
	add ebx,[ebp+8]                 ; x0
	imul ebx,[_VBE_CalcBitsPerPixel2]
	mov edi,[_VBE_VirtualScreenAddress]
	add edi,ebx
	mov esi,[ebp+24]                ; text ptr
	mov edx,[ebp+16]                 ; color
	mov ebx,[_ROM_Font]
	xor eax,eax

.@@jump5:
	push ebx                        ; rom font start
	lodsb
	or al,al
	jz near .@@end                  ; Zero terminated string
	movsx eax,al
	shl eax,4                       ; height in ROM is 16 pixels
	add ebx,eax                     ; position of letter
	mov ecx,16                      ; height - 16 pixels
.@@jump4:
	push ecx                        ; height
	mov al,[ebx]
	movsx eax,al
	mov ecx,8                       ; length - 8 pixels
.@@jump3:
	push eax
	shl eax,1
	bt eax,ecx
	jc .@@jump1
.@@come_back:
	add edi,[_VBE_CalcBitsPerPixel2]
	jmp .@@skip
.@@jump1:
	mov eax,edx
	test byte [ebp+20],1            ; colorize ( 0:single , 1:multi)
	jz .@@one_color
	add eax,[ebp+20]
	dec eax
.@@one_color:
	cmp edi,[_VBE_VirtualScreenAddress]
	jb .@@come_back
	cmp edi,[_VBE_FirstByteBeyondVirtualScreen]
	jae .@@come_back
	push ecx
	mov ecx,[_VBE_CalcBitsPerPixel2]
	rep stosb
	pop ecx
.@@skip:
	pop eax
	dec ecx
	jnz .@@jump3
	inc ebx
	add edi,[_VBE_BytesPerScanLine]
	sub edi,[_VBE_CalcBitsPerPixel]
	add dword [ebp+20],6                ; adjust colorize
	pop ecx
	dec ecx
	jnz .@@jump4
	pop ebx
	mov ecx,[_VBE_BytesPerScanLine]
	shl ecx,4
	sub ecx,[_VBE_CalcBitsPerPixel]
	sub edi,ecx
	and dword [ebp+20],1
	jmp .@@jump5
.@@end:
	pop ebx
	pop es
	mov eax,edi
	pop edi
	pop esi
	pop edx
	pop ecx
	pop ebx
	pop ebp
	ret



;******************************************************************************
;*
;* ScrollText proc, call it like this :
;*                              dd      push (txt_ptr)  ebp+20   text pointer
;*                              db      push (colorize) ebp+16   1=multicolor
;*                              dd      push (color)    ebp+12
;*                              dd      push (y0)       ebp+8
;*                                      call _ScrollText
;*
;******************************************************************************
_ScrollText:
	push ebp
	mov ebp,esp
	pushad
	push es
	push ds
	pop es
.@@next_line:
	mov esi,[ebp+20]                ; text ptr
	cmp dword [ebp+8],-16           ; y0
	jg .@@y0_down_ok
	push ebx
.@@come_back_down:
	lodsb
	or al,al
	jz near .@@end_of_line
	cmp al,0ffh
	jz near .@@end_of_txt
	jmp short .@@come_back_down
.@@y0_down_ok:
	mov ebx,[_VBE_YResolution]
	cmp [ebp+8],ebx
	jl .@@y0_up_ok
	push ebx
	jmp .@@end_of_txt
.@@y0_up_ok:
	mov edi,[ebp+20]                ; text_ptr
	xor eax,eax
	xor ecx,ecx
	dec ecx
	repne scasb
	neg ecx
	inc ecx
	shl ecx,2                       ; multiply by 8 & divide by 2
	cmp byte [edi-2],0ffh
	jne .do_not_adjust
	sub ecx,byte 4
.do_not_adjust:
	mov eax,[_VBE_XResolution]
	shr eax,1
	sub eax,ecx                     ; eax = current X0 of text
	mov ebx,[_VBE_XResolution]
	imul ebx,[ebp+8]                ; y0
	add ebx,eax                     ; x0
	imul ebx,[_VBE_CalcBitsPerPixel2]
	mov edi,[_VBE_VirtualScreenAddress]
	add edi,ebx
	mov edx,[ebp+12]                 ; color
	mov ebx,[_ROM_Font]
	xor eax,eax

.@@jump5:
	push ebx                        ; rom font start
	lodsb
	or al,al
	jz near .@@end_of_line          ; Zero terminated string
	cmp al,0ffh
	jz near .@@end_of_txt
	movsx eax,al
	shl eax,4                       ; height in ROM is 16 pixels
	add ebx,eax                     ; position of letter
	mov ecx,16                      ; height - 16 pixels
.@@jump4:
	push ecx                        ; height
	mov al,[ebx]
	movsx eax,al
	mov ecx,8                       ; length - 8 pixels
.@@jump3:
	push eax
	shl eax,1
	bt eax,ecx
	jc .@@jump1
.@@come_back:
	add edi,[_VBE_CalcBitsPerPixel2]
	jmp short .@@skip
.@@jump1:
	mov eax,edx
	test byte [ebp+16],1            ; colorize ( 0:single , 1:multi)
	jz .@@one_color
	add eax,[ebp+16]
	dec eax
.@@one_color:
	cmp edi,[_VBE_VirtualScreenAddress]
	jb .@@come_back
	cmp edi,[_VBE_FirstByteBeyondVirtualScreen]
	jae .@@come_back
	push ecx
	mov ecx,[_VBE_CalcBitsPerPixel2]
	rep stosb
	pop ecx
.@@skip:
	pop eax
	dec ecx
	jnz .@@jump3
	inc ebx
	add edi,[_VBE_BytesPerScanLine]
	sub edi,[_VBE_CalcBitsPerPixel]
	add dword [ebp+16],6            ; adjust colorize
	pop ecx
	dec ecx
	jnz .@@jump4
	pop ebx
	mov ecx,[_VBE_BytesPerScanLine]
	shl ecx,4
	sub ecx,[_VBE_CalcBitsPerPixel]
	sub edi,ecx
	and dword [ebp+16],1
	jmp .@@jump5
.@@end_of_line:
	pop ebx
	add dword [ebp+8],16            ; adjust y0 position
	mov [ebp+20],esi
	jmp .@@next_line
.@@end_of_txt:
	pop ebx
	pop es
	popad
	pop ebp
	ret



;******************************************************************************
;*
;* WriteWordSVGA: Write word as a decimal number in SVGA graphics mode
;*
;*        In:  push dword - position at virtual screen (pointer)
;*             push dword - color of number to write
;*             push dword - number to write
;*             call _WriteWordSVGA
;*
;*        Out: EAX- new position at virtual screen
;*
;******************************************************************************
_WriteWordSVGA:
	push ebx
	push ecx
	push edx
	push esi
	push edi
	push ebp 
	mov ax,[esp+4+24]                ; Number to write
	mov edx,[esp+8+24]               ; Color of that number
	mov edi,[esp+12+24]              ; position at virtual screen

	mov esi,edx
	mov bx,10
	xor cx,cx
.affdecimal_dec:
	xor dx,dx
	div bx
	push dx
	inc cx
	or ax,ax
	jnz .affdecimal_dec
.affdecimal_aff:
	pop ax
	add al,48
	push es
	push ds
	pop es
	mov edx,esi
	call WriteCharSVGA_asm
	pop es
	dec cx
	jnz .affdecimal_aff
	mov eax,edi
	pop ebp
	pop edi
	pop esi
	pop edx
	pop ecx
	pop ebx
	ret



;******************************************************************************
;*
;* WriteCharSVGA_asm : Write char as a decimal number in SVGA graphics mode
;*                     (internal to draw.asm)
;*
;*        In:  AL  - ASCII number
;*             EDX - Color of that number
;*             ES:EDI - position at virtual screen
;*             call WriteCharSVGA_asm
;*
;*        Out: EDI - new position at virtual screen
;*
;******************************************************************************
WriteCharSVGA_asm:
	push eax
	push ebx
	push ecx
	push edx
	push ebp
	push esi
	mov ebx,[_ROM_Font]                      ; pointer to system font
	movsx eax,al
	shl eax,4                               ; height 16 pixels in ROM
	add ebx,eax                             ; find font in that table
	mov ecx,16
.@@jump4:
	push ecx                                ; height
	mov al,[ebx]
	movsx eax,al
	mov ecx,8                               ; length 8 pixeli
.@@jump3:
	push eax
	shl eax,1
	bt eax,ecx
	jc .@@jump1
.@@come_back:
	add edi,[_VBE_CalcBitsPerPixel2]
	jmp short .@@skip
.@@jump1:
	mov eax,edx
	cmp edi,[_VBE_VirtualScreenAddress]
	jb .@@come_back
	cmp edi,[_VBE_FirstByteBeyondVirtualScreen]
	jae .@@come_back	
	cmp dword [_VBE_CalcBitsPerPixel],8
	jne .highcolor
	stosb
	jmp short .@@skip
.highcolor:
	cmp dword [_VBE_CalcBitsPerPixel],16
	jne .truecolor
	stosw
	jmp short .@@skip
.truecolor:
	stosd
.@@skip:
	pop eax
	dec ecx
	jnz .@@jump3
	inc ebx
	add edi,[_VBE_BytesPerScanLine]
	sub edi,[_VBE_CalcBitsPerPixel]
	pop ecx
	dec ecx
	jnz .@@jump4
	mov ecx,[_VBE_BytesPerScanLine]
	shl ecx,4
	sub ecx,[_VBE_CalcBitsPerPixel]
	sub edi,ecx
	pop esi
	pop ebp
	pop edx
	pop ecx
	pop ebx
	pop eax
	ret



;******************************************************************************
;*
;* WriteCharSVGA : Write char as a decimal number in SVGA graphics mode
;*
;*        In:  push dword - position at virtual screen
;*             push dword - color
;*             push byte  - char
;*             call _WriteCharSVGA
;*
;*        Out: EAX - new position at virtual screen
;*
;******************************************************************************
_WriteCharSVGA:
	push ebx
	push ecx
	push edx
	push esi
	push edi
	push ebp
	push es
	push ds
	pop es
	mov al,[esp+4+28]                   ; char
	mov edx,[esp+8+28]                  ; color
	mov edi,[esp+12+28]                 ; position at virtual screen

	mov ebx,[_ROM_Font]                      ; pointer to system font
	movsx eax,al
	shl eax,4                               ; height 16 pixels in ROM
	add ebx,eax                             ; find font in that table
	mov ecx,16
.@@jump4:
	push ecx                                ; height
	mov al,[ebx]
	movsx eax,al
	mov ecx,8                               ; length 8 pixeli
.@@jump3:
	push eax
	shl eax,1
	bt eax,ecx
	jc .@@jump1
.@@come_back:
	add edi,[_VBE_CalcBitsPerPixel2]
	jmp short .@@skip
.@@jump1:
	mov eax,edx
	cmp edi,[_VBE_VirtualScreenAddress]
	jb .@@come_back
	cmp edi,[_VBE_FirstByteBeyondVirtualScreen]
	jae .@@come_back
	cmp dword [_VBE_CalcBitsPerPixel],8
	jne .highcolor
	stosb
	jmp short .@@skip
.highcolor:
	cmp dword [_VBE_CalcBitsPerPixel],16
	jne .truecolor
	stosw
	jmp short .@@skip
.truecolor:
	stosd
.@@skip:
	pop eax
	dec ecx
	jnz .@@jump3
	inc ebx
	add edi,[_VBE_BytesPerScanLine]
	sub edi,[_VBE_CalcBitsPerPixel]
	pop ecx
	dec ecx
	jnz .@@jump4
	mov ecx,[_VBE_BytesPerScanLine]
	shl ecx,4
	sub ecx,[_VBE_CalcBitsPerPixel]
	sub edi,ecx

	mov eax,edi
	pop es
	pop ebp
	pop edi
	pop esi
	pop edx
	pop ecx
	pop ebx
	ret



;******************************************************************************
;*
;* Line: draw a line on the virtual screen with x1,y1 - x2,y2 coordinates
;*	 WARNING : This routine does not check if the line coordinates
;*                 exceed the virtual screen boundary.  That should be
;*                 achieved by your application, otherwise you will be
;*                 kicked off with a page fault (exception 0E) or a
;*                 general protection fault (exception 0D) if paging is
;*                 disabled !!!
;*
;*   In:  push dword color		; ebp + 24
;*        push dword y2			; ebp + 20
;*	    push dword x2			; ebp + 16
;*	    push dword y1			; ebp + 12
;*	    push dword x1			; ebp + 8
;*	    call _Line
;*
;*   Out: Nothing
;*
;******************************************************************************
_Line:
	push ebp
	mov ebp,esp
	sub esp,byte 40			; temporary 8 dwords
					; ebp-4 = dinc1
					; ebp-8 = dinc2
					; ebp-12= xinc1
					; ebp-16= xinc2
					; ebp-20= yinc1
					; ebp-24= yinc2
					; ebp-28= screeninc1
					; ebp-32= screeninc2
					; ebp-36= temporary1
					; ebp-40= temporary2
	pushad

; calculate y
	mov eax,[ebp+20]                             ; y2
	mov edx,[ebp+12]                             ; y1
	sub eax,edx                                  ; y2-y1
	jns .@positive_y
	neg eax
.@positive_y:
	mov ebx,eax                                  ; ebx = y2-y1

; calculate x
	mov eax,[ebp+16]                             ; x2
	mov edx,[ebp+8]                              ; x1
	sub eax,edx
	jns .@positive_x
	neg eax
.@positive_x:                                      ; eax = x2-x1
	cmp eax,ebx
	jl .@dx_less_than_dy

	push ebx                                     ; y2-y1 = dy
	shl ebx,1
	push ebx
	mov [ebp-4],ebx                              ; dy*2 = dinc1
	pop ebx
	sub ebx,eax
	mov edx,ebx                                  ; (dy*2)-dx = D

	pop ebx                                      ; y2-y1 = dy
	sub ebx,eax
	shl ebx,1
	mov [ebp-8],ebx                              ; (dy-dx)*2 = dinc2
	
	inc eax
	push eax                                     ; dx+1 = numpixels
	mov dword [ebp-12],1                         ; xinc1
	mov dword [ebp-16],1                         ; xinc2
	mov dword [ebp-20],0                         ; yinc1
	mov dword [ebp-24],1                         ; yinc2
	jmp .@direction

.@dx_less_than_dy:
	push eax                                     ; dx
	shl eax,1
	push eax
	mov [ebp-4],eax                              ; dx*2 = dinc1
	pop eax
	sub eax,ebx
	mov edx,eax                                  ; (dx*2)-dy = D
	
	pop eax                                      ; dx
	sub eax,ebx
	shl eax,1
	mov [ebp-8],eax                              ; (dx-dy)*2 = dinc2
	
	inc ebx
	push ebx                                      ; dy+1 = numpixels
	mov dword [ebp-12],0                          ; xinc1
	mov dword [ebp-16],1                          ; xinc2
	mov dword [ebp-20],1                          ; yinc1
	mov dword [ebp-24],1                          ; yinc2

; changes of direction...
.@direction:
	mov eax,[ebp+8]                               ; x1
	mov ebx,[ebp+16]                              ; x2
	cmp eax,ebx
	jl .@skip_x                                   ; when x1 < x2
	
	mov eax,[ebp-12]                              ; xinc1
	neg eax                                       ; change of sign of xinc1
	mov [ebp-12],eax                              ; xinc1
	mov eax,[ebp-16]                              ; xinc2
	neg eax                                       ; change of sign of xinc2
	mov [ebp-16],eax                              ; xinc2

.@skip_x:
	mov eax,[ebp+12]                              ; y1
	mov ebx,[ebp+20]                              ; y2
	cmp eax,ebx
	jl .@skip_y                                   ; when y1 < y2
	
	mov eax,[ebp-20]                              ; yinc1
	neg eax                                       ; change of sign of yinc1
	mov [ebp-20],eax                              ; yinc1
	mov eax,[ebp-24]                              ; yinc2
	neg eax                                       ; change of sign of yinc2
	mov [ebp-24],eax                              ; yinc2

; screen start address
.@skip_y:
	mov eax,[ebp+12]                              ; y1
	imul eax,[_VBE_XResolution]
	add eax,[ebp+8]                               ; x1
	imul eax,[_VBE_CalcBitsPerPixel2]             ; any BPP support
	push eax

; screeninc1
	mov eax,[ebp-20]                              ; yinc1
	imul eax,[_VBE_XResolution]
	add eax,[ebp-12]                              ; xinc1
	imul eax,[_VBE_CalcBitsPerPixel2]             ; any BPP support
	mov [ebp-28],eax                              ; screeninc1

; screeninc2
	mov eax,[ebp-24]
	imul eax,[_VBE_XResolution]
	add eax,[ebp-16]                              ; xinc2
	imul eax,[_VBE_CalcBitsPerPixel2]             ; any BPP support
	mov [ebp-32],eax                              ; screeninc2

; draw...
	pop edi                                       ; points to the begining of the line
	add edi,[_VBE_VirtualScreenAddress]
	pop ecx                                       ; numpixels
	mov eax,[ebp+24]                              ; color for any BPP support
	mov ebx,[ebp-4]                               ; dinc1

; now draw it for real...
.@bres1:
	cmp dword [_VBE_CalcBitsPerPixel],8
	jne .hicolor
	mov [edi],al
	jmp short .continue
.hicolor:
	cmp dword [_VBE_CalcBitsPerPixel],16
	jne .truecolor
	mov [edi],ax
	jmp short .continue
.truecolor:
	mov [edi],eax
.continue:
	or edx,edx                                    ; EDX < 0
	jnl .@bres2

; D < 0
	add edx,ebx                                   ; where EBX = dinc1
	add edi,[ebp-28]                              ; screeninc1
	jmp short .@bres3

; D >= 0
.@bres2:
	add edx,[ebp-8]                               ; dinc2
	add edi,[ebp-32]                              ; screeninc2

.@bres3:
	dec ecx
	jnz .@bres1

.end:
	add esp,byte 40                               ; discard 8 temporary dwords
	popad
	pop ebp
	ret



;******************************************************************************
;*
;* Circle: darws a circle on the virtual screen (clipping implemented).
;*
;*     In:  push dword color		; ebp+20
;*          push dword r		; ebp+16
;*          push dword y0		; ebp+12
;*          push dword x0		; ebp+8
;*          call _Circle
;*
;*     Out: Nothing
;*
;******************************************************************************
_Circle:
	push ebp
	mov ebp,esp
	sub esp,byte 16			; temporary location for 4 dwords
					; ebp-4 = x1
					; ebp-8 = y1
					; ebp-12= x2
					; ebp-16= y2
	pushad
	
.@draw_circle:
	mov dword [ebp-4],0                       ; x1 = 0
	mov eax,[ebp+16]                          ; r
	mov [ebp-8],eax                           ; y1 = r

	shl eax,1
	mov ebx,3
	sub ebx,eax                               ; d = 3 - 2*r
	push ebx

.@repeat:
	call .@registers
	add eax,ecx
	mov [ebp-12],eax                          ; x2 = x0 + x1
	add ebx,edx
	mov [ebp-16],ebx                          ; y2 = y0 + y1
	call .@put_pixel

	call .@registers
	add eax,ecx
	mov [ebp-12],eax                          ; x2 = x0 + x1
	sub ebx,edx
	mov [ebp-16],ebx                          ; y2 = y0 - y1
	call .@put_pixel

	call .@registers
	sub eax,ecx
	mov [ebp-12],eax                          ; x2 = x0 - x1
	add ebx,edx
	mov [ebp-16],ebx                          ; y2 = y0 + y1
	call .@put_pixel

	call .@registers
	sub eax,ecx
	mov [ebp-12],eax                          ; x2 = x0 - x1
	sub ebx,edx
	mov [ebp-16],ebx                          ; y2 = y0 - y1
	call .@put_pixel

	call .@registers
	add eax,edx
	mov [ebp-12],eax                          ; x2 = x0 + y1
	add ebx,ecx
	mov [ebp-16],ebx                          ; y2 = y0 + x1
	call .@put_pixel

	call .@registers
	add eax,edx
	mov [ebp-12],eax                          ; x2 = x0 + y1
	sub ebx,ecx
	mov [ebp-16],ebx                          ; y2 = y0 - x1
	call .@put_pixel

	call .@registers
	sub eax,edx
	mov [ebp-12],eax                          ; x2 = x0 - y1
	add ebx,ecx
	mov [ebp-16],ebx                          ; y2 = y0 + x1
	call .@put_pixel

	call .@registers
	sub eax,edx
	mov [ebp-12],eax                          ; x2 = x0 - y1
	sub ebx,ecx
	mov [ebp-16],ebx                          ; y2 = y0 - x1
	call .@put_pixel

	inc dword [ebp-4]                         ; x1

	pop edx
	or edx,edx
	jl .@decision2                            ; for d < 0

; for d >= 0
	dec dword [ebp-8]                         ; y1
	
	mov eax,[ebp-4]                           ; x1
	shl eax,1                                 ; 2*x1
	mov ebx,[ebp-8]                           ; y1
	shl ebx,1                                 ; 2*y1
	sub eax,ebx                               ; 2*x1 - 2*y1
	inc eax                                   ; 2*x1 - 2*y1 + 1
	shl eax,1
	add edx,eax                               ; d = d + 2*(2*x1 - 2*y1 + 1)
	push edx
	jmp .@end_circle

.@decision2:
	mov eax,[ebp-4]                           ; x1
	shl eax,1                                 ; 2*x1
	inc eax
	shl eax,1                                 ; 2*(2*x1 + 1)
	add edx,eax                               ; d = d + 2*(2*x1 + 1)
	push edx

.@end_circle:
	mov eax,[ebp-4]                           ; x1
	mov ebx,[ebp-8]                           ; y1
	cmp eax,ebx
	jle near .@repeat                         ; if x1 <= y1
	
	pop edx
	popad
	add esp,byte 16                           ; discard 4 temporary dwords
	pop ebp
	ret

.@put_pixel:
	mov edi,[ebp-16]                          ; y2

	or edi,edi
	jl .@skip
	cmp edi,[_VBE_YResolution]
	jae .@skip
	mov eax,[ebp-12]                          ; x2
	or eax,eax
	jl .@skip
	cmp eax,[_VBE_XResolution]
	jae .@skip

	imul edi,[_VBE_XResolution]
	add edi,eax                               ; x2
	imul edi,[_VBE_CalcBitsPerPixel2]
	add edi,[_VBE_VirtualScreenAddress]

	mov eax,[ebp+20]                          ; color
	cmp dword [_VBE_CalcBitsPerPixel],8
	jne .hicolor
	mov [edi],al
	jmp .@skip
.hicolor:
	cmp dword [_VBE_CalcBitsPerPixel],16
	jne .truecolor
	mov [edi],ax
	jmp .@skip
.truecolor:
	mov [edi],eax
.@skip:
	ret

.@registers:
	mov eax,[ebp+8]                             ; x0
	mov ebx,[ebp+12]                            ; y0
	mov ecx,[ebp-4]                             ; x1
	mov edx,[ebp-8]                             ; y1
	ret



;******************************************************************************
;*
;* PutPixel: You need explanation ...?
;*           Watch out where you put the pixel (must not exceed the virtual
;*           screen boundary).
;*
;*     In:  push dword color		; ebp+16
;*          push dword y0		; ebp+12
;*          push dword x0		; ebp+8
;*          call _PutPixel
;*
;*     Out: Nothing
;*
;******************************************************************************
_PutPixel:
	push ebp
	mov ebp,esp
	push edi
	push eax
	mov edi,[ebp+12]                             ; y0
	imul edi,[_VBE_XResolution]
	add edi,[ebp+8]                              ; x0
	imul edi,[_VBE_CalcBitsPerPixel2]
	add edi,[_VBE_VirtualScreenAddress]
	mov eax,[ebp+16]
	cmp dword [_VBE_CalcBitsPerPixel],8
	jne .hicolor
	mov [edi],al
	jmp .continue
.hicolor:
	cmp dword [_VBE_CalcBitsPerPixel],16
	jne .truecolor
	mov [edi],ax
	jmp .continue
.truecolor:
	mov [edi],eax
.continue:
	pop eax
	pop edi
	pop ebp
	ret



;******************************************************************************
;*
;* GetPixel: You need explanation ...?
;*           Watch out from where you get the pixel (must not exceed the
;*           virtual screen boundary).
;*
;*      In: push dword y0		; ebp+12
;*          push dword x0		; ebp+8
;*          call _GetPixel
;*
;*     Out: EAX - color
;*
;******************************************************************************
_GetPixel:
	push ebp
	mov ebp,esp
	push edi
	mov edi,[ebp+12]                                ; y0
	imul edi,[_VBE_XResolution]
	add edi,[ebp+8]                                 ; x0
	imul edi,[_VBE_CalcBitsPerPixel2]
	add edi,[_VBE_VirtualScreenAddress]
	cmp dword [_VBE_CalcBitsPerPixel],8
	jne .hicolor
	mov al,[edi]
	movzx eax,al
	jmp .continue
.hicolor:
	cmp dword [_VBE_CalcBitsPerPixel],16
	jne .truecolor
	mov ax,[edi]
	movzx eax,ax
	jmp .continue
.truecolor:
	mov eax,[edi]
.continue:
	pop edi
	pop ebp
	ret



;*****************************************************************************
;*
;* Check the length of the text to scroll vertically
;*
;*       In:  push dword - pointer to the text to be scrolled vertically
;*            call _CheckScrollTextLength
;*           
;*       Out: EAX - length of the text in vertical lines multiplied by 16
;*
;*****************************************************************************
_CheckScrollTextLength:
	push ebx
	push ecx
	push edx
	push esi
	push edi
	xor ecx,ecx
	dec ecx
	mov eax,0ffh
	mov edi,[esp+4+20]	; pointer to the text to be scrolled vertically
	mov edx,edi
	repne scasb
	xchg edx,edi
	sub edx,edi
	mov ecx,edx             ; ECX - length of text to scroll

	xor eax,eax
	xor ebx,ebx
.count_lines:
	repne scasb
	inc ebx
	or ecx,ecx
	jnz .count_lines
; EBX - nr of lines
	shl ebx,4               ; multiply by 16 (text height is 16 pixels)
	mov eax,ebx
	pop edi
	pop esi
	pop edx
	pop ecx
	pop ebx
	ret



;*****************************************************************************
;*
;* Create the color of your choice in highcolor and truecolor modes.
;*
;*       In:  push dword - intensity of blue  (0-255)
;*            push dword - intensity of green (0-255)
;*            push dword - intensity of red   (0-255)
;*            call _CreateColor
;*           
;*       Out: EAX - the requested color in direct color format
;*
;*****************************************************************************
_CreateColor:
	push ebx
	push ecx
	push edx
	mov ebx,[esp+12+4]                       ; red
	mov ecx,[esp+12+8]                       ; green
	mov edx,[esp+12+12]                      ; blu
	movzx ebx,bl
	movzx ecx,cl
	movzx edx,dl
	cmp dword [_VBE_BitsPerPixel],8
	jne .highcolor1
	xor eax,eax
	jmp short .continue
.highcolor1:
	cmp dword [_VBE_BitsPerPixel],15
	jne .highcolor2
	shr ebx,3
	shl ebx,10
	shr ecx,3
	shl ecx,5
	shr edx,3
	mov eax,edx                              ; blu
	or eax,ecx                               ; green
	or eax,ebx                               ; red
	jmp short .continue
.highcolor2
	cmp dword [_VBE_BitsPerPixel],16
	jne .truecolor
	shr ebx,3
	shl ebx,11
	shr ecx,2
	shl ecx,5
	shr edx,3
	mov eax,edx                              ; blu
	or eax,ecx                               ; green
	or eax,ebx                               ; red
	jmp short .continue
.truecolor:
	shl ebx,16
	shl ecx,8
	mov eax,edx                              ; blu
	or eax,ecx                               ; green
	or eax,ebx                               ; red
.continue:
	pop edx
	pop ecx
	pop ebx
	ret


