\ FORTH SCREEN FILE INDEX PROGRAM
\ COPYRIGHT (C) 1985 BY THOMAS ALMY
\ ALL RIGHTS RESERVED.

\  Users of ForthCMP are given permission to use or distribute this
\  program, as long as no charge is made and the credit message is maintained.



100 MSDOS
SCONSTANT SDEFSTR SCR" \ SOURCE DEFAULTS TO .SCR 
SCONSTANT DDEFSTR INX" \ DESTINATION  DEFAULTS TO .INX
HEX 
6000 CONSTANT BUFSIZ   \ each i/o buffer is to be LARGE!
DECIMAL
INCLUDE FILTER

1 1 IN/OUT
: INDEX ( SCREEN# - VALID )
  infile PAD 64 FREAD 64 <> IF DROP ( done ) 0 ELSE  
	4 .R
	SPACE
	PAD 64 -TRAILING TYPE
	CR
        infile 1024 64 - 0 1 FSEEK 2DROP \ skip to next line zero
	-1 ( return success )
  THEN ; 

0 0 IN/OUT 
: NOTICE  
	." FORTH SCREEN INDEXING PROGRAM " CR
	." COPYRIGHT (C) 1985 BY THOMAS ALMY " CR 
  ;

0 0 IN/OUT 
: USAGE   
    CONSOLE CR
    ." USAGE:  INDEX  [SCRFILE] [LISTFILE]" CR
    ." where SCRFILE is a file of Forth screens (default extension SCR)" CR
    ." and LISTFILE is file for index (default extension INX)" CR
    ." If SCRFILE is not specified, standard input is used," CR
    ." use `-' if listfile is to be specified." CR
    ABORT
  ;

: MAIN    
        SETBUFS ( which allows I/O )
	NOTICE  ( Welcome message )
	SETFILES IF USAGE THEN ( open files, if possible )
	OPTIONSTRING 2+ @ IF USAGE THEN ( any arg means bad syntax )
	0 
	BEGIN 
		DUP INDEX
	WHILE
		1+ DUP 60 MOD 0= IF CR CR CR CR CR CR THEN 
	REPEAT
	DROP 
	BYE 
  ;

INCLUDE DOS2
INCLUDE FORTHLIB

END

