/*
Name:               split.c
Processor:          Intel 80xxx
Platform:           IBM PC
Compiler:           BC v3
Compiler Directive: Autolink
Creation Date:      5 Nov 00
Author:             I Parker
Version:            1.01
Bugs:               none known
ToDo:
Description:        splits file into parts and merges them back again
                    each file split is manual, that is you can't say split into
                    thirty parts, but you have total control over the splits 
                    to byte level. i.e. you can say extract byte x to byte y in
                    middle of file. It is capable of working with very large 
                    files.
Usage:              split [-start|-end|-point|-merge]
Status:             freeware use this code at your own risk I accept no liability
Revision History:
Notes:              -start splits file from begining of file to byte count
                    -end splits file from byte count to end of file
                    -point splits piece out of middle of file
                    -merge merges files back into one
                    It may be of note that the end of file markers are treated
                    differently between the splitting options. This is so the
                    file when merged back together is 100% correct.
Wish List:
Faults:
*/

#include <stdio.h>

FILE *out;

void concatenate(void)
{
FILE *cat;
extern FILE *out;
char ch,catname[13];
unsigned long int last, cnt_1;

  printf("\n Enter name of next file to merge (concatenate) ");
  scanf("%12s",&catname);
    if((cat = fopen(catname, "rb")) == NULL)
  {fprintf(stderr, "Couldn't open file \"%s\".\n",catname);exit(0);}

  fseek(cat,0L,SEEK_END);
  last = ftell(cat);
  rewind(cat);
  for(cnt_1 = 0L; cnt_1 <= last -1; cnt_1++)
    {
    ch = fgetc(cat);
    fputc(ch,out);
    }
  fclose(cat);
}

void merge(void)
{
FILE *in;
extern FILE *out;
char ipname[13];
char opname[13];
char ch;
int cmd;
unsigned long int last, cnt_1;
int cnt_2;


printf("\n Enter name of output file ");
scanf("%12s",&opname);
if((out = fopen(opname, "wb")) == NULL)
{fprintf(stderr, "Couldn't create output file \"%s\".\n",opname);exit(0);}

printf("\n Enter name of first file to merge ");
scanf("%12s",&ipname);
if((in = fopen(ipname, "rb")) == NULL)
{fprintf(stderr, "Couldn't open first file \"%s\".\n",ipname);exit(0);}

fseek(in,0L,SEEK_END);
last = ftell(in);
fseek(in,0L,SEEK_SET);
for(cnt_1 = 0L; cnt_1 <= last -1; cnt_1++)
{
ch = fgetc(in);
fputc(ch,out);
}
fclose(in);

while(cmd != '.'){
concatenate();
printf("\n enter stop (.) to stop; return for next file ");
cmd = getch();
}
printf("\n writing and closing :- %s ", &opname);
last = ftell(out);
printf("\n which is %ld bytes long ", last);
fclose(out);
}


void prompt(void)
{
printf("\n split by IParker V1.01"
       "\n usage split -start splits file from start to a point"
       "\n             -end splits file from point to end"
       "\n             -point splits file from point 1 to point 2"
       "\n             -merge merge multipart files back together");
}
 
void start(void)
{
FILE *in, *verb;  
unsigned long count,last,cutoffbyte;
char ch;
char vername[13]; 
char inname[13];

printf("\n Enter name of file to split including file extension ");
scanf("%12s",&inname);            
if((in = fopen(inname, "rb")) == NULL)                    /* read only */
   {
   fprintf(stderr,"Can't open data file. \n",&inname);
   exit(2);
   }      

printf("\n Enter name of output file one including file extension ");
scanf("%12s",&vername);            
if((verb = fopen(vername, "wb")) == NULL)                    /* write only */
   {
   fprintf(stderr,"Can't create output file one. \n",&vername);
   exit(2);
   }

fseek(in,0L,SEEK_END);                                   /* seek end of file */
	last = ftell(in);                             /* report size of file */
printf("\n size of file is %ld bytes", last);
printf("\n enter the cutoff byte ");
scanf("%ld",&cutoffbyte);

if(cutoffbyte >= last)
   {printf("\n THAT BYTE IS BEYOND THE LENGTH OF THE FILE ");exit(3);}

fseek(in,0L,SEEK_SET);                           
	for (count = 0L; count <= cutoffbyte -1; count++)     /* loop to end of data file */
	{
	
		ch = fgetc(in);                       /* get char from data file */ 
                {fputc(ch,verb);}                             
	}
fclose(in);
fclose(verb);
}

void end(void)
{
FILE *in, *verb;  
unsigned long count,last,startbyte;
char ch;
char vername[13]; 
char inname[13];

printf("\n Enter name of file to split including file extension ");
scanf("%12s",&inname);            
if((in = fopen(inname, "rb")) == NULL)                    /* read only */
   {
   fprintf(stderr,"Can't open data file. \n",&inname);
   exit(2);
   }      

printf("\n Enter name of output file one including file extension ");
scanf("%12s",&vername);            
if((verb = fopen(vername, "wb")) == NULL)                    /* write only */
   {
   fprintf(stderr,"Can't create output file one. \n",&vername);
   exit(2);
   }

fseek(in,0L,SEEK_END);                                   /* seek end of file */
	last = ftell(in);                             /* report size of file */
printf("\n size of file is %ld bytes", last);
printf("\n enter the start point byte ");
scanf("%ld",&startbyte);

if(startbyte >= last)
   {printf("\n THAT BYTE IS BEYOND THE LENGTH OF THE FILE ");exit(3);}


fseek(in,startbyte -1,SEEK_SET);                           
	for (count = startbyte; count <= last; count++)     /* loop to end of data file */
        {
		ch = fgetc(in);                       /* get char from data file */ 
                {fputc(ch,verb);}                             
	}
fclose(in);
fclose(verb);
}

void point(void)
{
FILE *in, *verb;  
unsigned long count,last,startbyte,cutoffbyte;
char ch;
char vername[13]; 
char inname[13];

printf("\n Enter name of file to split including file extension ");
scanf("%12s",&inname);            
if((in = fopen(inname, "rb")) == NULL)                    /* read only */
   {
   fprintf(stderr,"Can't open data file. \n",&inname);
   exit(2);
   }      

printf("\n Enter name of output file one including file extension ");
scanf("%12s",&vername);            
if((verb = fopen(vername, "wb")) == NULL)                    /* write only */
   {
   fprintf(stderr,"Can't create output file one. \n",&vername);
   exit(2);
   }

fseek(in,0L,SEEK_END);                                   /* seek end of file */
	last = ftell(in);                             /* report size of file */
printf("\n size of file is %ld bytes", last);
printf("\n enter the start byte ");
scanf("%ld",&startbyte);

if(startbyte >= last)
   {printf("\n THAT BYTE IS BEYOND THE LENGTH OF THE FILE ");exit(3);}

printf("\n enter the cutoff byte ");
scanf("%ld",&cutoffbyte);

if(cutoffbyte >= last)
   {printf("\n THAT BYTE IS BEYOND THE LENGTH OF THE FILE ");exit(3);}

if(startbyte >= cutoffbyte)
   {printf("\n THE START BYTE IS BEYOND THE END BYTE ");exit(3);}

fseek(in,startbyte -1,SEEK_SET);                           
	for (count = startbyte; count <= cutoffbyte; count++)     /* loop to end of data file */
	{
	
		ch = fgetc(in);                       /* get char from data file */ 
                {fputc(ch,verb);}                             
	}
fclose(in);
fclose(verb);
}

void main(int argc,char *argv[])
{
if(argc != 2)
{prompt();exit(0);}

if(strcmp(argv[1], "-start") == 0)
       {start();}
else if(strcmp(argv[1], "-end") == 0)
       {end();}
else if(strcmp(argv[1], "-point") == 0)
       {point();} 
else if(strcmp(argv[1], "-merge") == 0)
       {merge();} 
else if(strcmp(argv[1], argv[1]) == 0)
       {prompt();exit(0);}
}

