#include <stdio.h>
#include <string.h>
#include <conio.h>
#include <ctype.h>
#include <process.h>
#include <dir.h>

long int LHex2Dez(char *hex);
void LinkDatafile(char *exename, char *datafilename);
void ExtractDatafile(char *exename, char *datafilename);
extern long int SearchForLinkedDatafile(FILE *datafile);  // check.c


void LinkDatafile(char *arg0, char *datafilename)
{
/*
LinkDatafile copys datafilename to the end of exename.
If the programm file is in the actual directory this file will be modifed
and the user is prompted whether to backup the exe-file.
If the programm file is in an other directory it will be copied in the
actual directory and this file will be modified.
*/
char *p_dummy;
char backupfilename[80], createbackup[85], instruction[80],
	 exename[99], programmpath[80], cwd[80];
FILE *datafile, *exefile;
int c;

if (*datafilename == NULL)     // no dfname given, ask for it
  {
  printf("\nEnter datafilename: "); gets(datafilename);
  if (*datafilename == NULL) exit(1);
  }

getcwd(cwd, 65);       // get the actual directory
 if (cwd[strlen(cwd)-1] != '\\') strcat(cwd, "\\"); // complete pathname
p_dummy = arg0 + strlen(arg0);  // get the programm-filename
while (*p_dummy != '\\' && p_dummy != arg0) p_dummy--; p_dummy++;
strncpy(programmpath, arg0, p_dummy-arg0); programmpath[p_dummy-arg0] = 0;

if (!stricmp(cwd, programmpath))  // is the programm file in the actual directory ?
  {  // yes, ask for backup
  strcpy(exename, arg0);
  fprintf(stderr, "Create backup-file of patch-programm (Y/n/q) ? ");  // Ask for backup
   c = getche(); c = toupper((unsigned char)c); fprintf(stderr, "\n");
   switch (c)
	 {
	 case 'N':
	   break;
	 case 'Q':   // quit
	 case 0x1B:
	   fprintf(stderr, "Aborting (user break).\n");
	   exit(1);
	 default:
	   strcpy(backupfilename, exename);  // construct backupfilename
	   p_dummy = strchr(backupfilename, '.');
	   strcpy(p_dummy, ".BAK");
	   printf(" Creating backupfile %s ...\n", backupfilename);
	   sprintf(createbackup, "copy %s %s", exename, backupfilename);
	   system(createbackup); // creat it
	   break;
	 }
  }
 else
  {  // no, copy it to the actual directory, modify this file
  sprintf(instruction, "copy %s %s%s > nul", arg0, cwd, p_dummy); // copy the file
  system(instruction);
  strcpy(exename, cwd); strcat(exename, p_dummy);  // set exename to programm file in actual directory
  }


if ((exefile = fopen(exename, "ab")) == NULL)   // open exe-file (append)
  {
  fprintf(stderr, "\nCannot open programm file for linking. Aborting.\n");
  exit(255);
  }
if ((datafile = fopen(datafilename, "rb")) == NULL)  // open datafile (read)
  {
  fprintf(stderr, "\nCannot open datafile for linking. Aborting.\n");
  exit(255);
  }

fseek(exefile, 0L, SEEK_END);    // go to the end of the exe-file

printf("Linking datafile ...");
while (1)              // copy datafile to exefile
  {
  c = fgetc(datafile);
  if (feof(datafile)) break;
  fputc(c, exefile);
  }

fclose(exefile); fclose(datafile);   // close them

printf(" Done.\ndatafile %s linked to %s.\n", strupr(datafilename), strupr(exename));

return;
}


void ExtractDatafile(char *exename, char *datafilename)
{
/*
ExtractDatafile copys a linked datafile (if one is found) out of exefile
to datafile. The linked datafile is not removed !
*/
FILE *exefile, *datafile;
long int linked_datafile_offset=0;
int c;

if (*datafilename == NULL)     // no dfname given, ask for it
  {
  printf("\nEnter datafilename: "); gets(datafilename);
  if (*datafilename == NULL) exit(1);
  }

if ((exefile = fopen(exename, "rb")) == NULL)   // open exe-file (read)
  {
  fprintf(stderr, "\nCannot open programm file for extracting. Aborting.\n");
  exit(255);
  }
if ((datafile = fopen(datafilename, "wb")) == NULL)  // open datafile (write)
  {
  fprintf(stderr, "\nCannot open datafile for extracting. Aborting.\n");
  exit(255);
  }

printf("Searching for linked datafile ...");
linked_datafile_offset = SearchForLinkedDatafile(exefile);  // search for a linked datafile
if (linked_datafile_offset == 0)  // no linked df found, abort
  {
  fprintf(stderr, " Failed.\nNo linked datafile found, cannot extract. Aborting.\n");
  fclose(exefile); fclose(datafile);
  exit(1);
  }
printf(" Done.\nExtracting linked datafile ...");
fseek(exefile, linked_datafile_offset, SEEK_SET);  // go to the begin of the linked df

while (1)              // copy the linked datafile out of exefile to datafile
  {
  c = fgetc(exefile);
  if (feof(exefile)) break;
  fputc(c, datafile);
  }

fclose(exefile); fclose(datafile);   // close them

printf(" Done.\nLinked datafile extracted to %s.\n", strupr(datafilename));

return;
}



long int LHex2Dez(char *hex)
/*
LHex2Dez converts the string hex in a signed long int (depending on the sign
of the hex-value).
LHex2Dez begins at the end of the string and steps left until a character
outside the valid range (0-9, A-F) is found.
*/
{
long int Stellenwert = 1, dez = 0;
int pos, w, negativ = 0, lastdigit = 0;
char z;

if (*hex == '-') negativ = 1, lastdigit = 1;

strupr(hex);
pos = strlen(hex);
while (!(*(hex+pos) >= '0' && *(hex+pos) <= '9') && !(*(hex+pos) >= 'A' && *(hex+pos) <= 'F'))
  pos--;


for (; pos>=lastdigit; pos--)
  {
  z = *(hex + pos);
  switch (z)
    {
    case 'A': w = 10; break;
    case 'B': w = 11; break;
    case 'C': w = 12; break;
    case 'D': w = 13; break;
    case 'E': w = 14; break;
    case 'F': w = 15; break;
    default: w = z-48;
    }
    dez += w * Stellenwert;
    Stellenwert *= 16;
  }

if (!negativ) return dez; else return -dez;
}
