#include "eel.h"

/*
* M-x edit-key.  Assumes you have the source for epsilon and that
* you have tagged it.  epsilon_tags is the name of the tag file
* which should contain absolute pathnames.  Type M-x edit_key
* then a bound key which takes you to the eel definition that
* implements the command.
*
* Enjoy, Shane Hartman
*/

char epsilon_tags[40] = "c:\\epsilon\\source\\tags";

command edit_key ()
{
  char tmp[80];
	int index;

  load_tags (epsilon_tags);
	index = *ask_key ("Edit command for key: ", 0, tmp);
  say ("");
  if (index <= 0 || name_type (index) == NT_MACRO)
  {
    say ("The key %s is not bound to any command.", tmp);
    quick_abort ();
  }
	else
  {
    char *name = name_name (index);
    
    if (name != NULL)
    {
      int i;
      char c;
      
      for (i = 0; (c = name[i]) != 0; i++)
      {
        if (c == '-') c = '_';
        tmp[i] = c;
      }
      tmp[i] = 0;
    }
    go_tag (tmp);
  }
}
