unit showbuff;
{
Written for JugglePro on March 16, 1993.
}

Interface

procedure showbuffer(cl,ncl:byte);
{
This writes the contents of the buffer to screen and displays the
selected line, cl, with background color 3.
}

function gget(var inn:text; start,finish:integer):byte;
{
This loads lines start thru finish from file inn into the buffer.
Returned value gget = number of lines retrieved
}

Implementation

uses crt,header;

procedure showbuffer;
var
  i:byte;

begin
  textcolor(txt1);
  textbackground(colr1);
  clrscr;
  gotoxy(15,25);
  write('Press Esc to exit.  Spacebar links.  Enter selects choice.');
  gotoxy(1,1);
  for i:=1 to ncl do
    writeln(buffer[i]);
  textbackground(colr3);
  if cl>ncl then cl:=ncl;
  gotoxy(1,cl);
  writeln(buffer[cl]);
end;

function gget;
var
  xx:integer;

begin
  reset(inn);
  xx:=1;
  if start>1 then
    repeat
      readln(inn);
      xx:=xx+1;
    until xx=start;
  repeat
    readln(inn,buffer[xx-start+1]);
    xx:=xx+1;
  until eof(inn) or (xx>finish);
  gget:=xx-start;
end;

end.