#include "pt.h" 
#include "conio.h" 
#include "string.h" 

void pascal
/* XTAG:setColor */
setColor(w)
	register struct window *w;
{
	extern union REGS rin, rout;
	extern unsigned char msgBuffer[];
	extern struct window *selWindow;
	extern long selBegin, selEnd;
	extern unsigned char textColor, selColor;
	extern unsigned char bannerColor, borderColor, elevColor;
	extern unsigned char msgColor, promptColor, errorColor, topColor;
	extern int scrRows, scrCols;
	extern struct SREGS segRegs;
	extern int debug;
	
	struct window *saveWindow;
	long saveBegin, saveEnd, savePosTopline;
	int saveRow1, saveCol1, saveRow2, saveCol2, saveNumTopline;
	int row, col, background, foreground;
	register int i;
	int backStart, backStop;
	unsigned char ch1, ch2, *line, *line1, *line2;
	unsigned char saveTextColor, saveSelColor;
	unsigned char saveBannerColor, saveBorderColor;
	unsigned char saveElevColor, saveMsgColor;
	unsigned char savePromptColor, saveErrorColor;
	unsigned char saveTopColor, color, whichColor;

	/* initialize */
	backStart = 0;
	backStop = 8;
	whichColor = 0;

	/* save the present state */
	saveTextColor = w->textColor;
	saveSelColor = w->selColor;
	saveBannerColor = w->bannerColor;
	saveBorderColor = w->borderColor;
	saveElevColor = w->elevColor;
	saveMsgColor = msgColor;
	savePromptColor = promptColor;
	saveErrorColor = errorColor;
	saveTopColor = topColor;
	
	/* save stuff */
	saveWindow = selWindow;
	selWindow = w;
	saveBegin = selBegin;
	selBegin = 18;
	saveEnd = selEnd;
	selEnd = 55;
	saveRow1 = w->row1;
	w->row1 = 15;
	saveCol1 = w->col1;
	w->col1 = 20;
	saveRow2 = w->row2;
	w->row2 = scrRows-1;
	saveCol2 = w->col2;
	w->col2 = scrCols-2;
	savePosTopline = w->posTopline;
	w->posTopline = 0;
	saveNumTopline = w->numTopline;
	w->numTopline = 0;

restart:
	/* set up the map and draw the menu */
	setMap(0, 0, scrRows-1, scrCols-1, 2, 0x7);

	/* draw the color selections */
	row = 6;
	for(background = backStart; background < backStop; background++) {
		col = 0;
		for(foreground = 0; foreground < 16; foreground++) {
			color = (unsigned char)(foreground + 16*background);
			displayChar(row, col++, ' ', color);
			if( background < 10 )
				ch1 = (unsigned char)'0'
						+ (unsigned char)background;
			else
				ch1 = (unsigned char)'A'
					+ (unsigned char)background - 10;
			displayChar(row, col++, ch1, color);
			if( foreground < 10 )
				ch2 = (unsigned char)'0'
						+ (unsigned char)foreground;
			else
				ch2 = (unsigned char)'A'
					+ (unsigned char)foreground - 10;
			displayChar(row, col++, ch2, color);
			displayChar(row, col++, ' ', color);
			col++;
		}
		++row;
	}

	/* display the instructions */
	line =
"         SELECT a display part to change the color of or EXIT to Point";
	for(i = 0; line[i] != '\0'; i++)
		displayChar(0, i, line[i], msgColor);

	line =
"SHOW plain/alternate color menus or CHANGE alternate colors are intense/blinking";
	for(i = 0; line[i] != '\0'; i++)
		displayChar(3, i, line[i], msgColor);

	line =
"      CLICK on a foreground/background color for the selected display part";
	for(i = 0; line[i] != '\0'; i++)
		displayChar(5, i, line[i], msgColor);

	line =
 "  Show-Plain-Colors    Show-Alt-Colors   Intense-Alt-Colors  Blinking-Alt-Colors";
	for(i = 0; line[i] != '\0'; i++)
		displayChar(4, i, line[i], textColor);

	line1 =
 "      Text          Selection        Banner          Border         Elevator    ";

	line2 =
 "    Info Msgs      User Input      Error Msgs       Top Line          Exit      ";
	while( 1 ) {

		/* draw the sample window */
		setMap(0, 0, scrRows-1, scrCols-1, 1, 0);
		drawWindow(w);

		/* draw the message things */
		line = "  Info Msgs   ";
		for(i = 0; line[i] != '\0'; i++)
			displayChar(17, i, line[i], msgColor);
		line = "  User Input  ";
		for(i = 0; line[i] != '\0'; i++)
			displayChar(19, i, line[i], promptColor);
		line = "  Error Msgs  ";
		for(i = 0; line[i] != '\0'; i++)
			displayChar(21, i, line[i], errorColor);
		line = "  Top Line    ";
		for(i = 0; line[i] != '\0'; i++)
			displayChar(23, i, line[i], topColor);

		/* draw in the two menu lines that can be selected in */
		for(i = 0; line1[i] != '\0'; i++) {
			if( (i/16) == whichColor )
				color = selColor;
			else
				color = textColor;
			displayChar(1, i, line1[i], color);
		}
		for(i = 0; line2[i] != '\0'; i++) {
			if( (i/16+5) == whichColor )
				color = selColor;
			else
				color = textColor;
			displayChar(2, i, line2[i], color);
		}
		updateScreen(0, scrRows-1);

		/* wait for a mouse button press and release and act on it */
		if( downButtons(&row, &col) ) {	/* ESCape key */
		restoreOriginalState:
			/* restore the original state */
			w->textColor = saveTextColor;
			w->selColor = saveSelColor;
			w->bannerColor = saveBannerColor;
			w->borderColor = saveBorderColor;
			w->elevColor = saveElevColor;
			msgColor = saveMsgColor;
			promptColor = savePromptColor;
			errorColor = saveErrorColor;
			topColor = saveTopColor;
			goto quit;
		}
		up2Buttons(&row, &col);
		switch( row ) {
		case 0:	/* message lines so ignore the click */
			goto quit;
		case 3:
		case 5:
			break;
		case 1:
			whichColor = (unsigned char)(col/16);
			break;
		case 2:
			whichColor = (unsigned char)(col/16 + 5);
			if( whichColor > 8 )
				goto quit;
			break;
		case 4:
			i = col/20;
			switch( i ) {
			case 0:
				backStart = 0;
				backStop = 8;
				break;
			case 1:
				backStart = 8;
				backStop = 16;
				break;
			case 2:
			case 3:
				/* toggle intensity and blinking */

				/* first for the enhanced graphics adapter */
				rin.h.ah = 0x10;
				rin.h.al = 3;
				rin.h.bl = (char)(i-2);
				int86(0x10, &rin, &rout);

				/* now for the color graphics adapter */
				/* set the blinking bit */
				movedata(0x40, 0x65, segRegs.ds,
					(unsigned int)&ch2, 1);
				if( i == 2 ) {
					/* turn off blinking (intense on) */
					ch2 &= ~0x20;
				} else {
					ch2 |= 0x20; /* turn on blinking */
				}
				outp(0x3D8, ch2);
				break;
			default:
				break;
			}
			goto restart;
		default:
			if( row > 23 )	/* bottom line? */
				goto restoreOriginalState;
			if( row > 13 )	/* past color menu? */
				break;
			color = (unsigned char)(16*(row-6+backStart) + col/5);
			switch( whichColor ) {
				case 0: w->textColor = color; break;
				case 1: w->selColor = color; break;
				case 2: w->bannerColor = color; break;
				case 3: w->borderColor = color; break;
				case 4: w->elevColor = color; break;
				case 5: msgColor = color; break;
				case 6: promptColor = color; break;
				case 7: errorColor = color; break;
				case 8: topColor = color; break;
			}
			break;
		}
	}

quit:
	/* restore stuff */
	selWindow = saveWindow;
	selBegin = saveBegin;
	selEnd = saveEnd;
	w->row1 = saveRow1;
	w->col1 = saveCol1;
	w->row2 = saveRow2;
	w->col2 = saveCol2;
	w->posTopline = savePosTopline;
	w->numTopline = saveNumTopline;
}
