#include "pt.h"
#include "stdlib.h"
#include "fcntl.h"
#include "process.h"
#include "malloc.h"
#include "direct.h"
#include "string.h"
#include "conio.h"
#include "io.h"

int pascal
/* XTAG:makeName */
makeName(s)
	register unsigned char *s;
{
	register int l;
	int nTries;
	unsigned char ch;

	/* try to create a new name by changing the last letter */
	l = strlen(s) - 1;
	nTries = 0;
	ch = tolower(s[l]);	/* save first character */
	while( access(s, 0) == 0 ) {
		/* the file name exists so try another */
		++nTries;
		if( s[l] == 'z' )
			s[l] = 'a';
		else
			++s[l];
		if( s[l] == ch )
			return -1;	/* could not find an unused name */
	}
	return nTries;
}

void pascal
/* XTAG:execCmd */
execCmd(cmdType)
	int cmdType;
{
	extern unsigned char msgBuffer[];
	extern unsigned char textBuffer[];
	extern int menuRow, menuCol;
	extern struct window *selWindow;
	extern long selBegin, selEnd;
	extern union REGS rin, rout;
	extern struct SREGS segRegs;
	extern unsigned int dispMemory;
	extern int scrRows, scrCols;
	extern int menuLine;
	extern unsigned char *userMessages[];
	extern int debug;
	extern unsigned char currentDirectory[];
	extern unsigned char currentDrive;
	extern unsigned char startDirectory[];
	extern unsigned char startDrive;

	int fid, saveOut, saveErr, outHandle;
	int row1, row2, col1, col2;
	int mouseStateSize;
	char *mouseState;
	struct SREGS newRegs;
	long cp;
	unsigned char outFile[13], cmdLine[150], cmdName[64], *p, ch;
	unsigned char *dosExit;

	/* use the current directory that the user set last */
	setDefaultDrive(currentDrive);
	chdir(currentDirectory);

if( cmdType == FEXECSHELL ) {	/* interactive */
	fid = getDOScolor();
	setMap(0, 0, scrRows-1, scrCols-1, 0, fid);
	updateScreen(0, scrRows-1);
	setCPos(0, 0);
	cprintf("EXIT returns you to Point\r\n");
} else {
	if( cmdType == FEXECCMD ) {
		/* get the window corners from the user */
		if( getBox(0, 0, &row1, &col1, &row2, &col2, 0) == 2 )
			return;
		if( row1 == row2 && col1 == col2 ) {
			row2 = scrRows-1;
			if( menuLine < 0 )
				--row2;
			col2 = scrCols-1;
		}
	}

	/* generate names for the  output temp file */
	strcpy(outFile, "UnNamed.a");
	makeName(outFile);

	/* handle redirection of the output */
	saveOut = dup(1);
	saveErr = dup(2);
	outHandle = creatls(outFile, 0);
	if( outHandle == -4 ) {
		msg(userMessages[HANDLEMSG], 3);
		closels(saveOut);
		return;
	} else if( outHandle < 0 ) {
		sprintf(msgBuffer,
			"Cannot create file [%s] ret=%d", outFile, outHandle);
		msg(msgBuffer, 2);
		closels(saveOut);
		return;
	} else {
		dup2(outHandle, 1);
		dup2(outHandle, 2);
		closels(outHandle);
	}
}

	/* save the mouse state */
	rin.x.ax = 21;
	int86(51, &rin, &rout);
	mouseStateSize = rout.x.bx;
	mouseState = (char *)malloc(mouseStateSize);
	if( mouseState != NULL) {
		rin.x.ax = 22;		/* save mouse state */
		rin.x.dx = (unsigned int)mouseState;
		newRegs.es = segRegs.ds;	/* put DS into ES */
		newRegs.cs = segRegs.cs;	/* other segment regs */
		newRegs.ss = segRegs.ss;	/* are unchanged */
		newRegs.ds = segRegs.ds;
		int86x(51, &rin, &rout, &newRegs);
		rin.x.ax = 2;	/* hide the mouse cursor */
		int86(51, &rin, &rout);
		/* reset the cursor to the usual shape */
		if( dispMemory == 0xB000 )
			setCType(12, 13);
		else
			setCType(6, 7);
	}

	/* execute the command */
	if( cmdType == FEXECSHELL ) {
		dosExit = getenv("COMSPEC");
		spawnl(P_WAIT, dosExit, dosExit, NULL);
	} else {
		strcpy(&cmdLine[0], " /C ");
		p = cmdLine + 4;
		cp = selBegin;
		fid = selWindow->fileId;
		while( cp <= selEnd )
			*p++ = readChar(fid, cp++);
		/* look for CRs, LFs, tabs, and blanks at end of the */
		/* command and delete them */
		while( 1 ) {
			ch = *(p-1);
			if( ch=='\n' || ch=='\r' || ch=='\t' || ch==' ' )
				--p;
			else
				break;
		}
		*p = '\0';
		strcpy(cmdName, getenv("COMSPEC"));
		sprintf(msgBuffer,
			"Please wait while executing selection <%s>",
			/* skip the " /C " at the beginning of cmdLine */
			&cmdLine[4]);
		msg(msgBuffer, 1);
		spawnl(P_WAIT, cmdName, cmdName, cmdLine, NULL);
	}

	/* reinitialize the mouse in case the program we called used it */
	if( mouseState == NULL ) {
		initMouse(5, 10, 1);
	} else {
		rin.x.ax = 23;		/* restore mouse state */
		rin.x.dx = (unsigned int)mouseState;
		int86x(51, &rin, &rout, &newRegs);
		rin.x.ax = 1;	/* show the mouse cursor */
		int86(51, &rin, &rout);
		/* restore the Point cursor shape */
		if( dispMemory == 0xB000 )
			setCType(4, 9);
		else
			setCType(2, 5);
		free(mouseState);
	}

	switch( cmdType ) {

	case FEXECSHELL:
	redraw:
		redrawBox(0, 0, scrRows-1, scrCols-1);
		updateScreen(0, scrRows-1);
		break;

	case FEXECCMD:
		/* undo the redirection */
		dup2(saveOut, 1);
		dup2(saveErr, 2);
		closels(saveOut);
		/* show the output file */
		createWindow(outFile, row1, col1, row2, col2, CRTOP, 0);
		updateScreen(0, scrRows-1);
		break;

	case FREPLACECMD:
		fid = selWindow->fileId;
		deleteChars(fid, 0, 1);
		outHandle = openls(outFile, 0);
		while( 1 ) {
			saveOut = readls(outHandle, &textBuffer[0],
				MSGBUFFERSIZE);
			if( saveOut <= 0 )
				break;
			for( row1 = 0; row1 < saveOut; ++row1)
				insertChar(textBuffer[row1]);
		}
		closels(outHandle);
		unlink(outFile);
		goto redraw;
	}

	/* remember the user's current directory and drive */
	(void)getcwd(&currentDirectory[0], FILENAMESIZE);
	currentDrive = getDefaultDrive();

	/* and return to the startup drive and directory */
	setDefaultDrive(startDrive);
	chdir(startDirectory);

}
