{ WASTED.EXE - Version 2.0    }
{ Created: 05/17/1996         }
{ Updated: 07/12/2000         }
{ Writen by Tim Jones         }
{ and Jason Hood              }
{ tjones@wpogate.ssc.nasa.gov (no longer valid?)}
{ jadoxa@hotmail.com          }

{$M 32768,0,655360}          {set up a large stack for recursion}

Program wasted;
uses
  dos;                       {for things like findfirst/findnext, intr() etc.}
const
  version='2.0';             {current version of the program}
  lastrptm=3;                {number of report methods in the program}
  FirstCluster=512;          {first cluster size for the comparison}
  clusternum=7;              {number of cluster sizes to compare}
  direntry=32;               {number of bytes for a directory entry}
  lfnentry=13;               {number of LFN characters in a directory entry}

  {various display lengths, including spaces between values}
  sizelen=14;                {bytesize and realsize: 9,999,999,999}
  wastlen=12;                {wasted: 99,999,999}
  dirylen=11;                {directory: 99,999,999}
  pcntlen=7;                 {percentage: 99.99 - 100% never occurs}
  pcntdec=2;
  pathlenlost=sizelen*2+wastlen+pcntlen+1; {One more for the percent sign}
  extdlen=23;                {extended file totals header}
  extflen=6;                 {number of files: 9,999 (for min. width only)}

type ClusterSizes = record
                      cluster:longint;  {cluster size}
                      total:longint;    {total number of clusters}
                      used:longint;     {used number of clusters}
                      size:real;        {total number of bytes for files}
                      dirsize:longint;  {total number of bytes used in dirs}
                    end;

type ExtFreeSpace = record
                      size:word;                {size of this record}
                      version:word;             {0}
                      clustersize:longint;      {sectors per cluster}
                      sectorsize:longint;       {bytes per sector}
                      available:longint;        {available clusters}
                      total:longint;            {total number of clusters}
                      phys_avail:longint;       {available physical sectors}
                      phys_total:longint;       {total physical sectors}
                      alloc_avail:longint;      {available allocation units}
                      alloc_total:longint;      {total allocation units}
                      reserved:array[0..7] of byte;
                    end;

var
  fspec:string;              {file spec. for selecting files}
  totclust,usdclust:longint; {total and used number of clusters on the disk}
  clust,usrclust:longint;    {cluster size, user cluster size}
  totalbs:real;              {total bytesize for all directories}
  totalrs:real;              {total realsize for all directories}
  totalds:longint;           {total dirsize  for all directories}
  totalfiles:longint;        {total number of files}
  totaldirs:longint;         {total number of subdirectories}
  totalempty:longint;        {total number of zero-cluster files}
  totalsc:longint;           {total number of single-cluster files}
  totalscbs:real;            {total bytesize for single-cluster files}
  totalscrs:real;            {total realsize for single-cluster files}
  totalmc:longint;           {total number of multi-cluster files}
  totalmcbs:real;            {total bytesize for multi-cluster files}
  totalmcrs:real;            {total realsize for multi-cluster files}
  clustcmp:array [1..clusternum] of ClusterSizes; {clusters for comparison}
  cmpclust:boolean;          {true if comparing clusters}
  s1name:pathstr;            {user specified dir to be used}
  files:boolean;             {display only files in selected directory}
  showtotals:boolean;        {holds user choice for showing totals or not}
  showexttotals:boolean;     {display extended totals}
  recurse:boolean;           {recurse into subdirectories or not}
  totalsonly:boolean;        {holds user choice for only displaying totals}
  progress:boolean;          {flag to show a progress indicator}
  screen:text;               {write to the screen for the progress indicator}
  pause:boolean;             {holds user choice for screen pausing}
  linecount:byte;            {holds the number of screen lines displayed}
  quitit:boolean;            {if quitit is true then the program will end}
  scrCols,scrRows:byte;      {screen dimensions}
  width:integer;             {width of the report}
  pathlen:integer;           {display length of the path}
  usrrptm:integer;           {user specified report method}
  isLFN:boolean;             {flag to indicate if long names are available}
  fat32:boolean;             {flag to indicate a FAT32 drive}
  redir:boolean;             {flag to indicate redirection}
  thousep:char;              {character used to separate thousands}

  param:string;              {holding variable for each cmd-line parameter}
  i,j:byte;                  {loop variable}
  fcount:byte;               {# of files specified on the cmd-line}
  tmp:string;                {used to hold numbers for conversion to strings}
  error:integer;             {string to numeric conversion error flag}
  num:longint;               {used to hold numbers converted from strings}


{This function will convert a given string into an all upper case string}
function upper(s:string):string;
var
  i:integer;
begin
  for i:=1 to length(s) do
    s[i]:=upcase(s[i]);
  upper:=s;
end;


{This function will "pad right" or truncate a string to a given length}
function padr(s:string; l:integer):string;
var
  j:integer;
begin
  j:=length(s);
  if j < l then
    fillchar(s[j+1], l-j, ' ');
  s[0]:=chr(l);
  padr:=s;
end;


{This function will return the left portion of a string (chars 1 to p)}
function left(const s:string; p:integer):string;
begin
  left:=copy(s, 1, p);
end;


{This function will return the right portion of a string (l chars from strlen)}
function right(const s:string; l:integer):string;
begin
  right:=copy(s, length(s)-l+1, l);
end;


{This function will return the right portion of a string (chars p to strlen)}
function toend(const s:string; p:integer):string;
begin
  toend:=copy(s, p, 255);
end;


{This function will return the last character of a string}
function lastc(const s:string):char;
begin
  lastc:=s[length(s)];
end;


{This function will return the symbol used to separate thousands}
function thousandsSeparator:char;
var
  buf:array[0..34] of byte;
  regs:registers;
begin
  regs.AX:=$3800;                  {Get Current Country Info}
  regs.DS:=seg(buf);
  regs.DX:=ofs(buf);
  buf[7]:=ord(',');                {Buffer unchanged if call failed}
  intr($21,regs);                  {so set a default value}
  thousandsSeparator:=chr(buf[7]);
end;


{This function will return a thousands-separated number}
function sep(num:real):string;
var
  s:string;
  j:integer;
begin
  str(num:0:0,s);
  j:=length(s) - 2;
  while j > 1 do
  begin
    insert(thousep, s, j);
    DEC(j,3);
  end;
  sep:=s;
end;


{Get the free space information for FAT32 drives}
{bytedrv = numerical equivalent of the drive letter A=1, B=2, C=3 etc.}
function getExtendedFreeSpace(bytedrv:byte; var ef:ExtFreeSpace):boolean;
var
  regs:registers;
  drive:string[4];
begin
  drive:=chr(bytedrv+64)+':\'+#0;
  ef.version:=0;
  regs.AX:=$7303;                  {Call to Get Extended Free Disk Space}
  regs.CX:=sizeof(ef);
  regs.DS:=seg(drive[1]);
  regs.DX:=ofs(drive[1]);
  regs.ES:=seg(ef);
  regs.DI:=ofs(ef);
  intr($21,regs);
  getExtendedFreeSpace:=not ((regs.Flags and fCarry = fCarry) or (regs.AL = 0));
end;


{This function invokes DOS interrupt 21h function 36h (or 7303h) to return the}
{cluster size, total number of clusters and free clusters for the given drive}
{bytedrv = numerical equivalent of the drive letter A=1, B=2, C=3 etc.}
function getDiskStats(bytedrv:byte; var total,used:longint):word;
var
  regs:registers;
  ef:ExtFreeSpace;
begin
  if getExtendedFreeSpace(bytedrv, ef) then
  begin
    getDiskStats:=ef.clustersize * ef.sectorsize;
    total:=ef.total;
    used:=ef.total - ef.available;
  end
  else
  begin
    regs.AH:=$36;                  {Call to Get Free Disk Space}
    regs.DL:=bytedrv;              {function 36 expects A=1, B=2, C=3 etc.}
    intr($21,regs);                {perform actual interrupt call}
    getDiskStats:=regs.AL*regs.CX; {calculate/return cluster size}
    total:=regs.DX;                {set total number of clusters}
    used:=regs.DX - regs.BX;       {set number of used clusters}
  end;
end;


{This function will return the actualsize given the bytesize and clustersize}
function getActualSize(bytesize,cluster:longint):longint;
begin
  if bytesize = 0 then
    getActualSize:=0
  else
    getActualSize:=(((bytesize - 1) div cluster) + 1) * cluster;
end;


{This function will make sure that the given directory has at least one}
{directory specified and will chop off the trailing backslash if needed}
{This function was necessary because the pascal CHDIR() function does not}
{appear to work properly.  ex. chdir('C:\') works but chdir('C:\BP\BIN\')}
{does not work.  (go figure)}
function dir(sdir:string):string;
begin
  if lastc(sdir) = '\' then        {check for an ending backslash}
  begin
    {delete(sdir,length(sdir),1);} {remove the ending backslash}
    DEC(sdir[0]);
    if lastc(sdir) = ':' then      {check for the case of "C:\"}
      {sdir:=sdir+'\';}            {put the ending backslash back on}
      INC(sdir[0]);
  end;
  dir:=sdir;                       {return the new directory}
end;


{This procedure will display the syntax for the program and also display an}
{error message if one was supplied.  This procedure always halts the program}
{with an error level 0 (no error) or 1 (error)}
procedure syntax(const errmsg:string);
begin
  writeln(' Purpose:');
  writeln('   WASTED was written to quickly traverse a harddrive and report how much');
  writeln('   diskspace each directory really uses based upon the cluster size.');
  writeln(' Output:');
  writeln('   bytes  usedbytes  usedbytes-bytes  percentage');
  writeln('   where percentage is based upon the report method used. (see below)');
  writeln(' Syntax:');
  writeln('   WASTED [directory][spec[;spec[;...]]] [options]');
  writeln('   where directory is the directory to start at (default=current directory)');
  writeln('         spec is the file specification(s) to use (default=*.*)');
  writeln(' Options: (prefix / and - are valid)');
  writeln('   /?   = This help text');
  writeln('   /C:n = Sets the cluster size to n (where n > 0)');
  writeln('   /n   = Sets the cluster size to n, or nK if n <= 64');
  writeln('   /C   = Compare cluster sizes');
  writeln('   /F   = Display files instead of directories');
  writeln('   /E   = Display totals for single- and multi-cluster files (Extended Totals)');
  writeln('   /T   = Display only the total(s)');
  writeln('   /NT  = Turns off the displaying of the Total line (No Totals)');
  writeln('   /NS  = Selected directory only (No Subdirectories)');
  writeln('   /P   = Pause between screens');
  writeln('   /W:n = Set the report width to n');
  writeln('   /R:n = Report using method n');
  writeln('          n=1 = Wasted percentage based upon used disk space (default)');
  writeln('          n=2 = Wasted percentage based upon overall used space');
  writeln('          n=3 = Wasted percentage based upon disk size');
  writeln(' Parameters may be specified in any order.');
  if errmsg <> '' then
  begin
    if not redir then writeln;
    writeln(screen,'Error: ',errmsg);
    halt(1);
  end;
  halt(0);
end;


{This function determines if stdout has been redirected}
{Returns true if output is to the screen, false if to a file}
function isatty:boolean;
var
  regs:registers;
begin
  regs.AX:=$4400;                  {IOCTL Get Device Information}
  regs.BX:=1;                      {stdout's handle}
  intr($21,regs);
  isatty:=(regs.DX and $80) <> 0;  {Bit 7 = 0 for file, 1 for device}
end;


{This function takes a given drive/directory and figures out the cluster info}
function init(const startdir:string):string;
var
  sdrive:byte;               {source drive in numerical format A=1, B=2 etc.}
  source:pathstr;
  sdir:dirstr;
  sname:namestr;
  sext:extstr;
  posn:byte;
  F:file;
  a:word;
begin
  {replace / with \ for those of us who like UN?X style}
  source:=startdir;
  for posn:=1 to length(source) do
    if source[posn] = '/' then source[posn]:='\';
  {generate the source drive (default = current drive/dir)}
  source:=fexpand(source);         {expands the dir to a fully qualified dir}
  if lastc(source) <> '\' then     {not explicitly a directory}
  begin
    posn:=pos(';',source);
    if posn <> 0 then              {multiple file specifications}
    begin
      repeat
        DEC(posn);                 {find the start of the first one}
      until source[posn] = '\';
      fspec:=toend(source,posn+1);
    end
    else
    begin
      fspec:='';
      {test for a directory if there's no wildcards}
      if (pos('*',source) = 0) and (pos('?',source) = 0) then
      begin
        assign(f,source);
        getfattr(f,a);
        if ((a and directory) = directory) or (doserror <> 0) then
          source:=source+'\';      {append an ending \}
      end;
    end;
  end;
  fsplit(source,sdir,sname,sext);  {splits the dir into pieces parts}
  if fspec = '' then               {convert to *.* if no spec. given}
  begin
    if sname = '' then sname:='*';
    if sext = '' then sext:='.*';
    fspec:=sname+sext;
  end;
  sdrive:=ord(sdir[1])-ord('A')+1; {store the source drive as a number A=1}
  {store the cluster size and the total/used number of clusters}
  clust:=getDiskStats(sdrive,totclust,usdclust);
  fat32:=totclust > $fff6;   {assume a FAT32 drive if more than 64K clusters}
  if usrclust > 0 then       {if the user specified a cluster size...}
  begin
    {calc how many user clusters will fit on the drive}
    totclust:=(totclust*clust) div usrclust;
    usdclust:=(usdclust*clust) div usrclust;
    clust:=usrclust;               {use the users cluster size}
  end
  else if cmpclust then
  begin
    usrclust:=FirstCluster;
    for i:=1 to clusternum do
      with clustcmp[i] do
      begin
        cluster:=usrclust;
        total:=(totclust*clust) div usrclust;
        used:=(usdclust*clust) div usrclust;
        size:=0;
        dirsize:=0;
        INC(usrclust,usrclust);
      end;
  end;
  totalbs:=0;                      {initialize the total bytesize}
  totalrs:=0;                      {initialize the total realsize}
  totalds:=0;                      {initialize the total dirsize}
  totalfiles:=0;                   {initialize the total file count}
  totaldirs:=0;                    {initialize the total subdirectory count}
  totalempty:=0;                   {intiialize the zero-cluster file count}
  totalsc:=0;                      {initialize the single-cluster file count}
  totalscbs:=0;                    {initialize the single-cluster bytesize}
  totalscrs:=0;                    {initialize the single-cluster realsize}
  totalmc:=0;                      {initialize the multi-cluster file count}
  totalmcbs:=0;                    {initialize the multi-cluster bytesize}
  totalmcrs:=0;                    {initialize the multi-cluster realsize}
  linecount:=0;                    {initialize the number of lines displayed}
  quitit:=false;                   {allow recursion to start}
  pathlen:=width - pathlenlost;    {initialize the display width of the path}
  progress:=cmpclust or totalsonly or (fspec <> '*.*');
  init:=sdir;                      {return the drive/dir we just got info on}
end;


{This function invokes DOS interrupt 21h function 07h to wait for user input}
{from STDIN.  The reason I just didn't use Pascal's Readkey or Keypressed}
{functions is because if you include the CRT unit, then you cannot perform}
{redirection of output on the dos commandline ex. WASTED C:\ > FULLDISK.TXT}
function dosPause:byte;
var
  regs:registers;
begin
  regs.AH:=$07;                    {Call to Direct STDIN Input function}
  intr($21,regs);                  {perform actual interrupt call}
  if (regs.AL = $1B) or (upcase(chr(regs.AL)) = 'Q') then {check for ESC key}
    quitit:=true;                  {set flag to break out of recursion loop}
end;


procedure checkpause(lines:byte);
begin
  if pause = true then
  begin
    if linecount+lines > scrRows-2 then
    begin
      dospause;
      linecount:=0;
    end;
    INC(linecount,lines);
  end;
end;


{This function expands a filename into a complete path}
function truename(name:string):string;
var
  regs:registers;
begin
  if isLFN then
  begin
    name:=name+#0;
    regs.AX:=$7160;                {LFN truename function}
    regs.CX:=$8002;                {SUBSTed drive/Long name}
    regs.DS:=seg(name[1]);
    regs.SI:=ofs(name[1]);
    regs.ES:=seg(name[1]);         {Long paths can be 260 characters}
    regs.DI:=ofs(name[1]);         {but strings are only 255, so let's}
    intr($21,regs);                {hope no-one has a maximum path}
    if (regs.AX = $7100) then
    begin
      isLFN:=false;
      truename:=fexpand(name);
    end
    else
    begin
      name[0]:=#255;               {Find the length of the new path}
      name[0]:=chr(pos(#0,name) - 1);
      truename:=name;
    end
  end
  else
    truename:=fexpand(name);
end;


{This procedure writes the path (and filename), padding or truncating}
{as necessary and checking for pause}
procedure writepath(const path:string);
begin
  checkpause(1);                 {add 1 to the linecount and check for pause}
  if length(path) > pathlen then
    write('...', right(path,pathlen-3))
  else
    write(padr(path,pathlen));
end;


{This procedure writes the percentage and newline}
procedure writepercent(wasted,realsize:real; clust,usdclust,totclust:longint);
var
  percent:real;
begin
  if (realsize = 0) then percent:=0  {avoid div by zero}
  else
    case usrrptm of
      1: percent:=wasted/realsize;
      2: percent:=wasted/clust/usdclust;
      3: percent:=wasted/clust/totclust;
    end;
  writeln(100*percent:pcntlen:pcntdec,'%');
end;


{This procedure writes all the values}
procedure writevalues(bytesize,realsize: real);
var
  wasted:real;
begin
  wasted:=realsize - bytesize;
  write(sep(bytesize):sizelen, sep(realsize):sizelen, sep(wasted):wastlen);
  writepercent(wasted,realsize,clust,usdclust,totclust);
end;


{This function returns the number of directory entries required for a LFN}
function LFNentries(const name:string):integer;
var
  path:string;
  j:integer;
begin
  if not isLFN then LFNentries:=0
  {else if (name = '.') or (name = '..') then LFNentries:=0}
  {name is the short-form, so only the directory shortcuts start with '.'}
  else if name[1] = '.' then LFNentries:=0
  else
  begin
    path:=truename(name);
    j:=length(path);               {Find the filename portion}
    while path[j] <> '\' do DEC(j);
    path:=toend(path,j+1);
    if path = name then            {No LFN entry}
      LFNentries:=0
    else
      LFNentries:=((length(path) - 1) div lfnentry) + 1;
  end;
end;


{This procedure will calculate the amount of wasted space taken up by the}
{files in the current directory. fspec is a string containing possible}
{multiple specifications, eg: "*.exe;*.com".}
procedure calcWaste(const theDir:string; fspec:string);
var
  dirinfo:searchrec;   {search record for findfirst/findnext functions}
  bytesize:longint;    {combined byte size of the files as reported by DOS}
  realsize:longint;    {combined byte size of the files based upon clusters}
  actualsize:longint;  {byte size of a file based upon clusters}
  spec:string;         {current file spec}
  dircount:integer;    {number of files and subdirectories in this directory}
  filecount:integer;   {number of files in this directory}
  i:integer;           {loop for comparing clusters}
  p:byte;              {position of the semi-colon}
begin
  if progress or redir then
    write(screen,padr(theDir,scrCols-1),#13);
  if not progress and not files then
    writepath(theDir);

  bytesize:=0;         {initialize byte size of the files as reported by DOS}
  realsize:=0;         {initialize byte size of the files based upon clusters}
  dircount:=0;         {initialize count of entries in the directory}
  filecount:=0;        {initialize count of files in the directory}
  fspec:=fspec+';';    {to simplify processing}
  repeat               {for each file spec - could duplicate files}
    p:=pos(';',fspec);
    spec:=left(fspec,p-1);
    findfirst(spec,hidden+readonly+sysfile+archive+directory,dirinfo);
    while (quitit = false) and (doserror = 0) do {while files exist in the dir}
    begin
      INC(dircount);
      INC(dircount,LFNentries(dirinfo.name));
      if (dirinfo.attr and directory) <> directory then
      begin
        INC(filecount);
        INC(bytesize,dirinfo.size);      {add byte sizes}
        if cmpclust then
          for i:=1 to clusternum do
            with clustcmp[i] do
              size:=size+getActualSize(dirinfo.size,cluster)
        else
        begin
          actualsize:=getActualSize(dirinfo.size,clust);
          INC(realsize,actualsize);      {add clust sizes}
          if showexttotals then
          begin
            if actualsize = 0 then
              INC(totalempty)
            else if actualsize <= clust then
            begin
              INC(totalsc);
              totalscbs:=totalscbs+dirinfo.size;
              totalscrs:=totalscrs+actualsize
            end
            else
            begin
              INC(totalmc);
              totalmcbs:=totalmcbs+dirinfo.size;
              totalmcrs:=totalmcrs+actualsize
            end
          end;
          if files and not totalsonly then
          begin
            writepath(truename(dirinfo.name));
            writevalues(dirinfo.size, actualsize);
          end;
        end;
      end;
      findnext(dirinfo);                 {find the next file}
    end;
    delete(fspec,1,p);                   {find the next spec.}
  until fspec = '';

  if cmpclust and (spec = '*.*') then      {add the space taken by}
    if fat32 or (length(theDir) > 3) then  {the directory itself}
    begin
      actualsize:=dircount*direntry;
      INC(totalds,actualsize);
      for i:=1 to clusternum do
        with clustcmp[i] do
          INC(dirsize,getActualSize(actualsize,cluster));
    end;

  if not files and not cmpclust then     {display directory totals}
  begin
    if spec = '*.*' then                 {include the directory itself}
      if fat32 or (length(theDir) > 3) then
      begin
        INC(bytesize,dircount*direntry);
        INC(realsize,getActualSize(dircount*direntry,clust));
      end;
    if not totalsonly then
    begin
      {if a filespec has been given then ignore directories not containing it}
      if spec = '*.*' then
        writevalues(bytesize, realsize)
      else
      begin
        if (filecount = 0) then
          DEC(totaldirs)  {decrease the directory count for the totals line}
        else
        begin
          writepath(theDir);
          writevalues(bytesize, realsize);
        end;
      end
    end;
  end;
  totalbs:=totalbs+bytesize; {add this directory bytesize to the total}
  totalrs:=totalrs+realsize; {add this directory realsize to the total}
  INC(totalfiles,filecount);
end;


{This procedure will display the dir we are working on, calculate the space}
{being wasted in that dir, and finally, recurse into any subdirectories}
procedure showWasted(const theDir:string);
var
  dirinfo2:searchrec;  {searchrec for findfirst/findnext}
begin
  calcWaste(theDir,fspec);    {calculate and display wasted space}
  {find the first subdir in this dir}
  findfirst('*.*',hidden+sysfile+readonly+archive+directory,dirinfo2);
  {while no ESC key and a file was found (no error)}
  while (quitit = false) and (doserror = 0) do
  begin
    {if the file found is a directory...}
    if (dirinfo2.attr and directory) = directory then
    begin
      {only recurse non . and .. directories}
      {if (dirinfo2.name <> '.') and (dirinfo2.name <> '..') then}
      {the short-form was found, so only the shortcuts start with '.'}
      if (dirinfo2.name[1] <> '.') then
      begin
        INC(totaldirs);            {update the subdirectory count}
        ChDir(dirinfo2.name);      {change into the next directory}
        showWasted(truename('.')); {call this procedure(showWasted) recursivly}
        ChDir('..');               {change back to this directory}
      end;
    end;
    findnext(dirinfo2);            {find the next file/directory}
  end;
end;


{This procedure will display some initial stats and spawn off the initial}
{call to the recursion procedure}
{Munge, munj, n. To process information; think; muttle over.}
procedure munge;
var
  startDir:pathstr;          {dir to start checking at}
  origDir:pathstr;           {current dir on requested drive}
  ourDrive:string[2];        {drive we are on}
  i:integer;
  s:string[20];
  wasted:real;

  function verb(number:longint):string;
  begin
    if number = 1 then verb:='is'
    else verb:='are';
  end;

  function plural(number:real; const word:string):string;
  begin
    if number = 1 then plural:=word
    else
    begin
      if lastc(word) = 'y' then plural:=left(word,length(word)-1)+'ies'
      {else if lastc(word) = 'x' then plural:=word+'es'}
      else plural:=word+'s';
    end;
  end;

  function count(number:real; const word:string):string;
  begin
    count:=sep(number)+' '+plural(number,word);
  end;

begin
  GetDir(0,origDir);         {find the current drive}
  ourDrive:=left(origDir,2);
  startDir:=init(s1name);    {init drive info for the drive wanted}
  {find where we are on the drive so we can come back}
  GetDir(ord(startDir[1])-ord('A')+1,origDir);
  {$I-}
  ChDir(dir(startDir));      {go into the starting directory}
  if IOResult = 3 then
  begin
    writeln('Path not found: ',startDir);
    halt(1)
  end;
  {$I+}
  {display cluster info and column headers}
  s:=sep(int(totclust)*clust);
  i:=length(s);
  writeln('Cluster size  :  ',sep(clust):i);
  writeln('# of Clusters :  ',sep(totclust):i);
  write(  'Est. Disk Size:  ',s);
  if (usrrptm = 2) then write(' (',sep(int(usdclust)*clust),' used)');
  writeln; writeln;
  if not cmpclust then
  begin
    if totalsonly or not files then
      write(padr('Directory',pathlen))
    else
      write(padr('File',pathlen));
    writeln('Bytesize':sizelen,'Realsize':sizelen,'Wasted':wastlen);
  end;
  linecount:=6;
  startDir:=truename(startDir);
  if recurse then
    showWasted(dir(startDir)) {display wasted space in this dir and its subdirs}
  else
    calcWaste(dir(startDir),fspec); {display wasted space in this dir only}
  write(screen,' ':scrCols-1,#13); {remove the last displayed directory}
  if cmpclust then
  begin
    if (totalfiles = 0) and (fspec <> '*.*') then
      writeln('There are no files matching "',startDir,fspec,'".')
    else
    begin
      write('   In ',startDir);
      if fspec <> '*.*' then write(fspec);
      if totaldirs <> 0 then
        write(' and the ',count(totaldirs,'directory'), ' below it');
      writeln;
      write('   there ',verb(totalfiles),' ',count(totalfiles,'file'));
      if totalfiles <> 0 then
        write(' totalling ',count(totalbs,'byte'));
      writeln('.');
      if (fspec = '*.*') and (totalds <> 0) then
      begin
        writeln('   It requires ',sep(totalds),
                ' bytes to store the directory entries.');
        writeln;
        writeln('                       Realsize                      Wasted');
        writeln('   Cluster','Files':sizelen,'Dirs.':dirylen,
                'Files':wastlen+1,'Dirs.':wastlen-1,'Total':wastlen);
      end
      else
      begin
        if fspec = '*.*' then
          writeln('   Root directory is a fixed size.');
        writeln;
        writeln('   Cluster','Realsize':sizelen,'Wasted':wastlen);
      end;
      for i:=1 to clusternum do
      begin
        with clustcmp[i] do
        begin
          if clust = cluster then write(startdir[1],':=>')
          else                    write('    ');
          write(sep(cluster):6,sep(size):sizelen);
          wasted:=size-totalbs+dirsize-totalds;
          if (fspec = '*.*') and (totalds <> 0) then
            write(sep(dirsize):dirylen,sep(size-totalbs):wastlen+1,
                  sep(dirsize-totalds):wastlen-1,
                  sep(wasted):wastlen)
          else
            write(sep(size-totalbs):wastlen);
          writepercent(wasted,size+dirsize,cluster,used,total);
        end;
      end;
    end;
  end
  else
  begin
    if (totalfiles = 0) and (files or (fspec <> '*.*')) then
    begin
      writeln;
      if fspec = '*.*' then
      begin
        write('Directory ',startDir);
        if totaldirs <> 0 then
          write(#13,#10,'and its ',count(totaldirs,'subdirectory'));
        writeln(' ',verb(totaldirs+1),' empty.');
      end
      else
        writeln('There are no files matching "',startDir,fspec,'".');
    end
    else
    begin
      {display the total line if the user hasn't specified otherwise}
      if showtotals and not (showexttotals and files) then
        if (files and (totalfiles > 1)) or (not files and (totaldirs > 0)) then
        begin
          if totalsonly then
          begin
            if not recurse then startDir:=dir(startDir);
            writepath(startDir);
          end
          else
            write(padr('Total:',pathlen));
          writevalues(totalbs, totalrs);
        end;
      {display the number of single- and multi-cluster files}
      if showexttotals then
      begin
        s:=sep(totalfiles);
        i:=length(s);
        if not (files and totalsonly) then
          writeln;
        if totalfiles = 0 then
          writeln('The ',plural(totaldirs+1,'directory'),' ',
                  verb(totaldirs+1),' empty.');
        if totalempty <> 0 then
          writeln(padr('Zero-cluster files:',extdlen),sep(totalempty):i);
        if totalsc <> 0 then
        begin
          write(padr('Single-cluster files:',extdlen),sep(totalsc):i,
                ' ':pathlen-i-extdlen);
          writevalues(totalscbs, totalscrs);
        end;
        if totalmc <> 0 then
        begin
          write(padr('Multi-cluster files:',extdlen),sep(totalmc):i,
                ' ':pathlen-i-extdlen);
          writevalues(totalmcbs, totalmcrs);
        end;
        if showtotals and (totalsc <> 0) and (totalmc <> 0) then begin
          write(padr('Total files:',extdlen),s,' ':pathlen-i-extdlen);
          writevalues(totalscbs+totalmcbs, totalscrs+totalmcrs);
        end;
      end;
    end;
  end;
  ChDir(origDir);            {go back to where we originally started from}
  ChDir(ourDrive);           {back to the original drive}
end;


begin
  assign(screen,'con');      {write to the screen, even if redirected}
  rewrite(screen);

  {display the program name, version, and author(s)}
  writeln(screen);
  writeln(screen,'WASTED.EXE v',version,
                 ' - written by Tim Jones and Jason Hood.');
  writeln(screen);

  usrclust:=0;               {set user defined clustersize to 0}
  cmpclust:=false;           {assume not comparing cluster sizes}
  usrrptm:=1;                {set the report method to 1 (default)}
  files:=false;              {directories only}
  showtotals:=true;          {set the flag to show the totals}
  showexttotals:=false;      {set the flag to show the extended totals}
  totalsonly:=false;         {set the flag to show only the totals}
  recurse:=true;             {all subdirectories}
  isLFN:=true;               {assume available for the first call}
  thousep:=thousandsSeparator; {find and set the thousands separator}
  redir:=not isatty;         {true if output is redirected}

  scrCols:=Mem[$40:$4a];     {0040:004A number of columns}
  scrRows:=Mem[$40:$84]+1;   {0040:0084 number of lines - 1}
  width:=scrCols-1;          {Less one to avoid wrap}

  fcount:=0;                 {set file counter to zero}
  s1name:='.\';              {set default directory to current}
  for i:=1 to paramcount do  {loop through each command-line parameter}
  begin
    param:=upper(paramstr(i)); {store off the current parameter in uppercase}
    if (param[1] = '/') or (param[1] = '-') then  {is it an option?}
    for j:=2 to length(param) do
    begin
      case param[j] of             {check the character of the parameter}
        '?':syntax('');            {help text}
        '/':;                      {ignore combined options, eg /e/t}
        'F':files:=true;           {listing files}
        'T':totalsonly:=true;      {show total(s) only}
        'E':showexttotals:=true;   {show extended totals}
        'P':if not redir then pause:=true;  {pause screen listing}
        'N':begin                  {No ... parameter?}
              INC(j);
              if param[j] = 'S' then
                recurse:=false     {turn off subdirectory scanning}
              else if param[j] = 'T' then
                showtotals:=false  {turn off the showing of end totals}
              else syntax('Unknown parameter: N'+param[j]);
            end;
        'C','R','W',               {number-based options}
        '0'..'9':
            begin
              {check for a colon separator and report any error}
              if ((param[j] = 'R') or (param[j] = 'W')) and
                 ((length(param) = j) or (param[j+1] <> ':')) then
                syntax('Colon required after '+param[j]);
              if (param[j] = 'C') and
                 ((length(param) = j) or (param[j+1] <> ':')) then
                cmpclust:=true
              else
              begin
                {convert what follows the colon into a number}
                if param[j+1] = ':' then
                  tmp:=toend(param, j+2)
                else
                  tmp:=toend(param, j);
                val(tmp, num, error);
                if error <> 0 then  {if the conversion failed...}
                begin
                  if param[j] in ['0'..'9'] then param[j]:='C';
                  {display the conversion error and quit}
                  syntax('Numeric conversion error in parameter: '+param[j]);
                end;
                case param[j] of
                  'R':begin        {report method was specified}
                        usrrptm:=num;
                        if usrrptm <= 0 then
                        begin
                          {display the report method error and quit}
                          syntax('Report method must be > 0');
                        end
                        else if usrrptm > lastrptm then
                        begin
                          str(lastrptm,tmp);  {convert numeric report to string}
                          syntax('Report method must be <= '+tmp);
                        end;
                      end;
                  'W':begin        {override the width of the screen}
                        width:=num;
                        if width < extdlen+extflen+pathlenlost then
                        begin
                          str(extdlen+extflen+pathlenlost,tmp);
                          syntax('Width must be >= '+tmp);
                        end;
                      end;
                  else             {user specified cluster size}
                  begin
                    usrclust:=num;
                    if usrclust <= 0 then
                    begin
                      {display the cluster size error and quit}
                      syntax('Cluster size must be > 0');
                    end;
                    {translate 1..64 to 1024..65536}
                    if (usrclust <= 64) and (param[j] <> 'C') then
                      usrclust:=usrclust shl 10; {* 1024}
                  end;
                end; {case}
                j:=length(param);  {skip to the next parameter}
              end;
            end;
        else
          {the user specified an unknown parameter so display error and quit}
          syntax('Unknown parameter: '+param[j]);
      end; {case}
    end else
    begin
      {the user must have specified a filename / directory}
      INC(fcount);
      case fcount of  {this case stmt is here for future expansion}
        1: s1name:=param;  {source 1 name = user specified starting directory}
      else
        {only one file parameter is allowed, display error and quit}
        syntax('Too many file parameters: '+param);
      end;
    end;
  end;
  if not recurse and not files then  {no totals for one directory}
  begin
    showtotals:=false;
    totalsonly:=false;
  end;
  if cmpclust then
    usrclust:=0;
  munge; {let's go!!!}
  close(screen);
end.


{Program History:
 v1.0 - first (non public) release limited to 4096 byte cluster size
 v1.1 + added auto calculating of cluster size
      - changed wasted percentage to be percentage of used disk space
 v1.2 - changed wasted percentage to be percentage of total disk space
      - previous versions were fixed to C:
      + added ability to start from any directory
 v1.3 - first public release
      - completely re-worked the checking of commandline parameters
      - fixed a bug which ended the recursion early
      + added help/syntax screen
      + added /? option for display of help/syntax screen
      + added /C:n option to allow the user to change the cluster size
      + added this history list
 v1.4 - fixed a bug which causes Runtime Error 003 (path not found) when
        you are in a subdirectory and did not specify a starting directory.
      + now you can specify paths with or without the trailing backslash
      + added a Total line at the end (default is to show totals)
      + added the switch /NT to disable the showing of totals
      + added the switch /P to enable a pause between screenfulls of info
 v1.5 + added the switch /R:n to allow the user to select the method
        for calculating the wasted percentage
        n=1 = Wasted percentage based upon disk size (default)
        n=2 = Wasted percentage based upon used disk space
      + added more information to the documentation file
 v1.6 - the program will now recurse into hidden subdirectories
      + recompiled to produce a smaller EXE (almost half the original size!)

 History of Jason Hood's modifications:

 v1.61 4 June, 1996:
  - used comma-separated numbers and adjusted the display accordingly

 v1.7 31 October, 1996:
  + added the /F option to display wastage of files
  + added the ability to select file specifications
  + added the /NS option to prevent recursing into subdirectories
  - general maintenance

 v1.8 28 to 30 March, 1997:
  + added the /C option to compare cluster sizes
  + took directory wastage into account
  - used INC and DEC instructions at appropriate places

 v2.0 28 June to 12 July, 2000:
  + recognize FAT32 partitions and LFN directory entries
  + added third report method (%age of used disk space) and modified order
  + display used space when using above
  + added extended totals (/E) for zero-, single- and multi-cluster files
  + added option /T to only display the total(s)
  + added width option (/W:width) to modify the report's path display
  - test for existing file instead of assuming directory
  - recognize quit when paging the file display
  - rewrote getActualSize function (one div instead of div and mod)
  - modified my version history notes
  - read BIOS to determine the number of lines for paging and default width
  - rewrote padr (fillchar instead of while, always use space, truncate)
  - combined getClustSize and getTotalClust into one function
  - numerous display tweaks
  - removed cluster size 65536 from the comparison
  - use reals for total sizes (2Gb just isn't enough anymore...)
  - rewrote option processing to allow multiple options (eg. /f/ns, -fns)
  - allow /num as shortcut for /C:num; if /num <= 64, translate to kilobytes
  - ignore root directory entries for FAT12/16 (fixed allocation)
  - added the writepercent procedure
}
