/*
  du.c :  Recursive Disk Usage
    Should be compiled with Microsoft C under small
    memory model


 Copyright (c) 1990 Jussi Puttonen (Internet: jpp@utu.fi)
 Not derived from licensed software.

 Permission is granted to freely use, copy, modify, and redistribute
 this software, provided that no attempt is made to gain profit from it,
 the author is not construed to be liable for any results of using the
 software, alterations are clearly marked as such, and this notice is
 not modified.
 */


#include <stdio.h>
#include <dos.h>
#include <string.h>

#define TRUE 1
#define FALSE 0

char * remove_trailing(string, ch)
/* Removes the last char of string if it is equal to ch */
char * string;
char ch;
{
char * last = &string[strlen(string)-1];
if (*last==ch) *last=0;
return string;
}

/********* Directory scanning ********/

#define FT_RDONLY 1
#define FT_HIDDEN 2
#define FT_SYSTEM 4
#define FT_VOLUME 8
#define FT_DIRECTORY 0x10
#define FT_ARCHIVE 0x20

struct Dta {
     char dummy[21];
     char Attr;
     unsigned long Time;
     unsigned long Size;
     char Name[12];
     char dummy2[32];
	};

union REGS in,out;

int attrib_mask = FT_RDONLY | FT_DIRECTORY | FT_ARCHIVE;

FindMatch(str,spec)
char *str,*spec;
{
char s [100];
sprintf(s,"%s\\%s",str, spec);
in.h.ah = 0x4E;
in.x.dx = (int) s;
in.x.cx = attrib_mask;
intdos(&in,&out); return(out.x.ax);
}

FindNext(str)
char *str;
{
in.h.ah = 0x4F; in.x.dx = (int) str;
intdos(&in,&out); return(out.x.ax);
}

/********* Disk Usage ********/

struct statistics {
     long count;
     long bytes;
     };

/* Command line options */
int Technical;
int Depth;

char * ldfmt(i, o, index)
/* Formats the long integer i to string i */
long i;
char * o;
{
if (!index) *o=0;
if (index && (index % 3 == 0)) *--o = ',';
*--o = i % 10 + '0';
if (i/10) return ldfmt(i/10, o, index+1);
    else  return o;
}

print_statistics(message, s)
/* Report statistics */
char * message;
struct statistics s;
{
if (Technical)
    printf("%-22s: %6ld files contain %8ld bytes\n", message, s.count,s.bytes);
    else {
       char scount[11], sbytes[13];
       printf("%-22s: %6s files contain %10s bytes\n", message,
          ldfmt(s.count, &scount[10], 0),
          ldfmt(s.bytes, &sbytes[12], 0));
         }
}

dotted(s)
/* Returns true for strings . and .. */
char *s;
{
if (*s++ != '.') return FALSE;
switch (*s++)
  {
  case '.' : return (*s == 0);
  case 0 : return TRUE;
  default : return FALSE;
  }
}

struct statistics Dir(str,spec, dpth)
char *str;
char *spec;
{
struct Dta DTA;
int OldDta;
char name[60];
struct statistics s = { 0,0 };

/* Get DTA */
in.h.ah = 0x2F; intdos(&in,&out);
OldDta = out.x.bx;

/* Set DTA */
in.h.ah = 0x1A;  in.x.dx = (int) &DTA;
intdos(&in,&out);

if (! FindMatch(str,spec))
  do {
     if (dotted(DTA.Name)) continue;
     sprintf(name,"%s\\%s",str,DTA.Name);
     if (DTA.Attr & FT_DIRECTORY)
      {
      struct statistics sr = Dir(name, spec, dpth+1);
      s.count += sr.count;
      s.bytes += sr.bytes;
      } else
      {
      s.count++; s.bytes+= DTA.Size;
      }
     }
  while (! FindNext(str));

/* Set DTA */
in.h.ah = 0x1A;  in.x.dx = OldDta;
intdos(&in,&out);
if ((! Depth) || (dpth <= Depth)) print_statistics(str, s);
return s;
}

void Help()
{
printf("Use: du [-t] [-d#] [-a] [dirspec] ...\n\
    Calculates the total size and count of the files\n\
    in the given directory and it's subdirectories.\n\
    Uses current directory at default. If more than\n\
    one directory is given, counts also grand total.\n\
    Options:\n\
           -t        Technical output (Numbers are displayed\n\
                      like 999999 instead of the default 999,999)\n\
           -d#       Stops reporting subtotals at depth #\n\
           -a        report also hidden and system files\n\
");
}

void bad_options(s)
char * s;
{
fprintf(stderr, "Bad command line option: %s\n Use \"du -h\" to get help\n", s);
exit(1);
}

main(argc,argv)
char **argv;
{
int i, specs=0;
struct statistics grand_total = { 0,0 };
fprintf(stderr,"Disk Usage utility 1.1. Copyright 1990 Jussi Puttonen (Internet: jpp@utu.fi)\n");

for (i=1; i<argc; i++)
   if (argv[i][0] == '-')
      switch (argv[i][1])
         {
         case 't' : case 'T' : Technical = TRUE;
             if (argv[i][2]) bad_options(argv[i]); break;
         case 'a' : case 'A' : attrib_mask |= (FT_SYSTEM|FT_HIDDEN);
             if (argv[i][2]) bad_options(argv[i]); break;
         case 'h' : case 'H' : Help(); exit(0);
         case 'd' : case 'D' : Depth = atoi(&argv[i][2]); break;
         default : bad_options(argv[i]);
         }

for (i=1; i<argc; i++)
   if (argv[i][0] != '-')
      {
      struct statistics st = Dir(remove_trailing(argv[i], '\\'),"*.*", 1);
      grand_total.count += st.count;
      grand_total.bytes += st.bytes;
      specs++;
      }

switch (specs)
     {
     case 0 : Dir(".", "*.*", 1); break;
     case 1 : break;
     default : print_statistics("\nGrand total", grand_total);
	}

return 0;
}
