/*
    Filename: C:\DAVE\CPP\IO\filecpy.c
    Author  : Dave Nelson
    Created : Sat 26-Dec-1998 20:57:30
    Modified: Tue 05-Jan-1999 21:03:31 - Dave Nelson

    Copyright 1998, 1999 by David S. Nelson
    Permission is hereby given to use this code in any way you see fit.

*/

#define BUFSIZE     4096

#include <stdlib.h>
#include <stdio.h>
#include <dos.h>
#include "fileio.h"

/*Function: filecpy
      Descr: Copy source file to target file.  Note that an actual target
             filename must be provided.  This will not work:

                 filecopy("myfile","a:");

             The target file will retain the timestamp of the source file.

       Args: char *     - Source filespec.
             char *     - Target filespec.
     Return: long         Number of bytes moved, if >0.  Otherwise:
                            -1  =   Unable to open source file.
                            -2  =   Unable to open target file.
                            -3  =   Unable to allocate buffers.
*/
long filecpy(char *src, char *dst){
FILE *ip, *op;
char *buffer;
long total = 0L;
int nr, rv;
unsigned di, ti;
    if( (ip=fopen(src,"rb"))==NULL) return -1L;
    rv = dos_getftime(ip->_file,&di,&ti);

    if( (op=fopen(dst,"wb"))==NULL) {
        fclose(ip);
        return -2L;
        }
    if( (buffer = (char *)malloc(BUFSIZE))==NULL)  {
        fclose(ip);
        fclose(op);
        return -3L;
        }

    while( (nr=fread(buffer,1,BUFSIZE,ip))!=0){
        total += nr;
        fwrite(buffer,nr,1,op);
        }
    fflush(op);                             // for some reason, the timestamp
    rv = dos_setftime(op->_file,di,ti);     // doesn't get set unless the
                                            // io buffer is flushed first.
    fclose(ip);
    fclose(op);
    free(buffer);
    return total;
    }




#if 0
void main(int argc, char **argv){
long cnt;
    switch( (cnt=filecpy(argv[1],argv[2]))){
        case -1:    printf("\nBad source spec.");       break;
        case -2:    printf("\nBad target spec.");       break;
        case -3:    printf("\nCan't allocate buffer");  break;
        default:    printf("\n%ld bytes copied.",cnt);  break;
        }
    }
#endif
