#include "syncdir.h"
#include <string.h>
#include <ctype.h>

static BOOL isMatch(const char *mask, const char *text)
{
  const char *pathPtr   = text;      /* scratch path ptr */
  const char *exclPtr   = mask;       /* scratch match ptr */
  const char *lastSrchP = NULL;      /* used to restart path */
  const char *lastSrchE = NULL;      /* used to restart match expr */
  BOOL        fail      = 0;         /* TRUE if the match failed   */

  while (!fail && *pathPtr && *exclPtr) {
    switch (*exclPtr) {
      case '?':
        /*
          match any single character. this is easy
        */
        pathPtr++;
        exclPtr++;
        break;
      case '*':
      {
        size_t minLen = 0;
        size_t len = 0;
        size_t ii;
        size_t fnd = 0;
        /*
          first, clear out the case of multiple '*'s
        */
        lastSrchE = exclPtr;
        while (*exclPtr == '*')
          exclPtr++;
        /*
          next, look for the minimum number of characters
        */
        while (*exclPtr == '?') {
          minLen++;
          exclPtr++;
        }
        if (!*exclPtr) {
          /*
            let's shortcut if we're looking at the end of the expression
            string
          */
          if (strlen(pathPtr) >= minLen)
            pathPtr += strlen(pathPtr);
          break;
        }
        /*
          ok, let's find out how long the substring must be
        */
        len=0;
        while (exclPtr[len]
               && (exclPtr[len] != '?')
               && (exclPtr[len] != '*'))
          len++;
        /*
          now:
            find the matching substring in pathPtr
        */
        fnd=0;
        while (!fnd && (strlen(pathPtr) >= len)) {
          for (ii=0; (ii < len) && (tolower(exclPtr[ii]) == tolower(pathPtr[ii])); ii++);
          if (ii != len)
            pathPtr++;
          else
            fnd = 1;
        }
        fail = !fnd;
        if (fnd) {
          lastSrchP = pathPtr+1;
          exclPtr += len;
          if (strlen(pathPtr) >= len+minLen)
            pathPtr += len + minLen;
        }
        break;
      }
      default:
        /*
          absolute match. this is easy also
        */
        if (tolower(*pathPtr) == tolower(*exclPtr)) {
          pathPtr++;
          exclPtr++;
        } else if (lastSrchP) {
          pathPtr = lastSrchP;
          exclPtr = lastSrchE;
          lastSrchP = lastSrchE = NULL;
        } else
          fail = 1;
    }
  }
  /*
    skip any '*'s at the end of the string
  */
  while (*exclPtr == '*')
    exclPtr++;
  /*
    if we're at the end of both strings, we've a match
  */
  return (!*pathPtr && !*exclPtr) ? TRUE : FALSE;
}


BOOL isInList(const char *list, const char *text)
{
  while (*list)
  {
    if (isMatch(list, text))
      return TRUE;
    list += strlen(list) + 1;
  }
  return FALSE;
}

