#include "ntui.h"
#include <assert.h>
#include <ctype.h>
#include <conio.h>

static void execCancelCheck(void)
{
  if (optionTest(OPT_VERBOSE))
  {
    if (statDlgCancelTest())
    {
      execModeSet(cancelDlgExec());
      statDlgCancelReset();
    }
  } else
  {
    /*
    check for ``esc''
    prompt for: [c]ontinue, [s]top, [a]bort
    */
    int key;
    if (kbhit() && (getch() == '\x1b'))
    {
      while (kbhit())
        getch();
      printf("[C]ontinue, [S]top, or [A]bort? ");
      do
      {
        key = tolower(getch());
      } while (strchr("csa", key) == 0);
      switch (key)
      {
        case 'c': execModeSet(EXECMODE_NORMAL); break;
        case 's': execModeSet(EXECMODE_CANCEL); break;
        case 'a': execModeSet(EXECMODE_ABORT);  break;
        default:
          assert(0);
      }
      printf("%c\n", key);
    }
  }
}

void showHelp(const char *str)
{
  printf("Format: Syncdir src [dst] flags\n"
         "/a            add files\n"
         "/c            copy files\n"
         "/d[d]         delete files\n"
         "/u            update files\n"
         "/f[acdu]      force add, copy, delete, update\n"
         "/g#           set granularity to # ms\n"
         "              files times within +/-# ms are considered equal\n"
         "/r            recurse into subdirectories\n"
         "/v            verbose mode\n"
         "/q            quiet mode\n"
         "/n            no action\n"
         "/[+][!][name] log actions & errors to [name]\n"
         "              [+] for append, [!] for errors only\n"
         "              default name: syncdir.log\n"
         "/i...         begin include file list\n"
         "/x...         begin exclude file list\n"
         "/b            execute in both directons\n"
         "/t            reset file access time when complete\n");
  if (str)
    printf("%s\n", str);
  printf("\n");
}

void showExecuteError(const char *file, const char *fn, const char *str, const char *log)
{
  UNUSED(str);
  UNUSED(fn);
  UNUSED(file);

  if (optionTest(OPT_VERBOSE))
    statDlgUpdate(log, TRUE, TRUE);
  else
    printf("%s", log);
  execCancelCheck();
}

static const char *prepareText(const char *src, const char *dst, ACTION act)
{
  static char txt[2048];
  if (act == ACTION_DELETE)
  {
    sprintf(txt, "DELETE %s\r\n", src);
  } else
  {
    sprintf(txt, "%-6.6s %s\r\n"
                 "   --> %s\r\n",
                 actionString(act),
                 src,
                 dst);
  }
  return txt;
}

void showExecuteAction(const char *src, const char *dst, ACTION act, BOOL exec, const char *log)
{
  UNUSED(act);
  UNUSED(dst);
  UNUSED(src);

  if (optionTest(OPT_VERBOSE))
    statDlgUpdate(log, exec, FALSE);
  else
    printf("%s", log);
  execCancelCheck();
}

void showCompleteAction(const char *src, const char *dst, ACTION act)
{
  UNUSED(act);
  UNUSED(dst);
  UNUSED(src);

  if (optionTest(OPT_VERBOSE))
    statDlgUpdate(0, FALSE, TRUE);
  execCancelCheck();
}

BOOL queryAction(const char *src, const char *dst, ACTION act)
{
  if (optionTest(OPT_VERBOSE))
    return queryDlgExec(prepareText(src, dst, act), act);
  else
  {
    int key;
    printf("\r%s(y/Y/n/N)? ", prepareText(src, dst, act));
    do
    {
      key = getch();
    } while (strchr("yYnN", key) == 0);
    printf("%c\n", key);
    switch (key)
    {
      case 'Y': 
        key = 'y';
        switch (act)
        {
          case ACTION_ADD:      optionSet(0, OPT_FORCE_ADD); break;
          case ACTION_DELETE:   optionSet(0, OPT_FORCE_DELETE); break;
          case ACTION_COPY:
          case ACTION_UPDATE:   optionSet(0, OPT_FORCE_COPY); break;
          default:
            assert(0);
        }
      case 'y': 
        break;
      case 'N': 
        key = 'n';
        switch (act)
        {
          case ACTION_ADD:      optionSet(0, OPT_NEVER_ADD); break;
          case ACTION_DELETE:   optionSet(0, OPT_NEVER_DELETE); break;
          case ACTION_COPY:
          case ACTION_UPDATE:   optionSet(0, OPT_NEVER_COPY); break;
          default:
            assert(0);
        }
      case 'n': 
        break;
      default:
      assert(0);
    }
    return (key == 'y');
  }
}

void showBegin(void)
{
  if (optionTest(OPT_VERBOSE))
  {
    statDlgCreate();
    statDlgCancelSet();
  }
}

void showComplete(void)
{
  if (optionTest(OPT_VERBOSE))
  {
    statDlgUpdate(0, FALSE, TRUE);
    statDlgDestroy();
  }
}

void showExecuteBegin(void)
{
  if (optionTest(OPT_VERBOSE))
  {
    statDlgCancelReset();
    statDlgUpdateTotalProgress(0,0);
  }
  execCancelCheck();
}

void showExecuteUpdate(void)
{
  if (optionTest(OPT_VERBOSE))
    statDlgUpdate(0, FALSE, FALSE);
  execCancelCheck();
}

void showExecuteComplete(void)
{
  if (optionTest(OPT_VERBOSE))
    statDlgUpdate(0, FALSE, TRUE);
}

void showExecuteActionBegin(const char *src, const char *dst, ACTION act)
{
  UNUSED(act);
  UNUSED(dst);
  UNUSED(src);
}

void showExecuteActionComplete(const char *src, const char *dst, ACTION act)
{
  UNUSED(act);
  UNUSED(dst);
  UNUSED(src);
}

void showScanBegin(const FILETABLE *tbl)
{
  if (optionTest(OPT_VERBOSE))
    scanDlgCreate(tbl->name);
  else
    printf("%s", tbl->name);
}

BOOL showScanUpdate(const FILETABLE *tbl, UINT32 scanCt)
{
  if (optionTest(OPT_VERBOSE))
    return scanDlgUpdate(scanCt, tbl->entryCt);
  else
  {
    printf("\r%s Scanned (%u) Accepted (%u)", tbl->name, scanCt, tbl->entryCt);
    return TRUE;
  }
}

void showScanComplete(const FILETABLE *tbl, UINT32 scanCt)
{
  UNUSED(tbl);
  UNUSED(scanCt);

  if (optionTest(OPT_VERBOSE))
    scanDlgDestroy();
  else
    printf("\n");
}

void showCopyBegin(const char *src, const char *dst, UINT32 amt)
{
  UNUSED(src);
  UNUSED(dst);
  UNUSED(amt);

  if (optionTest(OPT_VERBOSE))
    statDlgUpdateFileProgress(0,0);
  execCancelCheck();
}

void showCopyUpdate(const char *src, const char *dst, UINT32 amt, UINT32 complete)
{
  UNUSED(src);
  UNUSED(dst);

  if (optionTest(OPT_VERBOSE))
  {
    statDlgUpdateFileProgress(amt, complete);
    statDlgUpdateTotalProgress(
      source->stAdd.tSz + source->stCopy.tSz + dest->stAdd.tSz + dest->stCopy.tSz,
      source->stAdd.cSz + source->stCopy.cSz + dest->stAdd.cSz + dest->stCopy.cSz + complete
    );
  }
  execCancelCheck();
}

void showCopyComplete(const char *src, const char *dst, UINT32 amt)
{
  UNUSED(src);
  UNUSED(dst);
  UNUSED(amt);
}

void showProcessBegin(UINT32 amt)
{
  UNUSED(amt);
  if (optionTest(OPT_VERBOSE))
    statDlgUpdateTotalProgress(0,0);
}

void showProcessUpdate(UINT32 amt, UINT32 complete)
{
  if (optionTest(OPT_VERBOSE))
  {
    statDlgUpdateTotalProgress(amt, complete);
    statDlgUpdate(0, FALSE, (amt == complete));
  }
}

void showProcessComplete(UINT32 amt)
{
  UNUSED(amt);
}

void showPostProcessBegin(const char *dir, UINT32 amt)
{
  UNUSED(dir);
  UNUSED(amt);
  if (optionTest(OPT_VERBOSE))
    statDlgUpdateTotalProgress(0,0);
}

void showPostProcessUpdate(const char *dir, UINT32 amt, UINT32 complete)
{
  UNUSED(dir);
  if (optionTest(OPT_VERBOSE))
  {
    statDlgUpdateTotalProgress(amt, complete);
    statDlgUpdate(0, FALSE, (amt == complete));
  }
}

void showPostProcessComplete(const char *dir, UINT32 amt)
{
  UNUSED(dir);
  UNUSED(amt);
}

