#include "..\shared\syncdir.h"
#include <string.h>
#include <dir.h>
#include <dos.h>
#include <io.h>
#include <sys\stat.h>
#include <fcntl.h>
#include <share.h>
#include <assert.h>
#include <time.h>
#include <errno.h>

#include "ui.h"

static UINT32 scanCt;

static BOOL dirScan(FILETABLE *tbl, char path[MAX_PATH])
{
  struct ffblk    fd;
  char           *ptr = path + strlen(path);
  char           *testPtr = path + strlen(tbl->name);
  BOOL            ret = TRUE;
  BOOL            done;
  assert(ptr > path);
  assert(ptr[-1] == '\\');
  strcpy(ptr, "*.*");

  for (done = findfirst(path, &fd, FA_RDONLY | FA_HIDDEN | FA_SYSTEM | FA_DIREC | FA_ARCH);
       !done;
       done = findnext(&fd))
  {
    if (strcmp(fd.ff_name, ".") && strcmp(fd.ff_name, ".."))
    {
      strcpy(ptr, fd.ff_name);
      if ((fd.ff_attrib & FA_DIREC) != 0)
        strcat(ptr, "\\");
      scanCt++;
      if (!optionTest(OPT_QUIET) && !showScanUpdate(tbl, scanCt))
        ret = FALSE;
      else if (isInList(includeList, testPtr) && !isInList(excludeList, testPtr))
      {
        FILEINFO *inf;
        inf = fileInfoAlloc(tbl, path + strlen(tbl->name));
        inf->osfi.modDate = fd.ff_fdate;
        inf->osfi.modTime = fd.ff_ftime;
        inf->isDir = (fd.ff_attrib & FA_DIREC) != 0;
        inf->size = (fileInfoIsDirectory(inf)) ? 0 : fd.ff_fsize;
        fileTableAdd(tbl, inf);
        if (fileInfoIsDirectory(inf) && optionTest(OPT_RECURSE))
          ret = dirScan(tbl, path);
      }
    }
  }
  *ptr = 0;
  return ret;
}

BOOL directoryScan(FILETABLE *tbl)
{
  BOOL ret;
  char path[MAX_PATH];
  strcpy(path, tbl->name);
  if (path[0] && (path[strlen(path)-1] != '\\'))
    strcat(path, "\\");
  scanCt = 0;
  if (!optionTest(OPT_QUIET))
    showScanBegin(tbl);
  ret = dirScan(tbl, path);
  if (!optionTest(OPT_QUIET))
    showScanComplete(tbl, scanCt);
  return ret;
}

static BOOL fileDeleteByPath(const char *path);
static BOOL dirDelete(char path[MAX_PATH])
{
  struct ffblk    fd;
  char           *ptr = path + strlen(path);
  BOOL            ret = TRUE;
  BOOL            done;
  strcpy(ptr, "\\*.*");

  for (done = findfirst(path, &fd, FA_RDONLY | FA_HIDDEN | FA_SYSTEM | FA_DIREC | FA_ARCH);
       !done;
       done = findnext(&fd))
  {
    if (strcmp(fd.ff_name, ".") && strcmp(fd.ff_name, ".."))
    {
      strcpy(ptr+1, fd.ff_name);
      if (fd.ff_attrib & FA_DIREC)
        ret = dirDelete(path);
      else
        ret = fileDeleteByPath(path);
    }
  }
  *ptr = 0;
  return (ret)
    ? (rmdir(path) == 0)
    : FALSE;
}

BOOL directoryDelete(const char *name)
{
  char path[MAX_PATH];
  char *ptr;
  strcpy(path, name);
  ptr = path + strlen(path);
  if ((ptr > path) && (ptr[-1] == '\\'))
    ptr[-1] = 0;
  return dirDelete(path);
}

BOOL directoryCreate(const char *name)
{
  char buf[MAX_PATH];
  char *ptr;

  strcpy(buf, name);
  ptr = buf + strlen(buf);

  if ((ptr > buf) && (ptr[-1] == '\\'))
    ptr[-1] = 0;

  return (mkdir(buf) == 0);
}

static BOOL fileDeleteByPath(const char *f)
{
  if (unlink(f) == 0)
    return TRUE;
  else
  {
    chmod(f, S_IREAD | S_IWRITE);
    return (unlink(f) == 0);
  }
}

BOOL fileDelete(const char *name)
{
  return fileDeleteByPath(name);
}

int fileInfoDateCompare(const FILEINFO *fA, const FILEINFO *fB)
{
  struct tagOS_FILEINFO *a = &fA->osfi;
  struct tagOS_FILEINFO *b = &fB->osfi;

  if (a->modDate < b->modDate)
    return -1;
  else if (a->modDate == b->modDate)
  {
    if (a->modTime < b->modTime)
      return -1;
    else if (a->modTime == b->modTime)
      return 0;
    else
      return 1;
  } else
   return 1;
}

int fileInfoNameCompare(const FILEINFO *a, const FILEINFO *b, BOOL partial)
{
  return (partial)
    ? strnicmp(a->name, b->name, strlen(a->name))
    : stricmp(a->name, b->name);
}

/*
 * 6 July 98: changed code to use findfirst()
 *            in an attempt to circumvent a novell error
 */
BOOL fileAttrGet(const char *name, FILEATTR *sts)
{
  BOOL ret = FALSE;
#if 0
  int h = open(name, O_RDONLY | O_BINARY);

  if (h != -1)
  {
    ret = getftime(h, &sts->mod) == 0;
    close(h);
    sts->attr = _chmod(name, 0);
  }
#else
  struct ffblk ffblk;
  ret = (findfirst(name, &ffblk, FA_RDONLY | FA_HIDDEN | FA_SYSTEM | FA_DIREC | FA_ARCH) == 0);
  if (ret)
  {
    sts->attr = ffblk.ff_attrib;
    sts->mod  = *(struct ftime *) &ffblk.ff_ftime;
  }
#endif
  return ret;
}

BOOL fileAttrSet(const char *dst, const FILEATTR *sts)
{
  int h = open(dst, O_RDWR | O_BINARY);
  BOOL ret = FALSE;
  if (h != -1)
  {
    ret = setftime(h, &sts->mod) == 0;
    close(h);
    _chmod(dst, 1, sts->attr);
  }
  return ret;
}

FILETABLE *fileTableInit(const char *dir, BOOL create)
{
  char path[MAX_PATH];
  struct stat statBuf;

  if (dir)
    strcpy(path, dir);
  else
    path[0] = 0;

  if (path[0] == 0)
    strcpy(path, ".");
  else if (strcmp(path+1, ":") == 0)
    strcat(path, ".");
  else
  {
    char *ptr;
    for (ptr = path + strlen(path) - 1; (ptr >= path) && (*ptr == '\\'); ptr--)
      ;
    ptr[1] = 0;
  }
  if (strcmp(path+1, ":") == 0)
    return fileTableAlloc(path);
  else if (stat(path, &statBuf) == -1) 
  {
    /*
     * does not exist, if create is FALSE, ignore!
     */
    if (!create)
      return 0;
    else
    {
      /*
       * attempt to create
       */
      char *ptr;
      for (ptr = strchr(path, '\\'); ptr; ptr = strchr(ptr+1, '\\'))
      {
        *ptr = 0;
        mkdir(path);
        *ptr = '\\';
      }
      return (mkdir(path) == -1)
        ? 0
        : fileTableAlloc(path);
    }
  } else if (!(statBuf.st_mode & S_IFDIR))
    return 0; /* exists but is not a directory */
  else
  {
    if (strcmp(path+1, ":\\") == 0)
      path[2] = 0;
    return fileTableAlloc(path); /* success! */
  }
}


FILEHANDLE fileOpen(const char *name)
{
   return sopen(name, O_BINARY | O_RDONLY, SH_DENYWR, 0);
}

FILEHANDLE fileCreate(const char *name)
{
  return  sopen(name, O_BINARY | O_WRONLY | O_CREAT, SH_DENYRW, S_IREAD | S_IWRITE);
}

UINT32     fileLength(FILEHANDLE f)
{
  return filelength(f);
}

UINT32     fileRead(FILEHANDLE f, void *dst, UINT32 len)
{
  return read(f, dst, len);
}

UINT32     fileWrite(FILEHANDLE f, const void *src, UINT32 len)
{
  return write(f, src, len);
}

BOOL       fileClose(FILEHANDLE f)
{
  return (close(f) == 0);
}

BOOL       fileHandleIsValid(FILEHANDLE f)
{
  return (f >= 0);
}

typedef struct
{
  FILE *file;
  char  name[MAX_PATH];
} EXT_FILE;

/*
 * shan't need more than two of these
 */
static EXT_FILE tempFiles[2];

FILE *fileTempCreate(void)
{
  EXT_FILE *extFile;
  if (tempFiles[0].file)
  {
    if (tempFiles[1].file)
    {
      extFile = 0;
    } else
      extFile = tempFiles + 1;
  } else
    extFile = tempFiles;

  if (extFile)
  {
    /*
     * find an appropriate file name & open it for ''w+b''
     */
    char *name = extFile->name;
    char *tmp = getenv("TMP");
    long  now = (long) time(0);
    int    ii;
    if (!tmp)
    {
      tmp = getenv("TEMP");
      if (!tmp)
        tmp = ".\\";
    }
    strcpy(name, tmp);
    if (name[0] && (name[strlen(name)-1] != '\\'))
      strcat(name, "\\");
    tmp = name + strlen(name);
    for (ii = 0, extFile->file = 0; !extFile->file && (ii < 100); ii++) /* don't try more than 100 times */
    {
      ultoa(now+ii, tmp, 16);
      if ((access(name, 0) == -1) && (errno == ENOENT))
        extFile->file = fopen(name, "w+b");
    }
  }
  return extFile->file;
}

BOOL fileTempDestroy(FILE *f)
{
  EXT_FILE *extFile;
  if (tempFiles[0].file == f)
  {
    extFile = tempFiles + 0;
  } else if (tempFiles[1].file == f)
  {
    extFile = tempFiles + 1;
  } else
    extFile = 0;
  fclose(extFile->file);
  fileDelete(extFile->name);
  return TRUE;
}
