;*************************  DIRS.ASM  ************************************
;
;	DIRS.ASM version 1.1b
;	
;	Usage:
;		DIRS
;	Purpose: This program will list the directories on a stack
;		created with the PUSHD v. 1.2 command.  Directories are
;		listed in order from the top of the stack to the
;		bottom.
;	Preconditions: 
;		1) PUSHD must be hooked to interrupt 13.
;		2) PUSHD must have the same commands from beginning
;		 to after definition of push6d, so that it knows how
;		 to access the resident code of PUSHD.  (This includes
;		 the fact that there are 6 locations for directory storage
;		 which are 67 bytes in size.)
;		3) PUSHD must have the signature "PUSHD VERSION 1.1".
;		4) PUSHD must look for 7788 in ax and 7789 in bx for
;		 a call to int 13.
;		5) PUSHD must put the value of 7789 into ax and 7788
;		 into bx upon calling int 13 by DIRS, if PUSHD is installed.
;		6) PUSHD will set the data segment to be equal to the data
;		 segment that PUSHD used to install itself.
;		7) ds:[nextpush] (ds of PUSHD installation) must hold
;		 the location of the next empty directory stack location.
;	Postconditions: 
;		1) The list of directories on the stack will be	printed out on
;		 the standard output OR
;		2) An appropiate error message will be printed out on standard
;		 error.
;		3) An error code will be generated.
;	Error codes:
;		0) Successful termination.
;	      254) No Directories on the stack.
;	      255) PUSHD is not installed.
;	Version changes:
;		1.1b July 21, 1990
;		 Removed commented-out commands from Toad Hall version.
;		1.1a July 19, 1990
;		 Toad Hall tweaking (much thanks to David Kirshbaum).
;	Future Enhancements:
;		1) Make DIRS a .EXE file.
;		2) Add a help option, ?, from the command line.
;
;	Created by:
;	  (from ideas based in UNIX and from PC Magazine's pushdir/popdir)
;		William P. Sarra
;			CIS:71041,347
;			arpa: sarra@TOPAZ.RUTGERS.EDU
;	uucp: ...{ames,cbosgd, harvard, moss}!rutgers!topaz.rutgers.edu!sarra
;
;*****************************************************************************

MAIN    group   CSEG
CSEG    segment public  para    'code'
        assume  CS:MAIN,DS:MAIN,ES:MAIN,SS:MAIN

org     80h
cmd_line        label   byte

org     100h            ;.COM file

Begin:  jmp     Start   ;program starts here

signature       db      'PUSHD VERSION 1.1'
;SIG_LEN        equ    $-signature

savedint13      dd     ?        ;used to be identical to pushd

nextpush        dw     offset MAIN:push1d     ;next place to save a dir

push1d  db     67 dup (0)       ;directory storage
push2d  db     67 dup (0)
push3d  db     67 dup (0)
push4d  db     67 dup (0)
push5d  db     67 dup (0)
push6d  db     67 dup (0)

;up to here must be EXACTLY identical in PUSHD, POPD and DIRS.

;****************************************************************
;
;       Data Section.
;
;****************************************************************

notinstalled1   db      'PUSHD must be installed before DIRS'
                db      ' will do anything.',13,10
NOTINSTALLED_LN equ     $-notinstalled1

emptymsg        db         'No directories on the stack.'
cr_lf           db      13,10   ;share this                     v1.2
EMPTYMSG_LEN        equ    $-emptymsg

CR_LF_LN        equ     $-cr_lf

;***************************************************************
;
;       Code Starts.
;
;***************************************************************

Start:

        ;is PUSHD already installed ?

        mov     ax,7788h                        ;signature request
        mov     bx,7789h                        ;signature request
        mov     si,offset MAIN:signature        ;point DS:si to signature
        int     13h                             ;is it installed ?

        assume  DS:nothing

        cmp     bx,7788h                ;were ax and bx switched ?
        jne     NotInstalled            ;no
        cmp     ax,7789h                ;were ax and bx switched ?
        jz      IsInstalled             ;yes, continue                  v1.2

NotInstalled:

        ;here PUSHD was not previously installed so POPD can't do anything
        ;useful so we just terminate with an error message.

        mov     dx,offset MAIN:notinstalled1    ;error message
        mov     cx,NOTINSTALLED_LN
        mov     al,0FFH                 ;ERRORLEVEL             v1.2
        jmp     Msg_Term                ;display, terminate     v1.2

IsInstalled:

        ASSUME  DS:CSEG                 ;TSR's

        ;get address of previously saved directory

        mov     dx,DS:[nextpush]                ;get next location      v1.2
        cmp     dx,offset MAIN:push1d           ;check for empty stack  v1.2
        jnz     NotEmpty                        ;nope, continue         v1.2

        ;directory stack is empty -- print message and quit

        mov  dx,offset MAIN:emptymsg            ;error message
        mov  cx,EMPTYMSG_LEN
        mov     al,0FEH                 ;ERRORLEVEL             v1.2
        jmp     short Msg_Term          ;display, terminate     v1.2

NotEmpty:

;v1.2   Pick up some handy "constants"
        mov     si,CS                   ;our CSEG               v1.2
        mov     di,DS                   ;TSR's CSEG             v1.2

        mov     bp,offset MAIN:cr_lf    ;handy constant         v1.2
        sub     dx,67                   ;get last pushed dir    v1.2

NotEmpty_Lup:

        ;handle the printing out of the stored directory.

        ASSUME  DS:CSEG         ;TSR's

        mov     cx,67           ;length of directory
        mov     bx,1            ;write on stdout
        mov     ah,40h          ;write to file/device
        int     21h

        sub     dx,cx           ;- 67                           v1.2

        ;now print out a cr/lf pair at the end of the directory

        mov     DS,si                   ;our CSEG                       v1.2
        ASSUME  DS:MAIN                 ;our CSEG

        xchg    dx,bp                   ;DS:DX=cr_lf, BP=saved DX       v1.2
        mov     cx,CR_LF_LN
        mov     bx,1                    ;stdout
        mov     ah,40h                  ;write to file/device
        int     21h

        mov     DS,di                   ;TSR's CSEG                     v1.2
        ASSUME  DS:CSEG                 ;TSR's

        xchg    dx,bp                   ;BP=cr_lf addr, DX=current dir addr v1.2

        ;get next directory storage location and make sure it is
        ;within the range of stored locations

        cmp     dx,offset MAIN:push1d   ;hit directory stack top yet?   v1.2
        jge     NotEmpty_Lup            ;not yet, keep going            v1.2

        mov     ax,4c00h        ;terminate upon successful completion
        int     21h

;*************************************************************************
;
;	PROCEDURE:	Msg_Term
;
;	Purpose: This procedure will handle the printing of error messages
;		and termination with the correct errorlevel.
;	Preconditions: 
;		DX = error message address.
;		CX = error message length.
;		AL = ERRORLEVEL.
;	Postconditions: 
;		The program will be terminated with the appropriate
;		 error message printed on standard error and with the
;		 the errorlevel stored in al.
;
;***************************************************************************

Msg_Term        PROC    NEAR
;v1.2 Common code

        push    CS
        pop     DS                      ;insure DS=CSEG

        push    ax                      ;save AL errorlevel
        mov     bx,2                    ;stderr
        mov     ah,40h                  ;dos function number
        int     21h                     ;show message
        pop     ax
        mov     ah,4CH                  ;terminate process
        int     21h

Msg_Term        ENDP

CSEG    ENDS
        END     Begin
