/************************************************************************/
/*									*/
/*	DV-GLUE		DESQview and DESQview/X Function Library	*/
/*			(c) Copyright 1992 Ralf Brown			*/
/*			All Rights Reserved.				*/
/*									*/
/*	File UIMENU.C	<description>					*/
/*									*/
/************************************************************************/
/* LastEdit:  3/28/93							*/

#include <mem.h>
#include <string.h>
#include "dvglue.h"
#include "dvstream.h"
#include "dvgui.h"

/*======================================================================*/

#define PRIVATE(type) static type near pascal
#define ACTIVE_MENU_ITEM(item) (((item) & M_TYPE_MASK) >= M_FLAG)

#define BOLD_BIT 8

/*======================================================*/
/*======================================================*/

typedef struct _window_list
   {
   struct _window_list *next, *prev ;
   OBJECT window ;
   int	  submenu_type ;
   } WINDOW_LIST ;
   
/*======================================================*/
/*======================================================*/

static BYTE setup_stream[] =
   {
   S_WINDOW(7), 
   WS_NEWWIN(0,0),	/* will fill in size later */
   WS_HIDDEN,           /* hide until we finish our setup */
   WS_NOFRAME,          /* we don't want a frame */
   WS_LOGATTR,          /* we want logical attributes */
   WS_PROGCOLOR,	/* tell DV not to mess with the attributes */
   S_MANAGER(4),
   MS_ALTFIELDPROC,
   MS_ALLOWREVATTR,
   MS_DISALLOW | DV_HSIZE,
   MS_DISALLOW | DV_VSIZE,
   S_WINDOW(47),
   WS_ATTRIB(0xF0,0,0,3),7,15,7,  /* fill in actual attributes later */
   WS_WRITEATTR,        /* change attributes when writing */
   WS_NOCTRLCHAR,	/* don't process control characters */
   WS_WINSIZE(0,0),	/* will fill in size later */
   WS_WINPOS(0,0),      /* will fill in window position later */
   WS_SETCOLOR(1),      /* use normal attribute */
   WS_CLEAR,            /* and clear window to that color */
   WS_CURSPOS(0,1),	/* home cursor */
   WS_MANYCHAR(0,223),  /* write top edge of border, fill in count later */
   WS_CURSPOS(0,1),	/* move to bottom edge (fill in row later) */
   WS_MANYCHAR(0,220),	/* write bottom edge, fill in count later */
   WS_CURSPOS(0,0),	/* back to top left corner */
   WS_SETCOLOR(3),      /* change to border color */
   WS_REPEAT(0),        /* will fill in count later */
   WS_CHARS(1),222,     /* write left edge of border */
   WS_SETCURSCOL(0),    /* fill in later, moves to right edge */
   WS_CHARS(1),221,     /* write right edge of border */
   WS_DOREPEAT,
   WS_SETCOLOR(9),      /* reverse video for title */
   WS_UPDATE,
   S_MANAGER(8),
   MS_CURRFLDPOS(0,0),
   MS_DISALLOW | DV_HMOVE,
   MS_DISALLOW | DV_VMOVE,
   MS_WINTOPSYS, MS_FLDMARKER(0xAF)  /* default field marker is  */
   } ;

/*======================================================*/
/*======================================================*/

static int pascal show_menu(DVMENU *menu_to_display,int org_row,int org_col,
			    WINDOW_LIST *parent,int *result_code)
{
   OBJECT window, kbd ;
   int height, width, size, status, action, want_exit ;
   int row, col, two_keys, type, cur_row ;
   int tmp, phys_height, phys_width ;
   int num_fields = 0 ;
   char *menu_values ;
   DVMENU menu = *menu_to_display ;
   DVMENU_ITEM *menu_item ;
   DVMENU_ITEM *item ;
   WINDOW_LIST winlist, *winptr ;
   /**/
   BYTE *stream_start, *stream ;

   *result_code = MA_EXIT ;

   /* first, call the user's pre- function */
   if (menu.before)
      (*menu.before)(menu_to_display) ;

/* find out whether we'll need one space or two for the menu's keystrokes, */
/*  how many fields are on the menu, and how big the menu window will be */

   two_keys = FALSE ;
   height = 4 ;  /* top & bottom edges + title + key echo area */
   width = 0 ;
   for (menu_item = menu.items ; menu_item->type != M_END ; menu_item++)
      if (ACTIVE_MENU_ITEM(menu_item->type))
	 {
	 num_fields++ ;
	 if ((menu_item->type & M_HOT) == 0 &&
	     menu_item->key1 != 0 && menu_item->key2 != 0)
	    two_keys = TRUE ;
	 }
   for (menu_item = menu.items ; menu_item->type != M_END ; menu_item++)
      {
#if 0 /* don't need following check, since all bits currently in use */
      if (menu_item->type & ~(M_TYPE_MASK|M_FLAG_MASK)) /* any unknown bits set? */
	 return ME_BADITEM ;
#endif
      type = (menu_item->type & M_TYPE_MASK) ;
      if (menu_item->type & M_HOT)
	 continue ;		/* nothing on menu, merely a field table entry */
      switch (type)
	 {
	 case M_IGNORE:
	    /* do nothing */
	    break ; 
	 case M_SEP:
	    height++ ;
	    break ;
	 case M_TEXT:
	 case M_CENTER:
	    if (menu_item->entry && ((tmp = strlen(menu_item->entry)) > 0))
	       {
	       if (tmp > 255)
		  return ME_BADITEM ;
	       else if (tmp > width)
		  width = tmp ;
	       }
	    height++ ;
	    break ;
	 case M_FLAG:
	 case M_FUNC:
	 case M_FUNCMENU:
	 case M_SUBMENU:
	 case M_SUBMENUR:
	 case M_QUIT:
	    if (menu_item->entry == NULL)
	       return ME_BADITEM ;	/* bad entry */
	    tmp = strlen(menu_item->entry) ;
	    if (tmp == 0 || tmp > 255)
	       return ME_BADITEM ;
	    if (menu_item->type & M_KEY)
	       {
	       if (strchr(menu_item->entry,' ') == NULL)
		  return ME_BADITEM ;
	       if (tmp > width)
		  width = tmp ;
	       }
	    else
	       {
	       if (tmp + 3 + two_keys > width)
		  width = tmp + 3 + two_keys ;
	       }
	    height++ ;
	    break ;
	 default:
	    return ME_BADITEM ;
	 }
      }
   if ((tmp = strlen(menu.title)) > width)
      width = tmp ;
   width += 4 ;  /* left & right edge, blanks just inside edges */

/* perform some simple error checks before proceeding */

   phys_height = DVphys_screen_height() ;
   phys_width = DVphys_screen_width() ;
   if ((height > phys_height || width > phys_width) && !menu.allow_oversize)
      return ME_TOOBIG ;

/* determine upper left corner of menu window */

   row = org_row + menu.row ;
   if (row < 0)
      {
      if (org_row > 0 || parent)
	 row = 0 ;
      else
	 row = phys_height - height + row + 1 ;
      if (row < 0)
         row = 0 ;
      }
   else
      {
      if (row + height > phys_height)
         row = phys_height - height ;
      }
   col = org_col + menu.col ;
   if (col < 0)
      {
      if (org_col > 0 || parent)
	 col = 0 ;
      else
	 col = phys_width - width + col + 1 ;
      if (col < 0)
         col = 0 ;
      }
   else
      {
      if (col + width > phys_width)
         col = phys_width - width ;
      }

   if ((stream = (BYTE *)malloc(sizeof(setup_stream))) == NULL)
      return ME_NOMEM ;

/* start building the stream */

   memcpy( stream, setup_stream, sizeof( setup_stream ) ) ;
   stream[5] = height ;		/* fix up WS_NEWWIN */
   stream[6] = width ;
   if (menu.text_color)
      {
      stream[26] = menu.text_color ;
      stream[28] = menu.text_color & 0x0F ;  /* force black background on border */
      }
   if (menu.select_color)
      stream[27] = menu.select_color ;
   else
      stream[27] = (menu.text_color) ? (menu.text_color | BOLD_BIT) : 15 ;
   stream[32] = height ;	/* fix up WS_WINSIZE */
   stream[33] = width ;
   stream[35] = row ;		/* fix up WS_WINPOS */
   stream[36] = col ;
   stream[44] = width-2 ;	/* fix up WS_MANYCHAR(0,223) */
   stream[47] = height-1 ;	/* fix up second WS_CURSPOS(0,1) */
   stream[50] = width-2 ;	/* fix up WS_MANYCHAR(0,220) */
   stream[58] = height ;	/* fix up WS_REPEAT */
   stream[62] = width-1 ;	/* fix up WS_SETCURSCOL */
   if (menu.allow_move)
      {
      stream[sizeof(setup_stream)-5] &= ~MS_DISALLOW ;
      stream[sizeof(setup_stream)-4] &= ~MS_DISALLOW ;
      }
   if (menu.marker)
      stream[sizeof(setup_stream)-1] = menu.marker ;

   /* create and initialize the window for our menu */
   window = DVwin_write(NIL,(char *)stream,sizeof(setup_stream)) ;
   free(stream) ;		/* don't need this stream anymore */
   if (window == NIL)
      {
      if (menu.after)
	 (*menu.after)(menu_to_display) ;
      return ME_RESOURCE ;
      }
   tmp = strlen(menu.title) ;
   DVwin_cursor(window,1,(width-tmp)/2) ;
   DVwin_write(window,menu.title,tmp) ;
   DVwin_attr(window,1) ;	/* set color back to normal */
   DVwin_title(window,menu.title) ;

   /* now display the actual menu */
   cur_row = 2 ;	/* last row of menu header */
   for (menu_item = menu.items ; menu_item->type != M_END ; menu_item++)
      {
      type = (menu_item->type & M_TYPE_MASK) ;
      switch (type)
	 {
	 case M_IGNORE:
	    /* do nothing */
	    break ;
	 case M_FLAG:
	    if (menu_item->arg && menu_item->selected)
	       *((int *)(menu_item->arg)) = TRUE ;
	    if (menu_item->selected || (menu_item->arg && *((int *)(menu_item->arg))))
	       DVwin_attr(window,2) ;	/* mark as selected */
	    /* fall through */
	 case M_FUNC:
	 case M_FUNCMENU:
	 case M_SUBMENU:
	 case M_SUBMENUR:
	 case M_QUIT:
	    {
	    char *keyname ;
	    int namelen ;

	    if (menu_item->type & M_HOT)
	       break ; /* do nothing, as only a field table entry */
	    DVwin_cursor(window,++cur_row,2) ;
	    if (menu_item->type & M_KEY)
	       {
	       keyname = strrchr( menu_item->entry, ' ' ) + 1 ;
	       namelen = strlen(keyname) ;
	       tmp = (int)(keyname - menu_item->entry) ;
	       }
	    else
	       tmp = strlen(menu_item->entry) ;
	    DVwin_write(window,menu_item->entry,tmp) ;
	    /* skip over to end of line */
	    if (menu_item->type & M_KEY)
	       {
	       DVwin_cursor(window,cur_row,width-2-namelen) ;
	       DVwin_write(window,keyname,namelen) ;
	       }
	    else
	       {
	       DVwin_cursor(window,cur_row,width-3-two_keys) ;
	       DVputchar(window,(menu_item->key1) ? menu_item->key1 : ' ',
		                1) ;
	       if (two_keys && menu_item->key2)
		  DVputchar(window,menu_item->key2,1) ;
	       }
	    }
	    break ;
	 case M_TEXT:
         case M_CENTER:
	    if (menu_item->entry && *menu_item->entry)
	       {
	       tmp = strlen(menu_item->entry) ;
	       DVwin_cursor(window,++cur_row,
		  (type==M_CENTER) ? ((width-tmp)/2) : 2) ;
	       if (menu_item->type & M_HI)
		  DVwin_attr(window,2) ; /* change to highlighted */
	       DVwin_write(window,menu_item->entry,tmp) ;
	       }
	    break ;
	 case M_SEP:
	    DVwin_cursor(window,++cur_row,1) ;
	    if (menu_item->type & M_HI)
	       DVwin_attr(window,2) ; /* change to highlighted */
	    DVwin_repchar(window,menu_item->key1,width-2) ;
	    break ;
	 }
      DVwin_attr(window,1) ;
      }
   size = 9 + sizeof(FT_HEADER) + (num_fields+two_keys)*sizeof(FT_ENTRY) ;
   if ((stream_start = (BYTE *)malloc(size+num_fields+1)) == NULL)
      {
      DVwin_free(window) ;
      return ME_NOMEM ;
      }
   menu_values = stream_start+size ;
   stream = stream_start ;
   *((int *)stream)++ = 0x001B ;  /* start of window stream */
   *((int *)stream)++ = size-4 ;
   *((int *)stream)++ = 0x18E5 ;
   *stream++ = 0xFF ;
   *stream++ = num_fields+two_keys ;
   tmp = F_READARRAY | F_B2STATUS ;
   if (menu.allow_kbd)
      tmp |= F_ALLOWKBD ;
   *stream++ = tmp ;
   *((int *)stream)++ = 0x0000 ;
   *((int *)stream)++ = 0x0209 ;
   cur_row = 3 ;
   if (two_keys)
      {
      *stream++ = 2 ;
      *stream++ = (width+1)/2-1 ;
      *stream++ = 2 ;
      *stream++ = (width+1)/2-1 ;
      *((int *)stream)++ = 0x0040 ;
      *((int *)stream)++ = 0x0000 ;
      }
   for (menu_item = menu.items ; menu_item->type != M_END ; menu_item++)
      {
      type = (menu_item->type & M_TYPE_MASK) ;
      if (menu_item->type & M_HOT)
	 {
	 *((int *)stream)++ = 0x0101 ;
	 *((int *)stream)++ = 0x0000 ;
	 *stream++ = 0xC0 ;
	 *stream++ = menu_item->key1 ;
	 *stream++ = 1 ;
	 *stream++ = menu_item->key2 ;
	 }
      else if (ACTIVE_MENU_ITEM(menu_item->type))
         {
         *stream++ = cur_row ;
         *stream++ = 1 ;
         *stream++ = cur_row ;
         *stream++ = width-2 ;
         *stream++ = (menu_item->selected) ? 0xC0 : 0xC0 | F_SELECTED ;
         *stream++ = menu_item->key1 ;
         *stream++ = 1 ;
         *stream++ = menu_item->key2 ;
         }
      if (type != M_IGNORE && (menu_item->type & M_HOT) == 0)
         cur_row++ ;
      }
   *((int *)stream) = 0x01F4 ;  /* position to field 1 */
   
   /* create the field table for the menu window */
   DVwin_write(window,(char *)stream_start,size) ;

   /* create a keyboard for use by the menu */
   kbd = DVkbd_new() ;
   if (kbd == NULL)
      {
      DVwin_free(window) ;
      free(stream_start) ;
      return ME_RESOURCE ;
      }
   winlist.window = window ;
   winlist.next = parent ;
   winlist.prev = NULL ;
   if (parent)
      {
      parent->prev = &winlist ;
      /* attach to parent menu, if any, so that both move in unison */
      if (_dvversion >= 0x021A)  /* v2.26+ ? */
	 {
	 int oldlevel = DVapilevel(0x021A) ;
	 
	 DVwin_connect(window,parent->window) ;
	 DVapilevel(oldlevel) ;
	 }
      }
   if (menu.reset)
      DVfld_reset(window) ;
   /* run through the menu until the result is a request to exit */
   do {
      int i, j, k, type ;
      
      /* connect keyboard to menu window and go into field mode */
      DVkbd_open(kbd,window) ;
      DVkbd_setflags(kbd,KBD_FIELDMODE) ;
      /* process the menu input and get the result */
      DVkbd_read(kbd,menu_values,num_fields+1) ;
      status = DVkbd_status(kbd) ;
      /* disconnect keyboard from menu window */
      DVkbd_clrflags(kbd,KBD_FIELDMODE) ;
      DVkbd_close(kbd) ;
      want_exit = 0 ;
      if (status == 2) /* right button/PgUp/Esc pressed? */
	 {
	 want_exit = MA_EXIT ;
	 break ;
	 }
      if (two_keys)
	 DVfld_clear(window,1) ;
      for (i = two_keys, j = 0 ; i < num_fields+two_keys ; i++)
	 {
	 action = MA_DONE ;	/* default action to take */
	 while ((type = (menu.items[j].type & M_TYPE_MASK)) < M_FLAG && 
	        type != M_END)
	    j++ ;
	 item = &menu.items[j] ;
	 if (menu_values[i-two_keys] == 'Y')
	    {
	    if (type != M_FLAG) /* deselect all fields except flag toggles */
	       DVfld_type(window,i+1,(DVqry_type(window,i+1) & ~ F_SELECTED)) ;
	    switch (type)
	       {
	       case M_FLAG:
		  if (item->arg)
		     *((int *)(item->arg)) = TRUE ;
		  break ;
	       case M_FUNC:
		  if (item->func)
		     {
		     for (parent = &winlist ; parent ; parent = parent->next)
			DVwin_hide(parent->window) ;
		     action = (*item->func)(window,status,menu_values,item->arg) ;
		     for (winptr = &winlist ; winptr->next ; winptr = winptr->next)
			;
		     while (winptr)
			{
			DVwin_top(winptr->window) ;
			winptr = winptr->prev ;
			}
		     for (parent = winlist.next ; parent ; parent = parent->next)
			if (parent->submenu_type == M_SUBMENUR)
			   break ;
			else
			   DVwin_unhide(parent->window) ;
		     if ((menu.items[j].type & M_EXIT) == 0 || (action & MA_EXIT))
			DVwin_unhide(window) ;
		     }
	          break ;
	       case M_FUNCMENU:
		  if (item->func)
		     action = (*item->func)(window,status,menu_values,item->arg) ;
		  break ;
	       case M_SUBMENU:
	       case M_SUBMENUR:
		  if (item->arg)
		     {
		     DVqry_position(window,&row,&col) ;
		     if (type == M_SUBMENUR)
			{
			row -= ((DVMENU *)item->arg)->row ;
			col -= ((DVMENU *)item->arg)->col ;
			DVwin_hide(window) ;
			}
		     winlist.submenu_type = type ;
		     show_menu((DVMENU *)item->arg,row,col,&winlist,result_code) ;
		     if (*result_code == MA_ABORT)
			action = MA_ABORT ;
		     if (type == M_SUBMENUR)
			DVwin_unhide(window) ;
		     }
		  else
		     action = MA_DONE ;
	          break ;
	       case M_QUIT:
		  action = MA_EXIT ;
	          break ;
	       }
	    }
	 else
	    if (type == M_FLAG && item->arg)
	       {
	       *((int *)(item->arg)) = FALSE ;
	       }
	 if (item->type & M_EXIT)
	    action |= MA_EXIT ;
	 if (action & MA_BEEP)
	    DVsound(1000,4) ;	/* same note DV uses */
	 if (action & MA_RESET)
	    DVfld_reset(window) ;
	 if (action & MA_SELECT)
	    {
	    for (k = 0 ; k < num_fields ; k++)
	       DVfld_type(window,k+1,(DVqry_type(window,k+1) & ~ F_SELECTED) |
				     ((menu_values[k] == 'Y') ? F_SELECTED : 0)) ;
	    }
	 want_exit |= (action & (MA_EXIT|MA_ABORT)) ;
	 j++ ;
	 }      
      DVwin_redraw(window) ;
      } while (want_exit == 0) ;
   DVkbd_setflags(NIL,KBD_ACTIVE) ;
   /* update menu structure as needed */
   if (menu.allow_move)
      {
      DVqry_position(window,&menu_to_display->row,&menu_to_display->col) ;
      }
   /* call the user's post- function */
   if (menu.after)
      (*menu.after)(menu_to_display) ;
   /* and finally clean up and return the results */
   DVwin_free(window) ;
   free(stream_start) ;
   DVkbd_free(kbd) ;
   *result_code = want_exit ;
   if (winlist.next)
      winlist.next->prev = NULL ;
   return status ;
}

/*======================================================*/
/*======================================================*/

int pascal UImenu(DVMENU *menu)
{
   int result_code ;
   int status ;
   
   status = show_menu(menu,0,0,NULL,&result_code) ;
   return status ;
}
   
/* End of file UIMENU.C */
