;************************************************************************
;*									*
;*	DV-GLUE		DESQview and DESQview/X Function Library	*
;*			(c) Copyright 1993 Ralf Brown			*
;*			All Rights Reserved.				*
;*									*
;*	File TMPALLOC.ASM	Temporary memory allocation, freed	*
;*				before calling function exits		*
;*									*
;************************************************************************
;LastEdit: 1/13/93

	INCLUDE API.INC
	Header@

MAX_STACK_ALLOC equ 64	; allocate from stack up to this size

;========================================================================

CSeg@

public $DVG$TMPALLOC
public $DVG$TMPFREE
public $DVG$TMPFREE_ESDI

; entry: AX = number of bytes
; exit:  [DX:]AX -> allocated memory
$DVG$TMPALLOC proc near
	cmp	ax,MAX_STACK_ALLOC
	ja	alloc_heap
IF LDATA
	mov	cx,sp			; ensure at least 256 bytes will be
	sub	cx,256			;   available on stack after allocating
	cmp	ax,cx			;   space
	ja	alloc_heap		;   (doesn't work in small-data models)
ENDIF
	pop	bx			; grab return address
	inc	ax			; round size up to even amount
	inc	ax
	and	al,0FEh
	sub	sp,ax			; allocate stack space
IF LDATA
	mov	dx,ss
ENDIF
	mov	ax,sp
	or	ax,ax			; clear ZF
	jmp	bx			; return to caller

alloc_heap:
	ALLOC_MEM			; allocate AX bytes
	DPTR_NULL dx,ax,bx
	ret
$DVG$TMPALLOC endp

; entry:  [ES:]DI -> allocated memory
;	  BP -> caller's stack frame
$DVG$TMPFREE_ESDI proc near
IF LDATA
	mov	dx,es
ENDIF
	mov	ax,di
	;; fall through to $DVG$TMPFREE ;;
$DVG$TMPFREE_ESDI endp

; entry:  [DX:]AX -> allocated memory
;	  BP -> caller's stack frame
$DVG$TMPFREE proc near
	; If pointer is between SS:SP and SS:BP, it was allocated from the
	; stack.  In that case, do nothing, as the caller's exit code will
	; automatically free the memory
IF LDATA
	mov	bx,ss
	cmp	bx,dx
	jne	free_heap		; using stack segment?
ENDIF
	cmp	ax,sp
	jb	free_heap
	cmp	ax,bp
	jbe	free_done
free_heap:
	FREE_MEM dx,ax
free_done:
	ret
$DVG$TMPFREE endp

CSegEnd@

	END
