;************************************************************************
;*									*
;*	DV-GLUE		DESQview and DESQview/X Function Library	*
;*			(c) Copyright 1992 Ralf Brown			*
;*			All Rights Reserved.				*
;*									*
;*	File QOS.ASM			<Description>			*
;*									*
;************************************************************************
;LastEdit: 12/20/92

	INCLUDE	RULES.ASI
	Header@

;========================================================================

DSeg@
PubSym@ QOS_MULTIPLEX_NUMBER,<db 0D2h>,__PASCAL__
initialized db 0
DSegEnd@

;========================================================================

CSeg@

;------------------------------------------------------------------------
; determine whether a QOS program is present on multiplex number AH

check_QOS proc near
	ASSUME	DS:DGROUP
	push	es
	push	ds
	push	bp
	push	di
	push	si
	push	dx
	push	cx
	push	bx
	push	ax
	mov	al,0
	mov	bx,5144h		; QD
	mov	cx,4D45h		; ME
	mov	dx,4D30h		; M0
	int	2Fh
	cmp	al,0FFh
	jne	check_QOS_no
	cmp	bx,4D45h		; ME
	jne	check_QOS_no
	cmp	cx,4D44h		; MD
	jne	check_QOS_no
	cmp	dx,5652h		; VR
	jne	check_QOS_no
check_QOS_yes:
	clc
	jmp short check_QOS_done

check_QOS_no:
	cmp	al,0
	jne	check_QOS_none
	cmp	QOS_multiplex_number,0
	jne	check_QOS_none
	pop	ax			; restore AX
	push	ax
	mov	QOS_multiplex_number,ah
check_QOS_none:
	stc
check_QOS_done:
	pop	ax
	pop	bx
	pop	cx
	pop	dx
	pop	si
	pop	di
	pop	bp
	pop	ds
	pop	es
	ret
check_QOS endp

;------------------------------------------------------------------------

PubProc@ QOSINIT,__PASCAL__
	SET_DS
	mov	al,1
	xchg	al,initialized
	or	al,al
	jnz	init_done
find_QOS:
	mov	ah,0D2h
find_QOS_loop:
	call	check_QOS
	jnc	found_QOS
	inc	ah
	cmp	ah,0D2h 		; if we make it back to DEh, there is
	je	no_QOS			;   no prior QOS program loaded
	or	ah,ah
	jnz	find_QOS_loop
	mov	ah,0C0h
	jmp	find_QOS_loop

no_QOS:
	mov	QOS_multiplex_number@,0
found_QOS:

init_done:
	mov	al,QOS_multiplex_number@
	mov	ah,0
	or	ax,ax
	RESTORE_DS
	ret
EndProc@ QOSINIT,__PASCAL__

CSegEnd@

	END
