;************************************************************************
;*									*
;*	DV-GLUE		DESQview and DESQview/X Function Library	*
;*			(c) Copyright 1992 Ralf Brown			*
;*			All Rights Reserved.				*
;*									*
;*	File QEMMINIT.ASM	Initialize QEMM-386 interface functions	*
;*									*
;************************************************************************
;LastEdit: 12/20/92

	INCLUDE	RULES.ASI
	Header@

;========================================================================

DSeg@
PubSym@ QEMM_VERSION,<dw 0>,__PASCAL__
initialized db 0
DSegEnd@

;========================================================================

BSeg@
QEMM_entrypt dd ?
BSegEnd@

;========================================================================

CSeg@

;------------------------------------------------------------------------

PubProc@ QEMMINIT,__PASCAL__
	SET_DS
	push	es
	push	di
	mov	ax,QEMM_VERSION@
	cmp	initialized,1
	je	init_done
	mov	ah,3Fh
	mov	cx,5145h		; QE
	mov	dx,4D4Dh		; MM
	int	67h
	cmp	ah,0
	mov	ax,0			; assume QEMM not installed
	jne	init_done
	mov	word ptr QEMM_entrypt,di
	mov	word ptr QEMM_entrypt+2,es
	mov	initialized,1
	mov	ah,3			; func = get version
	call	QEMM_entrypt
	mov	ax,0
	jc	init_done
	mov	ax,bx
	mov	QEMM_VERSION@,ax	; remember QEMM version 
init_done:
	pop	di
	pop	es
	RESTORE_DS
	ret
EndProc@ QEMMINIT,__PASCAL__

;------------------------------------------------------------------------

public $DVG$QEMMCALL
$DVG$QEMMCALL proc near
	SET_DS
	cmp	initialized,1
	jne	QEMMcall_try_init
do_call:
	call	QEMM_entrypt
	RESTORE_DS
	ret

QEMMcall_try_init:
	ASSUME	DS:DGROUP
	push	dx
	push	cx
	push	bx
	push	ax
	call	QEMMINIT@
	pop	ax
	pop	bx
	pop	cx
	pop	dx
	cmp	initialized,1
	je	do_call
QEMMcall_error:
	RESTORE_DS
	xor	ax,ax			; indicate error
	stc
	ret
$DVG$QEMMCALL endp

CSegEnd@

	END
