;************************************************************************
;*									*
;*	DV-GLUE		DESQview and DESQview/X Function Library	*
;*			(c) Copyright 1992 Ralf Brown			*
;*			All Rights Reserved.				*
;*									*
;*	File DVGALLOC.ASM	internal memory allocation functions	*
;*									*
;************************************************************************
;LastEdit: 12/28/92

	INCLUDE	API.INC
	Header@

;========================================================================

DSeg@
mutex	db 0
DSegEnd@

;========================================================================

IF LPROG eq 0
CSeg@
ENDIF

ExtProc@ malloc,__CDECL__
ExtProc@ free,__CDECL__
ExtProc@ realloc,__CDECL__

IF LPROG
CSeg@
ENDIF

public $DVG$ALLOC
public $DVG$FREE
public $DVG$REALLOC

;------------------------------------------------------------------------
; entry: AX = size in bytes
; return: [DX:]AX -> allocated block or NULL
;
$DVG$ALLOC proc near
	ASSUME	DS:DGROUP
	push	ax
	SERIALIZE mutex
	call	malloc@
	mov	mutex,0			; OK for other threads to enter now
	inc	sp			; pop malloc's arg
	inc	sp
	ret
$DVG$ALLOC endp

;------------------------------------------------------------------------
; entry: STACK: [D]WORD -> previously-allocated block
;
$DVG$FREE proc near
@block = DPTR_ [bp+4]
	ASSUME	DS:DGROUP
	push	bp
	mov	bp,sp
	PUSHDPTRMEM @block	
	SERIALIZE mutex
	call	free@
	mov	mutex,0			; OK for other threads to enter now
	mov	sp,bp			; pop args off stack
	pop	bp
	ret	dPtrSize
$DVG$FREE endp

;------------------------------------------------------------------------
; entry: AX = new size in bytes
;	 STACK: [D]WORD -> allocated block
; return: [DX:]AX -> resized block
;
$DVG$REALLOC proc near
@block = DPTR_ [bp+4]
	ASSUME	DS:DGROUP
	push	bp
	mov	bp,sp
	push	ax
	PUSHDPTRMEM @block
	SERIALIZE mutex
	call	realloc@
	mov	mutex,0			; OK for other threads to enter now
	mov	sp,bp			; pop args off stack
	pop	bp
	ret	dPtrSize
$DVG$REALLOC endp

;------------------------------------------------------------------------

CsegEnd@

	END
