;************************************************************************
;*									*
;*	DV-GLUE		DESQview and DESQview/X Function Library	*
;*			(c) Copyright 1992 Ralf Brown			*
;*			All Rights Reserved.				*
;*									*
;*	File DCALL226.ASM 	direct-call functions added in DV 2.26	*
;*									*
;************************************************************************
;LastEdit: 12/30/92

	INCLUDE	API.INC
	MIN_VERSION 2,26

	Header@

;========================================================================

CSeg@

; v2.26+
; void DVdispatchint(OBJECT task,void far (*func)(void),union REGS *regs) ;
PubProc@ DVDISPATCHINT,__PASCAL__
@task = dword ptr [bp+6+cPtrSize+dPtrSize]
@func = dword ptr [bp+2+cPtrSize+dPtrSize]
@regs = DPTR_ [bp+2+cPtrSize]
	mov	ax,1120h
public $DVG$DISPATCHINT
$DVG$DISPATCHINT:
	push	bp
	mov	bp,sp
	mov	bx,word ptr @task+2	; segment of task handle
	mov	cx,word ptr @func
	mov	dx,word ptr @func+2
	push	es
	push	ds
	push	di
	push	si
	LDS_	si,@regs


	int	15h
	pop	si
	pop	di
	pop	ds
	pop	es
	pop	bp
	ret	6+dPtrSize
EndProc@ DVDISPATCHINT,__PASCAL__

; v2.26+
PubProc@ DVASSERTVIR,__PASCAL__
@state = word ptr [bp+2+cPtrSize]
	mov	ax,1121h
	push	bp
	mov	bp,sp
	mov	bx,@state
	pop	bp
	int	15h
	mov	ax,bx
	ret	2
EndProc@ DVASSERTVIR,__PASCAL__

; v2.26+
; int DVprocessmem(OBJECT task,unsigned *total,unsigned *sysmem,unsigned *maxblock) ;
PubProc@ DVPROCESSMEM,__PASCAL__
@task = dword ptr [bp+2+cPtrSize+3*dPtrSize]
@total = DPTR_ [bp+2+cPtrSize+2*dPtrSize]
@sysmem = DPTR_ [bp+2+cPtrSize+dPtrSize]
@maxblock = DPTR_ [bp+2+cPtrSize]
	push	bp
	mov	bp,sp
	mov	dx,word ptr @task+2	; DX <- segment of task handle
	or	dx,dx			; see if NIL
	jnz	pm_have_handle
	mov	ah,12h
	mov	bx,1			; get caller's task handle
	int	15h
	pop	ax			; discard offset of handle
	pop	dx			; get segment of handle
pm_have_handle:
	mov	ax,1122h
	int	15h
	push	ax			; remember flags
	push	ds
	push	si
	LDS_	si,@maxblock
	DPTR_NULL ds,si,ax
	jz	skip_maxblock
	mov	[si],cx
skip_maxblock:
	LDS_	si,@sysmem
	DPTR_NULL ds,si,ax
	jz	skip_sysmem
	mov	[si],bx
skip_sysmem:
	LDS_	si,@total
	DPTR_NULL ds,si,ax
	jz	skip_total
	mov	[si],dx
skip_total:
	pop	si
	pop	ds
	pop	ax			; retrieve flags as return value
	pop	bp
	ret	4+3*dPtrSize
EndProc@ DVPROCESSMEM,__PASCAL__

CSegEnd@

	END
