;************************************************************************
;*									*
;*	DV-GLUE		DESQview and DESQview/X Function Library	*
;*			(c) Copyright 1993 Ralf Brown			*
;*			All Rights Reserved.				*
;*									*
;*	File APPNEW.ASM	   Create new application in current process	*
;*									*
;************************************************************************
;LastEdit: 1/13/93

	INCLUDE API.INC
	MIN_VERSION 2,00

	Header@

;========================================================================

EXEC_block STRUC
  ex_env	dw ?
  ex_cmdline	dd ?
  ex_fcb1	dd ?
  ex_fcb2	dd ?
  ex_stack	dd ?
  ex_entrypt	dd ?
EXEC_block ENDS

FCB STRUC
  fcb_drive	db ?
  fcb_name	db 8 dup (?)
  fcb_ext	db 3 dup (?)
  fcb_curblk	dw ?
; don't actually need any of the following fields
;  fcb_recsize	dw ?
;  fcb_filesize	dd ?
;  fcb_date	dw ?
;  fcb_time	dw ?
;  fcb_reserved	db 8 dup (?)
;  fcb_currec	db ?
;  fcb_random	dd ?
FCB ENDS

;========================================================================

DSeg@
ExtSym@ _doserrno,WORD,__CDECL__
ExtSym@ _psp,WORD,__CDECL__

newapp_mutex db 0

execblk	label byte
		dw ?  ;environment segment
execblk_cmdline	dw offset DGROUP:cmd_line_len
IF LDATA
		dw DGROUP
ELSE
		dw ?  ;segment of commandline
ENDIF
execblk_fcb1	dw offset DGROUP:fcb1
IF LDATA
		dw DGROUP
ELSE
		dw ?  ;segment of fcb1
ENDIF
execblk_fcb2	dw offset DGROUP:fcb2
IF LDATA
		dw DGROUP
ELSE
		dw ?  ;segment of fcb2
ENDIF
execblk_stack	dd ?  	; scratch space for initial stack
execblk_entrypt	dd ?	; scratch space for entry point

DSegEnd@

;========================================================================

BSeg@
new_psp		dw ?

cmd_line_len	db ?
cmd_line	db 126 dup (?)
cmd_line_end equ $
		db ?			; room for terminating CR
fcb1		FCB <>
fcb2		FCB <>
BSegEnd@

;========================================================================

CSeg@

ExtProc@ DVTASK_NEW,__PASCAL__
ExtProc@ DVTASK_POST,__PASCAL__

;------------------------------------------------------------------------

terminate proc far
;	mov	ah,51h
;	int	21h			; get PSP segment
;	mov	ds,bx			; set up addressing to PSP
;	DV_OSTACK
;	mov	bx,0Ah			; address of termination address
;	POPMEM32 [bx]			; restore termination address
	mov	ah,12h
	mov	bx,0201h		; kill calling task
	int	15h
	int	20h			; insurance
terminate endp

launch_app proc far
	ASSUME	DS:DGROUP
	xor	ax,ax
	push	ax			; for programs expecting a 0 on top of stack
	PUSHMEM32 execblk_entrypt	; this is where we will jump
	mov	bx,new_psp
	mov	newapp_mutex,0		; allow another call to TVspawn...
	mov	ah,50h			; set PSP segment
	int	21h
	mov	ds,bx			; set up segment registers for program
	mov	es,bx			; DS = ES = PSP
	mov	ds:[16h],bx		; set parent of new program to itself
	mov	bx,0Ah			; pointer to termination address in PSP
;	DV_OSTACK			; switch to task's local stack
;	PUSHMEM32 [bx]
;	DV_USTACK			; back to user stack
	mov	ax,offset __TEXT:terminate
	mov	[bx],ax
	mov	[bx+2],cs		; set termination address in PSP
	xor	ax,ax			; clean up registers
	xor	bx,bx
	ret				; jump to entry point
launch_app endp

;------------------------------------------------------------------------

PubProc@ DVSPAWNVE,__PASCAL__
@win = dword ptr [bp+Overhead+12+2*dPtrSize]
@row = word ptr [bp+Overhead+10+2*dPtrSize]
@col = word ptr [bp+Overhead+8+2*dPtrSize]
@rows = word ptr [bp+Overhead+6+2*dPtrSize]
@cols = word ptr [bp+Overhead+4+2*dPtrSize]
@switchmenu = word ptr [bp+Overhead+2+2*dPtrSize]
@program = DPTR_ [bp+Overhead+2+dPtrSize]
@args = DPTR_ [bp+Overhead+2]
@env = word ptr [bp+Overhead]
	@Enter
	pushm	es,di,si
	SERIALIZE newapp_mutex
	;
	; OK, now we are the only one using this function
	; start by initializing the EXEC parameter block
	;
	mov	ax,@env
	mov	execblk.ex_env,ax
IF LDATA eq 0
	mov	word ptr execblk_cmdline+2,ds
	mov	word ptr execblk_fcb1+2,ds
	mov	word ptr execblk_fcb2+2,ds
ENDIF
	;
	; concatenate the arguments to form the commandline
	;
	push	ds
	pop	es
	ASSUME	ES:DGROUP
	mov	di,offset DGROUP:cmd_line
	pushDS_
	LDS_	si,@args
	ASSUME	DS:NOTHING
parm_cat_loop:
	add	si,dPtrSize		; move to next parameter
	pushDS_
	push	si
	LDS_	si,[si]
	ASSUME	DS:NOTHING
	DPTR_NULL ds,si,ax
	jz	parm_cat_done
another_parm:
	cmp	di,offset DGROUP:cmd_line_end
	jae	parm_cat_done
	mov	al,' '			; separate parameters by blanks
	stosb
parm_copy_loop:
	lodsb
	or	al,al
	jz	parm_copy_done
	stosb
	cmp	di,offset DGROUP:cmd_line_end
	jb	parm_copy_loop
parm_copy_done:
	pop	si
	popDS_
	ASSUME	DS:NOTHING
	jmp	parm_cat_loop
parm_cat_done:
	pop	si
	popDS_				; pop the DS:SI stored during the loop
	popDS_
	ASSUME	DS:DGROUP
	mov	al,13			; append the needed CR to the command line
	stosb
	sub	di,offset DGROUP:cmd_line+1
	mov	ax,di
	mov	cmd_line_len,al
	;
	; now set up the FCBs
	;
	mov	si,offset DGROUP:cmd_line ; point SI at completed commandline
	push	ds
	pop	es
	mov	di,offset DGROUP:fcb1
	mov	ax,2901h		; parse into FCB, skipping whitespace
	int	21h
	jc	unparseable_name
	cmp	al,0FFh
	je	unparseable_name
	mov	di,offset DGROUP:fcb2
	mov	ax,2901h
	int	21h
unparseable_name:
	;
	; load the program, but don't execute it yet
	;
	mov	_doserrno@,0
	push	ds
	pop	es
	ASSUME	ES:DGROUP
	mov	bx,offset DGROUP:execblk
	pushDS_
	LDS_	dx,@program
	ASSUME	DS:NOTHING
	mov	ax,4B01h		; load but don't execute
	int	21h
	popDS_				; restore access to DGROUP if necessary
	ASSUME	DS:DGROUP
	jnc	no_error
	mov	_doserrno@,ax
	xor	ax,ax
	xor	dx,dx
	jmp	spawnve_exit

no_error:
	mov	ah,51h			; get PSP (should use 62h, but req. DOS 3+)
	int	21h
	mov	new_psp,bx
	mov	ah,50h			; restore our own PSP segment
	mov	bx,_psp@
	int	21h
	;
	; finally ready to launch the child program as a new task
	;
	PUSHMEM32 @win			; window handle
	xor	ax,ax
	PUSHDPTR ax,ax			; NULL
	push	@row
	push	@col
	push	@rows
	push	@cols
	PUSHMEM32 execblk.ex_stack
	push	ax			; 0
	mov	ax,offset __TEXT:launch_app
	PUSHCPTR cs,ax
	push	@switchmenu
	call	DVtask_new@
	pushm	dx,ax			; DX:AX = new app's task handle
	or	dx,ax
	jz	spawnve_done
	; wait until child process clears busy flag
wait_loop:
	cmp	newapp_mutex,0
	jz	child_ready
	mov	ax,1000h
	int	15h			; give up CPU
	jmp	wait_loop
child_ready:
	popm	ax,dx			; DX:AX <- new app's task handle
	pushm	dx,ax
	pushm	dx,ax
	call	DVtask_post@
spawnve_done:
	popm	ax,dx			; DX:AX <- new app's task handle
spawnve_exit:
	popm	si,di,es
	@Exit
	ret	16+2*dPtrSize
EndProc@ DVSPAWNVE,__PASCAL__

;------------------------------------------------------------------------

PubProc@ DVapp_new,__CDECL__
@win = dword ptr [bp+2+cPtrSize]
@row = word ptr [bp+6+cPtrSize]
@col = word ptr [bp+8+cPtrSize]
@rows = word ptr [bp+10+cPtrSize]
@cols = word ptr [bp+12+cPtrSize]
@switchmenu = word ptr [bp+14+cPtrSize]
@program = DPTR_ [bp+16+cPtrSize]
@args = word ptr [bp+16+cPtrSize+dPtrSize]
	push	bp
	mov	bp,sp
	PUSHMEM32 @win
	push	@row
	push	@col
	push	@rows
	push	@cols
	push	@switchmenu
	PUSHDPTRMEM @program
	lea	ax,@args
	PUSHDPTR ss,ax
	xor	ax,ax
	push	ax
	call	DVSPAWNVE@
	pop	bp
	ret
EndProc@ DVapp_new,__CDECL__

;------------------------------------------------------------------------

kill_task proc far
	mov	ax,4C00h
	int	21h			; terminate program
	mov	ah,12h
	mov	bx,0201h		; FREE(ME)
	int	15h
	int	20h			; just in case....
kill_task endp

PubProc@ DVAPP_FREE,__PASCAL__
@task = dword ptr [bp+2+cPtrSize]
	push	bp
	mov	bp,sp
	mov	ax,1021h		; PGMINT
	mov	bx,word ptr @task+2
	mov	cx,offset __TEXT:kill_task
	mov	dx,cs
	int	15h
	pop	bp
	ret	4
EndProc@ DVAPP_FREE,__PASCAL__


CSegEnd@

	END
