/************************************************************************/
/*									*/
/*	DV-GLUE		DESQview and DESQview/X Function Library	*/
/*			(c) Copyright 1988, 1992 Ralf Brown		*/
/*			All Rights Reserved.				*/
/*									*/
/*	File DVP.H	Define format of a .DVP file			*/
/*									*/
/************************************************************************/
/* LastEdit: 12/20/92							*/

typedef struct
   {
   BYTE reserved0 ;	      /* apparently always 0 */
   BYTE checksum ;            /* makes sum of bytes of .PIF file equal zero */
   char program_name[30] ;    /* blank-padded */
   WORD max_memory ;          /* in K */
   WORD min_memory ;          /* in K */
   char executable_name[64] ; /* ASCIZ */
   BYTE data_drive ;          /* 0 = default, else drive letter ('A',...) */
   char data_directory[64] ;  /* ASCIZ */
   char parameters[64] ;      /* ASCIZ */
   BYTE video_mode ;          /* 7Fh = use current */
   BYTE num_text_pages ;
   BYTE lowest_int ;          /* number of lowest interrupt program changes */
   BYTE highest_int ;         /* number of highest interrupt program changes */
   BYTE max_win_height ;
   BYTE max_win_width ;
   BYTE starting_row ;        /* 0 = use default */
   BYTE starting_col ;        /* 0 = use default */
   WORD total_overhead_RAM ;  /* how many K to allocate for system RAM */
                              /* (= requested + amt needed for screen buffer) */
   char shared_program[64] ;  /* ASCIZ */
   char shared_prg_data[64] ; /* ASCIZ */
   BYTE flags1 ;              /* bit 7 = set if writes directly to screen */
                              /* bit 6 = set if runs only in foreground */
                              /* bit 5 = set if uses math coprocessor */
                              /* bit 4 = set if "Keyboard Conflict" = 4 */
                              /* bit 3 = reserved */
                              /* bit 2 = reserved */
                              /* bit 1 = reserved */
                              /* bit 0 = set if can be swapped out */
   BYTE flags2 ;              /* bit 6 = set if command line present */
                              /* bit 5 = set if changes interrupt vectors */

/* everything up to this point is identical to a TopView .PIF file */
/* the remainder is unique to a DESQview .DVP file.  Note that there */
/* is some duplication of information */

   char open_keys[2] ;
   WORD script_buffer_size ;  /* in bytes */
   WORD pause_count ;         /* number of keyboard checks per clock tick to */
                              /* allow before invoking PAUSE function */
   BYTE uses_own_colors ;     /* nonzero = yes,  0 = no */
   BYTE swappable ;           /* nonzero = yes */
   BYTE reserved179h ;        /* should be zero */
   BYTE reserved17Ah ;        /* should be zero */
   BYTE reserved17Bh ;        /* should be zero */
   BYTE close_on_exit ;       /* nonzero = close on exit, 0 = don't */
   BYTE needs_floppy ;        /* nonzero if floppy disk needed */

/* the following is available in DV 2.00 and later.  Previous versions set */
/* these bytes to zero */
   BYTE DVPformat ;           /* 0 = DV 1.20+, 1 = DV 2.00+, 2 = DV 2.20+ */
   BYTE reserved17Fh ;        /* should be zero */
   BYTE starting_height ;     /* 0 = use default */
   BYTE starting_width ;      /* 0 = use default */
   WORD max_expanded_mem ;    /* in K, FFFFh = no limit */
   BYTE flags3 ;              /* bit 7 = automatically assign position */
                              /* bit 6 = reserved */
                              /* bit 5 = maximum memory has been specified */
                              /* bit 4 = 1 don't allow close window cmd */
                              /* bit 3 = set if "Runs only in fg" = ' ' */
                              /* bit 2 = don't virtualize */
                              /* bit 1 = reserved */
                              /* bit 0 = reserved */
   BYTE keyboard_conflict ;   /* 0 thru 4 */
   BYTE num_graphics_pages ;
   WORD system_RAM ;          /* amount of SYSTEM RAM requested, in K */
   BYTE initial_video_mode ;  /* FFh = use current mode if compatible */

/* the following is available in DESQview v2.20 and later, and is set to zero */
/* in earlier versions: */
   BYTE  serial_ports ;       /* -1 = uses all serial ports */
                              /*  0 = not using serial ports */
                              /*  1 = uses COM1 only */
                              /*  2 = uses COM2 only */
   BYTE flags4 ;              /* default C3h */
                              /* bit 7 = set if automatically close on exit */
                              /* bit 6 = set if swappable if not using serial */
                              /* bits 5-3 reserved */
                              /* bit 2 = set if virtualizing graphics */
                              /* bit 1 = set if sharing CPU when foreground */
                              /* bit 0 = set if sharing EGA when fg and zoomed */
   BYTE protection_level ;    /* 0-3, nonzero means use separate virtual 86's */

   BYTE reserved[19] ;        /* currently unused */
   } DVP_file ;

/* end of DVP.H */
