/*
    REFERENCES -- bibliographic software
    Copyright (C) 1995-2000  Volker Kiefel

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
    USA
*/

/*
    cfg_fun.c
*/

#include <stdio.h>
#include "cfg_fun.h"
#include "abbruch.h"

#if defined(__EMX__) && !defined(MIT_ANSI_SYS)
      #include <sys/video.h>
#endif

#include "str_fun.h"
#include <string.h>
#include "fl_ut.h"

extern char fehlermeldung[250];
extern config_set one_config_set;


#if defined(MIT_ANSI_SYS)
  extern ansi_farben_set one_ansi_farben_set;
#elif defined(__DJGPP__)
  extern ansi_farben_set one_ansi_farben_set;
#elif defined(__EMX__)
  extern ansi_farben_set one_ansi_farben_set;
#endif

/*

 Um diese Struktur geht es:

 typedef struct
 {
    char text_editor[PFAD_LEN + 1];
    char text_pager[PFAD_LEN + 1];
    char call_editor_command_file[PFAD_LEN + 1];
    char help_path[PFAD_LEN + 1];
    int colors;
    int sl;
    int delay_list_write;
    int delay_struct_write;
 } config_set

 Die zugewiesene Variable heisst in den Programmdateien
 'one_config_set'

*/

config_set config_auswerten(char * programmdatei)
{
   config_set cs;
   char exepfad[PFAD_LEN];
   FILE * fpcfg;
   char zeile[CFG_ZEILE_LEN+4];
   char ex_zeile[CFG_ZEILE_LEN+4];
   int ok;
   long zahl;

   /* Vorgabewerte */

   strcpy(cs.text_editor,"EDIT");
   strcpy(cs.text_pager,"EDIT");
   strcpy(cs.call_editor_command_file,"TF.BAT");
   strcpy(cs.help_path,"\\REFS36\\DOC");
   strcpy(cs.copy_command,"COPY");
   cs.colors=0;
   cs.delay_list_write=0;
   cs.delay_struct_write=0;
   cs.sl=25;
   cs.insert_mode=1;

   programmpfad(programmdatei,exepfad);
   strcat(exepfad,CFG_DATEI);
   if ((fpcfg=fopen(exepfad,"r"))==NULL)
   {
       return cs;
   }

   while ((fgets(zeile,CFG_ZEILE_LEN,fpcfg)!=NULL))
   {
       zahl = 0;
       trim(zeile,'\n');
       trim(zeile,' ');
       extractitem(1,zeile,"=",ex_zeile);
       trim(ex_zeile,' ');
       upper(ex_zeile);
       if (!strcmp(ex_zeile,"EDITOR"))
       {
          extractitem(2,zeile,"=",ex_zeile);
          if (strlen(ex_zeile)>0)
          {
             strlimcpy(cs.text_editor,ex_zeile,PFAD_LEN);
             /* 
              * If the text pager has not yet been changed from its default,
              * assign the name of the selected editor to the pager-function.
              */
             if (!strcmp(cs.text_pager,"EDIT"))
             {
                strlimcpy(cs.text_pager,ex_zeile,PFAD_LEN);
             }
          }
       }
       if (!strcmp(ex_zeile,"PAGER"))
       {
          extractitem(2,zeile,"=",ex_zeile);
          if (strlen(ex_zeile)>0)
          {
             strlimcpy(cs.text_pager,ex_zeile,PFAD_LEN);
          }
       }
       if (!strcmp(ex_zeile,"CALL_EDITOR_COMMAND_FILE"))
       {
          extractitem(2,zeile,"=",ex_zeile);
          if (strlen(ex_zeile)>0)
          {
             slash_to_backslash(ex_zeile);
             strlimcpy(cs.call_editor_command_file,ex_zeile,PFAD_LEN);
          }
       }
       if (!strcmp(ex_zeile,"HELP_FILES"))
       {
          extractitem(2,zeile,"=",ex_zeile);
          if (strlen(ex_zeile)>0)
          {
             slash_to_backslash(ex_zeile);
             strlimcpy(cs.help_path,ex_zeile,PFAD_LEN);
          }
       }
       if (!strcmp(ex_zeile,"COPY_COMMAND"))
       {
          extractitem(2,zeile,"=",ex_zeile);
          if (strlen(ex_zeile)>0)
          {
              strlimcpy(cs.copy_command,ex_zeile,PFAD_LEN);
          }
       }
       else if (!strcmp(ex_zeile,"INSERT_MODE"))
       {
          extractitem(2,zeile,"=",ex_zeile);
          if (strlen(ex_zeile)>0)
          {
              string_in_long(ex_zeile,&zahl,&ok);
              if (ok)
              {
                 if (zahl < 0)  zahl = 0;
                 if (zahl >= 1) zahl = 1;
              }
              cs.insert_mode = (int) zahl;
          }
       }


       else if (!strcmp(ex_zeile,"COLORS"))
       {
          extractitem(2,zeile,"=",ex_zeile);
          if (strlen(ex_zeile)>0)
          {
              string_in_long(ex_zeile,&zahl,&ok);
              if (ok)
              {
                 if (zahl < 0)  zahl = 0;
                 if (zahl > 11) zahl = 0;
              }
              cs.colors=zahl;
          }
       }
#if defined(MIT_ANSI_SYS) || defined(__DJGPP__)
       else if (!strcmp(ex_zeile,"LINES_OF_SCREEN"))
       {
          extractitem(2,zeile,"=",ex_zeile);
          if (strlen(ex_zeile)>0)
          {
              string_in_long(ex_zeile,&zahl,&ok);
              if (ok)
              {
                 if (zahl != 25 && zahl != 43 && zahl != 50)
                 {
                    cs.sl=25;
                 }
                 else
                 {
                    cs.sl=zahl;
                 }
              }
          }
       }
#endif
       else if (!strcmp(ex_zeile,"DELAY_LIST_WRITE"))
       {
          extractitem(2,zeile,"=",ex_zeile);
          if (strlen(ex_zeile)>0)
          {
              string_in_long(ex_zeile,&zahl,&ok);
              if (ok)
              {
                 if (zahl < 0)  zahl = 0;
                 if (zahl > 30000) zahl = 30000;
              }
              cs.delay_list_write=zahl;
          }
       }
       else if (!strcmp(ex_zeile,"DELAY_STRUCT_WRITE"))
       {
          extractitem(2,zeile,"=",ex_zeile);
          if (strlen(ex_zeile)>0)
          {
             string_in_long(ex_zeile,&zahl,&ok);
             if (ok)
             {
                if (zahl < 0)  zahl = 0;
                if (zahl > 30000) zahl = 30000;
             }
             cs.delay_struct_write=zahl;
          }
       }
/*
 *  This feature is no more documented, but remains available in v3.6.
 *
 *  Usage in the REFS.CFG:
 *  
 *     DELAY_LIST_WRITE=MILLISECONDS
 *     DELAY_STRUCT_WRITE=MILLISECONDS
 * 
 *  Enter 0..30000 milliseconds if you have problems with certain cache
 *  programs (no problems with Smartdrv observed!), DELAY_LIST_WRITE
 *  interrupts "ListR" and "Export" every 200 records, DELAY_STRUCT_WRITE
 *  interrupts "RestructureDatabase"
 */
       
   }
   fclose(fpcfg);
   return cs;
}

int farben_setzen(int kennung)
{
#if defined(MIT_ANSI_SYS)
    strcpy(one_ansi_farben_set.farbe_norm,"");
    strcpy(one_ansi_farben_set.farbe_inv,"");
    strcpy(one_ansi_farben_set.farbe_e_zle,"");
#elif defined(__EMX__)
    one_ansi_farben_set.farbe_norm=0;
    one_ansi_farben_set.farbe_inv=0;
    one_ansi_farben_set.farbe_e_zle=0;
#endif
    if (kennung==1)
    {
#if defined(MIT_ANSI_SYS)
        sprintf(one_ansi_farben_set.farbe_norm,"\033[1;37;44m");
        sprintf(one_ansi_farben_set.farbe_inv,"\033[0;30;47m");
        sprintf(one_ansi_farben_set.farbe_e_zle,"\033[1;37;44m");
        printf("%s",one_ansi_farben_set.farbe_norm);
        fflush(stdout);
#elif defined(__EMX__)
        one_ansi_farben_set.farbe_norm=F_WHITE|B_BLUE|INTENSITY;
        one_ansi_farben_set.farbe_inv=F_BLACK|B_WHITE;
        one_ansi_farben_set.farbe_e_zle=F_WHITE|B_BLUE|INTENSITY;
        v_attrib(one_ansi_farben_set.farbe_norm);
#elif defined(__DJGPP__)
        one_ansi_farben_set.farbe_norm_v=WHITE;
        one_ansi_farben_set.farbe_norm_h=BLUE;
        one_ansi_farben_set.farbe_inv_v=BLACK;
        one_ansi_farben_set.farbe_inv_h=LIGHTGRAY;
        one_ansi_farben_set.farbe_e_zle_v=WHITE;
        one_ansi_farben_set.farbe_e_zle_h=BLUE;
        textcolor(one_ansi_farben_set.farbe_norm_v);
        textbackground(one_ansi_farben_set.farbe_norm_h);
#endif
    }
    else if (kennung==2)
    {
#if defined(MIT_ANSI_SYS)
        sprintf(one_ansi_farben_set.farbe_norm,"\033[1;37;44m");
        sprintf(one_ansi_farben_set.farbe_inv,"\033[1;37;45m");
        sprintf(one_ansi_farben_set.farbe_e_zle,"\033[0;30;47m");
        printf("%s",one_ansi_farben_set.farbe_norm);
        fflush(stdout);
#elif defined(__EMX__)
        one_ansi_farben_set.farbe_norm=F_WHITE|B_BLUE|INTENSITY;
        one_ansi_farben_set.farbe_inv=F_WHITE|B_MAGENTA|INTENSITY;
        one_ansi_farben_set.farbe_e_zle=F_BLACK|B_WHITE;
        v_attrib(one_ansi_farben_set.farbe_norm);
#elif defined(__DJGPP__)
        one_ansi_farben_set.farbe_norm_v=WHITE;
        one_ansi_farben_set.farbe_norm_h=BLUE;
        one_ansi_farben_set.farbe_inv_v=WHITE;
        one_ansi_farben_set.farbe_inv_h=MAGENTA;
        one_ansi_farben_set.farbe_e_zle_v=BLACK;
        one_ansi_farben_set.farbe_e_zle_h=LIGHTGRAY;
        textcolor(one_ansi_farben_set.farbe_norm_v);
        textbackground(one_ansi_farben_set.farbe_norm_h);
#endif
                                }
    else if (kennung==3)
    {
#if defined(MIT_ANSI_SYS)
        sprintf(one_ansi_farben_set.farbe_norm,"\033[1;37;44m");
        sprintf(one_ansi_farben_set.farbe_inv,"\033[1;37;41m");
        sprintf(one_ansi_farben_set.farbe_e_zle,"\033[0;30;47m");
        printf("%s",one_ansi_farben_set.farbe_norm);
        fflush(stdout);
#elif defined(__EMX__)
        one_ansi_farben_set.farbe_norm=F_WHITE|B_BLUE|INTENSITY;
        one_ansi_farben_set.farbe_inv=F_WHITE|B_RED|INTENSITY;
        one_ansi_farben_set.farbe_e_zle=F_BLACK|B_WHITE;
        v_attrib(one_ansi_farben_set.farbe_norm);
#elif defined(__DJGPP__)
        one_ansi_farben_set.farbe_norm_v=WHITE;
        one_ansi_farben_set.farbe_norm_h=BLUE;
        one_ansi_farben_set.farbe_inv_v=WHITE;
        one_ansi_farben_set.farbe_inv_h=RED;
        one_ansi_farben_set.farbe_e_zle_v=BLACK;
        one_ansi_farben_set.farbe_e_zle_h=LIGHTGRAY;
        textcolor(one_ansi_farben_set.farbe_norm_v);
        textbackground(one_ansi_farben_set.farbe_norm_h);
#endif
                                }
    else if (kennung==4)
    {
#if defined(MIT_ANSI_SYS)
        sprintf(one_ansi_farben_set.farbe_norm,"\033[1;37;44m");
        sprintf(one_ansi_farben_set.farbe_inv,"\033[1;37;46m");
        sprintf(one_ansi_farben_set.farbe_e_zle,"\033[0;30;47m");
        printf("%s",one_ansi_farben_set.farbe_norm);
        fflush(stdout);
#elif defined(__EMX__)
        one_ansi_farben_set.farbe_norm=F_WHITE|B_BLUE|INTENSITY;
        one_ansi_farben_set.farbe_inv=F_WHITE|B_CYAN|INTENSITY;
        one_ansi_farben_set.farbe_e_zle=F_BLACK|B_WHITE;
        v_attrib(one_ansi_farben_set.farbe_norm);
#elif defined(__DJGPP__)
        one_ansi_farben_set.farbe_norm_v=WHITE;
        one_ansi_farben_set.farbe_norm_h=BLUE;
        one_ansi_farben_set.farbe_inv_v=WHITE;
        one_ansi_farben_set.farbe_inv_h=CYAN;
        one_ansi_farben_set.farbe_e_zle_v=BLACK;
        one_ansi_farben_set.farbe_e_zle_h=LIGHTGRAY;
        textcolor(one_ansi_farben_set.farbe_norm_v);
        textbackground(one_ansi_farben_set.farbe_norm_h);
#endif
                                }
    else if (kennung==5)
    {
#if defined(MIT_ANSI_SYS)
        sprintf(one_ansi_farben_set.farbe_norm,"\033[0;37;44m");
        sprintf(one_ansi_farben_set.farbe_inv,"\033[1;37;45m");
        sprintf(one_ansi_farben_set.farbe_e_zle,"\033[0;30;47m");
        printf("%s",one_ansi_farben_set.farbe_norm);
        fflush(stdout);
#elif defined(__EMX__)
        one_ansi_farben_set.farbe_norm=F_WHITE|B_BLUE;
        one_ansi_farben_set.farbe_inv=F_WHITE|B_MAGENTA|INTENSITY;
        one_ansi_farben_set.farbe_e_zle=F_BLACK|B_WHITE;
        v_attrib(one_ansi_farben_set.farbe_norm);
#elif defined(__DJGPP__)
        one_ansi_farben_set.farbe_norm_v=LIGHTGRAY;
        one_ansi_farben_set.farbe_norm_h=BLUE;
        one_ansi_farben_set.farbe_inv_v=WHITE;
        one_ansi_farben_set.farbe_inv_h=MAGENTA;
        one_ansi_farben_set.farbe_e_zle_v=BLACK;
        one_ansi_farben_set.farbe_e_zle_h=LIGHTGRAY;
        textcolor(one_ansi_farben_set.farbe_norm_v);
        textbackground(one_ansi_farben_set.farbe_norm_h);
#endif
                                }
    else if (kennung==6)
    {
#if defined(MIT_ANSI_SYS)
        sprintf(one_ansi_farben_set.farbe_norm,"\033[1;33;44m");
        sprintf(one_ansi_farben_set.farbe_inv,"\033[1;37;45m");
        sprintf(one_ansi_farben_set.farbe_e_zle,"\033[0;30;47m");
        printf("%s",one_ansi_farben_set.farbe_norm);
        fflush(stdout);
#elif defined(__EMX__)
        one_ansi_farben_set.farbe_norm=F_YELLOW|B_BLUE|INTENSITY;
        one_ansi_farben_set.farbe_inv=F_WHITE|B_MAGENTA|INTENSITY;
        one_ansi_farben_set.farbe_e_zle=F_BLACK|B_WHITE;
        v_attrib(one_ansi_farben_set.farbe_norm);
#elif defined(__DJGPP__)
        one_ansi_farben_set.farbe_norm_v=YELLOW;
        one_ansi_farben_set.farbe_norm_h=BLUE;
        one_ansi_farben_set.farbe_inv_v=WHITE;
        one_ansi_farben_set.farbe_inv_h=MAGENTA;
        one_ansi_farben_set.farbe_e_zle_v=BLACK;
        one_ansi_farben_set.farbe_e_zle_h=LIGHTGRAY;
        textcolor(one_ansi_farben_set.farbe_norm_v);
        textbackground(one_ansi_farben_set.farbe_norm_h);
#endif
                                }
    else if (kennung==7)
    {
#if defined(MIT_ANSI_SYS)
        sprintf(one_ansi_farben_set.farbe_norm,"\033[1;37;40m");
        sprintf(one_ansi_farben_set.farbe_inv,"\033[0;30;47m");
        sprintf(one_ansi_farben_set.farbe_e_zle,"\033[0;30;47m");
        printf("%s",one_ansi_farben_set.farbe_norm);
        fflush(stdout);
#elif defined(__EMX__)
        one_ansi_farben_set.farbe_norm=F_WHITE|B_BLACK|INTENSITY;
        one_ansi_farben_set.farbe_inv=F_BLACK|B_WHITE;
        one_ansi_farben_set.farbe_e_zle=F_BLACK|B_WHITE;
        v_attrib(one_ansi_farben_set.farbe_norm);
#elif defined(__DJGPP__)
        one_ansi_farben_set.farbe_norm_v=WHITE;
        one_ansi_farben_set.farbe_norm_h=BLACK;
        one_ansi_farben_set.farbe_inv_v=BLACK;
        one_ansi_farben_set.farbe_inv_h=LIGHTGRAY;
        one_ansi_farben_set.farbe_e_zle_v=BLACK;
        one_ansi_farben_set.farbe_e_zle_h=LIGHTGRAY;
        textcolor(one_ansi_farben_set.farbe_norm_v);
        textbackground(one_ansi_farben_set.farbe_norm_h);
#endif
                                }
    else if (kennung==8)
    {
#if defined(MIT_ANSI_SYS)
        sprintf(one_ansi_farben_set.farbe_norm,"\033[0;36;40m");
        sprintf(one_ansi_farben_set.farbe_inv,"\033[1;37;45m");
        sprintf(one_ansi_farben_set.farbe_e_zle,"\033[0;30;47m");
        printf("%s",one_ansi_farben_set.farbe_norm);
        fflush(stdout);
#elif defined(__EMX__)
        one_ansi_farben_set.farbe_norm=F_CYAN|B_BLACK;
        one_ansi_farben_set.farbe_inv=F_WHITE|B_MAGENTA|INTENSITY;
        one_ansi_farben_set.farbe_e_zle=F_BLACK|B_WHITE;
        v_attrib(one_ansi_farben_set.farbe_norm);
#elif defined(__DJGPP__)
        one_ansi_farben_set.farbe_norm_v=CYAN;
        one_ansi_farben_set.farbe_norm_h=BLACK;
        one_ansi_farben_set.farbe_inv_v=WHITE;
        one_ansi_farben_set.farbe_inv_h=MAGENTA;
        one_ansi_farben_set.farbe_e_zle_v=BLACK;
        one_ansi_farben_set.farbe_e_zle_h=LIGHTGRAY;
        textcolor(one_ansi_farben_set.farbe_norm_v);
        textbackground(one_ansi_farben_set.farbe_norm_h);
#endif
                                }
    else if (kennung==9)
    {
#if defined(MIT_ANSI_SYS)
        sprintf(one_ansi_farben_set.farbe_norm,"\033[1;33;40m");
        sprintf(one_ansi_farben_set.farbe_inv,"\033[1;36;44m");
        sprintf(one_ansi_farben_set.farbe_e_zle,"\033[0;31;47m");
        printf("%s",one_ansi_farben_set.farbe_norm);
        fflush(stdout);
#elif defined(__EMX__)
        one_ansi_farben_set.farbe_norm=F_YELLOW|B_BLACK|INTENSITY;
        one_ansi_farben_set.farbe_inv=F_CYAN|B_BLUE|INTENSITY;
        one_ansi_farben_set.farbe_e_zle=F_RED|B_WHITE;
        v_attrib(one_ansi_farben_set.farbe_norm);
#elif defined(__DJGPP__)
        one_ansi_farben_set.farbe_norm_v=YELLOW;
        one_ansi_farben_set.farbe_norm_h=BLACK;
        one_ansi_farben_set.farbe_inv_v=LIGHTCYAN;
        one_ansi_farben_set.farbe_inv_h=BLUE;
        one_ansi_farben_set.farbe_e_zle_v=RED;
        one_ansi_farben_set.farbe_e_zle_h=LIGHTGRAY;
        textcolor(one_ansi_farben_set.farbe_norm_v);
        textbackground(one_ansi_farben_set.farbe_norm_h);
#endif
                                }
    else if (kennung==10)
    {
#if defined(MIT_ANSI_SYS)
        sprintf(one_ansi_farben_set.farbe_norm,"\033[1;37;46m");
        sprintf(one_ansi_farben_set.farbe_inv,"\033[1;37;45m");
        sprintf(one_ansi_farben_set.farbe_e_zle,"\033[1;37;44m");
        printf("%s",one_ansi_farben_set.farbe_norm);
        fflush(stdout);
#elif defined(__EMX__)
        one_ansi_farben_set.farbe_norm=F_WHITE|B_CYAN|INTENSITY;
        one_ansi_farben_set.farbe_inv=F_WHITE|B_MAGENTA|INTENSITY;
        one_ansi_farben_set.farbe_e_zle=F_WHITE|B_BLUE|INTENSITY;
        v_attrib(one_ansi_farben_set.farbe_norm);
#elif defined(__DJGPP__)
        one_ansi_farben_set.farbe_norm_v=WHITE;
        one_ansi_farben_set.farbe_norm_h=CYAN;
        one_ansi_farben_set.farbe_inv_v=WHITE;
        one_ansi_farben_set.farbe_inv_h=MAGENTA;
        one_ansi_farben_set.farbe_e_zle_v=WHITE;
        one_ansi_farben_set.farbe_e_zle_h=BLUE;
        textcolor(one_ansi_farben_set.farbe_norm_v);
        textbackground(one_ansi_farben_set.farbe_norm_h);
#endif

    }
    else if (kennung==11)
    {
#if defined(MIT_ANSI_SYS)
        sprintf(one_ansi_farben_set.farbe_norm,"\033[0;34;47m");
        sprintf(one_ansi_farben_set.farbe_inv,"\033[1;37;45m");
        sprintf(one_ansi_farben_set.farbe_e_zle,"\033[1;37;44m");
        printf("%s",one_ansi_farben_set.farbe_norm);
        fflush(stdout);
#elif defined(__EMX__)
        one_ansi_farben_set.farbe_norm=F_BLUE|B_WHITE;
        one_ansi_farben_set.farbe_inv=F_WHITE|B_MAGENTA|INTENSITY;
        one_ansi_farben_set.farbe_e_zle=F_WHITE|B_BLUE|INTENSITY;
        v_attrib(one_ansi_farben_set.farbe_norm);
#elif defined(__DJGPP__)
        one_ansi_farben_set.farbe_norm_v=BLUE;
        one_ansi_farben_set.farbe_norm_h=LIGHTGRAY;
        one_ansi_farben_set.farbe_inv_v=WHITE;
        one_ansi_farben_set.farbe_inv_h=MAGENTA;
        one_ansi_farben_set.farbe_e_zle_v=WHITE;
        one_ansi_farben_set.farbe_e_zle_h=BLUE;
        textcolor(one_ansi_farben_set.farbe_norm_v);
        textbackground(one_ansi_farben_set.farbe_norm_h);
#endif

    }
    else
    {
#if defined(MIT_ANSI_SYS)
        sprintf(one_ansi_farben_set.farbe_norm,"\033[0;37;40m");
        sprintf(one_ansi_farben_set.farbe_inv,"\033[0;30;47m");
        sprintf(one_ansi_farben_set.farbe_e_zle,"\033[0;37;40m");
        printf("%s",one_ansi_farben_set.farbe_norm);
        fflush(stdout);
#elif defined(__EMX__)
        one_ansi_farben_set.farbe_norm=F_WHITE|B_BLACK;
        one_ansi_farben_set.farbe_inv=F_BLACK|B_WHITE;
        one_ansi_farben_set.farbe_e_zle=F_WHITE|B_BLACK;
        v_attrib(one_ansi_farben_set.farbe_norm);
#elif defined(__DJGPP__)
        one_ansi_farben_set.farbe_norm_v=LIGHTGRAY;
        one_ansi_farben_set.farbe_norm_h=BLACK;
        one_ansi_farben_set.farbe_inv_v=BLACK;
        one_ansi_farben_set.farbe_inv_h=LIGHTGRAY;
        one_ansi_farben_set.farbe_e_zle_v=LIGHTGRAY;
        one_ansi_farben_set.farbe_e_zle_h=BLACK;
        textcolor(one_ansi_farben_set.farbe_norm_v);
        textbackground(one_ansi_farben_set.farbe_norm_h);
#endif
     }
    return 1;
}
