;**************************************************************************
;                   Dynamic Menu System                                   *
;                           by                                            *
;                   Andrew Cunningham                                     *
;                Manchester Business School                               *
;                                                                         *
;             Menu display routines developed by:-                        *
;             Harry Goldman, DataBase Designs Inc.                        *
;                                                                         *
;             Paradox script files:-                                      *
;     SY_MENU.SC    Dynamic menu routines by A.C.                         *
;     AU_UTILS.SC   Routines from GOLDUTIL2.SC by H.G., modified by A.C.  *
;     SY_MAKE.SC    Script to create library file                         *
;     MENU.SC       This file                                             *
;                                                                         *
;                                                                         *
version.a="Version 1.3, Apr '93"
;**************************************************************************
;    Created March 1993.                                                  *
;    Last mod: 21 apr 1993  - all files  V1.2.1                           *
;    1. Corrected invalid directory error 22/4/93                          *
;    2. Corrected error due to system tables being read only 23/4/93
;    3. Added directory change on sub-menu call using script field to define
;       Corrected exit script to play on return from sub-menu.
;**************************************************************************
menu_title="Timetable Generator" ; Title to appear on menu screen
sys_path="c:\\timtbl\\"            ; Path to this software
;**************************************************************************
;                                                                         *
;        Check that initial menu table present - if not create it         *
;        in the current directory and then start the menu system.         *
;                                                                         *
;**************************************************************************
TKLibName=sys_path+"sys_lib"
readlib TKLibName menuheader.u,Menu.u,Menuctl.u,Message.u,checkprinter.l,
                  checktbl.l,create_menu,Initheader.u,GetTblNames.u
Initheader.u()
canvas on
if not istable("sys_menu") or not istable("sys_medt") then
 readlib TKLibName Init_menu
 Init_menu()        ; create inital menu table (sys_menu)
 release procs Init_menu
endif
readlib TKLibName warnmsg,promptmsg,prompt_box,sho_form,sel_tilde,sho_menu,
setmenu,sho_help,update_tbl_lst
sho_menu()          ; display initial menu
release procs all
;release vars all
