#include <stdio.h>
#include <memory.h>
#include <dos.h>
#include <stdlib.h>
#include "cmdline.h"
#include "umem.h"

static BOOL ems_available;
static BOOL ems_checked;
static BYTE far *pageframe;
static EMSMEM *allocatedlist;

static BYTE far *emsvect = MK_FP(0,0x67 *4);
static void freeall(void)
{	
	while (allocatedlist)
		DeallocateEMSMemory(allocatedlist);
}
static  BYTE far * pageit(unsigned short handle, int phys, int logical, BOOL toerr)
{
	union REGS regs;
	regs.h.ah = 0x44;
	regs.w.bx = logical;
	regs.h.al = phys;
	regs.w.dx = handle;
	int86(0x67,&regs,&regs);
	if (regs.h.ah && toerr)
		fatal("EMS: paging function failed");
	return (pageframe + (phys <<14));
}
static BOOL ems_init(void)
{
	if (!ems_checked) {
		ems_checked = TRUE;
		if (*emsvect) {
			union REGS regs;
			regs.h.ah = 0x40;
			int86(0x67,&regs,&regs);
			if (!regs.h.ah) {
				regs.h.ah = 0x41;
				int86(0x67,&regs,&regs);
				if (!regs.h.ah) {
					pageframe = MK_FP(regs.w.bx,0);
					ems_available = TRUE;
				}
			}
		}
		atexit(freeall);
	}
	return ems_available;
}
EMSMEM *AllocateEMSMemory(long size, BYTE fill)
{
  EMSMEM *mem = AllocateMemory(sizeof(EMSMEM));
	mem->size = size;
	mem->fill = fill;
	if (mem->inems = ems_init()) {
		union REGS regs;
		int i;
		size = (size+16383)>>14;
		regs.w.bx = size;
		regs.h.ah = 0x43;
		int86 (0x67,&regs,&regs);
		if (regs.h.ah)
			fatal("EMS: not enough EMS memory");
		mem->id.handle = regs.w.dx;
		for (i=0; i <size; i++)
			memset(pageit(mem->id.handle,0,i,TRUE),fill,16384);

	} else {
		if (size > 65530L)
			fatal("EMS: not available- Image capacity is 64K");
		mem->id.address = AllocateMemory(size);
		memset(mem->id.address,fill,size);
	}
	mem->next = allocatedlist;
	allocatedlist = mem;
	return(mem);
}
void DeallocateEMSMemory(EMSMEM *mem)
{
	if (mem->inems) {
		union REGS regs;
		EMSMEM **p = &allocatedlist;
		regs.w.dx = mem->id.handle;
		regs.w.ax = 0x45;
		int86(0x67,&regs,&regs);
		while (*p ) {
			if (*p	== mem) {
				*p = mem->next;
				break;
			}
		}
	}
	else
		DeallocateMemory(mem->id.address);
	DeallocateMemory(mem);
}
void ResizeEMSMemory(EMSMEM *mem, long size)
{
	long oldsize = mem->size;
	if (mem->inems) {
		union REGS regs;
		int i;
		mem->size = size;
		oldsize = (oldsize+16383)>>14;
		size = (size+16383)>>14;
		if ( size != oldsize) {
			regs.w.bx = size;
			regs.h.ah = 0x51;
			regs.w.dx = mem->id.handle;
			int86 (0x67,&regs,&regs);
			if (regs.h.ah)
				fatal("EMS: not enough EMS memory");
			regs.w.dx = mem->id.handle;
			for (i= oldsize; i <size; i++)
				memset(pageit(mem->id.handle,0,i,TRUE),mem->fill,16384);
		}
	} else {
		BYTE *p;
		if (size > 65530L)
			fatal("EMS: not available- Image capacity is 64K");
		p = AllocateMemory(size);
		memset(p+oldsize,mem->fill,size - oldsize);
		memcpy(p,mem->id.address,oldsize);
		DeallocateMemory(mem->id.address);
		mem->id.address = p;
		mem->size = size;
	}
}
BYTE *PtrToEMSMem(EMSMEM *mem, long offset)
{
	if (mem->inems) {
		union REGS regs;
		int p = offset >> 14;
		regs.w.dx = mem->id.handle;
		pageit(mem->id.handle,0,p,TRUE);
		pageit(mem->id.handle,1,++p,FALSE);
		return(pageframe + (offset & 0x3fff));
	} else
		return(mem->id.address + offset);
}
#ifdef TESTIT
main()
{
	EMSMEM *mem;
	BYTE *p;
	long i;
	MemoryInit(0xffff);
	mem = AllocateEMSMemory(200000,0x44);
 	p = PtrToEMSMem(mem, 0*16384L);
	memset(p,0,10000);
	ResizeEMSMemory(mem,16382);

	for (i=0; i < 1*16384L; i++) {
		p = PtrToEMSMem(mem,i);
		printf("%06lx: %02x\n",i,*p);
	}
	MemoryRundown();
}
#endif