#include <stdio.h>
#include <string.h>
#include <malloc.h>
#include "cmdline.h"
#include "umem.h"
#include "data.h"
#include "section.h"
#include "public.h"
#include "lexpr.h"
#include "partit.h"
#include "input.h"
#include "errors.h"
#include "module.h"

extern LIST *sectionlist;
extern char *prm_specifier;
extern BOOL prm_relocatable;
extern BOOL prm_debug;

LDESCRIPTION *partitions = 0;
static void CheckNoOverlay(LEXPRESSION *e, char *name)
{
	while (e) {
		if (e->type == EXP_NUMBER)
			SpecError("Attempt to set number of non-overlay %s failed", name);
		e = e->left;
	}
}
void AddPartition( LDESCRIPTION *l)
{
	LDESCRIPTION **p = & partitions;
	while (*p)
		p = *p;
	*p = l;
}
LDESCRIPTION *MakePartition(LDESCRIPTION *l, char *name, LEXPRESSION *e)
{
	LDESCRIPTION *p = AllocateMemory(sizeof(LDESCRIPTION));
	CheckNoOverlay(e,name);
	p->name = AllocateMemory(strlen(name) + 1);
	strcpy(p->name, name);
	p->type = TY_PARTITION;
	p->exp = e;
	p->sidelink = 0;
	p->downlink = l;
	p->virtual = 0;
	return(p);
}
LDESCRIPTION *MakeOverlay(LDESCRIPTION *l, char *name, LEXPRESSION *e)
{
	LDESCRIPTION *p = AllocateMemory(sizeof(LDESCRIPTION));
	LEXPRESSION *r = e;
	while (r) {
		if (r->type != EXP_NUMBER)
			SpecError("Attempt to set attribs on overlay %s failed", name);
		r = r->left;
	}
	p->name = AllocateMemory(strlen(name) + 1);
	strcpy(p->name, name);
	p->type = TY_OVERLAY;
	p->exp = e;
	p->sidelink = 0;
	p->downlink = l;
	return(p);
}
static void CheckRegionNoPC(LEXPRESSION *e, char *name)
{
	if (!e)
		return;
	CheckRegionNoPC(e->left,name);
	CheckRegionNoPC(e->right,name);
	if (e->type == EXP_PC)
		SpecError("Can't use PC relative in region %s",name);
}
LDESCRIPTION *MakeRegion(LDESCRIPTION *l, char *name, LEXPRESSION *e)
{
	LDESCRIPTION *p = AllocateMemory(sizeof(LDESCRIPTION));
	CheckNoOverlay(e,name);
	p->name = AllocateMemory(strlen(name) + 1);
	strcpy(p->name, name);
	p->type = TY_REGION;
	CheckRegionNoPC(e,name);
	p->exp = e;
	p->sidelink = 0;
	p->downlink = l;
	return(p);
}
LDESCRIPTION *MakeSymbol(char *name, LEXPRESSION *e)
{
	LDESCRIPTION *p = AllocateMemory(sizeof(LDESCRIPTION));
	p->name = AllocateMemory(strlen(name) + 1);
	strcpy(p->name, name);
	p->type = TY_SYMBOL;
	p->exp = e;
	p->sidelink = 0;
	p->downlink = 0;
	return(p);
}
LDESCRIPTION *MergeList(LDESCRIPTION *l1, LDESCRIPTION *l2)
{
	LDESCRIPTION *p = l1;
	if (l1) {
		while (p->sidelink)
			p = p->sidelink;
		p->sidelink = l2;
		return(l1);
	}
	return(l2);
}
static void DeletePartition(LDESCRIPTION *p)
{
	if (!p)
		return;
	DeletePartition(p->downlink);
	DeletePartition(p->sidelink);
	DeallocateMemory(p->name);
	DeallocateMemory(p);
}
void DeletePartitions(void)
{
	DeletePartition(partitions);
}
void AddDebugPartition(char *name)
{
	LDESCRIPTION *p,*o,*r;
	p = AllocateMemory(sizeof(LDESCRIPTION));
	p->type = TY_PARTITION;
	p->sidelink = 0;
	o = p->downlink = AllocateMemory(sizeof(LDESCRIPTION));
	o->type = TY_OVERLAY;
	o->sidelink = 0;
	r = o->downlink = AllocateMemory(sizeof(LDESCRIPTION));
	r->type = TY_REGION;
	r->sidelink = 0;
	r->downlink = 0;
	r->exp = o->exp = 0;
	p->exp = AllocateMemory(sizeof(LEXPRESSION));
	p->exp->type = EXP_ADDRESS;
	p->exp->value = 0;
	p->exp->left = 0;
	p->name = AllocateMemory(sizeof(name)+1);
	strcpy(p->name,name);
	o->name = AllocateMemory(sizeof(name)+1);
	strcpy(o->name,name);
	r->name = AllocateMemory(sizeof(name)+1);
	strcpy(r->name,name);
	AddPartition(p);
}
void declaredebugpartitions(void)
{
	if (prm_debug) {
		LIST *l = sectionlist;
		while (l) {
			SECTION *s = l->data;
			if (!strcmp(s->name,"??LINE")) 
				AddDebugPartition(s->name);
			l = l->link;
		}
	}
}
void SetPartitions(int mode)
{
	LIST *l;
	SectionInit(mode);
	if (mode != RESOLVE)
		return;
	if (!partitions) {
		long address = 0;
		if (!prm_relocatable) {
			LIST *s = sectionlist;
			while (s) {
				SECTION *p = s->data;
				long t = (address+p->align-1)%p->align;
				p->loaded = TRUE;
				t = p->align -1 - t;
				if (!strncmp(p->name,"??",2))
					p->absbase = 0;
				else {
					address+= t;
					p->absbase = address;
					if (p->flags & SECTION_8051BITS)
						address = address + (p->base + p->size);
					else
						address = address + (p->base + p->size)/8;
				}
				while (p->link) {
					p->flags |= SECTION_ABSOLUTE;
					p = p->link;
				}
				p->flags |= SECTION_ABSOLUTE;
				s = s->link;
			}
		}
		if (!prm_debug) {
			LIST *s = &sectionlist;
			while (s->link) {
				if (!strcmp(((SECTION*)s->link->data)->name,"??LINE")) {
					s->link = s->link->link;
					break;
				}
				s = s->link;
			}
		}
	}
	else {
		long address = 0, oaddress;
		LDESCRIPTION *p = partitions;
		long total_size = 0;
		declaredebugpartitions();
		while (p) {
			if (p->type == TY_PARTITION) {
				LEXPRESSION *e = p->exp;
				LDESCRIPTION *o = p->downlink;
				address+=total_size;
				p->roundsize = -1;
				p->maxsize = -1;
				p->align = -1;
				p->size = 0;
				p->virtual = 0;
				while (e) {
					switch (e->type) {
						case EXP_ADDRESS:
							address = e->value;
							break;
						case EXP_SIZE:
							if (e->value < 0)
								fatal("Bad size in spec file ");
							p->maxsize = e->value;
							break;
						case EXP_ROUNDSIZE:
							if (e->value < 2)
								fatal("Bad round size in spec file ");
							p->roundsize = e->value;
							break;
						case EXP_ALIGN:
							p->align = e->value;
							break;
						case EXP_VIRTUAL:
							if (e->value == -1)
								p->virtual = address;
							else
								p->virtual = e->value;
							break;
						default:
							SpecError("Internal error 3");
					}
					e = e->left;
				}
				if (p->align != -1) {
					long t = (address+p->align-1)%p->align;
					t = p->align -1 - t;
					address+= t;
				}
				p->address = address;
				while (o) {
					if (o->type == TY_OVERLAY) {
						LDESCRIPTION *r = o->downlink;
						SECTION *lastfound = 0;
						BOOL first = TRUE;
						oaddress = address;
						o->address = oaddress;
						o->size = 0;
						o->maxsize = p->maxsize;
						o->roundsize = p->roundsize;
						o->align = p->align;
						o->virtual = p->virtual;
						while (r) {
							if (r->type == TY_REGION) {
								LEXPRESSION *e = r->exp;
								LDESCRIPTION *sy = r->downlink;
								SECTION *found = 0;
								long t;
								long oldoaddress = oaddress;
								LIST *l;
								r->maxsize = -1;
							  r->roundsize = -1;
								r->align = -1;
								r->size =0;
								r->virtual = o->virtual;
								while (e) {
									switch (e->type) {
										case EXP_ADDRESS:
											if (e->value < oaddress)
												fatal("non-ascending addresses");
											if (first) {
												o->address = oaddress = oldoaddress = e->value;
											}
											else {
											/*	o->size += e->value - oaddress; */
												oaddress = e->value;
											}
											break;
										case EXP_SIZE:
											if (e->value < 0)
												fatal("Bad size in spec file");
											r->maxsize = e->value;
											break;
										case EXP_ROUNDSIZE:
											if (e->value < 2)
												fatal("Bad round size in spec file");
											r->roundsize = e->value;
											break;
										case EXP_ALIGN:
											r->align = e->value;
											break;
										case EXP_VIRTUAL:   
											fatal("Virtual not allowed on regions");
										default:
											SpecError("Internal error 4");
									}
									e = e->left;
								}
								first = FALSE;
								l = sectionlist;
								while (l) {
									SECTION *s = l->data;
									if (!strcmp(s->name,r->name)) {
										found = s;
										break;
									}
									l = l->link;
								}
								if (r->align != -1) {
									t = (oaddress+r->align-1)%r->align;
									t = r->align -1 - t;
									oaddress+= t;
								}
								if (found) {
									lastfound = found;
									found->virtual = o->virtual;
									found->loaded = TRUE;
									if (found->absbase)
										Error("Duplicating region %s not allowed",found->name);
									if (o->align == -1 && r->align == -1) {
										t = (oaddress+found->align-1)%found->align;
										t = found->align -1 - t;
										oaddress+= t;
									}
									found->absbase = oaddress;
									while (found->link) {
										found->flags |= SECTION_ABSOLUTE;
										found = found->link;
									}
									found->flags |= SECTION_ABSOLUTE;
									r->size = found->size + found->base;
									r->sectype = found->flags & SECTION_8051BITS;
								}
								if (r->roundsize != -1) {
									t = (r->size-1)%r->roundsize;
									t = r->roundsize -1 - t;
									r->size+= t;
									if (found)
										found->size += t;
								}
								if (r->maxsize != -1) {
									if (r->size > r->maxsize)
										Error("Region %s exceeded size", r->name);
									r->size = r->maxsize;
									if (found) {
										found->parent->abssize = r->size;
									}
								}
								while (sy) {
									if (sy->type == TY_SYMBOL)
										AssignLinkerPublic(sy->name, evalLinkerExpr(sy->exp,oaddress, TRUE));
									sy = sy->sidelink;
								}
								r->address = oaddress;
								o->size +=oaddress - oldoaddress+r->size;
								oaddress += r->size;
							}
							else
								if (r->type == TY_SYMBOL)
									AssignLinkerPublic(r->name,evalLinkerExpr(r->exp,oaddress,FALSE));
							r = r->sidelink;
						}
						if (o->roundsize != -1) {
							long t = (o->size-1)%o->roundsize;
							t = o->roundsize -1 - t;
							o->size+= t;
						}
						if (o->maxsize != -1) {
							if (o->size > o->maxsize)
								Error("Overlay %s exceeded size", o->name);
							else 
								if (lastfound)
									lastfound->parent->abssize += o->maxsize - o->size;
							o->size = o->maxsize;
						}
					}
					else
						if (o->type == TY_SYMBOL)
							AssignLinkerPublic(o->name,evalLinkerExpr(o->exp,address,FALSE));
					if (o->size > p->size)
						p->size = o->size;
					o = o->sidelink;
				}
										
			}
			else
				if (p->type == TY_SYMBOL)
					AssignLinkerPublic(p->name,evalLinkerExpr(p->exp,0,TRUE));
			total_size = p->size;
			p=p->sidelink;
		}
	}
	l = sectionlist;
	while (l) {
		SECTION *p = l->data;
		p->buffer = AllocateEMSMemory(p->abssize,0xff);
		l = l->link;
	}
}