//===================================================================
// algorthm.hpp
//
// Version 1.1
//
// Written by:
//   Brent Worden
//   WordenWare
//   email:  Brent@Worden.org
//
// Copyright (c) 1998-1999 WordenWare
//
// Created:  August 28, 1998
// Revised:  April 10, 1999
//===================================================================

#ifndef _ALGORTHM_HPP_
#define _ALGORTHM_HPP_

#include "numerics.h"

NUM_BEGIN

template<class X, class Y>
inline double average(X x, Y y)
//-------------------------------------------------------------------
// Returns the average of elements in x and y.
//-------------------------------------------------------------------
{
    return x + (y - x) / 2.0;
};

template<class S, class T, class D>
void pairwdiff(S sfirst, S slast, T tfirst, T tlast, D dest)
//-------------------------------------------------------------------
// Computes the pairwise differences between the elements in
// [sfirst, slast) and the elements in [tfirst, tlast) and places
// them in dest.  dest must be large enough to hold all of the m * n
// differences, where m = slast - sfirst and n = tlast - tfirst.
//-------------------------------------------------------------------
{
    S i;
    T j;

    for(i = sfirst; i < slast; ++i){
        for(j = tfirst; j < tlast; ++j){
            *dest = *i - *j;
            ++dest;
        }
    }
};

template<class S, class T>
void walshavg(S first, S last, T dest)
//-------------------------------------------------------------------
// Computes the Walsh averages of the elements in [first, last) and
// places them in dest.  dest must be large enough to hold all of the
// n averages ( n = k * (k + 1) / 2, where k = last - first).
//-------------------------------------------------------------------
{
    S i, j;	
    
    for(i = first; i < last; ++i){
        for(j = i; j < last; ++j){
            *dest = average(*i, *j);
            ++dest;
        }
    }
};

NUM_END

#endif

//===================================================================
// Revision History
//
// Version 1.0 - 08/28/1998 - New.
// Version 1.1 - 04/10/1999 - Added Numerics namespace.
//                            Fixed pointer bug in walshavg.
//===================================================================
