#include <stdlib.h>
#include "repmaker.h"
#include "text_buf.h"

int ReportMaker::get_command(char* buf, int i, ADD_LIST* info,
    FIELD_LIST* flist)
    {
    i++;                    // Skip @
    ADDINFO_LAYOUT* add;
    switch(buf[i])
        {
        case 'd':           // date
            add = new ADDINFO_LAYOUT(loc(i - 1, bline), DATE_INFO,
                "");
            add->service[5] = 0;
            info->add(add, info->used_add);
            i += 4;
            break;
	case 'D':           // dd
            add = new ADDINFO_LAYOUT(loc(i - 1, bline), DATE_INFO,
                "");
            add->service[5] = 1;
            info->add(add, info->used_add);
            i += 2;
            break;
	case 'M':           // mm
            add = new ADDINFO_LAYOUT(loc(i - 1, bline), DATE_INFO,
                "");
            add->service[5] = 2;
            info->add(add, info->used_add);
            i += 2;
            break;
	case 'Y':           // yy
            add = new ADDINFO_LAYOUT(loc(i - 1, bline), DATE_INFO,
                "");
            add->service[5] = 3;
            info->add(add, info->used_add);
            i += 2;
            break;
	case 'n':           // record num
            add = new ADDINFO_LAYOUT(loc(i - 1, bline),
	        REC_NO_INFO, "");
            info->add(add, info->used_add);
            i += 2;
            break;
	case 'p':           // page
            add = new ADDINFO_LAYOUT(loc(i - 1, bline), PAGE_INFO,
                "");
            info->add(add, info->used_add);
            i += 4;
            break;
	default:           // "field name"
            int res = i - 1;
            i++;            // Skip "
            char* tok;

            tok = strtok(buf + i, " ");  // tok contains wrap x
            int fno = atoi(tok);
            i += strlen(tok) + 1;

            int wrapx = PAGE_WIDTH, wrapy = 1;

            FIELD_LAYOUT* fld = new FIELD_LAYOUT(rect(res, bline,
	        res + wrapx, bline + wrapy), fno);
            flist->add(fld, flist->used_fields);
            break;
        }
    return i;
    }
///////////////////////////////
int ReportMaker::get_band(ADD_LIST* info, FIELD_LIST* flist)
    {
    char buf[255];
    int band_top = line;

    while(1)        // Skip white and comments
        {
        fgets(buf, 255, f);
        if(!strcmp(buf, "PAGETOP\n")   || !strcmp(buf, "PAGEBOTTOM\n")   ||
           !strcmp(buf, "TABLETOP\n")  || !strcmp(buf, "TABLEBOTTOM\n")  ||
           !strcmp(buf, "RECORDTOP\n") || !strcmp(buf, "RECORDBOTTOM\n") ||
           !strcmp(buf, "RECORD\n"))
           break;
        line++;
        band_top++;
        }

    while(1)
        {
        fgets(buf, 255, f);
        if(buf[strlen(buf) - 1] == '\n')
            buf[strlen(buf) - 1] = '\0';

        if(!strcmp(buf, "PAGETOP")   || !strcmp(buf, "PAGEBOTTOM")   ||
           !strcmp(buf, "TABLETOP")  || !strcmp(buf, "TABLEBOTTOM")  ||
           !strcmp(buf, "RECORDTOP") || !strcmp(buf, "RECORDBOTTOM") ||
           !strcmp(buf, "RECORD"))
           {
           bline = 0;
	   return band_top;
           }
        int res = 0;
        for(int i = 0; i < 255 && buf[i] != '\0'; i++)
            {
            if(buf[i] == '@')
                {
		buf[i] = '\0';
                ADDINFO_LAYOUT* add = new ADDINFO_LAYOUT(loc(res, bline),
		    TEXT_INFO, buf + res);

                info->add(add, info->used_add);
                buf[i] = '@';
                i = get_command(buf, i, info, flist);
                while(buf[i] == ' ')
                    i++;
                res = i;
                }
	    }
        buf[strlen(buf) + 1] = '\0';
        buf[strlen(buf)] = '\n';
        ADDINFO_LAYOUT* add = new ADDINFO_LAYOUT(loc(res, bline), TEXT_INFO,
	    buf + res);
        info->add(add, info->used_add);

        line++;
        bline++;
	}
    }
///////////////////////////
PAGE_LAYOUT* ReportMaker::getPageLayout(char* fileName)
    {
    if((f = fopen(fileName, "r")) == NULL)
        return NULL;

    ADD_LIST* p_top_info = new ADD_LIST();
    ADD_LIST* t_top_info = new ADD_LIST();
    ADD_LIST* r_top_info = new ADD_LIST();

    RECORD_LAYOUT* rec = new RECORD_LAYOUT();

    ADD_LIST* r_bottom_info = new ADD_LIST();
    ADD_LIST* t_bottom_info = new ADD_LIST();
    ADD_LIST* p_bottom_info = new ADD_LIST();

    int pt = get_band(p_top_info);
    int tt = get_band(t_top_info);
    int rt = get_band(r_top_info);

    get_band((ADD_LIST*)rec, (FIELD_LIST*)rec);

    int rb = get_band(r_bottom_info);
    int tb = get_band(t_bottom_info);
    int pb = get_band(p_bottom_info);

    PAGE_LAYOUT* page = new PAGE_LAYOUT(
	pt, // p_band_top
	pb, // p_band_bottom,
	tt, // t_band_top,
	tb, // t_band_bottom*,
	rt, // r_band_top,
	rb, // r_band_bottom,
	p_top_info, p_bottom_info, t_top_info, t_bottom_info, r_top_info,
	r_bottom_info, rec);

    fclose(f);
    return page;
    }
//////////////////////////////

#include "rep_man.h"
void main()
    {
    if(PXInit() != PXSUCCESS)
	return;

    KH_PXTable* table = new KH_PXTable("demo.db");

    ReportMaker* rm = new ReportMaker();

    PAGE_LAYOUT* page = rm->getPageLayout("work.rpt");

    ReportManager* report = new ReportManager(page, table, DRAFT,
	LABELS_AS_IS); // l_format

    report->print();

    delete table;

    delete page->pg_top_info;
    delete page->pg_bottom_info;
    delete page->tb_top_info;
    delete page->tb_bottom_info;
    delete page->rc_top_info;
    delete page->rc_bottom_info;

    delete page->record;

    delete page;
    delete report;
    delete rm;

    PXExit();
    }
