#include "button.h"
#include "patterns.h"
#include "khbgi.h"

Button::Button(rect r, char* txt, BORDERS b_type, int pat)
     : Press(r, b_type)
    {
    if(txt)
        text = strdup(txt);
    else
        text = NULL;
    pattern = pat;
    }
/////////////////////////
void Button::show()
    {
    settextstyle(DEFAULT_FONT, HORIZ_DIR, 1);
    settextjustify(CENTER_TEXT, CENTER_TEXT);
    setcolor((int)pColorSet->colors.ATTR_COLOR);

    rect r = screenRect(rectangle);
    bar(r, (int)pColorSet->colors.BAK_COLOR,
        (int)pColorSet->colors.FILL_COLOR, (uchar*)::pattern[pattern]);
    int i;
    char* txt = text;
    for(i = 0; txt = strchr(txt, '\n'); i++) // counts '\n' in string
	txt++;
    int start = i * textheight("L") * 5 / 8;  // start for few lines
						      // output
    txt = text;
    char t[80];                               // maximum length
    while(i > 0)
	{
	memset(t, '\0', 79);
	int n = strchr(txt, '\n') - txt;
	strncpy(t, txt, n);
	::outtextxy(r.origin.X + r.width() / 2,
		r.origin.Y + r.height() / 2 - start, t);
	txt += n + 1; i--;
	start -= textheight("L") * 5 / 4;
	}
    ::outtextxy(r.origin.X + r.width() / 2,
		r.origin.Y + r.height() / 2 - start, txt);
    Frame::show();
    }
/////////////////////
/*
void main()
    {
    if(!init_KNOW_HOW())
        return;
    setfillstyle(SOLID_FILL, pColorSet->colors.BAK_COLOR);
    bar(0, 0, getmaxx(), getmaxy());

    Button b(rect(1, 1, 15, 6), "HELLO,\nWORLD\n!!!", SHOW_BORDER, 16);
    b.show();
    b.exe();

    close_KNOW_HOW();
    closegraph();
    }
*/