#include "blipxtab.h"
#include "stdicons.h"

BlockIPXTable::BlockIPXTable(rect coordinates,
	       char* tabName,
	       char* fName,
	       char* h,
	       int s,
	       BORDERS b_type,
	       BORDERS hdr_b_type,
	       int res,
	       int hdr_pat,
	       int elem_pat,
	       int fNo,
	       char** fields,
	       char** types)
	: BlockPXTable(coordinates, tabName, fName, h, s, b_type,
	       hdr_b_type, res, hdr_pat, elem_pat, fNo, fields, types)
    {
    int xl = coordinates.origin.X + 1;
    int yt = coordinates.corner.Y - 2;

    f_first_button = new Icon(loc(xl + 13, yt), ICON_FIND_FIRST, SMALL_ICON,
	BUTTON_BORDER);
    f_next_button = new Icon(loc(xl + 17, yt), ICON_FIND_NEXT,
	SMALL_ICON, BUTTON_BORDER);
    rotate_button = new Icon(loc(xl + 21, yt), ICON_ROTATE, SMALL_ICON,
	BUTTON_BORDER);
    edit_button = new Icon(loc(xl + 25, yt), ICON_EDIT, SMALL_ICON,
	BUTTON_BORDER);

    add(f_first_button);
    add(f_next_button);
    add(rotate_button);
    add(edit_button);

    assign(table, f_first_button, AC_FIND_FIRST);
    assign(table, f_next_button, AC_FIND_NEXT);
    assign(table, rotate_button, AC_NEXT);
    assign(table, edit_button, AC_EDIT);
    }
/////////////////////////////////
void BlockIPXTable::rearrange()
    {
    BlockPXTable::rearrange();
    rect r;
    rect coord = textRect(r = w1->bound());

    int xl = r.origin.X + 1;
    int yt = r.corner.Y - 2;

    f_first_button->repose(rect(xl + 13, yt, xl + 16, yt));
    f_next_button->repose(rect(xl + 17, yt, xl + 24, yt));
    rotate_button->repose(rect(xl + 21, yt, xl + 31, yt));
    edit_button->repose(rect(xl + 25, yt, xl + 31, yt));
    }
/////////////////////////
/*
void main()
    {
    if(!init_KNOW_HOW())
	return;
    if(PXInit() != PXSUCCESS)
	return;

    setfillstyle(SOLID_FILL, pColorSet->colors.BAK_COLOR);
    bar(0, 0, getmaxx(), getmaxy());

    BlockIPXTable w(rect(10, 2, 78, 18), "demo.db", "window.pcy",
	" KNOW-HOW 4.x", 3, SHOW_BORDER, SHOW_BORDER, MOVE | RESIZE, 19, 0);

    w.show_window();
    w.exe();
    w.hide();

    PXExit();
    close_KNOW_HOW();
    closegraph();
    }
*/