#include "ask.h"
#include "editl.h"

#define min(x,y) (x>y)?y:x
#define max(x,y) (x<y)?y:x

Ask::Ask(rect coordinates, char* tabName, KH_STRTABLE* fields,
	       char* fName, int s,
	       BORDERS b_type, int res, int pat, int hdr_pat)
   :  KH_AbstractTable(coordinates, fName, "", s,
	       /*columnNumber*/ fields->used,
	       /*int* wid */ NULL, /*int* colNum */ NULL,
	       b_type, NO_BORDER, res, pat, hdr_pat)
    {
    tableName = strdup(tabName);
    mode = KH_EDIT_TABLE;

    querry = new KH_STRTABLE(fields->used, NULL);
    examples = new KH_STRTABLE(fields->used, NULL);
    checkers = new char[255];
    memset(checkers, '\0', 255);
    fieldNames = fields;

    colNumbers = new int[nColumns + 1];
    for(int i = 0; i < nColumns + 1; i++)
	colNumbers[i] = i;
    iColWidth = new int[nColumns + 1];
    for(xCurs = 0; xCurs < nColumns; xCurs++)
	{
	iColWidth[xCurs] = getFieldMaxWidth();
	}
    xCurs = 0;

    yScreen = 2;
    }
/////////////////////////////////////
void Ask::getFieldName(char* name, int n)
    {
    strcpy(name, fieldNames->strings[n - 1]);
    }
/////////////////////////////////////
int Ask::getFieldMaxWidth()
    {
    int x = 0;
    if(querry->strings[xCurs][0] != '\0')
	x = strlen(querry->strings[xCurs]);
    if(examples->strings[xCurs][0] != '\0')
	x = strlen(examples->strings[xCurs]);

    return max(x + 4, strlen(fieldNames->strings[xCurs]) + 2);
    }
//////////////////////////////////////
void Ask::show()
    {
    KH_AbstractTable::show();
    setfillstyle(SOLID_FILL, pColorSet->colors.HILITE_COLOR);
    setcolor(pColorSet->colors.FILL_COLOR);
    rect r = bound();
    r.origin.X = r.corner.X - (strlen(tableName) + 1) * pScreenSet->cell_width;
    r.origin.Y = r.corner.Y - pScreenSet->standart_height;
    bar(r);
    settextstyle(DEFAULT_FONT, HORIZ_DIR, 1);
    settextjustify(LEFT_TEXT, BOTTOM_TEXT);
    outtextxy(r.origin.X + 1, r.corner.Y, tableName);
    }
//////////////////////////////////////
void Ask::showField(int sx, int x, int y, int flag, int /*field_type*/)
    {
    rect r = user_screen();
    int endx = r.corner.X < r.origin.X + screenXL(sx + iColWidth[x] - 1)
	    ? r.corner.X : r.origin.X + screenXL(sx + iColWidth[x] - 1);
    setviewport(r.origin.X + screenXL(sx + 1), r.origin.Y,
		endx, r.corner.Y, 1);

    if(flag)
	bar(2, screenYT(y - yStart + 1) + 2,
		endx - 2, screenYT(y - yStart + 2) - 2);
    settextjustify(LEFT_TEXT, CENTER_TEXT);

    if(checkers[x])
	{
	char buf[2];
	buf[0] = '';
	buf[1] = '\0';
	setcolor(pColorSet->colors.MARK_COLOR);
	setfillstyle(SOLID_FILL, pColorSet->colors.MARK_BAK_COLOR);
	bar(0, pScreenSet->cell_height + 2,
	    pScreenSet->cell_width, 2 * pScreenSet->cell_height - 2);
	outtextxy(0, 3 * pScreenSet->cell_height / 2, buf);
	}

    int exs = pScreenSet->cell_width;
    int exe = exs + strlen(examples->strings[x]) * pScreenSet->cell_width;
    if(examples->strings[x][0] != '\0')
	{
	setcolor(pColorSet->colors.ATTR_COLOR);
	setfillstyle(SOLID_FILL, pColorSet->colors.FILL_COLOR);

	bar(exs, pScreenSet->cell_height + 2, exe,
	    2 * pScreenSet->cell_height - 2);
	outtextxy(exs, 3 * pScreenSet->cell_height / 2, examples->strings[xCurs]);
	}

    setcolor(BLACK);
    if(querry->strings[x][0] != '\0')
	outtextxy(exe, 3 * pScreenSet->cell_height / 2, querry->strings[x]);

    setviewport(0, 0, getmaxx(), getmaxy(), 1);
    }
///////////////////////////////
void Ask::editField()
    {
    rect r = user_screen();

    setviewport(r.origin.X, r.origin.Y, getmaxx(), getmaxy(), 1);
    EditLine* editl
	    = new EditLine(loc(0, 0),
                  min(iColWidth[colNumbers[xCurs]], rectangle.width() - 3),
		  QUERRY_MAX_LEN, BUTTON_BORDER, 0, 1);
    editl->put_string(querry->strings[xCurs]);
    editl->show();
//    do {
	editl->exe();
//       } while(!check_type(type, global[global_num]));

    setviewport(0, 0, getmaxx(), getmaxy(), 1);
    delete querry->strings[xCurs];
    querry->strings[xCurs] = strdup(global[global_num]);
    delete editl;

    if(strlen(querry->strings[xCurs]) + strlen(examples->strings[xCurs])
	+ 3 > iColWidth[colNumbers[xCurs]])
	{
	iColWidth[colNumbers[xCurs]] = strlen(querry->strings[xCurs])
		 + strlen(examples->strings[xCurs]) + 3;
	show();
	}
    else
	{
	r.origin.Y += pScreenSet->cell_height;
	line_table(r);
	setfillstyle(SOLID_FILL, WHITE);
	showField(xPos, colNumbers[xCurs], yCurs, 1, getFieldType(colNumbers[xCurs], yCurs));
	}
    mouseShowCursor();
    }
////////////////////////////////////
int Ask::searchField(int ask)
    {
    if(!ask)
	{
	if(checkers[xCurs])
	    checkers[xCurs] = '\0';
	else
	    checkers[xCurs] = '\1';
	return 1;
	}
    rect r = user_screen();

    setviewport(r.origin.X, r.origin.Y, getmaxx(), getmaxy(), 1);
    EditLine* editl
	= new EditLine(loc(0, 0),
        min(iColWidth[colNumbers[xCurs]], rectangle.width() - 3),
		  EXAMPLE_MAX_LEN, BUTTON_BORDER, 0, 1);
    editl->put_string(examples->strings[xCurs]);
    editl->show();
//    do {
	 editl->exe();
//       } while(!check_type(type, global[global_num]));

    delete examples->strings[xCurs];
    examples->strings[xCurs] = strdup(global[global_num]);
    delete editl;

    if(strlen(querry->strings[xCurs]) + strlen(examples->strings[xCurs])
	+ 3 > iColWidth[colNumbers[xCurs]])
	iColWidth[colNumbers[xCurs]] = strlen(querry->strings[xCurs])
		 + strlen(examples->strings[xCurs]) + 3;

    setviewport(0, 0, getmaxx(), getmaxy(), 1);

    r.origin.Y += pScreenSet->cell_height;
    line_table(r);

    mouseShowCursor();
    setfillstyle(SOLID_FILL, WHITE);

    return 1;
    }
/////////////////////////////
void Ask::touch(int)
    {
    global_num = fieldNames->used;
    delete global[0];
    global[0] = strdup("Ask");
    for(int i = 1; i <= global_num; i++)
	{
	delete global[i];
	global[i] = strdup(querry->strings[i - 1]);
	}

    delete global[i];
    global[i++] = strdup(checkers);
    delete global[i + 1];
    global[i + 1] = strdup(tableName);

    for(; i <= 2 * global_num + 3; i++)
	{
	delete global[i];
	global[i] = strdup(examples->strings[i - 1]);
	}
    }
///////////////////////////
/*
void main()
    {
    if(!init_KNOW_HOW())
	return;
    setfillstyle(SOLID_FILL, pColorSet->colors.BAK_COLOR);
    bar(0, 0, getmaxx(), getmaxy());

    char* s[] = { "One", "Two", "Three", "Four", "Five" };
    KH_STRTABLE* fields = new KH_STRTABLE(5, s);

    Ask w(rect(10, 10, 50, 13), "demo.db", fields, "window.pcy", 0);

    w.show_window();
    w.exe();
    w.hide();

    close_KNOW_HOW();
    closegraph();
    }
*/