// This is disk array library version 1.0 beta release for C++.
// Programmed by Rubtsov Grigorii, 11.23.97.
// This library allows to make arrays on disk.
// See disk_arr.txt for more information

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

template <class T> class disk_arr_line;
template <class T> class disk_arr_element;

template <class T>
class disk_arr {
private:
	FILE *memfile;
   char *file_name;
	const long xsize, ysize;
   const bool ftype;
   const bool rcheck;
   bool 	fstatus;
   T* zero_value;
   void range_error(long x, long y) const;
   friend class disk_arr_line<T>;
   friend class disk_arr_element<T>;
public:
	disk_arr(char *, long, long, const T&, bool type=false, bool check=false);
	disk_arr(const disk_arr&);
 	~disk_arr();
   bool operator!() const { return (!fstatus); }
   disk_arr_line<T> operator[](long x) {
                      disk_arr_line<T> temp(x, this); return temp; }
};


template <class T>
disk_arr<T>::disk_arr(char *fname, long x, long y, const T& zero, bool type=false, bool check=false):
  xsize(x), ysize(y), ftype(type), rcheck(check)
{
   zero_value = new T(zero);
   char* bytes;
	file_name = new char[strlen(fname)+1];
   strcpy(file_name, fname);
	if (ftype) {
   	memfile = fopen(fname, "r+b");
	 	if (memfile) {
        fstatus = true;
        return;
      }
   }
  	memfile = fopen(fname, "w+b");
  	if (!memfile) {
     	fstatus = false;
     	return;
  	}
  	fstatus = true;
  	bytes=(char*)zero_value;
	for(long c1=0; c1<(xsize*ysize); c1++)
  		for(int c2=0; c2<sizeof(T); c2++)
  			fprintf(memfile, "%c", bytes[c2]);
  	return;
}


template <class T>
disk_arr<T>::disk_arr(const disk_arr& a): xsize(0), ysize(0), ftype(a.ftype), rcheck(0)
{
	printf("\a\aError: disk_arr objects cannot be copied, \r\n");
   printf("passed to function by value or returned from\r\n");
   printf("function by value. \r\n");
   printf("Other words: copy constructor can't be called.\r\n");
   fclose(memfile);
   abort();
}


template <class T>
disk_arr<T>::~disk_arr()
{
	fclose(memfile);
   if (!ftype) remove(file_name);
   delete []file_name;
   delete zero_value;
   return;
}

template <class T>
void disk_arr<T>::range_error(long x, long y) const
{
	fprintf(stderr, "Range check error in file %s,\r\n", file_name);
   fprintf(stderr, "X=%li, Y=%li, maxX=%li, maxY=%li.\r\n",x, y, xsize-1, ysize-1);
   abort();
}


template <class T>
class disk_arr_line {
private:
	const long x;
   disk_arr<T>* a;
   disk_arr_line(long x1, disk_arr<T>* a1):
   					x(x1), a(a1) {}
   friend class disk_arr<T>;
public:
   disk_arr_element<T> operator[](long y) {
   							disk_arr_element<T> temp(x, y, a); return temp; }
};

template <class T>
class disk_arr_element {
private:
	const long x;
   const long y;
   disk_arr<T>* a;
   disk_arr_element(long x1, long y1, disk_arr<T>* a1):
                   x(x1), y(y1), a(a1) {}
   friend disk_arr_line<T>;
public:
   disk_arr_element<T> operator= (const T& r);
   disk_arr_element<T> operator= (disk_arr_element<T> el)
   										{ return (operator=(T(el))); }
   operator T() const;
};


template <class T>
disk_arr_element<T> disk_arr_element<T>::operator=(const T& r)
{
   char* bytes;
	if ((x>=a->xsize)||(x<0)||(y<0)||(y>=a->ysize))
   	if(a->rcheck==true) a->range_error(x, y);
     		else return (*this);
	fseek(a->memfile, sizeof(T)*(a->ysize*x+y), 0);
   bytes=(char*)&r;
   for(unsigned int c2=0; c2<sizeof(T); c2++)
   			fprintf(a->memfile, "%c", bytes[c2]);
   return (*this);
}

template <class T>
disk_arr_element<T>::operator T() const
{
	if ((x>=a->xsize)||(x<0)||(y<0)||(y>=a->ysize))
   	if(a->rcheck==true) a->range_error(x, y);
      else return *(a->zero_value);

   char* bytes;
	T* r;
   r = new T;
   bytes=(char*)r;
	fseek(a->memfile, sizeof(T)*(a->ysize*x+y), 0);
   for(unsigned int c2=0; c2<sizeof(T); c2++)
		fscanf(a->memfile, "%c", &bytes[c2]);
   delete r;
   return (*r);
}
