/***********************************************************************

                       CSA Library, Free Evaluation Version 2.1.1 
                                           Release: May 14th 1997 

       Header file for the directory class.

       This class can be used to travers through a
       directory to obtain all file names.
       It ignores all file attributes.

       There is no support for a recursive descent.

                                           Copyright(c) 1994-1997 
                                                          ComBits 
                                                  The Netherlands 
***********************************************************************/
#ifndef __CSDIR_H
#define __CSDIR_H


#include "cstypes.h"
#include "csdate.h"
#include "csfile.h"


/////////////////////////////////////////////////////////////////////////////
////////////////////// The CSDIR class //////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////



class CSDIR: public csDATE, public FILE_NAME
{

#if (defined( _CP_030))
      struct stat    statbuf;
      struct dirent *dirp;
      DIR           *dp;
#endif

#if (defined( _CP_001))
      int first;
      csSTR nam;
      struct ffblk  ff;
#endif

#if (defined( _CP_002a) || defined(_CP_002c))
      int first;
      csSTR nam;
      struct _find_t  ff;
#endif

#if (defined( _CP_002b) )
      int first;
      csSTR nam;
      struct _finddata_t  ff;
      long hFile;
#endif

#if (defined(_CP_004))
      int first;
      csSTR nam;
      struct find_t  ff;
#endif


  private:
      int     IsOpen;
      csCHAR *NameBuf;
      csCHAR *p;


   public:


      CSDIR(void);
      virtual
     ~CSDIR(void);

      int open(csCHAR *name);  // 'Open' a directoru for reading.
      int rewind(void);        // Done automatically by open();
      int read(void);          // Read the next entry.

      // 0 = error, 1=dir, 2=file, 3=something else
      int type(void);
      int close(void);
      long size(void);

};




#endif
