#
# This is CalcPlus interpreter makefile.
#
# Uncomment or change CC and LINK to your C++ compiler
# and specify your version of YACC if necessary.
#

YACC = pcyacc

# ========= Borland C++ ========
#
# CC   = bcc -ml
# LINK = bcc -ml -ecalc
#

# =========== MSVC =============
#
# CC   = cl -AL
# LINK = cl -AL -Fecalc -F 7FFF
#

# ========= Watcom C++ =========
#
# CC   = wcl386 -mf -c
# LINK = wcl386 -mf -fe=calc
#

# ========= Zortech C++ ========
#
# CC   = ztc -mx -c
# LINK = ztc -mx -ocalc
#


OBJ = calcplus.obj calctype.obj calcexpr.obj calclib.obj calclex.obj yycalc.obj

calc.exe:       $(OBJ) calc.mak
                $(LINK) $(OBJ)

yycalc.cpp:     yycalc.yac
                if exist yycalc.cpp del yycalc.cpp
                $(YACC) -d yycalc.yac
                ren yycalc.c yycalc.cpp

yytab.h:        yycalc.cpp

yycalc.obj:     yycalc.cpp calctype.h calcexpr.h calclex.h
                $(CC) -c yycalc.cpp

calctype.obj:   calctype.cpp calctype.h
                $(CC) -c calctype.cpp

calclex.obj:    calclex.cpp calclex.h yytab.h
                $(CC) -c calclex.cpp

calclib.obj:    calclib.cpp calcexpr.h calclex.h calctype.h
                $(CC) -c calclib.cpp

calcexpr.obj:   calcexpr.cpp calcexpr.h calclex.h calctype.h
                $(CC) -c calcexpr.cpp

calcplus.obj:   calcplus.cpp yycalc.h calcexpr.h calclex.h
                $(CC) -c calcplus.cpp


