{$R-,V-,S-}
PROGRAM SUN_Comm;

{$M 40000,0,45000}

USES
   Crt, Dos, GlobType, PibTimer, PibAsync, Windows,
   Ansidrv, Tpz, MyDos, TpStack, Printer;

CONST Max = 150;
      MaxBuffer = 7168;
      MaxBufferLimit = 6656;
      Esc = #27;
      On  = 1;
      Off = 0;
      Pause = 2;
      Send = 1;
      Receive = 0;
      Open_Close : array[0..2] of String[5]
                 = ('Close','Open ','Pause');
      On_Off     : array[0..1] of String[3]
                 = ('OFF ','ON');
      Yes_No     : array[0..2] of String[3]
                 = ('N','Y','Y');
      Ctrl_Keys  : array['A'..'Z'] of Byte
                 = (1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,
                    23,24,25,26);
TYPE
    Str30 = String[30];
    PathType = String[255];
    BytePtr = ^BYTE;
    PtrRec = RECORD
                   Ofs,
                   Seg : WORD;
              END;
    ProtocolRec = record
                       Up,
                       Down : PathType;
                       Name : String[30];
                       Flag : Integer;
                  end;
    ProtoArray = array['A'..'G'] of ProtocolRec;
    FonBookRec = record
                       Name      : Str30;
                       Number    : Str30;
                       BaudRate  : Word;
                       Parity    : Char;
                       DataBits  : Integer;
                       StopBits  : Integer;
                 end;
    FonBookArray = Array[1..Max] of FonBookRec;
    MacrosRec  = record
                   Home_Key,
                   End_Key,
                   Up_Key,
                   Down_Key,
                   Left_Key,
                   Right_Key,
                   PageUp_Key,
                   PageDown_Key,
                   Ins_Key,
                   Del_Key          : String;
                end;
    ConfigRec = record
                BaudRate         : Word;             (* Baud rate for connection, e.g., 1200  *)
                ComPort          : Integer;          (* Which port, e.g., 1 for COM1:         *)
                Parity           : Char;             (* Parity, e.g., E for even parity       *)
                DataBits         : Integer;          (* How many bits per Character, e.g., 8  *)
                StopBits         : Integer;          (* How many stop bits -- nearly always 1 *)
                InBufSize        : Integer;          (* Size of input buffer                  *)
                OutBufSize       : Integer;          (* Size of output buffer                 *)
                Do_XonXoff       : Char;             (* 'Y' to do XON/XOFF flow control       *)
                Do_HardWired     : Char;             (* 'Y' to do XON/XOFF flow control       *)
                Do_CTS           : Char;             (* 'Y' to do CTS/RTS flow control        *)
                Do_DSR           : Char;             (* 'Y' to do DSR/DTR flow control        *)
                Do_Async_Status  : Byte;             (* Line error reporting off  *)
                Com_Addr_Str     : String[10];       (* Comm port address in hex string       *)
                Com_Addr         : Integer;          (* Comm port address                     *)
                Com_Irq          : Integer;          (* Comm port IRQ address                 *)
                Com_Int_No       : Integer;          (* Comm port interrupt vector number     *)
                LocalEcho        : Byte;
                DirectScreen     : Byte;
                MuteMode         : Byte;          (* No Sound *)
                LineFeeds        : Byte;
                ChatMode         : Byte;
                Protocols        : ProtoArray;
                FonBook          : FonBookArray;
                FilesPath        : String;
                HideStatusBar    : Byte;
                ToggleBackSpace  : Byte;
                Macros           : MacrosRec;
            end;
    BufferType = array[1..MaxBuffer] of Char;
    BufferRec  = Record
                    BufferArray    : BufferType;
                    BufferCounter  : Integer;
                    BufferFileName : String[12];
                    BufferStatus   : Byte;
                 end;
VAR
   CursorCol : Integer;
   CursorRow : Integer;
   WindowPtr : Pointer;

(************************************************************************)
{$I suninc.inc}
(************************************************************************)

PROCEDURE GetInt(VAR Number  : Integer;
                     Mode    : Byte);
VAR ExitOK  : Boolean;
    Str6    : String[6];
    Num     : LongInt;
    X       : Integer;
begin
     ExitOK := FALSE;
     Str6 := ' ';
     repeat
          case Mode of
               0 : readln(Str6);
               1 : read(Str6);
          end; {Case}
          val(Str6,Num,X);
          if (Num <= 32767) and (Num >= -32767)
             then ExitOK := TRUE;
     until ExitOK = TRUE;
     Number := Num;
end;

(************************************************************************)

PROCEDURE GetChar(VAR Chars : Char;
                      Mode  : Integer);
begin
     case Mode of
         0 : Chars := Readkey;
         1 : readln(Chars);
         2 : read(Chars);
     end; {case}
     Chars := upcase(Chars);
end;

(************************************************************************)

PROCEDURE GetStr(VAR TempStr : String;
                     Mode    : Integer);
begin
     case Mode of
         0 : readln(TempStr);
         1 : read(TempStr);
     end; {case}
end;

(************************************************************************)

PROCEDURE Clear_Config(VAR Config : ConfigRec);
VAR Lcv      : Integer;
    Counter  : Char;
begin
    with Config do
    begin
    for Counter := 'A' to 'G' do
    begin
         Protocols[Counter].Up   := ' ';
         Protocols[Counter].Down := ' ';
         Protocols[Counter].Name := ' ';
         Protocols[Counter].Flag := Off;
    end;
    for Lcv := 1 to Max do
    begin
        with FonBook[Lcv] do
        begin
           Name      := ' ';
           Number    := ' ';
           BaudRate  := 1200;
           Parity    := 'N';
           DataBits  := 8;
           StopBits  := 1;
        end;
    end;
    BaudRate        := 1200;         (* Baud rate for connection, e.g., 1200  *)
    ComPort         := 1;            (* Which port, e.g., 1 for COM1:         *)
    Parity          := 'N';          (* Parity, e.g., E for even parity       *)
    DataBits        := 8;            (* How many bits per Character, e.g., 8  *)
    StopBits        := 1;            (* How many stop bits -- nearly always 1 *)
    InBufSize       := 1024;         (* Size of input buffer                  *)
    OutBufSize      := 1024;         (* Size of output buffer                 *)
    Do_XonXoff      := 'N';          (* 'Y' to do XON/XOFF flow control       *)
    Do_HardWired    := 'N';          (* 'Y' to do XON/XOFF flow control       *)
    Do_CTS          := 'N';          (* 'Y' to do CTS/RTS flow control        *)
    Do_DSR          := 'N';          (* 'Y' to do DSR/DTR flow control        *)
    Do_Async_Status := Off;         (* Line error reporting off              *)
    Com_Addr_Str    := '02e8';       (* Comm port address in hex string       *)
    Com_Addr := Hex_To_Dec( Com_Addr_Str , -1 );
                                     (* Comm port address                     *)
    Com_Irq         :=  4;           (* Comm port IRQ address                 *)
    Com_Int_No      := -1;           (* Comm port interrupt vector number     *)
                                     (* Use -1 if Not Sure                    *)
    LocalEcho       := Off;
    DirectScreen    := On;
    MuteMode        := Off;          (* No Sound *)
    LineFeeds       := Off;
    ChatMode        := Off;
    FilesPath       := 'C:\programs';
    HideStatusBar   := Off;
    ToggleBackSpace := Off;
    with Macros do
    begin
    Home_Key        := ' ';
    End_Key         := ' ';
    Up_Key          := ' ';
    Down_Key        := ' ';
    Left_Key        := ' ';
    Right_Key       := ' ';
    PageUp_Key      := ' ';
    PageDown_Key    := ' ';
    Ins_Key         := ' ';
    Del_Key         := #127
    end; {with2}
    end; {with}
    DirectVideo     := TRUE;
end;


(************************************************************************)

PROCEDURE Install_Protocols(VAR Config : ConfigRec);
VAR Question,
    Counter  : Char;
    OldPath   : String[80];
begin
     window(1,1,80,25);
     WINDOWIN(white,blue,4,15,4,65,18,CursorCol,CursorRow,WindowPtr);
     while (Question <> Esc) do
     begin
     MAKEWINDOW(white,blue,4,0,15,4,65,18);
     textcolor(yellow);
     with Config do
     begin
     writeln('                Install Protocols');
     LINE(196,49,white);
     writeln;
     textcolor(yellow);
     for Counter := 'A' to 'G' do
        begin
             with Protocols[Counter] do
             begin
                writeln(Counter:15,' - ',Name);
             end; {with}
        end; {for}
     textcolor(lightgray);
     writeln;
     writeln('               Press ESC to Exit');
     OffCursor;
     Question := ReadKey;
     Question := Upcase(Question);
     OnCursor;
     if Question in ['A'..'G'] then
               begin
                    OldPath := Protocols[Question].Name;
                    SETSCREEN(black,white,0,5,20,75,20);
                    write(' Name: ',Protocols[Question].Name);
                    window(12,20,75,20);
                    textcolor(red);
                    readln(Protocols[Question].Name);
                    if length(Protocols[Question].Name) <= 1
                       then Protocols[Question].Name := OldPath;
                    OldPath := Protocols[Question].Up;
                    SETSCREEN(black,white,0,5,20,75,20);
                    write(' Up Path: ',Protocols[Question].Up);
                    window(15,20,75,20);
                    textcolor(red);
                    readln(Protocols[Question].Up);
                    if length(Protocols[Question].Up) <= 1
                       then Protocols[Question].Up := OldPath;
                    OldPath := Protocols[Question].Down;
                    SETSCREEN(black,white,0,5,20,75,20);
                    write(' Down Path: ',Protocols[Question].Down);
                    window(17,20,75,20);
                    textcolor(red);
                    readln(Protocols[Question].Down);
                    if length(Protocols[Question].Down) <= 1
                       then Protocols[Question].Down := OldPath;
                    Protocols[Question].Flag := 1;
                end;
     end; {while}
     WINDOWOUT(CursorCol,CursorRow,WindowPtr);
     end; {with}
end;

(************************************************************************)

PROCEDURE SaveConfig(VAR Config : ConFigRec);
VAR CfgFile    : Text;
    Counter    : Char;
    Lcv        : Integer;
BEGIN
  SETSCREEN(LightCyan+Blink,blue,0,10,21,70,21);
  write('                Saving Config File...');
  {$I-}
  chdir(Config.FilesPath);
  {$I+}
  Assign(CfgFile, 'SunCom.CFG');
  Rewrite(CfgFile);
  with Config do
  begin
  writeln(CfgFile,ComPort);
  writeln(CfgFile,BaudRate);
  writeln(CfgFile,Parity);
  writeln(CfgFile,DataBits);
  writeln(CfgFile,StopBits);
  writeln(CfgFile,LocalEcho);
  writeln(CfgFile,LineFeeds);
  writeln(CfgFile,ChatMode);
  writeln(CfgFile,MuteMode);
  writeln(CfgFile,InBufSize);
  writeln(CfgFile,OutBufSize);
  writeln(CfgFile,Do_XonXoff);
  writeln(CfgFile,Do_HardWired);
  writeln(CfgFile,Do_CTS);
  writeln(CfgFile,Do_DSR);
  writeln(CfgFile,Com_Addr_Str);
  writeln(CfgFile,Com_Addr);
  writeln(CfgFile,Com_IRQ);
  writeln(CfgFile,Com_INT_No);
  writeln(CfgFile,DirectScreen);
  writeln(CfgFile,Do_Async_Status);
  writeln(CfgFile,HideStatusBar);
  for Counter := 'A' to 'G' do
      begin
           writeln(CfgFile,Protocols[Counter].Name);
           writeln(CfgFile,Protocols[Counter].Up);
           writeln(CfgFile,Protocols[Counter].Down);
           writeln(CfgFile,Protocols[Counter].Flag);
      end; {for}
  writeln(CfgFile,FilesPath);
  for Lcv := 1 to Max do
      begin
           writeln(CfgFile,FonBook[Lcv].Name);
           writeln(CfgFile,FonBook[Lcv].Number);
      end;
  end; {with}
  close(CfgFile);
  delay(3000);
  writeln;
  window(3,3,77,21);
END (* SaveConfig *);

(****************************************************************************)

PROCEDURE Load_Macros(VAR Config : ConfigRec);
VAR CfgFile : Text;
begin
   {$I-}
   chdir(Config.FilesPath);
   assign(CfgFile,'SunCom.Mac');
   reset(CfgFile);
   {$I+}
   if IOresult <> 0
      then begin
                MAKEWINDOW(white,red,4,0,30,10,50,12);
                write(' *** IO ERROR ***',^G,^G);
                delay(10000);
                exit;
           end;
   with Config.Macros do
   begin
   readln(CfgFile,PageUp_Key);
   readln(CfgFile,PageDown_Key);
   readln(CfgFile,Home_Key);
   readln(CfgFile,End_Key);
   readln(CfgFile,Up_Key);
   readln(CfgFile,Down_Key);
   readln(CfgFile,Left_Key);
   readln(CfgFile,Right_Key);
   readln(CfgFile,Ins_Key);
   readln(CfgFile,Del_Key);
   end; {with}
   close(CfgFile);
end;

(****************************************************************************)

PROCEDURE Save_Macros(VAR Config : ConfigRec);
VAR CfgFile : Text;
begin
   {$I-}
   chdir(Config.FilesPath);
   {$I+}
   assign(CfgFile,'SunCom.Mac');
   rewrite(CfgFile);
   with Config.Macros do
   begin
   writeln(CfgFile,PageUp_Key);
   writeln(CfgFile,PageDown_Key);
   writeln(CfgFile,Home_Key);
   writeln(CfgFile,End_Key);
   writeln(CfgFile,Up_Key);
   writeln(CfgFile,Down_Key);
   writeln(CfgFile,Left_Key);
   writeln(CfgFile,Right_Key);
   writeln(CfgFile,Ins_Key);
   writeln(CfgFile,Del_Key);
   end; {with}
   close(CfgFile);
end;

(************************************************************************)

PROCEDURE Define_Macros(VAR Config : ConfigRec);
VAR
   Choice,
   YesNo       : Char;
LABEL Beginning;
BEGIN (* Get_Comm_Params *)
   with Config.Macros do begin
   WINDOWIN(white,blue,4,2,2,78,24,CursorCol,CursorRow,WindowPtr);
   writeln('                        SUN Comm Define Macro Keys');
   LINE(196,75,white);
   Beginning:
   OffCursor;
   window(3,5,77,23);
   textbackground(blue);
   textcolor(yellow);
   clrscr;
   writeln;
   writeln('     A - PgUp ');
   writeln('     B - PgDown ');
   writeln('     C - Home ');
   writeln('     D - End  ');
   writeln('     E - Up   ');
   writeln('     F - Down ');
   writeln('     G - Left ');
   writeln('     H - Right');
   writeln('     I - Ins  ');
   writeln('     J - Del  ');
   window(20,6,77,21);
   textcolor(white);
   writeln(PageUp_Key);
   writeln(PageDown_Key);
   writeln(Home_Key);
   writeln(End_Key);
   writeln(Up_Key);
   writeln(Down_Key);
   writeln(Left_Key);
   writeln(Right_Key);
   writeln(Ins_Key);
   writeln(Del_Key);
   window(3,17,77,22);
   textcolor(lightcyan);
   writeln('         ^n  -  Control Char + Letter     ^M  -  Carriage Return');
   writeln('         ^[  -  ESC                       ~   -  1 sec wait ');
   writeln('      ##000  -  To Send a ASCII/Graphic Char');
   textcolor(lightgray);
   writeln;
   write('                              ESC - To Exit');
   Choice := Readkey;
   Choice := upcase(Choice);
   OnCursor;
   if Choice = ESC
        then begin
                WINDOWOUT(CursorCol,CursorRow,WindowPtr);
                Exit;
             end;
   if Not(Choice in ['A'..'J','L','S'])
      then goto beginning;
   if Choice in ['A'..'J']
      then SETSCREEN(black,white,0,20,Ord(Choice)-59,77,Ord(Choice)-59);
   case Choice of
           'A' : GetStr(PageUp_Key,0);
           'B' : GetStr(PageDown_Key,0);
           'C' : GetStr(Home_Key,0);
           'D' : GetStr(End_Key,0);
           'E' : GetStr(Up_Key,0);
           'F' : GetStr(Down_Key,0);
           'G' : GetStr(Left_Key,0);
           'H' : GetStr(Right_Key,0);
           'I' : GetStr(Ins_Key,0);
           'J' : GetStr(Del_Key,0);
           'L' : Load_Macros(Config);
           'S' : Save_Macros(Config);
   end; {case}
   goto Beginning;
   end; {with}
end;   (* Define Macros *)

(****************************************************************************)

PROCEDURE ShowPortStatus(VAR Config : ConfigRec;
                         VAR Buffer : BufferRec);
VAR
  Lcv,
  X,
  Y,
  Top,
  Bottom    : BYTE;
  DispStr   : STRING;
  WkStr     : STRING[18];
BEGIN
  with Config do begin
  with Buffer do begin
    if (HideStatusBar = On) or (Config.HideStatusBar = 2)
       then begin
               if HideStatusBar = On then SETSCREEN(white,black,0,1,1,80,25);
               HideStatusBar := 2;
               exit;
            end;
    SETSCREEN(black,white,0,1,25,80,25);
    if BufferStatus = Off
       then write(chr(177),' SunCom v1.0   ',chr(177),'  ALT Q = Help  ',chr(177),' ')
       else write(chr(177),' Buffer: ',Open_Close[BufferStatus],' ',chr(177),'  ALT Q = Help  ',chr(177),' ');
    DispStr := '';
    str(BaudRate,WkStr);
    DispStr := DispStr + WkStr + ',' + Parity + ',';
    str(DataBits,WkStr);
    DispStr := DispStr + WkStr + ',';
    Str(StopBits,WkStr);
    DispStr := DispStr + WkStr;
    gotoxy(40,25);
    write(DispStr,' ',chr(177));
    if LocalEcho = On
       then write(' ECHO ',chr(177))
       else write(' OFF  ',chr(177));
    if LineFeeds = On
       then write(' LF  ',chr(177))
       else write(' OFF ',chr(177));
    if ChatMode = On
       then write(' CHAT ',chr(177))
       else write(' OFF  ',chr(177));
    if ToggleBackSpace = On
       then write(' DEL  ',chr(177))
       else write(' BKSP ',chr(177));
    if MuteMode = Off
       then write(' ',chr(14),' ',chr(177))
       else write('   ',chr(177));
    OnCursor;
  end; {with - Buffer};
  end; {with - Config};
  SetScreen(white,black,1,1,1,80,24);
end;

(************************************************************************)

PROCEDURE Setup(VAR Config : ConfigRec);
VAR
   Choice,
   YesNo       : Char;
LABEL Beginning;
begin (* Setup *)
   with Config do
   begin
   WINDOWIN(white,blue,4,2,2,78,22,CursorCol,CursorRow,WindowPtr);
   writeln('                        SUN Comm Advanced Setup');
   LINE(196,75,white);
   Beginning:
   OffCursor;
   window(3,5,77,21);
   textbackground(blue);
   textcolor(yellow);
   clrscr;
   writeln;
   writeln('     A - Size in bytes of async receive buffer: ');
   writeln('     B - Size in bytes of async output buffer:  ');
   writeln('     C - Use XON/XOFF flow control (Y/N)?  ');
   writeln('     D - Do CTS/RTS flow control (Y/N)?  ');
   writeln('     E - Do DSR/DTR flow control (Y/N)?  ');
   writeln('     F - Is connection hard-wired (Y/N)?  ');
   writeln('     G - Line Error reporting (Y/N)?  ');
   writeln('     H - Direct Screen Write (Y/N)?  ');
   writeln('     I - Hide Status Bar (Y/N)? ');
   writeln('     J - Use <DEL> instead of ^H for Backspace (Y,N)? ');
   gotoxy(30,15);
   textcolor(lightgray);
   writeln('ESC - To Exit');
   window(60,6,77,21);
   textcolor(white);
   writeln(InBufSize);
   writeln(OutBufSize);
   writeln(Do_XonXoff);
   writeln(Do_CTS);
   writeln(Do_DSR);
   writeln(Do_HardWired);
   writeln(Yes_No[Do_Async_Status]);
   writeln(Yes_No[DirectScreen]);
   writeln(Yes_No[HideStatusBar]);
   writeln(Yes_No[ToggleBackSpace]);
   Choice := Readkey;
   Choice := upcase(Choice);
   OnCursor;
   if Choice = ESC
        then begin
                Exit;
             end;
   if Not(Choice in ['A'..'J'])
      then goto beginning;
   SETSCREEN(black,white,0,60,Ord(Choice)-59,70,Ord(Choice)-59);
   case Choice of
           'A' : GetInt(InBufSize,0);
           'B' : GetInt(OutBufSize,0);
           'C' : GetChar(Do_XonXoff,0);
           'D' : GetChar(Do_CTS,0);
           'E' : GetChar(Do_DSR,0);
           'F' : GetChar(Do_HardWired,0);
           'G' : begin
                    GetChar(YesNo,0);
                    if YesNo in ['Y','y']
                       then Do_Async_Status := On
                       else Do_Async_Status := Off;
                 end;
           'H' : begin
                    GetChar(YesNo,0);
                    if YesNo in ['Y','y']
                       then begin
                               DirectScreen := On;
                               DirectVideo  := TRUE;
                             end
                       else begin
                               DirectScreen := Off;
                               DirectVideo  := FALSE;
                            end;
                 end;
           'I' : begin
                    GetChar(YesNo,0);
                    if YesNo in ['Y','y']
                       then HideStatusBar := On
                       else HideStatusBar := Off;
                 end;
           'J' : begin
                    GetChar(YesNo,0);
                    if YesNo in ['Y','y']
                       then ToggleBackSpace := On
                       else ToggleBackSpace := Off;
                 end;
   end; {case}
   end; {with - Config}
end;  (* Setup *)

(****************************************************************************)

PROCEDURE Clear_Buffer(VAR Buffer : BufferRec);
VAR Counter : Integer;
begin
   with Buffer do
   begin
        BufferStatus   := Off;
        BufferFileName := 'SunCom.Buf';
        BufferCounter  := 1;
        for Counter := 1 to MaxBuffer do
            begin
                 BufferArray[Counter] := ' ';
            end;
   end; {with - Buffer}
end;

(****************************************************************************)

FUNCTION Initialize(VAR Config : ConfigRec;
                    VAR Buffer : BufferRec) : Boolean;
CONST
   Digits : ARRAY[0..15] OF Char = ('0','1','2','3','4','5','6','7','8','9',
                                    'A','B','C','D','E','F');
VAR Flags   : Byte;
BEGIN (* Initialize*)
   with Config do begin
   Async_Do_CTS         := ( UpCase( Do_CTS ) = 'Y' );        (* Set CTS checking *)
   Async_Do_DSR         := ( UpCase( Do_DSR ) = 'Y' );        (* Set DSR checking *)
   Async_Do_XonXoff     := ( UpCase( Do_XonXoff ) = 'Y' );    (* Set XON/XOFF to user request *)
   Async_Hard_Wired_On  := ( UpCase( Do_HardWired ) = 'Y' );  (* Set hard-wired as user requests *)
   Async_Break_Length   := 500;                               (* Set half-second break duration *)
   Async_Init(InBufSize, OutBufSize,0,0,0);               (* Let XON/XOFF break points default. *)
       (* If com port 3 or 4, make sure port address specified in memory. *)
   IF ( ComPort > 2 ) THEN
      Async_Setup_Port( ComPort,Com_Addr, Com_Irq, Com_Int_No );
     (* Try opening the serial port.   *)
   IF ( NOT Async_Open( ComPort, BaudRate, Parity, DataBits, StopBits ) ) THEN
      BEGIN
         WRITELN('Cannot open serial port.');
         Initialize := FALSE;
      END
   ELSE
      BEGIN
         SETSCREEN(white,black,0,1,1,80,24);
         WRITELN('SUN Terminal ready.');
         Initialize := TRUE;
      END;
   IF Do_Async_Status = On THEN
         IF Async_Line_Error(Flags) THEN
            BEGIN
               WRITELN;
               WRITELN( 'Line error = <', Digits[ Flags SHR 4 ],
                                          Digits[ Flags AND $F ], '>' );
            END;
   CLEAR_BUFFER(Buffer);
   end; {with - Config}
END   (* Initialize *);

(****************************************************************************)

PROCEDURE Set_FilesPath(VAR Config : ConfigRec);
VAR ExitFlag : Boolean;
    OldPath  : String[80];
begin
     WINDOWIN(white,blue,4,5,11,75,13,CursorCol,CursorRow,WindowPtr);
     ONCURSOR;
     ExitFlag := False;
     with Config do
     begin
     while ExitFlag <> True do
     begin
     textcolor(yellow);
     OldPath := FilesPath;
     write('Files Path: ',FilesPath);
     window(18,12,74,12);
     textcolor(lightred);
     readln(FilesPath);
     if length(FilesPath) <= 1
        then FilesPath := OldPath;
     if FilesPath[length(FilesPath)] = '\'
        then delete(FilesPath,Length(FilesPath),1);
     {$I-}
     chdir(FilesPath);
     {$I+}
     if IOResult <> 0
        then begin
                  window(6,12,74,12);
                  textcolor(lightred+blink);
                  writeln;
                  write('INVALID PATH!',^g);
                  delay(3000);
                  window(6,12,74,12);
                  writeln;
                  FilesPath := ' ';
                  ExitFlag := False;
             end
        else ExitFlag := True;
     end; {while}
     end; {with}
     OFFCURSOR;
     WINDOWOUT(CursorCol,CursorRow,WindowPtr);
end;

(****************************************************************************)

PROCEDURE Modem_Config_Menu(VAR Config : ConfigRec;
                            VAR Buffer : BufferRec);
VAR
  dbool,
  WinOutFlag : Boolean;
  Ch,
  Choice     : Char;
  HighComm   : Byte;
  ChoiceInt  : Integer;
  TempStr    : String[20];
LABEL Beginning;
BEGIN
     with Config do
     begin
     WINDOWIN(white,blue,4,2,2,78,22,CursorCol,CursorRow,WindowPtr);
     Beginning:
     clrscr;
     WinOutFlag := False;
     HighComm := Off;
     textcolor(white);
     OffCursor;
     writeln('                            SUN Comm Modem Setup');
     LINE(196,75,white);
     textcolor(yellow);
     writeln('   BAUD RATE      PARITY       DATA BITS              OTHER         ');
     writeln;
     writeln('   A -  1200     K - Even    R - 7 bits       T - Install Protocols ');
     writeln('   B -  2400     L - Space   S - 8 bits       U - Save Configuration');
     writeln('   C -  9600     M - Mark                     V - Advanced Setup    ');
     writeln('   D - 19200     N - None                     W - Set Files Path    ');
     writeln('   E - 38400     O - Odd                      X - Define Macros     ');
     writeln('   F - 57600                                  Y -                   ');
     writeln('                                              Z -                   ');
     writeln('   COM PORT      STOP BITS                                          ');
     writeln('                                                                    ');
     writeln('   G - Com 1     P - 1 bits     ESC - To Exit                       ');
     writeln('   H - Com 2     Q - 2 bits                                         ');
     writeln('   I - Com 3                    Current Config: Com',ComPort,',',BaudRate,',',Parity,',',DataBits,',',StopBits);
     if ComPort < 2
        then writeln('   J - Com 4                                                        ')
        else writeln('   J - Com 4                    Com Addr: ',Com_Addr_Str,'  IRQ #: ',Com_IRQ);
     Choice := Readkey;
     Choice := upcase(Choice);
     OnCursor;
     if Choice = ESC
        then begin
                OnCursor;
                if Initialize(Config,Buffer) = False then
                   begin
                        writeln(^G,'ComPort NOT Opened!',^G);
                        delay(3000);
                   end;
                ShowPortStatus(Config,Buffer);
                if WinOutFlag = False then WINDOWOUT(CursorCol,CursorRow,WindowPtr);
                OnCursor;
                Exit;
             end;
     CASE Choice OF
           'A' : BaudRate := 1200;
           'B' : BaudRate := 2400;
           'C' : BaudRate := 9600;
           'D' : BaudRate := 19200;
           'E' : BaudRate := 38400;
           'F' : BaudRate := 57600;
           'G' : ComPort := 1;
           'H' : ComPort := 2;
           'I' : begin
                      ComPort := 3;
                      HighComm := On;
                 end;
           'J' : begin
                      ComPort := 4;
                      HighComm := On;
                 end;
           'K' : Parity := 'E';   (* Goes with 7 Data Bits *)
           'L' : Parity := 'S';
           'M' : Parity := 'M';
           'N' : Parity := 'N';   (* Goes with 8 Data Bits *)
           'O' : Parity := 'O';
           'P' : StopBits := 1;
           'Q' : StopBits := 2;
           'R' : DataBits := 7;   (* Word Size - For PC to Mainframe (IBM, UNIX) *)
           'S' : DataBits := 8;   (* Word Size - For PC to PC *)
           'T' : begin
                    WINDOWOUT(CursorCol,CursorRow,WindowPtr);
                    Install_Protocols(Config);
                    WINDOWOUT(CursorCol,CursorRow,WindowPtr);
                    WINDOWIN(white,blue,4,2,2,78,22,CursorCol,CursorRow,WindowPtr);
                 end;
           'U' : begin
                    SAVECONFIG(Config);
                 end;
           'V' : begin
                    WINDOWOUT(CursorCol,CursorRow,WindowPtr);
                    Setup(Config);
                    WINDOWOUT(CursorCol,CursorRow,WindowPtr);
                    WINDOWIN(white,blue,4,2,2,78,22,CursorCol,CursorRow,WindowPtr);
                 end;
           'W' : begin
                    WINDOWOUT(CursorCol,CursorRow,WindowPtr);
                    Set_FilesPath(Config);
                    WINDOWOUT(CursorCol,CursorRow,WindowPtr);
                    WINDOWIN(white,blue,4,2,2,78,22,CursorCol,CursorRow,WindowPtr);
                 end;
           'X' : begin
                    WINDOWOUT(CursorCol,CursorRow,WindowPtr);
                    Define_Macros(Config);
                    WINDOWIN(white,blue,4,2,2,78,22,CursorCol,CursorRow,WindowPtr);
                 end;
     END (* case *);
     IF (ComPort > 2) and (HighComm = On) THEN
        begin
           SETSCREEN(yellow,blue,0,10,21,70,21);
           WRITE('Enter com port base address (hex):  ');
           textcolor(white);
           readln(Com_Addr_Str);
           Com_Addr := Hex_To_Dec(Com_Addr_Str,-1);
           textcolor(yellow);
           WRITE('Enter com port IRQ level (1 to 15):  ');
           textcolor(white);
           GetInt(Com_Irq,0);
           textcolor(yellow);
           WRITE('Enter com port interrupt vector number (hex):  ');
           textcolor(white);
           readln(TempStr);
           Com_Int_No := Hex_To_Dec(TempStr,-1);
           writeln;
           window(3,3,77,21);
         end;
     goto Beginning;
     END (* with *);
END (* Configure_Menu *);

(************************************************************************)

PROCEDURE LoadConfig(VAR Config : ConfigRec;
                     VAR Buffer : BufferRec);
VAR Flag,
    Lcv        : Integer;
    CfgFile    : Text;
    Counter,
    YesNo      : Char;
    dbool      : Boolean;
BEGIN
   DirectVideo := FALSE;           (* No direct screen writes *)
   Clear_Config(Config);
   SETSCREEN(white,black,0,1,1,80,25);
   writeln;
   writeln('                    SUN Comm  v1.0  -  Boyd C. Fletcher ');
   writeln;
   write('Load Config File (Y,N) ');
   repeat
         YesNo := Readkey;
   until YesNo in ['Y','y','N','n'];
   writeln;
   if YesNo in ['Y','y']
       then begin
                 {$I-}
                 assign(CfgFile,'SunCom.CFG');
                 reset(CfgFile);
                 {$I+}
                 if IOResult <> 0
                    then begin
                              writeln(^G,'Config File NOT Found!',^G);
                              delay(2000);
                              Modem_Config_Menu(Config,Buffer);
                              exit;
                         end
                    else begin
                              close(CfgFile);
                              write('Loading Load Setup'); {LOAD_SETUP}
                         end;
            end
       else begin
                 Modem_Config_Menu(Config,Buffer);
                 exit;
             end;
  Assign(CfgFile, 'SunCom.CFG');
{$I-}
  Reset(CfgFile);
{$I+}
  if IOResult = 0 then
  begin
     with Config do
     begin
     readln(CfgFile,ComPort);
     readln(CfgFile,BaudRate);
     readln(CfgFile,Parity);
     readln(CfgFile,DataBits);
     readln(CfgFile,StopBits);
     readln(CfgFile,LocalEcho);
     readln(CfgFile,LineFeeds);
     readln(CfgFile,ChatMode);
     readln(CfgFile,MuteMode);
     readln(CfgFile,InBufSize);
     readln(CfgFile,OutBufSize);
     readln(CfgFile,Do_XonXoff);
     readln(CfgFile,Do_HardWired);
     readln(CfgFile,Do_CTS);
     readln(CfgFile,Do_DSR);
     readln(CfgFile,Com_Addr_Str);
     readln(CfgFile,Com_Addr);
     readln(CfgFile,Com_IRQ);
     readln(CfgFile,Com_INT_No);
     readln(CfgFile,DirectScreen);
     readln(CfgFile,Do_Async_Status);
     readln(CfgFile,HideStatusBar);
     for Counter := 'A' to 'G' do
        begin
           readln(CfgFile,Protocols[Counter].Name);
           readln(CfgFile,Protocols[Counter].Up);
           readln(CfgFile,Protocols[Counter].Down);
           readln(CfgFile,Protocols[Counter].Flag);
        end; {for}
     readln(CfgFile,FilesPath);
     for Lcv := 1 to Max do
          begin
               readln(CfgFile,FonBook[Lcv].Name);
               readln(CfgFile,FonBook[Lcv].Number);
          end;
     if DirectScreen = On
        then DirectVideo := TRUE
        else DirectVideo := FALSE;
     end; {with}
     close(CfgFile);
     dBool := Initialize(Config,Buffer);
  end;
END (* LoadConfig *);

(****************************************************************************)

PROCEDURE Dial(    Number     : Str30;
                   Name       : Str30;
               VAR RX,
                   RY         : Integer;
               VAR Config : ConfigRec);
VAR PhoneNumber : Str30;
    Question    : Char;
    Lcv         : Integer;
begin
     write(' (T)one or (P)ulse: ');
     Question := readkey;
     Question := upcase(Question);
     if Question = 'T'
        then PhoneNumber := 'ATDT '
        else PhoneNumber := 'ATDP ';
     ONCURSOR;
     WINDOWOUT(CursorCol,CursorRow,WindowPtr);
     SETSCREEN(white,black,0,1,1,80,24);
     writeln('Dialing ',Name,' AT ',Number,'    Hit ''RETURN'' to Cancel.');
     writeln;
     RX := 1;
     RY := 3;
     PhoneNumber := PhoneNumber + Number + #13;
     for Lcv := 1 to length(PhoneNumber) do
         begin
               Async_Send_Now(PhoneNumber[Lcv]);
         end;
     delay(1000);
end;

(****************************************************************************)

PROCEDURE Phone_Book(VAR RX,
                         RY         : Integer;
                     VAR Config : ConfigRec);
VAR ExitOk,
    dbool       : Boolean;
    Counter,
    Index       : LongInt;
    Lcv         : Integer;
    Question    : Char;
    Number      : String[3];
    OldRec      : FonBookRec;
    PhoneNumber : Str30;
begin
     with Config do
     begin
     WINDOWIN(white,blue,4,5,2,75,24,CursorCol,CursorRow,WindowPtr);
     textcolor(yellow);
     writeln('  SUN Comm v1.0  -  Phone Book':50);
     LINE(196,69,white);
     window(6,20,74,23);
     LINE(196,69,white);
     textcolor(yellow);
     write('     (D)ial  (M)anual Dial  Make (Q)ueue  E(x)it  (E)dit  ',chr(24),chr(25));
     window(6,5,74,19);
     OFFCURSOR;
     Lcv := 1;
     Counter := 1;
     ExitOk := False;
     Question := '>';
     while (ExitOk = False) do
         begin
            if(Lcv <> 15)and(Question='>')
                 then begin
                           textcolor(white);
                           write(Counter:4,'. ');
                           textcolor(yellow);
                           writeln(FonBook[Counter].Name,'  ',FonBook[Counter].Number);
                      end;
              if (Lcv = 15)and(Question = '>')
                 then begin
                           textcolor(white);
                           write(Counter:4,'. ');
                           textcolor(yellow);
                           write(FonBook[Counter].Name,'  ',FonBook[Counter].Number);
                      end;
              if (Lcv = 15) then
                 begin
                      repeat until KeyPressed;
                      Question := Readkey;
                      if Question = #0 then
                         begin
                              Question := ReadKey;
                              if Question = #80
                                 then Question := '>';
                              if Question = #72
                                 then Question := '<';
                              if Question = #77
                                 then Question := ' ';
                              if Question = #73
                                 then Question := '<';
                              if Question = #81
                                 then Question := '>';
                              if Question = #71
                                 then begin
                                           Question := '>';
                                           Counter := 0;
                                      end;
                              if Question = #79
                                 then begin
                                           Question := '>';
                                           Counter := 135;
                                      end;
                         end;
                      if Question = #27
                         then Question := 'X';
                      Question := upcase(Question);
                      ONCURSOR;
                      if Question in ['Q','D','>','E','M','<','X','0'..'9'] then
                         begin
                              Case Question of
                                     '<' : Counter := Counter - 30;
                                     'M' : begin
                                                SETSCREEN(black,white,0,6,23,74,23);
                                                write(' Manual Dial: ');
                                                readln(PhoneNumber);
                                                Dial(PhoneNumber,'Manual Dial',RX,RY,Config);
                                                Exit;
                                            end;
                                     'Q' : begin
                                                SETSCREEN(black,white,0,6,23,74,23);
                                                write(' Index Number(s): ');
                                                readln(Number);
                                                val(Number,Index,Lcv);
                                                if (Index >= 1) and (Index <= 150)
                                                   then begin
                                                             OldRec := FonBook[Index];
                                                        end;
                                                Counter := Counter - 15;
                                           end;
                                     'D' : begin
                                                SETSCREEN(black,white,0,6,23,74,23);
                                                write(' Index Number: ');
                                                readln(Number);
                                                val(Number,Index,Lcv);
                                                if (Index >= 1) and (Index <= 150) then
                                                    begin
                                                        Dial(FonBook[Index].Number,FonBook[Index].Name,RX,RY,Config);
                                                        Exit;
                                                    end;
                                                Counter := Counter - 15;
                                            end;
                                     'E'  : begin
                                                SETSCREEN(black,white,0,6,23,74,23);
                                                Counter := Counter - 15;
                                                write(' Index Number: ');
                                                readln(Number);
                                                val(Number,Index,Lcv);
                                                if (Index >= 1) and (Index <= 150)
                                                   then begin
                                                OldRec := FonBook[Index];
                                                write(' #',Index:3,' Name: ',FonBook[Index].Name);
                                                window(18,23,48,23);
                                                textcolor(red);
                                                readln(FonBook[Index].Name);
                                                if length(FonBook[Index].Name) <= 1 then FonBook[Index].Name := OldRec.Name;
                                                if length(FonBook[Index].Name) < 30 then
                                                   begin
                                                        for Lcv := length(FonBook[Index].Name) to 30 do
                                                            begin
                                                                 FonBook[Index].Name := FonBook[Index].Name + ' ';
                                                            end; {for}
                                                   end;
                                                textcolor(black);
                                                SETSCREEN(black,white,0,6,23,74,23);
                                                write(' #',Index:3,' Number: ',FonBook[Index].Number);
                                                window(20,23,50,23);
                                                textcolor(red);
                                                readln(FonBook[Index].Number);
                                                if length(FonBook[Index].Number)<=1 then FonBook[Index].Number:=OldRec.Number;
                                                end {if}
                                            end;
                                     'X' : ExitOk := True;
                             '1','2','3',
                             '4','5','6',
                             '7','8','9',
                             '0'         : begin
                                                SETSCREEN(black,white,0,6,23,74,23);
                                                write(' Index Number: ');
                                                readln(Number);
                                                val(Number,Index,Lcv);
                                                if (Index >= 1) and (Index <= 150) then
                                                    begin
                                                        Dial(FonBook[Index].Number,FonBook[Index].Name,RX,RY,Config);
                                                        Exit;
                                                    end;
                                                Counter := Counter - 15;
                                           end;
                              end; {case}
                              if Question in ['Q','D','>','<','E','M','X'] then
                                 begin
                                      Lcv := 0;
                                      Question := '>';
                                 end
                                 else begin
                                           Question := '>';
                                           Lcv := 0;
                                      end;
                              SETSCREEN(yellow,blue,0,6,23,74,23);
                              window(6,5,74,19);
                         end;
                      if Question in ['Q','D','>','<','E','M','X'] then
                         begin
                              Lcv := 0;
                              Question := '>';
                         end
                         else begin
                                   Question := '>';
                                   Counter := Counter - 15;
                                   Lcv := 0;
                              end;
                      clrscr;
                      OFFCURSOR;
                 end;
              if Question in ['>','<'] then
                 begin
                      Counter := Counter + 1;
                      Lcv := Lcv + 1;
                      if Counter > 150 then Counter := 1;
                      if Counter < 1 then Counter := 136;
                 end;
         end;
     end; {with}
     ONCURSOR;
     WINDOWOUT(CursorCol,CursorRow,WindowPtr);
end;

(****************************************************************************)

PROCEDURE Finish_Communications;

BEGIN (* Finish_Communications *)
   Async_Close(FALSE);             (* Close port and drop DTR *)
   Async_Release_Buffers;          (* Release space allocated for buffers *)
END   (* Finish_Communications *);

(****************************************************************************)

Procedure Save_Buffer(VAR Buffer : BufferRec);
VAR Counter  : Integer;
    DataFile : Text;
begin
     with Buffer do begin
     {$I-}
     assign(DataFile,BufferFileName);
     reset(DataFile);
     {$I+}
     if IOResult <> 0
        then begin
                  assign(DataFile,BufferFileName);
                  rewrite(DataFile);
             end
        else begin
                  assign(DataFile,BufferFileName);
                  append(DataFile);
             end;
     for Counter := 1 to BufferCounter do
         begin
              write(DataFile,BufferArray[Counter]);
         end;
     close(DataFile);
     BufferCounter := 1;
     end; {with - Buffer}
end;

(****************************************************************************)

PROCEDURE Buffer_Menu(VAR Buffer : BufferRec);
VAR Question    : Char;
    OldFileName : String[12];
LABEL Beginning;
begin
     with Buffer do begin
     WINDOWIN(white,blue,4,25,9,55,20,CursorCol,CursorRow,WindowPtr);
     Beginning:
     SETSCREEN(white,blue,0,26,10,54,19);
     OFFCURSOR;
     textcolor(yellow);
     writeln('     Capture Buffer Menu');
     LINE(196,29,white);
     textcolor(yellow);
     writeln('      O - Open Buffer ');
     writeln('      C - Close Buffer');
     writeln('      S - Set Filename');
     LINE(196,29,white);
     textcolor(yellow);
     write(' Status  : ');
     textcolor(white);
     writeln(Open_Close[BufferStatus]);
     textcolor(yellow);
     write(' Filename: ');
     textcolor(white);
     writeln(BufferFileName);
     LINE(196,29,white);
     textcolor(lightgray);
     write('       ESC - To Exit');
     Question := readkey;
     if Question = ESC then
        begin
             ONCURSOR;
             WINDOWOUT(CursorCol,CursorRow,WindowPtr);
             Exit;
        end;
     ONCURSOR;
     if Question in ['O','o','C','c','S','s']
        then case Question of
                 'O','o' : BufferStatus := On;
                 'C','c' : begin
                                BufferStatus := Off;
                                Save_Buffer(Buffer);
                                Clear_Buffer(Buffer);
                           end;
                 'S','s' : begin
                                OldFileName := BufferFileName;
                                SETSCREEN(black,white,0,5,22,75,22);
                                write(' Buffer Filename: ',BufferFileName);
                                window(23,22,75,22);
                                textcolor(red);
                                readln(BufferFilename);
                                if length(BufferFileName) <= 1
                                   then BufferFileName := OldFileName;
                                SETSCREEN(black,black,0,5,22,75,22);
                           end;
             end; {case}
     goto Beginning;
     end; {with - Buffer}
end;

(****************************************************************************)

PROCEDURE Menu(    Ch         : Char;
               VAR RX,
                   RY         : Integer;
               VAR Config     : ConfigRec;
               VAR Buffer     : BufferRec;
               VAR ExitActive : Boolean);
VAR Question   : Char;
    dbool      : Boolean;
    HangUpStr  : String[10];
    Lcv        : Integer;
begin
     with Config do begin
     with Buffer do begin
     case Ch of
          #45 : begin
                     WINDOWIN(white,blue,4,25,10,55,12,CursorCol,CursorRow,WindowPtr);
                     textcolor(yellow);
                     write(' Exit - Are you sure (Y,N)? ');
                     Question := ReadKey;
                     WINDOWOUT(CursorCol,CursorRow,WindowPtr);
                     if Question in ['Y','y']
                        then ExitActive := True;
                end;
          #16 : begin
                     OFFCURSOR;
                     WINDOWIN(white,blue,4,1,1,80,23,CursorCol,CursorRow,WindowPtr);
                     DisplayMenu;
                     MAKEWINDOW(white,blue,0,1,22,18,79,24);
                     writeln('ALT Q - This Screen (HELP SCREEN)');
                     SETSCREEN(lightcyan,blue,1,28,21,79,24);
                     ShowStackUsage;
                     repeat until KeyPressed;
                     WINDOWOUT(CursorCol,CursorRow,WindowPtr);
                     ONCURSOR;
                end;
          #24 : begin
                     Modem_Config_Menu(Config,Buffer);
                     ShowPortStatus(Config,Buffer);
                end;
          #47 : DIRECTORY(white,yellow,blue,4);
          #37 : DEFINE_MACROS(Config);
          #35 : begin
                     WINDOWIN(white,blue,4,23,10,57,12,CursorCol,CursorRow,WindowPtr);
                     textcolor(yellow);
                     write(' HANG UP - Are you sure (Y,N)? ');
                     Question := ReadKey;
                     WINDOWOUT(CursorCol,CursorRow,WindowPtr);
                     if Question in ['Y','y']
                        then begin
                                  OFFCURSOR;
                                  MAKEWINDOW(white,blue,4,0,23,10,57,12);
                                  textcolor(yellow);
                                  write('   ******* Hanging Up *******',^G);
                                  Async_Close(TRUE);
                                  Async_Release_Buffers;
                                  delay(2000);
                                  dbool := Initialize(Config,Buffer);
                                  delay(1000);
                                  if Async_Carrier_Detect = False
                                     then begin
                                               HangUpStr := 'ATH'+#13;
                                               For Lcv := 1 to length(HangUpStr) do
                                                 begin
                                                     Async_Send_Now(HangUpStr[Lcv]);
                                                 end;
                                               delay(1000);
                                               RX := 1;
                                               RY := 6;
                                          end;
                             end;
                     ONCURSOR;
                end;
          #31 : begin
                     UPLOAD(Config);
                     ShowPortStatus(Config,Buffer);
                end;
          #19 : begin
                     DOWNLOAD(Config);
                     ShowPortStatus(Config,Buffer);
                end;
          #33 : begin
                     READ_FILE(Config);
                     ShowPortStatus(Config,Buffer);
                end;
          #17 : begin
                     SETSCREEN(white,black,0,1,1,80,24);
                     RX := 1;
                     RY := 1;
                end;
          #18 : begin
                     if LocalEcho = On
                        then LocalEcho := Off
                        else LocalEcho := On;
                     ShowPortStatus(Config,Buffer);
                end;
          #38 : begin
                     if LineFeeds = On
                        then LineFeeds := Off
                        else LineFeeds := On;
                     ShowPortStatus(Config,Buffer);
                end;
          #46 : begin
                     if ChatMode = On
                        then ChatMode := Off
                        else ChatMode := On;
                     ShowPortStatus(Config,Buffer);
                end;
          #50 : begin
                     if MuteMode = On
                        then MuteMode := Off
                        else MuteMode := On;
                     ShowPortStatus(Config,Buffer);
                end;
          #25 : begin
                     if BufferStatus = On
                        then begin
                                  BufferStatus := Pause;
                                  Save_Buffer(Buffer)
                             end
                        else BufferStatus := On;
                     ShowPortStatus(Config,Buffer);
                end;
          #48 : begin
                     if ToggleBackSpace = On
                        then ToggleBackSpace := Off
                        else ToggleBackSpace := On;
                     ShowPortStatus(Config,Buffer);
                end;
          #22 : begin
                     BUFFER_MENU(Buffer);
                     ShowPortStatus(Config,Buffer);
                end;
          #44 : SHELL_TO_DOS;
          #32 : PHONE_BOOK(RX,RY,Config);
     end; {case}
     end; {with - Buffer}
     end; {with - config}
end;

(****************************************************************************)

PROCEDURE Send_Macro(VAR Config : ConfigRec;
                         Key : Char);
VAR SendStr,
    TempStr       : String;
    Lcv,
    Code,
    GraphicNum,
    Start         : Integer;
begin
     with Config.Macros do
     begin
     SendStr := ' ';
     case Key of
          #71 : SendStr := Home_Key;
          #79 : SendStr := End_Key;
          #72 : SendStr := Up_Key;
          #80 : SendStr := Down_Key;
          #75 : SendStr := Left_Key;
          #77 : SendStr := Right_Key;
          #73 : SendStr := PageUp_Key;
          #81 : SendStr := PageDown_Key;
          #82 : SendStr := Ins_Key;
          #83 : SendStr := Del_Key;
    end; {case}
    Start := 1;
    for Lcv := Start to length(SendStr) do
        begin
             if SendStr[Lcv] = '^' then
                begin
                    Lcv := Lcv + 1;
                    Async_Send_Now(chr(Ctrl_Keys[SendStr[Lcv]]));
                end
                else if SendStr[Lcv] = '~' then
                        begin
                            delay(1500);
                        end
                        else if (SendStr[Lcv] = '#') and (SendStr[Lcv+1] = '#') then
                                begin
                                    Lcv := Lcv + 2;
                                    TempStr := SendStr[Lcv]+SendStr[Lcv+1]+SendStr[Lcv+2];
                                    Lcv := Lcv + 2;
                                    val(TempStr,GraphicNum,Code);
                                    if Code <> 0
                                       then writeln(^G,'Error In Macro (',Key,') at position: ',Code)
                                       else Async_Send_Now(chr(GraphicNum));
                                end
                                else begin
                                          Async_Send_Now(SendStr[Lcv]);
                                          if Config.LocalEcho = On then write(SendStr[Lcv]);
                                     end;
        end; {for}
    end {with}
end;

(****************************************************************************)

PROCEDURE TermDisplay (    Ch        : Char;
                       VAR Config    : ConfigRec;
                           Direction : Byte);
begin
  if Ch = #9
     then begin
             write('     ');
             exit;
          end;
  if Config.ChatMode = Off
     then ANSIDRIVER(Ch)
     else if Direction = Send then
             begin
                  textcolor(white);
                  write(Ch);
             end
             else begin
                       textcolor(yellow);
                       write(Ch);
                  end;
  if (Ch = #13) and (Config.Linefeeds = On) then writeln;
  if (Ch = #12) then SETSCREEN(white,black,0,1,1,80,24);
  if Ch = #8 then write(' ',chr(8));
END (* TermDisplay *);

(****************************************************************************)

PROCEDURE Terminal(VAR Config : ConfigRec;
                   VAR Buffer : BufferRec);

VAR
   Sch        : Char;        (* Send Char    *)
   RCh        : Char;        (* Receive Char *)
   ExitOK     : Boolean;     (* Exit Flag    *)
   Bool       : Boolean;
   Question   : CHAR;
   RX,RY      : Integer;

BEGIN
   with Config do begin
   with Buffer do begin
   ExitOk := FALSE;
   ShowPortStatus(Config,Buffer);
   GotoXY(1,3);
   repeat
       IF KeyPressed THEN
           BEGIN
              Sch := ReadKey;
              if Sch = #0 then
                 begin
                      Sch := ReadKey;
                      RX := WhereX;
                      RY := WhereY;
                      if Sch in [#79,#72,#80,#75,#77,#73,#81,#82,#83]
                         then Send_Macro(Config,Sch)
                         else Menu(Sch,RX,RY,Config,Buffer,ExitOK);
                      if HideStatusbar = Off
                         then SetScreen(white,black,1,1,1,80,24)
                         else SetScreen(white,black,1,1,1,80,25);
                      gotoxy(RX,RY);
                 end
        else begin
                if (ToggleBackSpace = On) and (Sch = #8)
                   then Async_Send_Now(chr(127))
                   else Async_Send_Now(Sch);
                if LocalEcho = On then TermDisplay(Sch,Config,Send);
             end;
        end;
      IF Async_Receive(Rch) THEN
         case ORD(Rch) of
            0: ;
            7: if MuteMode = Off
                  then TermDisplay(Rch,Config,Receive)
                  else write('<BEL>')
            else begin
                      if (BufferStatus = On) and (BufferCounter <= MaxBufferLimit) and (LocalEcho = Off)
                         then begin
                                 BufferArray[BufferCounter] := Rch;
                                 BufferCounter := BufferCounter + 1;
                              end
                         else if (BufferStatus = On) and (BufferCounter > MaxBufferLimit)
                                 then Save_Buffer(Buffer);
                      TermDisplay(Rch,Config,Receive);
                 end;
         end;{case}
   until (ExitOK = True);
   end; {with - Buffer}
   end {with - Config}
END;

(****************************************************************************)

PROCEDURE Main;

VAR Config : ConfigRec;
    Buffer : BufferRec;
BEGIN
   LoadConfig(Config,Buffer);
   IF Initialize(Config,Buffer) then
      BEGIN
         Terminal(Config,Buffer);
         Finish_Communications;
      END;
   clrscr;
END;

BEGIN
     Main;
     ShowStackUsage;
END.
